#include <stdlib.h>
#include "allegro.h"

/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */


int main(int argc, char *argv[])
{
	MIDI *the_music;
	int progress;
	int result = 1; /* key was pressed to stop it */

	allegro_init();
	if (argc != 2) return 1;
	install_keyboard();
	install_timer();
	set_volume_per_voice(1);
	if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, argv[0]) != 0) {
	 return 1;
	}
	set_volume(255,255);
	the_music = load_midi(argv[1]);
	if (!the_music) {
		return 1;
	}

	play_midi(the_music, NULL);

	do {
		poll_keyboard();
		if( progress != midi_pos ) {
			progress = midi_pos;
		}
		if( progress < 0 ) {
			result = 0;  /* no keypress */
			goto out;
		}
		rest(2);
	} while ((!key[KEY_ESC]) && (!key[KEY_SPACE]));

out:
	destroy_midi(the_music);
	return result;  /* 0 if key pressed, 1 if not */
}
END_OF_MAIN();

