/* Go game for LCARS 24
*/
/* This program is free software. You may redistribute and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License or
 * (at your option) any later version.
 *
 * Refer to the file C:\LCARS24\DATA\COPYING.TXT for details.
 */


#include "go.h"

void GoClearBoard()
{
	int i,j;

	for(j = 0; j < 19; ++j) memset(GoBoard,0,19);
}
void GoWarning()
{
	PutsFont21(561,101, RED, "ILLEGAL MOVE");
	GoMessageFlag=1;
}

void GoEraseWarning()
{
	rectfill(screen,561,101,753,122,BLACK);
	GoMessageFlag=0;
}
void GoTurnMessage(int w)
{
	GoMessageFlag=w;
	rectfill(screen,561,52,753,78,BLACK);

	switch( w )
		{
		case 0:         return;
		case 1: 	PutsScorpio(561,52, SEABLUE, "WHITE'S MOVE");
				return;
		case 2: 	PutsScorpio(561,52, SEABLUE, "BLACK'S MOVE");
				return;
		default:	return;
	}
}

int GoGetRand(int d, int prev)
{
	int Result;

	srand( (unsigned int)time( NULL ) );
	Result = rand() % d;
	if( Result == prev ) ++ Result;
	if( Result > d-1 ) Result = 0;
	return(Result);
}

void GoDisplayFilename()
{
	rectfill(screen,130,1+12,548,39,LAVENDER);
	PutsLuna(130,20,BLACK,LAVENDER,"Powered by GNU GO");
}

void GoDrawEmptyBoard()
{
	int z;

	LeftBumper26(73, 52, GoGridColor);
	LeftBumper26(73, 521, GoGridColor);

	RightBumper26(516, 52, GoGridColor);
	RightBumper26(516, 521, GoGridColor);

	rectfill(screen, 47, 65, 542, 532, GoGridColor);
	rectfill(screen, 73, 52, 516, 547, GoGridColor);

	for( z = 0; z < 19; ++z) {
		line(screen,69,74+(z*25),520,74+(z*25),BLACK);
		line(screen,69,75+(z*25),520,75+(z*25),BLACK);
	}
	for( z = 0; z < 19; ++z) {
		line(screen,69+(z*25),74,69+(z*25),525,BLACK);
		line(screen,70+(z*25),74,70+(z*25),525,BLACK);
	}
}

void GoPlaceStone(int turn)
{
	int cx,cy,color;

	cx=69+(GoX*25);
	cy=74+(GoY*25);

	if(turn==2) {
		masked_blit(blackstone, screen, 0,0, cx-11, cy-11, blackstone->w, blackstone->h);
		GoBoard[GoX][GoY]=2;
		return;
	} else {
	masked_blit(whitestone, screen, 0,0, cx-11, cy-11, whitestone->w, whitestone->h);
		GoBoard[GoX][GoY]=1;
		return;
	}
}
void GoRemoveStone()
{
	int cx,cy;

	cx=69+(GoX*25);
	cy=74+(GoY*25);

	GoBoard[GoX][GoY]=0;

	rectfill(screen,cx-11,cy-11,cx+11,cy+13,GoGridColor);

/* redraw erased intersection lines, horiz then vert */
	if(GoX>0 && GoY>0 && GoX<18 && GoY<18) {  /* typical intesection */
		rectfill(screen,cx-11,cy,cx+11,cy+1,BLACK);
		rectfill(screen,cx,cy-11,cx+1,cy+13,BLACK);
		return;
	}
	if(GoX==0 && GoY==0) {   /* NW corner */
		rectfill(screen,cx,cy,cx+11,cy+1,BLACK);
		rectfill(screen,cx,cy,cx+1,cy+13,BLACK);
		return;
	}
	if(GoX==0 && GoY==18) {  /* SW corner */
		rectfill(screen,cx,cy-11,cx+1,cy+1,BLACK);
		rectfill(screen,cx,cy,cx+11,cy+1,BLACK);
		return;
	}
	if(GoX==18 && GoY==0) {   /* NE corner */
		rectfill(screen,cx-11,cy,cx,cy+1,BLACK);
		rectfill(screen,cx,cy,cx+1,cy+13,BLACK);
		return;
	}
	if(GoX==18 && GoY==18) {  /* SE corner */
		rectfill(screen,cx-11,cy,cx+1,cy+1,BLACK);
		rectfill(screen,cx,cy-11,cx+1,cy,BLACK);
		return;
	}
	if(GoY==0) {  /* top */
		rectfill(screen,cx-11,cy,cx+11,cy+1,BLACK);
		rectfill(screen,cx,cy,cx+1,cy+13,BLACK);
		return;
	}
	if(GoY==18) {  /* bottom */
		rectfill(screen,cx-11,cy,cx+11,cy+1,BLACK);
		rectfill(screen,cx,cy-11,cx+1,cy,BLACK);
		return;
	}
	if(GoX==0) {  /* left */
		rectfill(screen,cx,cy,cx+11,cy+1,BLACK);
		rectfill(screen,cx,cy-11,cx+1,cy+13,BLACK);
		return;
	}
	if(GoX==18) {  /* right */
		rectfill(screen,cx-11,cy,cx,cy+1,BLACK);
		rectfill(screen,cx,cy-11,cx+1,cy+13,BLACK);
		return;
	}
}
void GoDrawCursor()
{
	int cx,cy;

	cx=69+(GoX*25);
	cy=74+(GoY*25);

	xor_mode(TRUE);
	rectfill(screen,cx-6, cy-6, cx+7, cy+7, WHITE);
	xor_mode(FALSE);
}
void GoCursorLeft()
{
	--GoX;
	if(GoX < 0) GoX=0;
	if(GoMessageFlag) GoEraseWarning();
}
void GoCursorRight()
{
	++GoX;
	if(GoX > 18) GoX=18;
	if(GoMessageFlag) GoEraseWarning();
}
void GoCursorUp()
{
	--GoY;
	if(GoY < 0) GoY=0;
	if(GoMessageFlag) GoEraseWarning();
}
void GoCursorDown()
{
	++GoY;
	if(GoY > 18) GoY=18;
	if(GoMessageFlag) GoEraseWarning();
}
void GoUpdateWrongGuesses()
{
	char OutStr[4];

	GoWrongGuesses++;
	PutsLuna(GoUpLftX,GoUpLftY+(9*42)+62, BRICK, BLACK, "INCORRECT: ");
	itoa(GoWrongGuesses,OutStr,10);
	rectfill(screen, GoUpLftX+92,GoUpLftY+(9*42)+62, GoUpLftX+116,GoUpLftY+(9*42)+80,BLACK);
	PutsLuna(GoUpLftX+92,GoUpLftY+(9*42)+62, BIGBLUE, BLACK, OutStr);
}
void GoClearUserNotes()
{
	int zx,zy;

	for( zy = 0; zy < 9; ++zy) {
		for( zx = 0; zx < 9; ++zx) {
			GoUserNotes[zy][zx] = 0;
		}
	}
}
int GoCheckOneUserNote(int ny, int nx, int val)
{
	int bin, check;

	bin=1;
	bin=bin<<val;
	check=GoUserNotes[ny][nx] & bin;
	if(check==0) GoUserNotes[ny][nx] +=bin;
		else GoUserNotes[ny][nx] -=bin;

	return(check);
}
void GoPutUserNote(int x, int y, int Val)
{
	int nx,ny;
	char Str[2];

	if(Val < 1 || Val > 9) return;

	t= Ln[GoY][GoX];
	if( ! isdigit(t)) return;

	nx=GoUpLftX+(x*42);
	ny=GoUpLftY+(y*42);

	nx +=6;
	ny +=4;
	if(Val > 3) ny +=13;
	if(Val > 6) ny +=13;
	if(Val==2 || Val==5 || Val==8) nx +=13;
	if(Val==3 || Val==6 || Val==9) nx +=26;

	itoa(Val,Str,10);
	if(GoCheckOneUserNote(ny,nx,Val)==0) PutsArial10(screen,nx,ny, BRICK, Str);
		else PutsArial10(screen,nx,ny, BLACK, Str);
}
int GoNewPuzzle()
{
	int Result;

	GoPuzzleNum++;
	if(GoPuzzleNum > NumOfFiles) GoPuzzleNum = 0;
	strcpy(CurrentFile,"C:\\LCARS24\\LC24APPS\\SUDOKU\\");
	strcat(CurrentFile, CommonFileArray[GoPuzzleNum]);

	GoDisplayFilename();
	Result = LoadTextFile();
	rectfill(screen,GoUpLftX,GoUpLftY,GoUpLftX+(9*42),GoUpLftY+378,BLACK);
	rectfill(screen,450,GoUpLftY-10,753,200,BLACK);

	/* Erase "WRONG GUESSES" */
	rectfill(screen, GoUpLftX,GoUpLftY+(9*42)+62, GoUpLftX+116,GoUpLftY+(9*42)+80,BLACK);
	GoWrongGuesses=0;
	GoSolutionShowing=FALSE;
	GoActivity=0;
	/* show BACK button disabled */
	rectfill(screen,543,96+(3*47),716,96+(4*47)-4,BLACK);

	if( exists("C:\\LCARS24\\LC24APPS\\SUDOKU\\PUZZ.WIP"))
		remove("C:\\LCARS24\\LC24APPS\\SUDOKU\\PUZZ.WIP");

	return(Result);
}
void GoSaveGameInProgress()
{
	strcpy(CurrentFile,"C:\\LCARS24\\LC24APPS\\SUDOKU\\PUZZ.WIP");
	SaveTextFile();
}
void GoMakeHandicap()
{
	int x,y;
	for(y=3; y<16; y+=6) {
		for(x=3; x<16; x+=6) {
			GoX=x;
			GoY=y;
			GoPlaceStone(2);
		}
	}
}

int GoCapture(int turn)
{
	int x,y, other, oldGoX, oldGoY, a,b,c,d,e;

	oldGoX=GoX;
	oldGoY=GoY;

	if(turn==1) other=2;
		else { other=1; turn=2; }

	for(y=1; y<18; y++) {
		for(x=1; x<18; x++) {
			a=GoBoard[x][y-1];
			b=GoBoard[x-1][y];
			c=GoBoard[x][y];
			d=GoBoard[x+1][y];
			e=GoBoard[x+1][y+1];
			if(c==other && a==turn && b==turn && d==turn && e==turn) {
				GoX=x;
				GoY=y;
				GoRemoveStone();
			}
		}
	}

	GoX=oldGoX;
	GoY=oldGoY;
}

void GoMakeRandomMove()
{
	int x,y,py, oldGoX, oldGoY;

	oldGoX=GoX;
	oldGoY=GoY;

	if(GoX > 0 && GoBoard[GoX-1][GoY]==0) {
		GoX--;
		GoPlaceStone(2);
		return;
	}
	if(GoX < 18 && GoBoard[GoX+1][GoY]==0) {
		GoX++;
		GoPlaceStone(2);
		return;
	}

	y=GoGetRand(18,GoY);
	GoX--;
	if(GoX < 0) GoX=3;

	if(GoBoard[GoX][y] == 0) {
		GoY=y;
		GoPlaceStone(2);
		return;
	}
	GoX=oldGoX;
	GoY=oldGoY;

	x=GoGetRand(18,GoY);
	GoY--;
	if(GoY < 0) GoY=3;
	if(GoBoard[x][GoY] == 0) {
		GoX=x;
		GoPlaceStone(2);
		return;
	}

	GoX--;
	if(GoBoard[GoX][GoY] == 0) {
		GoX=x;
		GoPlaceStone(2);
		return;
	}

	GoX=oldGoX;
	GoY=oldGoY;
/*	GoDrawCursor();  */
}

int GoWindowActive()
{

NextPuzz:
	GoGridColor = makecol(0x99,0x66,0x33);;
	GoDrawEmptyBoard();
	GoMakeHandicap();
	GoX=12;
	GoY=8;
	GoTurn=1;
	GoTurnMessage(GoTurn);
loopback:
	GoDrawCursor();
	do {
		PePutTime(ORANGE);
	} while(!kbhit());
	c = GetKey();
	GoDrawCursor();
	switch( c )
		{
			case 13:        if(GoBoard[GoX][GoY] !=0) {
						GoWarning();
						goto loopback;
					}
					GoPlaceStone(1);
					GoCapture(2);
					GoMakeRandomMove();
					GoCapture(1);
					GoTurnMessage(1);

				/*	GoTurnMessage(GoTurn+1); */
				/*	GoTurn=!GoTurn; */

					goto loopback;
			case 27: 	GoTurnMessage(GoTurn+1);
					GoTurn=!GoTurn;
					goto loopback;
			case F11:	OpenHelp("C:\\LCARS24\\LC24APPS\\SUDOKU\\SUDOKU.TXT");
					min_old=70;
					goto loopback;
			case F12:
					return(0);
			case LEFTARROW: GoCursorLeft();
					goto loopback;
			case RIGHTARROW: GoCursorRight();
					goto loopback;
			case PGUPKEY:
			case UPARROW: 	GoCursorUp();
					goto loopback;
			case PGDNKEY:
			case DOWNARROW: GoCursorDown();
					goto loopback;
			case DELKEY:	GoRemoveStone();
					goto loopback;
			case 350: 	Screenshot792("Go8.bmp");
					goto loopback;
			case 351: 	Screenshot1024("Go10.bmp");
					goto loopback;
			default:        goto loopback;
		}
}

void GoScreen()
{
	int top=87;

	rectfill(screen,0,0,800,600,BLACK);
	PopsicleSticks(LAVENDER);
	Title("GO");

/*	PutsLuna(705-StrLenLuna("NOTES: SHIFT + NUMERIC KEYS"),566, BLACK,LAVENDER, "NOTES: SHIFT + NUMERIC KEYS"); */
	PutsLuna(172,566, BLACK,LAVENDER, "MOVE CURSOR: ARROW KEYS");
	PutsLuna(378,566, BLACK,LAVENDER, "PLACE STONE: ENTER KEY");

/*
	RightBumper36(718,top+(7*47), BIGBLUE);
	ButtonType4(543, top+(4*47), LILAC, "NEXT PUZZLE", "F9", SEABLUE);
*/

	ButtonType4(543, top+(7*47), BIGBLUE, "PASS", "ESC", BRICK);
	ButtonType4(543, top+(8*47), LILAC, "HELP", "F11", TAN);
	ButtonType4(543, top+(9*47), BIGBLUE, "CLOSE", "F12", ORANGE);


/* to verify button alignment with game board */
/* hline(screen, 47, 549, 753, SKYBLUE); */

}
void GoInit()
{
	min_old=70;
	GoClearBoard();

}
int GoMode()
{
	int Result;

	GoInit();
	whitestone=load_bitmap("C:\\LCARS24\\LC24APPS\\GO\\WHITESTN.BMP", the_palette);
	if (!whitestone) {
		NormalLoadError("C:\\LCARS24\\LC24APPS\\GO\\WHITESTN.BMP, WHITESTN.BMP");
		return(86);
	}
	blackstone=load_bitmap("C:\\LCARS24\\LC24APPS\\GO\\BLACKSTN.BMP", the_palette);
	if (!blackstone) {
		NormalLoadError("C:\\LCARS24\\LC24APPS\\GO\\BLACKSTN.BMP, BLACKSRN.BMP");
		return(86);
	}
	GoScreen();
	GoDisplayFilename();
	Result = GoWindowActive();
	destroy_bitmap(whitestone);
	destroy_bitmap(blackstone);
	return(Result);
}

