;;****************************************************************************
;;     loader.asm
;;****************************************************************************
;;
;; loader for eprom code
;;
;; 14apr93 Alessandro Fanelli, Luigi Rizzo (luigi@iet.unipi.it)
;;
;;****************************************************************************
EPROM_SIZE	EQU	32 ;; size eprom, KB
DEST_SEGMENT	EQU	1000h	;; where the code is copied
COM_ORG		EQU	100h	;; start IP for .COM files
    .286 ;;  286 code
    .model tiny ;; for .COM
 
    .CODE
    ORG 100h
the_eprom:
    DB 55h, 0aah
    DB 2*EPROM_SIZE ;; eprom size, in 512byte blocks
    jmp eprom_start;
    DB 0ffh ;; room for checksum
    DB 0ffh ;; room for checksum
    DB 0ffh ;; room for checksum
    DB 0ffh ;; room for checksum
 
eprom_start:
    jmp newint19
    ;; install as new INT19 handler
 
newint19:
    mov ax,cs  ;; establish addressing
    mov ds, ax
    ;; copy to RAM
    xor si,si ;; ds:si=source
    xor di,di ;; es:di dest;;
    mov ax,DEST_SEGMENT ;; dest. segment
    mov es,ax
    mov cx, EPROM_SIZE*1024;;
    cld
    rep movsb
 
    mov ax,DEST_SEGMENT
    mov ds,ax
    mov es,ax
    mov ss,ax
    mov sp,0fffeh
    sti
    ;; set other registers if needed
    push DEST_SEGMENT	;; prepare to jump...
    push COM_ORG
    retf
 
END the_eprom
 
;; --------- end of file --------------
