;;*********  File: bridge.asm *****************************

    PAGE 66,80

;; Copyright (C) 1989 Northwestern University, Vance Morrison
;; AUTHOR: Vance Morrison - morrison@accuvax.nwu.edu - 5/24/89
;; Changes (C) 1993, Universita' di Pisa
;; 05may93 Alessandro Fanelli, Luigi Rizzo (luigi@iet.unipi.it)
;;
;; Permission to view, compile, and modify for LOCAL (intra-organization)
;; USE ONLY is hereby granted, provided that this copyright and permission
;; notice appear on all copies.  Any other use by permission only.
;;
;; Northwestern University makes no representations about the suitability
;; of this software for any purpose.  It is provided "as is" without expressed
;; or implied warranty.  See the copywrite notice file for complete details.
;;
;; BRIDGE.ASM implements a simple ethernet bridge

    .dosseg	;; code first, then data
    .286	;; at least 286 code
    .model tiny ;; for .COM
    ;;  jumps	;; deal with long displacement - default in masm 6.0

;;-------------- this was in declare.inc ------------------------
    include memory.inc  ;; (macros) for 8/16 bit data paths and port I/O
    include bridge.inc  ;; (macros) definition of BDG_IF_R_ACCESS
    include if.inc  ;; (macros) general interface definition
    include ct.inc  ;; statistics
    include copyrt.inc ;;  authors info
    include wd80x3.inc  ;; was wd8003.inc

    include buffer.inc  ;; these are for the serial card
    include queue.inc
    include qif.inc
    include slip.inc
    include i8250.inc

    include packet.inc
    ;   include 3c507.inc

    cur_if = 1  ;; marks the current interface
    include declare.inc ;; bridge configuration
    num_dls= cur_if - 1	;; the index of last interface

    .DATA?
    bdg_table_ptr dw ?  ;; holds segment address of table

;;---------------------------------------------------------------------
;; This routine converts the ASCII base ten number pointed to by SI and
;; returns the number in AX.  It also updates SI to point to the next
;; char in the string.  This routine skips preceeding space and stops
;; conversion at the first non-digit.  Clearly this routine can' handle
;; numbers up to 64K

ASCII_TO_BINARY MACRO
    local top_loop, next_char, conv_string, space_loop, done

space_loop:
    mov CL, [SI]
    cmp CL, ' '         ; skip space
    jnz conv_string
    inc SI
    jmp space_loop
    conv_string:

    xor AX, AX
    xor CH, CH
top_loop:
    sub CL, '0'         ; is it a digit
    jl done
    cmp CL, 9
    jg done

    mov DX, AX          ; AX = AX * 10
    shl AX, 1
    shl AX, 1
    add AX, DX
    shl AX, 1

    add AX, CX
    next_char:
    inc SI
    mov CL, [SI]
    jmp top_loop

done:
ENDM

;;************************************************************************
;;
;; The bridge main entry point for .COM files
    .CODE
    ORG 100H
bridge_start:
    jmp real_start

    ;; insert code for all interfaces
    FOR idx,<1,2,3,4,5>
        WDE_REAL_DEFINE  idx
        I8250_REAL_DEFINE idx
        PKT_REAL_DEFINE idx
	; C507_REAL_DEFINE idx
    ENDM

real_start:
    mov AX, cs  ;; initialize data segment
    mov DS, AX	;; not really needed...
    cld		;; direction forward - default
    IFDEF i8250_declared ;; save the command line
	.DATA
	comline_count db 0   ;; a place to put the command line
	comline       db 127 dup (0)
	baud_rate_div dw 0   ;; used for remote bridging
	.CODE
	mov SI, 80h
	mov AX, cs
	mov ES, AX
	mov DI, offset comline_count
	mov CX, 40h
	rep   movsw
	mov SI, offset comline	;; if this is a remote bridge
	ASCII_TO_BINARY		;; get the baud rate
	cmp AX, 0
	jnz not_default
	mov AX, 19200                   ;; 19.2 is the default
    not_default:
	shr AX, 1                           ;; compute the baud rate div
	mov BX, AX
	mov AX, 57600
	xor DX, DX
	div BX
	mov baud_rate_div, AX
    ENDIF ;; i8250_declared

    FOR idx,<1,2,3,4,5>		;; call definition code
	IF idx le num_dls	;; for existing IF only

	    WDE_DEFINE		idx

	    BUFF_DEFINE		%(idx*10+1) ;; this is for the serial IF
	    QUEUE_DEFINE	%(idx*10+2)
	    BUFF_DEFINE		%(idx*10+3)
	    QUEUE_DEFINE	%(idx*10+4)
	    Q_IF_DEFINE		idx
	    SLIP_DEFINE		idx
	    I8250_DEFINE	idx, serial_fail
	
	    PKT_DEFINE		idx, packet_fail

	    ; C507_DEFINE	idx, card_fail

	ENDIF     ;; idx le num_dls
    ENDM

    .CODE
    mov bdg_flush_ptr,6
    mov ax, cs
    add ax, 1000h
    mov bdg_table_ptr, AX   ;; remember where the table is
    mov ES, AX
    xor DI, DI
    mov CX, 32768 ;; table size
    mov ax, 0ffffh ;; clean the table. No card has address FFFFFFFFFFFF
    rep stosw ;; default - forward

    call INIT_TAB ;; init digits table
    call PRINT_MASK ;; print mask
    call PRINT_CARDS ;; print working cards
    ;; start looking for packets
    ;; This is the brigde main loop, we want to go FAST!
    ;;
init_ct:
    mov cx, 2048    ;; cx= # big_loops before increase BIGLOOP_CTR
big_loop:
    push cx
    FOR idx,<1,2,3,4,5> ;; was 8
	IF idx le num_dls
	    BDG_IF_R_ACCESS idx
	ENDIF     ;; idx le num_dls
    ENDM
    pop cx
IFDEF flush_tables
    cmp cl,0
    jne dont_flush
    mov es,bdg_table_ptr	;; flush about 16 entries per second
    mov bx, bdg_flush_ptr	;; wrap in 512 seconds
    mov byte ptr es:[bx],0ffh	;; flush entry
    add bx, 8			;; don't care about wraparound
    mov bdg_flush_ptr, bx
dont_flush:
ENDIF ;; flush_tables
    dec cx
    jnz big_loop
    COUNT_CYCLE %BIGLOOP_CTR
    PRINT_COUNTERS
    jmp init_ct
    ;; never exit from here.

card_fail:	;; print_reg <error configuring ethernet card.  Code = >, AX
packet_fail:	;; print <error configuring packet driver>
serial_fail:	;; print <error configuring serial port>

terminate: jmp terminate	;;
    include proc.asm
END bridge_start
;; --------- end of file --------------
