/*
 * PWCBSD - Philips USB webcam driver for FreeBSD 5.4 and higher
 *
 *  Copyright (C) 2006 Raaf 
 *
 * Based on the Linux pwc driver.
 *  
 *  Copyright (C) 1999-2003 Nemosoft Unv.
 *  Copyright (C) 2004-2006 Luc Saillard
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301  USA
 */
#ifndef PWC_DEC23_H
#define PWC_DEC23_H

struct pwc_dec23_private
{
  unsigned char xx,yy,zz,zzmask;

  unsigned char table_0004[2*0x4000];
  unsigned char table_8004[2*0x1000];
  unsigned int  table_a004[256*12];

  unsigned char table_d004[8*256];
  unsigned int  table_d800[256];
  unsigned int  table_dc00[256];
};


void pwc_dec23_init(int type, int release, unsigned char *buffer, void *private_data);
void pwc_dec23_exit(void);
void pwc_dec23_decompress(const struct pwc_coord *image,
                            const struct pwc_coord *view,
			    const struct pwc_coord *offset,
			    const char *src,
			    char *dst,
			    int flags,
			    const void *data,
			    int bandlength);



#endif



