; This file is a part of SecureDevice 1.4
; Copyright (C) 1994 by Max Loewenthal and Arthur Helwig

; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.

; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.

; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

IDEAL
MODEL       TINY,C
JUMPS

INCLUDE     'GLOBALS.ASM'
INCLUDE     'DVSTRUCS.ASM'

MinorName   EQU         'SDTSR'
MinorVer    EQU         '1.02'

MaxDrives   =           26
WinWidth    =           MaxPwdLen+10
WinHeight   =           9
;DEBUG       =           1

STRUC       ColorMap
            EnterBox    DB          ?
            WrongBox    DB          ?
            EnterText   DB          ?
            WrongText   DB          ?
            Password    DB          ?
ENDS        ColorMap

PwdX        =           5
PwdY        =           4
StackSize   =           512
TimerFreq   =           1193180


MACRO       UpcaseChar  Ch
            LOCAL       @@0

                        CMP         Ch,'a'
                        JB          @@0
                        CMP         Ch,'z'
                        JA          @@0
                        SUB         Ch,'a'-'A'
            @@0:
ENDM        UpcaseChar

STRUC       DriveKeys
            Key         DB          0
            ShiftState  DW          0
ENDS        DriveKeys

EXTRN       MD5Init:PROC,MD5Update:PROC,MD5Final:PROC
EXTRN       Write:PROC,InitScreen:PROC,MovePart:PROC
EXTRN       ScreenHeight:WORD,ScreenWidth:WORD,Graphic:BYTE

CODESEG
            ASSUME       CS:@CODE-10h
ORG         100h
START:
            JMP         Install

            ASSUME      ES:@CODE,DS:@CODE,SS:@CODE,CS:@CODE
PROC        InputPassword
            ; CF = Escaped
            LOCAL       InsertOn:BYTE

                        PUSH        AX BX CX DX SI DI


            @@2:

                        MOV         BX,0                    ; pointer in buffer

            @@Next:     CMP         [ShowBox],0
                        JE          @@0
                        CALL        @@Display
            @@0:        MOV         AH,0
                        INT         16h
                        CMP         AL,8
                        JE          @@BackSpace
                        CMP         AL,13
                        JE          @@Entered
                        CMP         AL,27
                        JE          @@Escaped
                        CMP         AL,0
                        JE          @@Next

            @@1:        CMP         BX,MaxPwdLen
                        JAE         @@Next
                        MOV         [Password+BX],AL
                        INC         BX
                        JMP         @@Next

            @@Backspace:CMP         BX,0
                        JE          @@Next
                        DEC         BX
                        JMP         @@Next

            @@Entered:  CMP         BX,0
                        JE          @@Escaped
                        MOV         [PasswordLen],BX
                        CLC
            @@Exit:     POP         DI SI DX CX BX AX
                        RET
            @@Escaped:  STC
                        MOV         [PasswordLen],0
                        JMP         @@Exit


            @@Stars     DB          MaxPwdLen DUP ('?')
            @@EndStars  DB          0

            @@Display:  PUSH        AX DI CX
                        MOV         CX,BX
                        LEA         DI,[@@Stars]
                        MOV         AL,'*'
                        CLD
                        REP         STOSB
                        MOV         CX,MaxPwdLen
                        SUB         CX,BX
                        JCXZ        @@4
                        MOV         AL,' '
                        REP         STOSB

            @@4:        LEA         AX,[@@Stars]
                        PUSH        AX
                        MOV         AL,[Colors.Password]
                        PUSH        AX
                        MOV         AX,[WinY]
                        ADD         AX,PwdY
                        PUSH        AX
                        MOV         AX,[WinX]
                        ADD         AX,PwdX
                        PUSH        AX
                        CALL        Write
                        ADD         SP,8
                        POP         CX DI AX
                        RETN
ENDP        InputPassword
PROC        DrawBox
            ; DL = Attr
                        PUSH        AX BX CX DX SI DI

                        MOV         AX,[WinX]
                        MOV         BX,[WinY]
                        LEA         DI,[BoxTop]
                        PUSH        DI DX BX AX
                        CALL        Write
                        ADD         SP,8
                        MOV         CX,WinHeight-2
                        LEA         DI,[BoxMiddle]
                        PUSH        DI DX

            @@NextLine: INC         BX
                        PUSH        BX AX
                        CALL        Write
                        POP         SI SI
                        LOOP        @@NextLine

                        POP         SI SI

                        LEA         DI,[BoxBottom]
                        INC         BX
                        PUSH        DI DX BX AX
                        CALL        Write
                        ADD         SP,8

                        POP         DI SI DX CX BX AX
                        RET
ENDP        DrawBox
            BoxTop       DB           '',WinWidth-2 DUP (''),'',0
            BoxMiddle    DB           '',WinWidth-2 DUP (' '),'',0
            BoxBottom    DB           '',WinWidth-2 DUP (''),'',0

PROC        MakeKey
            ASSUME      DS:@CODE,ES:@CODE,SS:@CODE,CS:@CODE
            LOCAL       MD5Buf:BYTE:88,TempKey:WORD:8

                        PUSH        AX BX CX DX DI SI ES

                        LEA         DI,[TempKey]            ; BC preserves SI DI
                        LEA         SI,[MD5Buf]

                        LEA         AX,[Password]
                        PUSH        [PasswordLen] DS AX SS SI
                        CALL        MD5Init
                        CALL        MD5Update
                        PUSH        SS DI                   ; SS:SI->MD5Buf still on the stack
                        CALL        MD5Final
                        ADD         SP,0Eh

                        POP         ES

                        LEA         SI,[TempKey]
                        LEA         DI,[Key]
                        MOV         CX,8
                        REP         MOVSW

                        MOV         SI,2
                        MOV         DI,4
                        MOV         BX,0
                        MOV         CX,44

            @@Next:     PUSH        BX
                        AND         BX,NOT 15
                        MOV         AX,[Key+BX+SI]
                        MOV         DX,[Key+BX+DI]
                        POP         BX
                        PUSH        CX
                        MOV         CL,9
                        SHL         AX,CL
                        MOV         CL,7
                        SHR         DX,CL
                        POP         CX
                        OR          AX,DX

                        MOV         [Key+BX+16],AX
            REPT        2
                        INC         BX
                        INC         SI
                        INC         DI
            ENDM
                        AND         DI,14
                        AND         SI,14
                        LOOP        @@Next

                        MOV         CX,52
                        MOV         BX,0
            @@Nxt:      XOR         [Key+BX],0DAEh
                        ADD         BX,2
                        LOOP        @@Nxt

                        POP         SI DI DX CX BX AX
                        RET
ENDP        MakeKey
PROC        Sound
            ; IN: BX=TimerFreq/frequency
                        PUSH        AX
                        IN          AL,61h
                        OR          AL,3
                        OUT         61h,AL
                        MOV         AL,0B6h
                        OUT         43h,AL
                        MOV         AL,BL
                        OUT         42h,AL
                        MOV         AL,BH
                        OUT         42h,AL
                        POP         AX
                        RET
ENDP        Sound
PROC        SoundOff
                        PUSH        AX
                        IN          AL,61H
                        AND         AL,0fcH
                        OUT         61H,AL
                        POP         AX
                        RET
ENDP        SoundOff
PROC        Pause
            ; CX = nof ticks
                        PUSHF
                        PUSH        ES AX CX
                        STI
                        MOV         AX,0
                        MOV         ES,AX
            @@Next:     MOV         AX,[ES:46Ch]
            @@Nothing:  CMP         [ES:46Ch],AX
                        JE          @@Nothing
                        LOOP        @@Next
                        POP         CX AX ES
                        POPF
                        RET
ENDP        Pause
PROC        EnterSound
                        CMP         [Beeps],0
                        JE          @@Exit
                        PUSH        CX BX
                        MOV         CX,4
                        MOV         BX,2711     ; TimerFreq/440
                        CALL        Sound
                        CALL        Pause
                        MOV         BX,3836     ; TimerFreq/311
                        CALL        Sound
                        CALL        Pause
                        CALL        SoundOff
                        POP         BX CX
            @@Exit:     RET
ENDP        EnterSound
PROC        WrongSound
                        CMP         [Beeps],0
                        JE          @@Exit
                        PUSH        CX BX
                        MOV         CX,4
                        MOV         BX,10847    ; TimerFreq/110
                        CALL        Sound
                        CALL        Pause
                        MOV         BX,15297    ; TimerFreq/78
                        CALL        Sound
                        CALL        Pause
                        CALL        SoundOff
                        POP         BX CX
            @@Exit:     RET
ENDP        WrongSound
PROC        GotitSound
                        CMP         [Beeps],0
                        JE          @@Exit
                        PUSH        CX BX
                        MOV         CX,2
                        MOV         BX,1355     ; TimerFreq/880
                        CALL        Sound
                        CALL        Pause
                        MOV         CX,4
                        MOV         BX,1011     ; TimerFreq/1180
                        CALL        Sound
                        CALL        Pause
                        CALL        SoundOff
                        POP         BX CX
            @@Exit:     RET
ENDP        GotitSound
PROC        WrongBox
            ; CX = # of try
                        PUSH        AX DX

                        MOV         DL,[Colors.WrongBox]
                        CALL        DrawBox

                        LEA         AX,[@@Wrong]
                        PUSH        AX
                        MOV         AL,[Colors.WrongText]
                        PUSH        AX
                        MOV         AX,[WinY]
                        ADD         AX,PwdY
                        DEC         AX
                        PUSH        AX
                        MOV         AX,(WinWidth-17)/2
                        ADD         AX,[WinX]
                        PUSH        AX
                        CALL        Write
                        ADD         SP,8
                        CMP         CX,1
                        JE          @@0
                        LEA         AX,[@@Again]
                        PUSH        AX
                        MOV         AL,[Colors.WrongText]
                        PUSH        AX
                        MOV         AX,[WinY]
                        ADD         AX,PwdY
                        PUSH        AX
                        MOV         AX,(WinWidth-9)/2
                        ADD         AX,[WinX]
                        PUSH        AX
                        CALL        Write
                        ADD         SP,8

            @@0:        MOV         AH,0
                        INT         16h
                        CMP         AL,27h
                        CLC
                        JNE         @@Exit
                        STC
            @@Exit:     
                        POP         DX AX
                        RET
            @@Wrong     DB          'Invalid password!',0
            @@Again     DB          'Try again',0
ENDP        WrongBox
PROC        TestKey
                        PUSH        AX DX SI
                        CALL        MakeKey
                        MOV         AX,0E200h
                        MOV         DL,[Drive]
                        LEA         SI,[Key]
                        INT         2Fh
                        CMP         AL,1
                        CLC
                        JE          @@Exit
                        STC
            @@Exit:     POP         SI DX AX
                        RET
ENDP        TestKey
PROC        EnterBox
                        PUSH        DX AX
                        MOV         DL,[Colors.EnterBox]
                        CALL        DrawBox
                        MOV         AL,[Drive]
                        MOV         [@@Drive],AL
                        ADD         [@@Drive],'A'
                        LEA         AX,[@@Question]
                        PUSH        AX
                        MOV         AL,[Colors.EnterText]
                        PUSH        AX
                        MOV         AX,[WinY]
                        ADD         AX,PwdY
                        DEC         AX
                        PUSH        AX
                        MOV         AX,(WinWidth-27)/2
                        ADD         AX,[WinX]
                        PUSH        AX
                        CALL        Write
                        ADD         SP,8
                        POP         AX DX
                        RET
            @@Question  DB          'Enter password for drive '
            @@Drive     DB          '?:',0
ENDP        EnterBox
PROC        DoPasswordThing
                        PUSH        CX

                        CMP         [ShowBox],1
                        JE          @@1
                        CALL        EnterSound

            @@1:        MOV         CX,3
                        
            @@15:       CMP         [ShowBox],0
                        JE          @@2
                        CALL        EnterBox

            @@2:        CALL        InputPassword
                        JC          @@Exit
                        CALL        TestKey
                        JNC         @@GotIt

                        CALL        WrongSound
                        CMP         [ShowBox],0
                        JE          @@3
                        CALL        WrongBox
                        JC          @@Exit
            @@3:        
                        LOOP        @@15
                        JMP         @@Exit

            @@GotIt:    CALL        GotItSound

            @@Exit:     PUSH        ES DI AX
                        PUSH        CS
                        POP         ES
                        MOV         AL,0
                        CLD
                        MOV         CX,SIZE Key
                        LEA         DI,[Key]
                        REP         STOSB
                        MOV         CX,SIZE Password
                        LEA         DI,[Password]
                        REP         STOSB
                        MOV         [PasswordLen],0
                        POP         AX DI ES CX
                        RET
ENDP        DoPasswordThing
PROC        PopUp
                        PUSH        AX BX CX DX
                        CALL        Initscreen
                        MOV         [ShowBox],0
                        
                        CMP         [Graphic],0
                        JNE         @@3
                        CMP         [ScreenWidth],WinWidth
                        JB          @@3
                        MOV         [ShowBox],1
                        
                        MOV         AH,3
                        INT         10h
                        MOV         [@@OldCursor],CX
                        MOV         CX,2020h
                        MOV         AH,1
                        INT         10h

                        MOV         AX,[ScreenHeight]
                        SUB         AX,WinHeight
                        SHR         AX,1
                        MOV         BX,AX
                        ADD         AX,WinHeight
                        DEC         AX
                        PUSH        AX                      ; Y2
                        MOV         AX,[ScreenWidth]
                        SUB         AX,WinWidth
                        SHR         AX,1
                        MOV         DX,AX
                        ADD         AX,WinWidth
                        DEC         AX
                        PUSH        AX                      ; X2
                        PUSH        BX DX                   ; Y1 X1
                        MOV         [WinX],DX
                        MOV         [WinY],BX
                        LEA         AX,[SaveBuffer]
                        PUSH        AX
                        MOV         AX,0                    ; to buffer
                        PUSH        AX
                        CALL        MovePart
                        POP         AX                      ; leave buffer+coords on stack

            @@3:        CALL        DoPasswordThing

                        CMP         [ShowBox],0
                        JE          @@2

                        MOV         AX,1                    ; to screen
                        PUSH        AX
                        CALL        MovePart
                        ADD         SP,0Ch
                        MOV         CX,[@@OldCursor]
                        MOV         AH,1
                        INT         10h

            @@2:        POP         DX CX BX AX
                        RET
            @@OldCursor DW          ?
ENDP        PopUp
OldINT2F    DD          ?
OldINT09    DD          ?
OldINT15    DD          ?

PROC        NewINT2F
            ; 1605:  windows in
            ; 1606:  windows out

            ; DE0F:  DV/X in
            ; DE03:  DV/X out

            ; E204:  installation check: returns AX=1DEAh, BX=0 if installed
            ; E202:  ask password: DL=drive, called by SECDEV.SYS
            ; E205:  set key: DL=drive (0FFh for all), SI = ShiftState, CL = scancode (0 for none)
            ; E206:  set colors: BL BH CL CH DL = colormap
            ; E207:  set quiet mode

            ASSUME      DS:NOTHING,ES:NOTHING,SS:NOTHING
                        CMP         AH,0DEh
                        JNE         @@7
            @@DVX:      CMP         AL,0Fh
                        JNE         @@8
                        MOV         [InDVX],1
                        JMP         @@DoOld
            @@8:        CMP         AL,3
                        JNE         @@DoOld
                        MOV         [InDVX],0
                        JMP         @@DoOld

            @@7:        CMP         AH,16h
                        JNE         @@6
            @@Windows:  CMP         AL,05
                        JNE         @@4
                        MOV         [InWindows],1
                        JMP         @@DoOld
            @@4:        CMP         AL,6
                        JNE         @@DoOld
                        MOV         [InWindows],0
                        JMP         @@Doold

            @@6:        CMP         AH,0E2h
                        JNE         @@DoOld
                        CMP         [InWindows],0
                        JNE         @@DoOld
                        CMP         [InDVX],0
                        JNE         @@DoOld

                        CMP         AX,0E206h
                        JNE         @@3
                        MOV         [Colors.EnterBox],BL
                        MOV         [Colors.WrongBox],BH
                        MOV         [Colors.EnterText],CL
                        MOV         [Colors.WrongText],CH
                        MOV         [Colors.Password],DL
                        IRET

            @@3:        CMP         AX,0E207h
                        JNE         @@9
                        MOV         [Beeps],0
                        IRET

            @@9:        CMP         AX,0E205h
                        JNE         @@0
                        PUSH        AX BX SI
                        MOV         BX,DX
                        MOV         BH,0
                        INC         BL
                        CMP         BX,MaxDrives
                        JA          @@2
                        MOV         AL,SIZE DriveKeys
                        MUL         BL
                        MOV         BX,AX
                        MOV         [BX+KeyStrokes.Key],CL
                        AND         SI,0F70Fh
                        MOV         [BX+KeyStrokes.ShiftState],SI
            @@2:        POP         SI BX AX
                        IRET

            @@0:        CMP         AX,0E204h
                        JNE         @@1
                        MOV         AX,1DEAh
                        MOV         BX,0
                        IRET

            @@1:        CMP         AX,0E202h
                        JNE         @@DoOld

                        MOV         [WORD PTR @@OldStack],SP
                        MOV         [WORD PTR @@OldStack+2],SS

                        CLI
                        PUSH        CS
                        POP         SS
                        MOV         SP,OFFSET EndOfCode+StackSize
            ASSUME      SS:@CODE
                        PUSH        DS ES
                        PUSH        CS CS
                        POP         ES DS
            ASSUME      DS:@CODE,ES:@CODE
                        MOV         [Drive],DL

                        PUSH        ES AX
                        MOV         AX,0
                        MOV         ES,AX
            ASSUME      ES:NOTHING
                        MOV         AX,[WORD PTR OldINT09]
                        XCHG        AX,[ES:24h]
                        MOV         [WORD PTR @@INT09],AX
                        MOV         AX,[WORD PTR OldINT09+2]
                        XCHG        AX,[ES:26h]
                        MOV         [WORD PTR @@INT09+2],AX
                        STI
                        POP         AX ES
                        CALL        Popup
                        PUSH        ES AX
                        CLI
                        MOV         AX,0
                        MOV         ES,AX
                        MOV         AX,[WORD PTR @@INT09]
                        MOV         [ES:24h],AX
                        MOV         AX,[WORD PTR @@INT09+2]
                        MOV         [ES:26h],AX
                        STI
                        POP         AX ES

                        POP         ES DS
            ASSUME      DS:NOTHING,ES:NOTHING
                        CLI
                        MOV         SS,[WORD PTR @@OldStack+2]
            ASSUME      SS:NOTHING
                        MOV         SP,[WORD PTR @@OldStack]
                        IRET

            @@DoOld:    JMP         [OldINT2F]
            @@INT09     DD          ?
            @@OldStack  DD          ?

ENDP        NewINT2F
PROC        GetShiftState

            ; return:   SI = shift states

                        PUSH        BX ES

                        MOV         BX,0
                        MOV         ES,BX

                        MOV         SI,[WORD PTR ES:417h]
                        AND         SI,0F70Fh
            ; this part is due to a bug in at least my BIOS:
            ;   when a right alt or a right ctrl is pressed,
            ;   the shift-states at 0:418 aren't properly set.

                        MOV         BX,SI
                        AND         BX,0504h                ; = any+left+right ctrl
                        CMP         BX,0004h                ; = any
                        JNE         @@7
                        OR          SI,0400h                ; = right

            @@7:        MOV         BX,SI
                        AND         BX,0A08h                ; = any+left+right ctrl
                        CMP         BX,0008h                ; = any
                        JNE         @@A
                        OR          SI,0800h                ; = right

            @@A:        POP         ES BX
                        RET
ENDP        GetShiftState
PROC        FindHotKey
            ASSUME      ES:NOTHING,DS:NOTHING,SS:NOTHING,CS:@CODE
            ; entry:
            ;   SI = shiftstate
            ;   AL = keystroke
            ;   DL = old drive  (-2 for first call)
            ;   BX = saved from previous call
            ; return:
            ;   ZF = 1 if found
            ;   DL = drive

                        CMP         DL,-2
                        JNE         @@Next

                        MOV         BX,0
                        MOV         DL,-1

            @@1:        CMP         [BX+KeyStrokes.Key],0
                        JNE         @@2
                        CMP         [BX+KeyStrokes.ShiftState],0
                        JE          @@Next

            @@2:        CMP         [BX+KeyStrokes.Key],AL
                        JNE         @@Next
                        PUSH        SI
                        TEST        [BX+KeyStrokes.ShiftState],0500h
                        JNE         @@B
                        AND         SI,NOT 0500h                     ; to support any (left or right) ctrl
            @@B:        TEST        [BX+KeyStrokes.ShiftState],0A00h
                        JNE         @@C
                        AND         SI,NOT 0A00h                     ; to support any (left or right) alt
            @@C:        CMP         SI,[BX+KeyStrokes.ShiftState]
                        POP         SI
                        JE          @@Found

            @@Next:     ADD         BX,3
                        INC         DX
                        CMP         DL,MaxDrives
                        JL          @@1
                        STC

            @@Exit:     RET

            @@Found:    CLC
                        RET
ENDP        FindHotKey

PROC        NewINT09
            ASSUME      ES:NOTHING,DS:NOTHING,SS:NOTHING,CS:@CODE

                        PUSH        SI AX BX DX
                        IN          AL,60h
                        TEST        AL,80h
                        JNE         @@DoOld

                        CMP         AL,0
                        JE          @@DoOld

                        CALL        GetShiftState
            IFDEF       DEBUG
                        CALL        LogKey
            ENDIF
                        MOV         DL,-2
                        CALL        FindHotKey
                        JC          @@DoOld

            @@Capture:  PUSH        AX
                        IN          AL,61h
                        MOV         AH,AL
                        OR          AL,80h
                        OUT         61h,AL
                        XCHG        AH,AL
                        OUT         61h,AL
                        MOV         AL,20h
                        OUT         20h,AL
                        POP         AX
                        JMP         @@1

            @@Next:     CALL        FindHotKey
                        JC          @@Exit

            @@1:        PUSH        AX
                        MOV         AX,0E203h
                        INT         2Fh
                        POP         AX
                        JMP         @@Next

            @@DoOld:    PUSHF
                        CALL        [OldINT09]

                        CALL        GetShiftState
                        CMP         SI,[OldShift]
                        JE          @@Exit
                        CMP         SI,0
                        JE          @@Exit

            @@4:        MOV         DL,-2
                        MOV         AL,0

            @@Next2:    CALL        FindHotKey
                        JC          @@8

                        PUSH        AX
                        MOV         AX,0E203h
                        INT         2Fh
                        POP         AX
                        JMP         @@Next2

            @@8:        MOV         [OldShift],SI

            @@Exit:     POP         DX BX AX SI
                        IRET
ENDP        NewINT09
IFDEF       DEBUG

MaxLogs     =           100

            NofLogs     DW          0
            Logs        DD          MaxLogs DUP (0)

PROC        LogKey      NEAR
            ASSUME      ES:NOTHING,DS:NOTHING,SS:NOTHING,CS:@CODE


                        CMP         [NofLogs],MaxLogs
                        JAE         @@Exit

                        PUSH        BX

                        MOV         BX,[NofLogs]
                        SHL         BX,1
                        SHL         BX,1
                        MOV         [WORD PTR BX+Logs],SI
                        MOV         [BYTE PTR BX+Logs+2],AL
                        INC         [NofLogs]

                        POP         BX

            @@Exit:     RET

ENDP        LogKey


ENDIF

DATASEG
            Drive       DB          ?
            SaveBuffer  DW          WinWidth*WinHeight DUP (?)
            WinX        DW          ?
            WinY        DW          ?
            ShowBox     DB          0
            InWindows   DB          0
            InDVX       DB          0
            Beeps       DB          -1

            Colors      ColorMap    <1Fh,4Eh,1Eh,4Fh,0Fh>

            Key         DW          52 DUP (?)
            PasswordLen DW          0
            Password    DB          MaxPwdLen+1 DUP ('?')
            Keystrokes  DriveKeys   MaxDrives+1 DUP (<>)                ; first = all
            OldShift    DW          0

            LABEL       EndOfCode
            AlreadyMsg  DB          'Already installed.',0Dh,0Ah,'$'
            InstMsg     DB          'Installed.',0Dh,0Ah,'$'

PROC        NextWord
            ASSUME      ES:NOTHING,DS:@CODE,CS:@CODE,SS:@CODE
            ; entry:
            ;   DI-> string
            ; return:
            ;   DI-> beginning of next word in string

                        CMP         [BYTE PTR DI],' '
                        JE          @@Next
                        CMP         [BYTE PTR DI],09h
                        JE          @@Next
                        RET

            @@Next:     INC         DI
                        JMP         NextWord
ENDP        NextWord

PROC        NextSpace
            ASSUME      ES:NOTHING,DS:@CODE,CS:@CODE,SS:@CODE
            ; entry:
            ;   DI-> string
            ; return:
            ;   DI-> beginning of next space/tab in string
                        CMP         [BYTE PTR DI],' '
                        JE          @@Exit
                        CMP         [BYTE PTR DI],09h
                        JE          @@Exit
                        CMP         [BYTE PTR DI],0Dh
                        JE          @@Exit
                        INC         DI
                        JMP         NextSpace

            @@Exit:     RET
ENDP        NextSpace

PROC        DeHex
            ; in: AX = string in hex
            ; out: AL = value, Carry set if error

                        CALL        @@DeHex
                        JC          @@Error
                        XCHG        AL,AH
                        CALL        @@DeHex
                        JC          @@Error
                        SHL         AH,1
                        SHL         AH,1
                        SHL         AH,1
                        SHL         AH,1
                        OR          AL,AH
                        RET

            @@Error:    STC
                        RET

            @@DeHex:
            ; in: AL = digit in hex
            ; out: AL = value, Carry set if error
                        UpcaseChar  AL
                        CMP         AL,'0'
                        JB          @@Error
                        CMP         AL,'9'
                        JA          @@Letter
                        SUB         AL,'0'
                        CLC
                        RET
            @@Letter:   CMP         AL,'A'
                        JB          @@Error
                        CMP         AL,'F'
                        JA          @@Error
                        SUB         AL,'A'-0Ah
                        CLC
                        RET
ENDP        DeHex

PROC        DumpHex
            ARG         Data:BYTE

                        PUSH        DX CX BX AX
                        MOV         AH,2
                        MOV         BH,0
                        MOV         CL,[Data]
                        MOV         CH,CL
                        SHR         CL,1
                        SHR         CL,1
                        SHR         CL,1
                        SHR         CL,1
                        MOV         BL,CL
                        MOV         DL,[HexDigits+BX]
                        INT         21h
                        MOV         BL,CH
                        AND         BL,0Fh
                        MOV         DL,[HexDigits+BX]
                        INT         21h
                        POP         AX BX CX DX
                        RET

            HexDigits   DB          '0123456789ABCDEF'
ENDP        DumpHex

PROC        DumpWord
            ; DS:DI-> word
                        PUSH        SI AX DX

                        MOV         AH,2
                        MOV         SI,DI

            @@Next:     LODSB
                        CMP         AL,' '
                        JE          @@Exit
                        CMP         AL,9
                        JE          @@Exit
                        CMP         AL,0Dh
                        JE          @@Exit
                        MOV         DL,AL
                        INT         21h
                        JMP         @@Next

            @@Exit:     POP         DX AX SI
                        RET
ENDP        DumpWord

PROC        ExtractParms
            ASSUME      ES:NOTHING,DS:@CODE,CS:@CODE,SS:@CODE
                        PUSH        AX BX CX DX DI SI

                        MOV         DI,81h

            @@Next:     CALL        NextWord
                        CMP         [BYTE PTR DI],0Dh
                        JE          @@Exit
                        CMP         [BYTE PTR DI],'/'
                        JNE         @@Error
                        MOV         AL,[BYTE PTR DI+1]
                        UpcaseChar  AL
                        CMP         AL,'K'
                        JE          @@Keys
                        CMP         AL,'Q'
                        JE          @@Quiet
                        CMP         AL,'C'
                        JNE         @@Error

            @@Colors:   LEA         SI,[DI+2]
                        CLD
                        LODSW
                        CALL        DeHex
                        JC          @@Error
                        MOV         BL,AL
                        LODSW
                        CALL        DeHex
                        JC          @@Error
                        MOV         BH,AL
                        LODSW
                        CALL        DeHex
                        JC          @@Error
                        MOV         CL,AL
                        LODSW
                        CALL        DeHex
                        JC          @@Error
                        MOV         CH,AL
                        LODSW
                        CALL        DeHex
                        JC          @@Error
                        MOV         DL,AL
                        LODSB
                        CMP         AL,' '
                        JE          @@Ok1
                        CMP         AL,9
                        JE          @@Ok1
                        CMP         AL,0Dh
                        JNE         @@Error
            @@Ok1:      MOV         AX,0E206h
                        INT         2Fh
                        PUSH        DX
                        LEA         DX,[@@ColorsMsg]
                        MOV         AH,9
                        INT         21h
                        POP         DX
                        MOV         AL,BL
                        PUSH        AX
                        CALL        DumpHex
                        POP         AX
                        MOV         AL,BH
                        PUSH        AX
                        CALL        DumpHex
                        POP         AX
                        MOV         AL,CL
                        PUSH        AX
                        CALL        DumpHex
                        POP         AX
                        MOV         AL,CH
                        PUSH        AX
                        CALL        DumpHex
                        POP         AX
                        MOV         AL,DL
                        PUSH        AX
                        CALL        DumpHex
                        POP         AX
                        JMP         @@DoCRLF

            @@Quiet:    LEA         SI,[DI+2]
                        CLD
                        LODSB
                        CMP         AL,' '
                        JE          @@Ok2
                        CMP         AL,9
                        JE          @@Ok2
                        CMP         AL,0Dh
                        MOV         AX,0E207h
                        INT         2Fh
                        JNE         @@Error

            @@Ok2:      LEA         DX,[@@QuietMsg]
                        MOV         AH,9
                        INT         21h
                        JMP         @@DoCRLF

            @@Keys:     MOV         DL,[BYTE PTR DI+2]
                        UpcaseChar  DL
                        SUB         DL,'@'
                        CMP         DL,MaxDrives
                        JA          @@Error
                        DEC         DL
                        LEA         SI,[DI+3]
                        CLD
                        LODSW
                        CALL        DeHex
                        JC          @@Error
                        MOV         BH,AL
                        LODSW
                        CALL        DeHex
                        JC          @@Error
                        MOV         BL,AL
                        LODSW
                        CALL        DeHex
                        JC          @@Error
                        MOV         CL,AL
                        LODSB
                        CMP         AL,' '
                        JE          @@Ok
                        CMP         AL,9
                        JE          @@Ok
                        CMP         AL,0Dh
                        JNE         @@Error
            @@Ok:
                        MOV         SI,BX
                        MOV         AX,0E205h
                        INT         2Fh

                        MOV         BL,DL
                        LEA         DX,[@@KeyAllMsg]
                        CMP         BL,0FFh
                        JE          @@0
                        LEA         DX,[@@KeySetMsg]
                        ADD         BL,'A'
                        MOV         [@@Drive],BL
            @@0:        MOV         AH,9
                        INT         21h
                        MOV         AX,SI
                        XCHG        AL,AH
                        PUSH        AX
                        CALL        DumpHex
                        POP         SI
                        XCHG        AL,AH
                        PUSH        AX
                        CALL        DumpHex
                        POP         SI
                        MOV         AL,CL
                        PUSH        AX
                        CALL        DumpHex
                        POP         SI
                        JMP         @@DoCRLF

            @@Error:    LEA         DX,[@@ErrorMsg]
                        MOV         AH,9
                        INT         21h
                        CALL        DumpWord
            @@DoCRLF:   LEA         DX,[@@CRLF]
                        MOV         AH,9
                        INT         21h

            @@1:        CALL        NextSpace
                        JMP         @@Next
                        
            @@Exit:     POP         SI DI DX CX BX AX
                        RET
            @@ErrorMsg  DB          'Error in parameter: $'
            @@CRLF      DB          0Dh,0Ah,'$'
            @@KeysetMsg DB          'Key combination for drive '
            @@Drive     DB          '? set at: $'
            @@KeyAllMsg DB          'Key combination for all drives set at: $'
            @@ColorsMsg DB          'Colors set at $'
            @@QuietMsg  DB          'Quiet mode.$'

ENDP        ExtractParms

Install:                ASSUME      ES:NOTHING,DS:@CODE,CS:@CODE,SS:@CODE

                        MOV         AH,9
                        LEA         DX,[NameVersion]
                        INT         21h
                        MOV         AX,0E204h
                        INT         2Fh
                        CMP         AX,1DEAh
                        JE          @@AlreadyInst

                        CLI
                        MOV         AX,352Fh
                        INT         21h
                        MOV         [WORD PTR OldINT2F],BX
                        MOV         [WORD PTR OldINT2F+2],ES
                        MOV         AX,3509h
                        INT         21h
                        MOV         [WORD PTR OldINT09],BX
                        MOV         [WORD PTR OldINT09+2],ES
                        MOV         DX,OFFSET NewINT2F
                        MOV         AX,252Fh
                        INT         21h
                        MOV         DX,OFFSET NewINT09
                        MOV         AX,2509h
                        INT         21h
                        LEA         DX,[InstMsg]
                        MOV         AH,9
                        INT         21h
                        CALL        ExtractParms
                        MOV         ES,[2Ch]
                        MOV         AH,49h
                        INT         21h
                        MOV         DX,OFFSET EndOfCode+Stacksize
                        INT         27h

            @@AlreadyInst:
                        LEA         DX,[AlreadyMsg]
                        MOV         AH,9
                        INT         21h
                        CALL        ExtractParms
                        RET

            NameVersion DB          MajorName,' ',MajorVer,'''s ',MinorName,' ',MinorVer,0Dh,0Ah
                        DB          'Written by ',AuthorName,0Dh,0Ah,'$'
                        

END         START
