#!/usr/bin/perl -w

# RPM info to GDB converter v0.2 beta!
# 
# Laust Brock-Nannestad, Jan-Feb 1999
# This is script is hereby placed in the public domain.
#
# For comments or bug reports, E-mail me at <laustbn@diku.dk>

# Features:
#
# -no external files needed, the GDB image is encoded into the script!
#  (you still need to get and compile 'gdbload', available from SUPER
#  http://www.palmtop.net (and then click on SUPER)
 

# Future?
#
# -The line splitting/concatenating "algorithm" is not working correctly.
# -Query RPMs directly (should be much faster)
# -Use the 200LX Database modules for Perl and remove dependencies on outside 
#  programs.
#
# The last two ideas are not high on my agenda, though.


# constants

# hex-encoded image of the empty gdb database.
$gdbimage = 
"86364400000091000000201044000000e0002d2000003600e1b6007348502070000000004020".
"2900000010000000c000e000ee10f000540010000000ffff500000008020f0002700c0001000".
"00000000ffff10000000c00022000310f000720010000000ffff1000000026102200c110f000".
"f10010000000ffff1000000020006300a310f000720010000000ffffdd8240dd08106300ef00".
"f000f00097000000ffff9a2840dd2000a40067202700650000000000ffff6020210000002000".
"0000020000622505d400602081001000100020000010006294e6374716c6c656460060203100".
"20002000400002000062e416d6560060206100300020006000020000626556273796f6e60060".
"204100400020008000020000627427f65707006020310050004000a000020000623596a75600".
"602041006000a000c000000000e462f6475637007020260000000000000020000014c6c60244".
"1647162616375602944756d63700000000000000000000000000000000ffffffff1000000000".
"00006120513051ff0000000000000000000000000000000000000000000000000000000000ff".
"00ff0000c020da0010003800200014c6c602649656c646370000000000000000000000000000".
"00000000000000002505d4a302ffa004f6005000001090ffd0a0ffa004f600b010001090ffd0".
"a0e416d656a302ffa004f6006020001090ffd0a06556273796f6e6a302ffa004f60090300010".
"90ffd0a07427f65707a302ffa004f6007040001090ffd0a03596a756a302ffa004f600605000".
"1090ffd0a0e4f6475637a302ffa004f6007060001090ffd0a0c02097000000f4006000441647".
"1634162746000000000000000000000000000000000000000000000000ffa004f60050000010".
"90ffd0a0d3d0a0ffa004f6006020001090ffd0a0655627a3ffa004f6009030001090ff023596".
"a756a3ffa004f6006050001090ffd0a0d3d0a0ffa004f6007060001090ffd0a0a02060000000".
"f100670000009100ffff004000002900efff004200007000efff00d100002100efff006b0000".
"8100efff008c00003100efff000e00006100efff003f00004100efff009010003100efff00d1".
"10004100efff000310002600efff004410006000efff00cc20009700efff00352000da00efff".
"006a10000000100010001000100020003000a000b000b000b000c000c000e000e000e000e000".
"e000e000e000e000e000e000e000e000e000e000e000e000e000e000e000";

# description of encoded database
$gdbdesc = '"&RPM","&Installed","&Name","&Version","&Group","&Size","N&otes"';

$ignore = $verbose = $total = 0;

unless ((scalar @ARGV)>1) {
    print "Usage: rpmgdb [-iv] <output-filename> <dir1> <dir2> ... <dirN>\n",
          "        -i    Ignore installed packages that could not be found in RPM form.\n",
          "        -v    Verbose\n";
    exit;
}

# parse options in the command line.

#$output = shift;

while (($output = shift) =~ /^-/) {
    $output =~ s/^.//;
    foreach (split (//, $output)) {
        if (/v/) { $verbose = 1 }
        elsif (/i/) { $ignore = 1}
        else { print STDERR "Unknown switch '$_' ignored!\n"; }
    }
}


print "Reading list of installed packages...\n";
open (INSTALLED, q[rpm -q --queryformat '"%{SOURCERPM}"\\n"%{NAME}"\\n"%{ARCH}"\\n' -a |])
    || die "Couldn't query installed RPMs - $!";
    while (<INSTALLED>) {
    s/\n//;
        $installed{$_} = <INSTALLED> . <INSTALLED>; $total++
    }
close INSTALLED;
print "$total packages found.\n";

open (OUT, "> $output.$$.tmp") || die "Couldn't create temporary file $output.$$.tmp - $!";
print OUT "$gdbdesc\n";
while ($dir = shift) { 
    unless ($dir =~ /\/$/) { $dir .= '/'; } # add a slash to the directory if not already present.
    unless (-d $dir) { print STDERR "Directory $dir not found - skipped.\n"; last}
    @globbed = glob "$dir*.rpm";
    print "Now searching $dir - ". scalar(@globbed). " RPMs found\n";
    foreach (@globbed) {
        $rpm = $_;
        $verbose && print "Now accessing $rpm\n";
    
    $info = `rpm -q --queryformat '"\%{NAME}"\\n"\%{VERSION}"\\n"\%{GROUP}"\\n"\%{SIZE}"\\n"\%{SOURCERPM}"\\n"\%{ARCH}"\\n\%{DESCRIPTION}\\n***END OF DESCRIPTION***' -p $rpm`;
    
    # Split $info in various bits 
    ($name, $version, $group, $size, $source, $arch, @comment) = split("\n", $info);

    # (lazy) check to see if a given package is installed
    if (defined $installed{$source} && $installed{$source} =~ /\n$arch/) {
        # mark this as an installed item and delete it from the hash
        $inst = 1;
        delete $installed{$source};
    }
    else { $inst = 0; }
        # convert the comment to a single string.
        $note = &excomment(@comment);
    $rpm =~ s/$dir//; # remove directory from RPM name.
    print OUT "\"$rpm\",\"$inst\",$name,$version,$group,$size,\"$note\"\n";
    }
}

print "Done...\n\nThe following programs were installed, but the corresponding .rpm files\n",
       "were not found:\n\n";

$in = 0;
foreach (sort (keys %installed)) { 
    $in++;
    print "$_\n";
    unless ($ignore) {
        ($name, $arch) = split("\n", $installed{$_});
        # query installed RPMs
        $rpm = 'N/A';
        $info = `rpm -q --queryformat '"\%{NAME}"\\n"\%{VERSION}"\\n"\%{GROUP}"\\n"\%{SIZE}"\\n"\%{SOURCERPM}"\\n"\%{ARCH}"\\n\%{DESCRIPTION}\\n***END OF DESCRIPTION***' $name`;
        ($name, $version, $group, $size, $source, $arch, @comment) = split("\n", $info);
        #convert the comment to a single string.
        $note = &excomment (@comment);
        print OUT "\"$rpm\",\"1\",$name,$version,$group,$size,\"$note\"\n";
    }
}

if ($in!=0) { print "\nTotal: $in packages\nThey will ". ($ignore?'not ':'') . "be included in the GDB database.\n";}
else { print "none"; }

# create GDB image.
open (TMP, "> $output") || die "Couldn't create $output. $!";
print TMP pack("h*", $gdbimage);
close TMP;

close OUT;

print "Creating GDB file...\n";
(system ("gdbload -n $output $output.$$.tmp") == 0) || die "Couldn't create database - gdbload failed";
print "All done!\n";

# extract comment subroutine.
sub excomment {
    local ($_, $line, $note, $i, $comment = @_);
    for ($i=0;$i < $#comment;$i++) {
    $line = $comment[$i];
    if (length($line)>76) { $line .= ' ';}
    else { $line .= "\n";}
    $note .= $line;
    }
    $note =~ s/\n$//; # remove trailing newline
    $note =~ s/\n/\\r\\n/g; # convert *NIX style newline to escaped DOS style newline
    $note =~ s/"/\\"/g; # escape inverted commas
    return $note;
}

END { 
    # Clean up
    if (defined $output) {
        (-e "$output.$$.tmp") && unlink ("$output.$$.tmp");
    }
}
