* INVENTRY.PRG (08-11.a)

SHOW 'INVENTRY test program'
SWITCH TALK OFF
RESET DATABASE
RESET REPORT
DROP VARIABLE ALL

* initialize database and tables
CREATE DATABASE inventry
CREATE CURSOR 1 FOR inventry
USE CURSOR 1
CREATE TABLE inven (itemnum number,onhand number,backordr number,;
  leadtime number,reorder number)
CREATE TABLE vend (vid number,name char(30),addr char(25),city char(25),;
  state char(2),rep char(25),phone char(20))
CREATE TABLE goods (itemnum number,descr char(20),vid number,;
  vitemnum char(15),price number,terms char(10))
INSERT INTO inven (itemnum,onhand,backordr,leadtime,reorder);
  VALUES(101,10,5,10,10)
INSERT INTO inven (itemnum,onhand,backordr,leadtime,reorder);
  VALUES(102,0,17,15,20)
INSERT INTO inven (itemnum,onhand,backordr,leadtime,reorder);
  VALUES(103,3,9,5,20)
INSERT INTO inven (itemnum,onhand,backordr,leadtime,reorder);
  VALUES(104,2,0,10,200)
INSERT INTO inven (itemnum,onhand,backordr,leadtime,reorder);
  VALUES(105,0,150,10,300)
INSERT INTO inven (itemnum,onhand,backordr,leadtime,reorder);
  VALUES(106,6,12,30,30)
INSERT INTO vend (vid,name,addr,city,state,rep,phone);
  VALUES(1001,'Paper Distributors','271 Landon','St.Louis','MO','Gibson','(999) 123-4567')
INSERT INTO vend (vid,name,addr,city,state,rep,phone);
  VALUES(1002,'Paper Company','123 Venice','Los Angeles','CA','Johnson','(999) 123-4567')
INSERT INTO vend (vid,name,addr,city,state,rep,phone);
  VALUES(1003,'Paper and Pen Company','1 Washington','San Francisco','CA','Warren','(888) 123-4567')
INSERT INTO vend (vid,name,addr,city,state,rep,phone);
  VALUES(1004,'Tablets and Stuff','2341 Madison Ave.','New York','NY','Davis','(888) 123-4567')
INSERT INTO goods (itemnum,descr,vid,vitemnum,price,terms);
  VALUES (101,'Bridgeport Pens',1001,'BP 132-001',1.500000,'10/n30')
INSERT INTO goods (itemnum,descr,vid,vitemnum,price,terms);
  VALUES (102,'Silly Erasers',1002,'1324-a',1.520000,'10/n30')
INSERT INTO goods (itemnum,descr,vid,vitemnum,price,terms);
  VALUES (103,'Ponderosa Paper',1002,'1324-a',1.520000,'10/n30')
INSERT INTO goods (itemnum,descr,vid,vitemnum,price,terms);
  VALUES (104,'Current Copy',1002,'1324-a',1.520000,'10/n30')
INSERT INTO goods (itemnum,descr,vid,vitemnum,price,terms);
  VALUES (105,'Small Things',1002,'1324-a',1.520000,'10/n30')
INSERT INTO goods (itemnum,descr,vid,vitemnum,price,terms);
  VALUES (106,'Good Stuff',1002,'1324-a',1.520000,'10/n30')

* print an inventory status report
SELECT goods.descr,inven.itemnum,inven.onhand,;
  inven.backordr,inven.leadtime,inven.reorder;
  FROM goods,inven;
  WHERE goods.itemnum=inven.itemnum
DOREPORT
  REPORT output
    TO CONSOLE
    END
  REPORT page heading
    PRINT TAB 20 '*********************'
    PRINT TAB 20 '*  Inventory Report *'
    PRINT TAB 20 '*********************'
    PRINT SKIP 'Item' TAB 32 'On' TAB 37 'Back' TAB 45 'Lead Time' TAB 55 'Reorder'
    PRINT TAB 32 'Hand' TAB 37 'Ordered' TAB 45 '(days)' TAB 55 'Point' SKIP 2
    END
  REPORT footing break at itemnum
    IF onhand < reorder
      PRINT SKIP
      ENDIF
    END
  REPORT page detail
    PRINT descr TAB 32 onhand PICTURE '^^^^' TAB 37 backordr PICTURE '^^^^';
      TAB 45 leadtime PICTURE '^^^^' TAB 55 reorder PICTURE '^^^^' SKIP 0
    IF onhand < reorder
      PRINT ' **reorder**'
    ELSE
      PRINT
    ENDIF
    END
  ENDREPORT
DROP CURSOR 1
DROP VARIABLE ALL
DROP DATABASE inventry
SWITCH DEFAULT
