/* LXPRINTF.C -- xprintf with Extensions/Deletions for Loki

	Written April 1994 by Craig Finseth

THE NON-VARARGS VERSION ASSUMES THAT sizeof(pointer) >= sizeof(int)
*/

#include "loki.h"

#if defined(VARARGS)
enum XP_STATE { XP_ARG, XP_B, XP_D, XP_H, XP_L, XP_O, XP_U, XP_X, XP_DONE };
enum XP_TYPE { XP_LT, XP_DONET };
#endif

static char *strptr;

static FLAG istext = TRUE;

#if defined(VARARGS)
static FLAG iszero;
static unsigned arg;
static char *format;
static enum XP_STATE state;

enum XP_TYPE lx_chunk(void);
void lx_chunkl(long val);
#endif

void lx_printf2();		/* const char *fmt, int *parms */
void lx_printlong(unsigned long value, int base, int len, FLAG notfirst,
	FLAG iszero);
void lx_printsput(const char c);

/* ------------------------------------------------------------ */

void
#if defined(VARARGS)
#if defined(__STDC__)
lxsprintf(char *string, char *fmt, ...)
	{
#else
lxsprintf(va_alist)
	va_dcl
	{
	char *string;
#endif
	va_list ap;
	long l;

#if defined(__STDC__)
	va_start(ap, fmt);
	format = fmt;
#else
	va_start(ap);
	string = va_arg(ap, char *);
	format = va_arg(ap, char *);
#endif
	strptr = string;
	state = XP_DONE;
	do	{
		switch (lx_chunk()) {

		case XP_LT:
			l = va_arg(ap, long);
			lx_chunkl(l);
			break;
			}
		} while (state != XP_DONE);
	va_end(ap);
#else
lxsprintf(string, format, args)
	char *string;
	char *format;
	int args;
	{
	strptr = string;
	lx_printf2(format, &args);
#endif
	*strptr = NUL;
	}


/* ------------------------------------------------------------ */

/* Process the format string up to the next % argument, updating the
static FORMAT.  Return the expected type.  Update STATE with the new
state and ARG and ISZERO with the argument information. */

#if defined(VARARGS)
enum XP_TYPE
lx_chunk()
	{

	while (*format != NUL) {
		if (state != XP_ARG) {
			if (*format != '%') {
#if defined(MSDOS)
				if (istext && *format == NL) {
					lx_printsput(CR);
					}
#endif
				lx_printsput(*format++);
				continue;
				}

			arg = 0;
			iszero = FALSE;
			if (*++format == '0') {
				format++;
				iszero = TRUE;
				}
			if (*format == '*') {
				format++;
				state = XP_ARG;
				return(XP_LT);
				}
			else if (xisdigit(*format)) {
				while (xisdigit(*format)) {
					arg = arg * 10 + *format++ - '0';
					}
				}
			else	arg = 1;
			}

		state = XP_DONE;

		switch (xtoupper(*format++)) {

		case '%':
			while (arg-- > 0) lx_printsput('%');
			break;

		case 'B':
			state = XP_B;
			return(XP_LT);
			/*break;*/

		case 'D':
			state = XP_D;
			return(XP_LT);
			/*break;*/

		case 'H':		/* long hexadecimal */
			state = XP_H;
			return(XP_LT);
			/*break;*/

		case 'L':
			state = XP_L;
			return(XP_LT);
			/*break;*/

		case 'O':
			state = XP_O;
			return(XP_LT);
			/*break;*/

		case 'X':
			state = XP_X;
			return(XP_LT);
			/*break;*/

		case 'U':
			state = XP_U;
			return(XP_LT);
			/*break;*/

		default:
			break;
			}
		}
	state = XP_DONE;
	return(XP_DONET);
	}
#endif


/* ------------------------------------------------------------ */

/* Print value VAL.  Import STATE, ARG, and ISZERO as a static. */

#if defined(VARARGS)
void
lx_chunkl(long val)
	{
	switch (state) {

	case XP_ARG:
		arg = val;
		break;

	case XP_B:
		lx_printlong(val, 2, arg, FALSE, iszero);
		break;

	case XP_L:
	case XP_D:
		if (val < 0) {
			lx_printsput('-');
			val = -val;
			}
		lx_printlong(val, 10, arg, FALSE, iszero);
		break;

	case XP_O:
		lx_printlong(val, 8, arg, FALSE, iszero);
		break;

	case XP_U:
		lx_printlong(val, 10, arg, FALSE, iszero);
		break;

	case XP_H:
	case XP_X:
		lx_printlong(val, 16, arg, FALSE, iszero);
		break;
		}
	}
#endif


/* ------------------------------------------------------------ */

void
lx_printf2(fmt, parms)
	char *fmt;
	int *parms;
	{
	FLAG iszero;
	unsigned arg;
	long *lptr;
	long ltmp;

	while (*fmt != NUL) {
		if (*fmt != '%') {
#if defined(MSDOS)
			if (istext && *fmt == NL) {
				lx_printsput(CR);
				}
#endif
			lx_printsput(*fmt++);
			continue;
			}

		arg = 0;
		iszero = FALSE;
		if (*++fmt == '0') {
			iszero = TRUE;
			fmt++;
			}
		if (*fmt == '*') {
			fmt++;
			lptr = (long *)parms;
			arg = *lptr++;
			parms = (int *)lptr;
			}
		else if (xisdigit(*fmt)) {
			while (xisdigit(*fmt)) {
				arg = arg * 10 + *fmt++ - '0';
				}
			}
		else	arg = 1;

		switch (xtoupper(*fmt++)) {

		case '%':
			while (arg-- > 0) lx_printsput('%');
			break;

		case 'B':
			lptr = (long *)parms;
			lx_printlong(*lptr++, 2, arg, FALSE, iszero);
			parms = (int *)lptr;
			break;

		case 'D':
		case 'L':
			lptr = (long *)parms;
			ltmp = *lptr++;
			if (ltmp < 0) {
				lx_printsput('-');
				ltmp = -ltmp;
				}
			lx_printlong(ltmp, 10, arg, FALSE, iszero);
			parms = (int *)lptr;
			break;

		case 'O':
			lptr = (long *)parms;
			lx_printlong(*lptr++, 8, arg, FALSE, iszero);
			parms = (int *)lptr;
			break;

		case 'H':
		case 'X':
			lptr = (long *)parms;
			lx_printlong(*lptr++, 16, arg, FALSE, iszero);
			parms = (int *)lptr;
			break;

		case 'U':
			lptr = (long *)parms;
			lx_printlong(*lptr++, 10, arg, FALSE, iszero);
			parms = (int *)lptr;
			break;

		default:
			break;
			}
		}
	}


/* ------------------------------------------------------------ */

/* Print out a long. */

void
lx_printlong(unsigned long value, int base, int len, FLAG notfirst,
	FLAG iszero)
	{
	if (value >= base || (len - 1) > 0)
		lx_printlong(value / base, base, len - 1, TRUE, iszero);
	if (!value && len > 0 && notfirst) lx_printsput(iszero ? '0' : SP);
	else	{
		value %= base;
		if (value > 9) lx_printsput((int) value + 'a' - 10);
		else lx_printsput((int) value + '0');
		}
	}


/* ------------------------------------------------------------ */

/* Print a character to a string. */

void
lx_printsput(const char c)
	{
	*strptr++ = c;
	}


/* end of LXPRINTF.C -- xprintf with Extensions/Deletions for Loki */
