/*
        System Manager Icon editor for HP-LX
*/

#include "lxapi.h"
#include <string.h>

#define	FILECOUNT  128
#define FILELENGTH  13
#define	DIRCOUNT    64
#define DIRLENGTH   13

int curX = 0;
int curY = 0;
int curW = 1;
int curH = 1;

int cripX = 0;
int cripY = 0;
int cripW = 1;
int cripH = 1;

int DrawMode = 2; /* XOR */

int isEditF = 0; /* ҏWς݂ۂ̃tO */

char FileSpec[48];
char Directory[48];
char WildCard[] = "*.ICN";

char *FileList[FILECOUNT];
char FileSpace[FILECOUNT*FILELENGTH];

char *DirList[DIRCOUNT];
char DirSpace[DIRCOUNT*DIRLENGTH];

/* ҏWƗ̈揉 */
char WorkBuff[200] = {0x01,0x00,0x01,0x00,0x2c,0x00,0x20,0x00};
char CripBuff[200];
char SubBuff[200] = {0x01,0x00,0x01,0x00,0x2c,0x00,0x20,0x00};

char FileName[40];   /* ҏW̃ACRt@C̃tpX */
char EditBuffer[40]; /* _CAO͗pobt@ */

char Text[10];  /* ėpeLXgobt@ */

char far *msgNULL    = "";
char far *msgAppName = "IconEdit";
char far	*msg2 =			"";
char far	*msg3 =			"";
char far	*msg4 =			"";
char far	*msg5 =			"";
char far	*msg6 =			"";
char far	*msg7 =			"";

char far *msgFileOpen = "File Open";
char far *msgFileSave = "File Save";

char far *msgFile    = "&File";
char far *msgOpen    = "&Open";
char far *msgSave    = "&Save";
char far *msgSaveAs  = "Save &As";
char far *msgExit    = "E&xit"; 
char far *msgQuit    = "&Quit";

char far *msgMirrorH = "MirrorH";
char far *msgMirrorV = "MirrorV";
char far *msgUndo    = "Undo";
char far *msgAll     = "All";
char far *msgCut     = "Cut";
char far *msgCopy    = "Copy";
char far *msgPaste   = "Paste";
char far *msgMode    = "Mode";

char far *msgCancel  = "Cancel";
char far *msgOk      = "OK";
char far *msgBoxTitle  = "Error";

char far **StringTable[] = {
    &msgNULL,
    &msgAppName,
    &msgFileOpen,&msgFileSave,
    /* &msgErr, */

    &msgFile,&msgOpen,&msgSave,&msgSaveAs,&msgExit,&msgQuit,

    &msgMirrorH,&msgMirrorV,&msgUndo,&msgAll,&msgCut,
    &msgCopy,&msgPaste,&msgMode,

    &msgCancel,&msgOk,
    &msgBoxTitle
};

int far MainHandler(PLHWINDOW,WORD,WORD,WORD,...);
int far OpenHandler(PLHWINDOW,WORD,WORD,WORD,...);
int far SaveHandler(PLHWINDOW,WORD,WORD,WORD,...);

void DrawCursor(void);    /* ٕ` */

int I_bit();     /* icoñrbg */
int C_bit();     /* Crip̃rbg */
int S_bit();     /* Sub̃rbg */
int I_set();

void MoveCursor();
void DragCursor();
void DrawArea2();    /* drawing on cursor area */
void DrawIconAll();  /* redraw icon */
void DrawCrip();     /* disp crip buffer */
void InitScreen(void);   /* ʏ */
void ShowInfo(void);     /* show infomation */

void far DoOpen(void);
void far DoSave(void);
void far DoSaveAs(void);
void far DoQuit(void);

void far DoMirrorH(void);
void far DoMirrorV(void);
void far DoUndo(void);
void far DoAll(void);
void far DoMin(void);
void far DoCut(void);
void far DoCopy(void);
void far DoPaste(void);
void far DoMode(void);

void number();
void InitFileDialogs(void);

BOOL Done;
LHAPIBLOCK LHAPIData;
EVENT_NORM app_event;

LHMENU FileMenu[]={
    {(PLHRES)&msgOpen,(PLHFUNC)DoOpen,0,0,NO_HELP},
    {(PLHRES)&msgSave,(PLHFUNC)DoSave,0,0,NO_HELP},
    {(PLHRES)&msgSaveAs,(PLHFUNC)DoSaveAs,0,0,NO_HELP},
    {(PLHRES)&msgExit,(PLHFUNC)DoQuit,0,MENU_BARBEFORE,NO_HELP},
    {0,0,0,0,0},
};

LHMENU MainMenu[]={
    {(PLHRES)&msgFile,(PLHFUNC)&FileMenu,0,MENU_PULLDOWN,NO_HELP},
    {(PLHRES)&msgQuit,(PLHFUNC)DoQuit,0,0,NO_HELP},
    {0,0,0,0,0},
};


LHFKEY MainFKeys[] = {
    {(PLHRES)&msgMirrorH,(PLHFUNC)DoMirrorH,2,0},
    {(PLHRES)&msgMirrorV,(PLHFUNC)DoMirrorV,3,0},
    {(PLHRES)&msgUndo,(PLHFUNC)DoUndo,4,0},
    {(PLHRES)&msgAll,(PLHFUNC)DoAll,5,0},
    {(PLHRES)&msgAll,(PLHFUNC)DoMin,5+FKEY_SHIFT,0},
    {(PLHRES)&msgCut,(PLHFUNC)DoCut,6,0},
    {(PLHRES)&msgCopy,(PLHFUNC)DoCopy,7,0},
    {(PLHRES)&msgPaste,(PLHFUNC)DoPaste,8,0},
    {(PLHRES)&msgMode,(PLHFUNC)DoMode,10+FKEY_LAST,0},
};

LHFKEY OkFkeys[] = {
	(PLHRES)&msgOk,(PLHFUNC)CMD_ESC,10+FKEY_LAST,FKEY_SENDMSG
};

LHFKEY ChoseFkeys[] = {
	{ (PLHRES)&msgCancel,(PLHFUNC)CMD_ESC,9,FKEY_SENDMSG },
	{ (PLHRES)&msgOk,(PLHFUNC)CMD_DONE,10+FKEY_LAST,FKEY_SENDMSG }
};


LHWINDOW MainView = {
    (PLHCLASS)MainHandler,0,0,640,190,0,0,0,0,
    NULL,MainFKeys,MainMenu,NO_HELP
};

LHWINDOW TDateTime = {
    DateTime,0,0,0,0,0,0,0,STYLE_DATETIME|STYLE_NOFOCUS,
    NULL, NO_FKEYS, NO_MENU, NO_HELP
};

LHWINDOW MainTitle = {
    TitleBar,0,0,0,0,
    (PLHRES)&msgAppName,0,0,STYLE_NOFOCUS,
    NULL,NO_FKEYS,(PLHMENU)&TDateTime,NO_HELP
};

LHWINDOW ErrorArray[] = {
		{StaticText,240,80,15,1,
		(PLHRES)&msgNULL,(PLHDATA)"File not found.",
		15,STYLE_NOBORDER|STYLE_WHCHAR,
		NULL,PARENT_FKEYS,NO_MENU,NO_HELP},
		{PushButton,280,110,6,1,
		(PLHRES)&msgOk,(PLHDATA)CMD_ESC,0,
		PUSHB_SENDMSG|STYLE_PUSHBUTTON|STYLE_WHCHAR,
		NULL,PARENT_FKEYS,NO_MENU,NO_HELP},
};

LHWINDOW ErrorDlg = {
		DialogBox,160,50,320,100,
		(PLHRES)&msgBoxTitle,(PLHDATA)ErrorArray,countof(ErrorArray),
		STYLE_SAVEUNDER,NULL,OkFkeys,NO_MENU,NO_HELP
};
    
LHWINDOW FoArray[] = {
		{Edit,0,0,0,0,
		(PLHRES)&msg3,(PLHDATA)FileSpec,48,
		STYLE_WHCHAR|EDIT_INSERT,
		NULL,PARENT_FKEYS,(PLHMENU)WildCard,NO_HELP},
		{PathText,0,0,0,0,
		(PLHRES)&msg7,(PLHDATA)Directory,48,
		STYLE_NOBORDER|STYLE_WHCHAR,
		NULL,PARENT_FKEYS,NO_MENU,NO_HELP},
		{FileListBox,0,0,0,0,
		(PLHRES)&msg4,(PLHDATA)FileList,FILECOUNT,
		STYLE_WHCHAR|STYLE_NOTIFY,
		NULL,PARENT_FKEYS,(PLHMENU)FILECOUNT,NO_HELP},
		{DirListBox,0,0,0,0,
		(PLHRES)&msg5,(PLHDATA)DirList,DIRCOUNT,
		STYLE_WHCHAR|STYLE_NOTIFY,
		NULL,PARENT_FKEYS,(PLHMENU)DIRCOUNT,NO_HELP},
		{PushButton,0,0,0,0,
		(PLHRES)&msg2,(PLHDATA)CMD_DONE,0x0d,PUSHB_SENDMSG|STYLE_PUSHBUTTON,
		NULL,PARENT_FKEYS,NO_MENU,NO_HELP},
		{PushButton,0,0,0,0,
		(PLHRES)&msg6,(PLHDATA)CMD_ESC,0,PUSHB_SENDMSG|STYLE_PUSHBUTTON,
		NULL,PARENT_FKEYS,NO_MENU,NO_HELP},
};

LHWINDOW OpenDlg = {
    (PLHCLASS)OpenHandler,0,0,0,0,
    (PLHRES)&msgFileOpen,(PLHDATA)FoArray,countof(FoArray),
    STYLE_SAVEUNDER,NULL,ChoseFkeys,NO_MENU,NO_HELP
};

LHWINDOW SaveDlg = {
    (PLHCLASS)SaveHandler,0,0,0,0,
    (PLHRES)&msgFileSave,(PLHDATA)FoArray,countof(FoArray),
    STYLE_SAVEUNDER,NULL,ChoseFkeys,NO_MENU,NO_HELP
};


#if defined(TURBOC)
#define GetDataSeg() _DS
#define GetCodeSeg() _CS
#define GetStack()   _SP
#endif
#if defined(LSIC)
int _asm_(char *);
#define GetDataSeg()    _asm_(" mov ax,ds\n")
#define GetCodeSeg()    _asm_(" mov ax,cs\n")
#define GetStack()      _asm_(" mov ax,sp\n")
#endif

void FixupFarPtrs(void)
{
    int i, dataseg;

#if defined(MSC)
    _asm {
        mov ax,ds
        mov dataseg,ax
    }
#else
    dataseg=GetDataSeg();
#endif

    for (i=0;i<countof(StringTable);i++)
        *(((int *)(StringTable[i]))+1) = dataseg;
}



int far MainHandler(PLHWINDOW Window,WORD Message,WORD Data,WORD Extra,...)
{
    switch(Message){
    case KEYSTROKE:
        switch(Data){
        /* pen draw */
        case ' ':
            isEditF=1;
            DrawArea2(DrawMode);
            return TRUE;
        /* Move cursor */
        case UPKEY: case DOWNKEY: case LEFTKEY: case RIGHTKEY:
            MoveCursor(Data);
            return TRUE;
        /* Drag cursor */
        case '8': case '2': case '4': case '6':
            DragCursor(Data);
            return TRUE;
        }
        break;
    case DRAW:
        if(Data & DRAW_FRAME){
            ClearRect(Window->x,Window->y,Window->w,Window->h);
            InitScreen();
        }
    }
    return(SubclassMsg(Object,Window,Message,Data,Extra));
}



int far OpenHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...)
{
    FILE fp;
    int i,err,len;

    if((Message == COMMAND) && (Data == CMD_DONE)){
        strcpy(EditBuffer,Directory);
        if(EditBuffer[strlen(EditBuffer)-1]!=0x5c)strcat(EditBuffer,"\\");
        strcat(EditBuffer,FileSpec);
        if(!strchr(EditBuffer,'.'))strcat(EditBuffer,".ICN");
        err=m_open(&fp,&EditBuffer,strlen(EditBuffer),0,0);
        if(err){
            return SendMsg( &ErrorDlg,CREATE,CREATE_FOCUS,0 );
        }
        err=m_read(&fp,&WorkBuff,200,&len);
        if(err){
            return SendMsg( &ErrorDlg,CREATE,CREATE_FOCUS,0 );
        }
        m_close(&fp);
        strcpy(FileName,EditBuffer);
        for(i=0;i<200;i++)SubBuff[i]=WorkBuff[i];
        isEditF=0;
		SendMsg(Window,DESTROY,DESTROY_NODRAW,0);
        ClearRect(Window->x,Window->y,Window->w,Window->h);
        InitScreen();
        return 0;
    }
	return SubclassMsg(FileOpenDialogBox,Window,Message,Data,Extra);
}
int far SaveHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...)
{
    FILE fp;
    int err;

    if((Message == COMMAND) && (Data == CMD_DONE)){
        strcpy(EditBuffer,Directory);
        if(EditBuffer[strlen(EditBuffer)-1]!=0x5c)strcat(EditBuffer,"\\");
        strcat(EditBuffer,FileSpec);
        if(!strchr(EditBuffer,'.'))strcat(EditBuffer,".ICN");
        err=m_fcreat(&fp,&EditBuffer,strlen(EditBuffer),0,0);
        if(err){
            return SendMsg( &ErrorDlg,CREATE,CREATE_FOCUS,0);
        }
        err=m_write(&fp,&WorkBuff,200);
        if(err){
            return SendMsg( &ErrorDlg,CREATE,CREATE_FOCUS,0);
        }
        m_close(&fp);
        strcpy(FileName,EditBuffer);
        isEditF=0;
        SendMsg(Window,DESTROY,DESTROY_NORMAL, 0);
        ShowInfo();
        return TRUE;
    }
    return SubclassMsg(FileOpenDialogBox, Window, Message, Data, Extra);
}

void MoveCursor(WORD Data)
{
    DrawCursor();
    switch(Data){
    case UPKEY:
        curY--;if(curY<0)curY=32-curH;
        break;
    case DOWNKEY:
        curY++;if(curY+curH>32)curY=0;
        break;
    case LEFTKEY:
        curX--;if(curX<0)curX=44-curW;
        break;
    case RIGHTKEY:
        curX++;if(curX+curW>44)curX=0;
    }
    DrawCursor();
    ShowInfo();
}
void DragCursor(WORD Data)
{
    DrawCursor();
    switch(Data){
    case '8':
        if(curH>1)curH--;
        break;
    case '2':
        if(curY+curH<32)curH++;
        break;
    case '4':
        if(curW>1)curW--;
        break;
    case '6':
        if(curX+curW<44)curW++;
    }
    DrawCursor();
    ShowInfo();
}

void InitScreen(void)
{
    ShadowBox(15,16,235,171); /* main */
    ShadowBox(260,16,60,44); /* sub  */
    ShadowBox(260,66,60,44); /* crip */
    ShadowBox(330,16,300,94);             /* info */
    DrawText(340,32,"Icon Editor",DRAW_NORMAL,FONT_LARGE);
    DrawText(340,65,"[CURSOR] = Move cursor",DRAW_NORMAL,FONT_SMALL);
    DrawText(340,75,"[2],[4],[6],[8] = Resize cursor",DRAW_NORMAL,FONT_SMALL);
    DrawText(340,85,"[SPACE] = Draw pixel",DRAW_NORMAL,FONT_SMALL);

    ShadowBox(260,117,370,70);
    DrawText(270,125,"File=",DRAW_NORMAL,FONT_NORMAL);
    DrawText(270,141,"X=## Y=## Width=## Hight=##",DRAW_NORMAL,FONT_NORMAL);
    DrawText(270,157,"DrawMode=",DRAW_NORMAL,FONT_NORMAL);

    ShowInfo();
    DrawCursor();
    DrawIconAll();
    DrawCrip();
}

void ShowInfo(void)
{
    /* char temp[10]; */

    DrawNChars(320,125,"                              ",
               DRAW_NORMAL,FONT_NORMAL,30);
    DrawNChars(320,125,FileName,DRAW_NORMAL,FONT_NORMAL,30);
    /* sprintf(temp,"%02d",curX); */
    number(curX);
    DrawText(290,141,Text,DRAW_NORMAL,FONT_NORMAL);
    /* sprintf(temp,"%02d",curY); */
    number(curY);
    DrawText(340,141,Text,DRAW_NORMAL,FONT_NORMAL);
    /* sprintf(temp,"%02d",curW); */
    number(curW);
    DrawText(430,141,Text,DRAW_NORMAL,FONT_NORMAL);
    /* sprintf(temp,"%02d",curH); */
    number(curH);
    DrawText(520,141,Text,DRAW_NORMAL,FONT_NORMAL);

    switch(DrawMode){
    case 0:
        DrawText(360,157,"RESET",DRAW_NORMAL,FONT_NORMAL);
        break;
    case 1:
        DrawText(360,157,"SET  ",DRAW_NORMAL,FONT_NORMAL);
        break;
    case 2:
        DrawText(360,157,"XOR  ",DRAW_NORMAL,FONT_NORMAL);
    }
}

void number(int x)
{
    Text[0]=x/10+0x30;
    Text[1]=x%10+0x30;
    Text[2]=0x00;
    return;
}

void DrawCursor(void)
{
    SetRepRule(3); /* XOR */
    Outline(curX*5+20,curY*5+20,curW*5-1,curH*5-1);
    Outline(curX*5+19,curY*5+19,curW*5+1,curH*5+1);
    ResetRepRule();
}

void DrawIconAll(void)
{
    int x,y;

    DrawCursor();

    ClearRect(20,20,220,160);
    ClearRect(265,20,44,32);

    SetRepRule(4);
    for(y=0;y<32;y++){
        for(x=0;x<44;x++){
            if(I_bit(x,y)){
                ClearRect(x*5+20,y*5+20,4,4);
                ClearRect(x+265,y+20,1,1);   /* sub  */
            }
        }
    }
    ResetRepRule();
    DrawCursor();
}

void DrawCrip()
{
    int x,y;

    ClearRect(264,69,46,34);
    Outline(cripX+264,cripY+69,cripW+2,cripH+2);
    SetRepRule(4);
    for(y=cripY;y<(cripY+cripH);y++){
        for(x=cripX;x<(cripX+cripW);x++){
            if(C_bit(x,y))ClearRect(x+265,y+70,1,1);
        }
    }
    ResetRepRule();
}

int I_set(int x,int y,int mode)
{
    int p; char i;

    p=x/8+y*6+8;       /* calculate address */
    i=128;i>>=x%8;     /* bit masc */

    switch(mode){
    case 0: /* RESET */
        WorkBuff[p]&=~i;
        return(0);
    case 1: /* SET */
        WorkBuff[p]|=i;
        return(1);
    case 2: /* XOR */
        WorkBuff[p]^=i;
        return((WorkBuff[p]&i)!=0);
    }
}

int I_bit(int x,int y)
{
    int p; char i;

    p=x/8+y*6+8;
    i=128;i>>=x%8;
    return((WorkBuff[p]&i)!=0);
}

int C_bit(int x,int y)
{
    int p; char i;

    p=x/8+y*6+8;
    i=128;i>>=x%8;
    return((CripBuff[p]&i)!=0);
}

int S_bit(int x,int y)
{
    int p; char i;

    p=x/8+y*6+8;
    i=128;i>>=x%8;
    return((SubBuff[p]&i)!=0);
}


void DrawArea2(int mode)
{
    int x,y,c;

    DrawCursor();
    for(y=curY;y<(curY+curH);y++){
        for(x=curX;x<(curX+curW);x++){
            (I_set(x,y,mode))?(c=4):(c=0);
            SetRepRule(c);
            ClearRect(x*5+20,y*5+20,4,4);
            ClearRect(x+265,y+20,1,1);
        }
    }
    ResetRepRule();
    DrawCursor();
}

void far DoMirrorH(void)
{
    int x,y,c,i;

    for(i=0;i<200;i++)SubBuff[i]=WorkBuff[i];

    DrawCursor();
    for(y=curY;y<(curY+curH);y++){
        for(x=curX;x<(curX+curW);x++){
            (I_set(x,y,S_bit(curX*2+curW-x-1,y)))?(c=4):(c=0);
            SetRepRule(c);
            ClearRect(x*5+20,y*5+20,4,4);
            ClearRect(x+265,y+20,1,1);
        }
    }
    ResetRepRule();
    DrawCursor();
    isEditF=1;
}

void far DoMirrorV(void)
{
    int x,y,c,i;

    for(i=0;i<200;i++)SubBuff[i]=WorkBuff[i];

    DrawCursor();
    for(y=curY;y<(curY+curH);y++){
        for(x=curX;x<(curX+curW);x++){
            (I_set(x,y,S_bit(x,curY*2+curH-y-1)))?(c=4):(c=0);
            SetRepRule(c);
            ClearRect(x*5+20,y*5+20,4,4);
            ClearRect(x+265,y+20,1,1);
        }
    }
    ResetRepRule();
    DrawCursor();
    isEditF=1;
}

void far DoUndo(void)
{
    int i;

    for(i=0;i<200;i++)WorkBuff[i]=SubBuff[i];
    isEditF=1;
    DrawIconAll();
}

void far DoAll(void)
{
    DrawCursor();
    curX=0;curY=0;
    curW=44;curH=32;
    DrawCursor();
    ShowInfo();
}

void far DoMin(void)
{
    DrawCursor();
    curW=1;curH=1;
    DrawCursor();
    ShowInfo();
}


void far DoCut(void)
{
    int i;

    cripX=curX;
    cripY=curY;
    cripW=curW;
    cripH=curH;
    for(i=0;i<200;i++)SubBuff[i]=CripBuff[i]=WorkBuff[i];
    isEditF=1;
    DrawArea2(0); /* RESET */
    DrawCrip();
}

void far DoCopy(void)
{
    int i;

    cripX=curX;
    cripY=curY;
    cripW=curW;
    cripH=curH;
    for(i=0;i<200;i++)SubBuff[i]=CripBuff[i]=WorkBuff[i];
    DrawCrip();

}

void far DoPaste(void)
{
    int p,q,c;

    DrawCursor();
    for(q=0;q<curH;q++){
        for(p=0;p<curW;p++){
            (I_set(curX+p,
                   curY+q,
                   C_bit(cripX+p%cripW,cripY+q%cripH)))?(c=4):(c=0);
            SetRepRule(c);
            ClearRect((curX+p)*5+20,(curY+q)*5+20,4,4);
            ClearRect(curX+p+265,curY+q+20,1,1);
        }
    }
    ResetRepRule();
    DrawCursor();
    isEditF=1;
}

void far DoMode(void)
{
    /* 0(RESET) > 1(SET) > 2(XOR) */
    DrawMode++;
    if(DrawMode==3) DrawMode=0;
    ShowInfo();
}

void far DoOpen(void)
{
    strcpy(FileSpec,WildCard);
    SendMsg(&OpenDlg,CREATE,CREATE_FOCUS,0);
}

void far DoSave(void)
{
    FILE fp;
    int err;

    if(0==strcmp(FileName,NULL)){
        DoSaveAs();
        return;
    }
    err=m_fcreat(&fp,&FileName,strlen(FileName),0,0);
    if(err){
        SendMsg( &ErrorDlg,CREATE,CREATE_FOCUS,0 );
        return;
    }
    err=m_write(&fp,&WorkBuff,200);
    if(err){
        SendMsg( &ErrorDlg,CREATE,CREATE_FOCUS,0 );
        return;
    }
    m_close(&fp);
    isEditF=0;
    ShowInfo();
}

void far DoSaveAs(void)
{
    strcpy(EditBuffer,FileName);
    SendMsg(&SaveDlg,CREATE,CREATE_FOCUS,0);
}

void far DoQuit(void)
{
    Done = TRUE;
}

void InitFileDialogs(void)
{
    int i;

    for (i=0; i<FILECOUNT; i++)  FileList[i] = FileSpace+i*FILELENGTH;
    for (i=0; i<DIRCOUNT; i++)   DirList[i]  = DirSpace+i*DIRLENGTH;
}

void main(void)
{
    m_init_app(SYSTEM_MANAGER_VERSION);

    InitializeLHAPI(&LHAPIData);
    SetDefaultFont(FONT_NORMAL);
    m_reg_app_name(msgAppName);

    SendMsg(&MainView,CREATE,CREATE_FOCUS,0);
    SendMsg(&MainTitle,CREATE,CREATE_NORMAL,0);

    Done = FALSE;

    InitFileDialogs();

    while(!Done){
        app_event.do_event = DO_EVENT;
        m_action(&app_event);
        switch(app_event.kind){
            case E_ACTIV:
            case E_REFRESH:
                FixupFarPtrs();
                ReactivateLHAPI(&LHAPIData);
                break;
            case E_DEACT:
                DeactivateLHAPI();
                break;
            case E_TERM:
            /* case E_BREAK: */
                Done = TRUE;
                break;
            case E_NONE:
                SendMsg(&TDateTime,DRAW,DRAW_ALL,0);
                break;
            case E_KEY:
                SendMsg(GetFocus(),KEYSTROKE,app_event.data,app_event.scan);
                break;
         }
    }
    m_fini();
}
