/*
 * GlobalSearch Version 1.20
 * Copyright (C) 1995,96 Hiroyuki Sekiya
 */

#define CURSOR_MOVE

#include <lxapi.h>
#include <string.h>
#include "gsmisc.h"

#define ENTERKEY		0x0D
#define ESCKEY			0x1B
#define PASTEKEY		0xD600
#define ALTCKEY			0x2E00
#define ALTFKEY			0x2100
#define MAXFILE			13
#define MAXPATH			80
#define LT_YIELD_THEN_LAUNCH	0x0001

void SetIme(void);
#define SetIme()


/***************************************************************************
* Far Strings
***************************************************************************/

char far *msgAppName	= "GlobalSearch";
char far *msg_KeyWord	= "&Key word";
char far *msg_CaseSens	= "&Case sensitive";
char far *msgTarget		= "Target Files";
char far *msg_Appt		= "&ApptBook";
char far *msg_Phone		= "&PhoneBook";
char far *msg_DBase		= "Data&base";
char far *msg_Note		= "&NoteTaker";
char far *msg_Memo		= "M&emo";
char far *msg_Search	= "&Search";
char far *msgSearch		= "Search Conditions";
char far *msg_Start		= "&Start\tF10";
char far *msgStart		= "Start";
char far *msg_Quit		= "&Quit";
char far *msgQuit		= "Quit";
char far *msg_Exit		= "E&xit\tF9";
char far *msgCancel		= "Cancel";
char far *msgOk			= "OK";
char far *msgMeterBox	= "Searching...";
char far *msgLaunchTit	= "Launch an application";
char far *msg_Launch	= "&Launch";
char far *msgLaunch		= "Launch";
char far *msg_Appli		= "&Applications";
char far *msg_Files		= "&Files";
char far *msg_After		= "&Search after launch";
char far *msgError		= "Error";
char far *msgDefault	= "Default";
char far *msgSelect		= "Select";
char far *msgSelFile	= "Select Target File";
char far *msg_Help		= "&Help";
char far *msg_About		= "&About Global Search";
char far *msgAbout		= "About Global Search";
char far *msgAboutText	= "Global Search Version 1.20\n\n"
						  "Copyright (C) 1995,96 Hiroyuki Sekiya\n\n"
						  "All Rights Reserved";
char far **msgAboutPtr	= &msgAboutText;


char far **StringTable[] = {
	&msgAppName, &msg_KeyWord, &msg_CaseSens, &msgTarget, &msg_Appt,
	&msg_Phone, &msg_DBase, &msg_Note, &msg_Memo, &msgSearch, &msg_Search,
	&msgStart, &msg_Start, &msgQuit, &msg_Quit, &msg_Exit, &msgCancel,
	&msgOk, &msgMeterBox, &msgLaunchTit, &msgLaunch, &msg_Launch, &msg_Appli,
	&msg_Files, &msg_After, &msgError, &msgDefault, &msgSelect, &msgSelFile,
	&msg_Help, &msg_About, &msgAbout, &msgAboutText
};

#if defined(TURBOC)
#define GetDataSeg()	_DS
#endif
#if defined(LSIC)
int _asm_(char *);
#define GetDataSeg()	_asm_(" mov ax,ds\n")
#endif

void FixupFarPtrs(void)
{
int i,dataseg;
#if defined(MSC)
	_asm {
		mov	ax,ds;
		mov	dataseg,ax;
	}
#else
	dataseg=GetDataSeg();
#endif
	for(i=0; i<countof(StringTable); i++)
		*(((int *)(StringTable[i]))+1) = dataseg;
}


/***************************************************************************
* Global Variables
***************************************************************************/

LHAPIBLOCK LHAPIData;
EVENT Event;
BOOL Done				= FALSE;

char MyEnvPath[]		= "a:\\_dat\\gs.env";

#define GF_CASESENS		0x0001		/* 啶/ʂ邩H */
#define GF_SEARCHINAPP	0x0002		/* AvNɎ邩H */
UINT GlobalFlags		= GF_SEARCHINAPP;

#define MAXKEYWD		80
char KeyWord[MAXKEYWD]	= "";		/*  */


/***************************************************************************
* L[[ht@C̃Xg
***************************************************************************/

typedef struct sAPPFILE {
	char		FileName[MAXFILE];	/* 8+3`̃t@C(K擪) */
	long		Ofs;				/* ̈ʒu(t@C|C^) */
} APPFILE;

#define MAXFILELIST		512
APPFILE WholeFiles[MAXFILELIST];	/* t@C̑SXg */
APPFILE *FileList[MAXFILELIST];		/* WholeFiles̊eGgւ̃|C^ */
UINT WholeCount;					/* t@C̑ */

/* FileList̃|C^WholeFilesɂȂ */
void InitListPtrs(void)
{
	UINT i;
	for (i=0; i<countof(FileList); ++i) FileList[i] = &WholeFiles[i];
}


/***************************************************************************
* AvP[V(ApptBook/PhoneBook/Database/NoteTaker/Memo)̏
***************************************************************************/

#define AF_ACTIVE	0x0001			/* ̑ΏۂH */
#define AF_LOADENV	0x0002			/* ENVt@Ct@C擾H */

typedef struct sAPPINF {
	const char	Name[10];			/* Av(K擪) */
	const UINT	HotKey;				/* Av̋NL[ */
	const char	*EnvFile;			/* ENVt@C */
	const long	EnvOfs;				/* ENVt@C̃t@C̈ʒu */
	/* ȍ~ϐ */
	UINT		Flags;				/* AF_ACTIVE, AF_LOADENV */
	char		Target[MAXPATH];	/* Ώۃt@C(ܲ޶މ) */
	char		Dir[MAXPATH];		/* ΏۃfBNg */
	APPFILE		**Files;			/* KeyWordt@C̃Xg */
	UINT		Count;				/* KeyWordt@C̐ */
} APPINF;

APPINF AppInf[] = {					/* Av̊e */
	{ "ApptBook",  0xB000, "c:\\_dat\\apptbk.env", 0,  AF_ACTIVE|AF_LOADENV },
	{ "PhoneBook", 0xB400, "c:\\_dat\\phone.env",  0,  AF_ACTIVE|AF_LOADENV },
	{ "Database",  0xBA00, "c:\\_dat\\db.env",     0,  AF_ACTIVE|AF_LOADENV },
	{ "NoteTaker", 0xBE00, "c:\\_dat\\note.env",   0,  AF_ACTIVE|AF_LOADENV },
	{ "Memo",      0xB800, "c:\\_dat\\memoed.env", 72, AF_ACTIVE|AF_LOADENV }
};

APPINF *AppList[countof(AppInf)];	/* 񂪌AṽXg */

/* Avz̗vf̃GCAX */
#define ApptInf		(AppInf[0])
#define PhoneInf	(AppInf[1])
#define DBaseInf	(AppInf[2])
#define NoteInf		(AppInf[3])
#define MemoInf		(AppInf[4])

#define TARGET_OFS	((UINT)&((APPINF *)0)->Target)


/***************************************************************************
* prototypes
***************************************************************************/

void far DoQuit(void) { Done = TRUE; }
void far DoSelect(void);
void far DoDefault(void);
void GetPathInEnv(APPINF *Inf);
void PutPathInEnv(APPINF *Inf, const char *FileName);
BOOL SaveMyEnvFile(const char *EnvFile);


/***************************************************************************
* Function Keys
***************************************************************************/

#define CMD_F10KEY		(CMD_USER)
#define StartFKey1		(MainFKeys[1])
#define StartFKey2		(PathEditFKeys[3])

LHFKEY MainFKeys[] = {
	{ (PLHRES)&msgQuit, (PLHFUNC)DoQuit, 9|FKEY_LAST, 0 },
	{ (PLHRES)&msgStart, (PLHFUNC)CMD_DONE, 10|FKEY_LAST, FKEY_SENDMSG }
};

LHFKEY PathEditFKeys[] = {
	{ (PLHRES)&msgSelect, (PLHFUNC)DoSelect, 3, 0 },
	{ (PLHRES)&msgDefault, (PLHFUNC)DoDefault, 4, 0 },
	{ (PLHRES)&msgQuit, (PLHFUNC)DoQuit, 9|FKEY_LAST, 0 },
	{ (PLHRES)&msgStart, (PLHFUNC)CMD_DONE, 10|FKEY_LAST, FKEY_SENDMSG }
};

LHFKEY LaunchFKeys[] = {
	{ (PLHRES)&msgCancel, (PLHFUNC)CMD_ESC, 9, FKEY_SENDMSG },
	{ (PLHRES)&msgLaunch, (PLHFUNC)CMD_DONE, 10|FKEY_LAST, FKEY_SENDMSG }
};

LHFKEY SelectFKeys[] = {
	{ (PLHRES)&msgCancel, (PLHFUNC)CMD_ESC, 9, FKEY_SENDMSG },
	{ (PLHRES)&msgOk, (PLHFUNC)CMD_F10KEY, 10|FKEY_LAST, FKEY_SENDMSG }
};

LHFKEY OkFKeys[] = {
	{ (PLHRES)&msgOk, (PLHFUNC)CMD_DONE, 10|FKEY_LAST, FKEY_SENDMSG }
};


/***************************************************************************
* Menu
***************************************************************************/

#define StartMenu	(SearchMenu[0])
extern LHWINDOW AboutDialog;

LHMENU SearchMenu[] = {
	{ (PLHRES)&msg_Start, (PLHFUNC)CMD_DONE, F10KEY, MENU_SENDMSG|MENU_ELLIPSIS|MENU_GRAY },
	{ (PLHRES)&msg_Exit, (PLHFUNC)DoQuit, 0, MENU_BARBEFORE },
	{ 0, 0, 0, 0 }
};

LHMENU HelpMenu[] = {
	{ (PLHRES)&msg_About, (PLHFUNC)&AboutDialog, 0, MENU_CREATEWND|MENU_ELLIPSIS },
	{ 0, 0, 0, 0 }
};

LHMENU MainMenu[] = {
	{ (PLHRES)&msg_Search, (PLHFUNC)SearchMenu, 0, MENU_PULLDOWN },
	{ (PLHRES)&msg_Quit, (PLHFUNC)DoQuit, 0, 0 },
	{ (PLHRES)&msg_Help, (PLHFUNC)HelpMenu, 0, MENU_PULLDOWN },
	{ 0, 0, 0, 0 }
};

LHMENU LaunchMenu[] = {
	{ (PLHRES)&msg_Launch, (PLHFUNC)CMD_DONE, 0, MENU_SENDMSG },
	{ (PLHRES)&msg_Quit, (PLHFUNC)DoQuit, 0, 0 },
	{ 0, 0, 0, 0 }
};


/***************************************************************************
* Main Title and Clock
***************************************************************************/

LHWINDOW TDateTime = {
	DateTime, 0, 0, 0, 0,
	NULL, NULL, 0, STYLE_DATETIME | STYLE_NOFOCUS,
	NULL, NO_FKEYS, NO_MENU, NO_HELP
};

LHWINDOW MainTitle = {
	TitleBar, 0, 0, 0, 0,
	(PLHRES)&msgAppName, NULL, 0, STYLE_NOFOCUS,
	NULL, NO_FKEYS, (PLHMENU)&TDateTime, NO_HELP
};


/***************************************************************************
* About Global Search
***************************************************************************/

int far AboutDlgHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra);

LHWINDOW AboutDlgArray[] = {
	{ MessageBox, 120, 55, 400, 80,
	  NULL, (PLHDATA)&msgAboutPtr, 1,
	  MSG_CENTER_LINES | STYLE_NOFOCUS | STYLE_NOBORDER | STYLE_NOSHADOW,
	  NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
	{ PushButton, 285, 135, 70, 14,
	  (PLHRES)&msgOk, (PLHDATA)CMD_DONE, F10KEY,
	  STYLE_PUSHBUTTON | PUSHB_SENDMSG,
	  NULL, PARENT_FKEYS, NO_MENU, NO_HELP }
};

LHWINDOW AboutDialog = {
	(PLHCLASS)AboutDlgHandler, 80, 20, 480, 160,
	(PLHRES)&msgAbout, (PLHDATA)&AboutDlgArray, countof(AboutDlgArray), 0,
	NULL, OkFKeys, NO_MENU, NO_HELP
};

int far AboutDlgHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra)
{
	if (Msg == COMMAND && Data == CMD_DONE)
		Data = CMD_ESC;
	return SubclassMsg(DialogBox, Wnd, Msg, Data, Extra);
}


/***************************************************************************
* G[o͗p1sbZ[W
***************************************************************************/

int far MsgDlgHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra, ...);

LHWINDOW MsgDlgArray[] = {
	{ StaticText, 20, 24, 40, 1,
	  NULL, NULL, 40,
	  STYLE_XYRELATIVE | STYLE_WHCHAR | STYLE_NOBORDER | TEXT_CENTER,
	  NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
	{ PushButton, 180, 58, 70, 14,
	  (PLHRES)&msgOk, (PLHDATA)CMD_DONE, F10KEY,
	  STYLE_XYRELATIVE | STYLE_PUSHBUTTON | PUSHB_SENDMSG,
	  NULL, PARENT_FKEYS, NO_MENU, NO_HELP }
};

LHWINDOW MessageDialog = {
	(PLHCLASS)MsgDlgHandler, 100, 50, 440, 100,
	(PLHRES)&msgError, (PLHDATA)&MsgDlgArray, countof(MsgDlgArray), 0,
	NULL, OkFKeys, NO_MENU, NO_HELP
};

int far MsgDlgHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra, ...)
{
	if (Msg == COMMAND && Data == CMD_DONE)
		Data = CMD_ESC;
	return SubclassMsg(DialogBox, Wnd, Msg, Data, Extra);
}

void ShowErrMsg(const char *Msg)
{
	m_beep();
	MsgDlgArray[0].Data = (PLHDATA)Msg;
	SendMsg(&MessageDialog, CREATE, CREATE_FOCUS, 0);
}


/***************************************************************************
* Progress Meter
***************************************************************************/

LHWINDOW MeterDlgArray[] = {
	{ StaticText, 20, 24, 28, 1,
	  NULL, NULL, 28,
	  STYLE_XYRELATIVE | STYLE_WHCHAR | STYLE_NOBORDER | TEXT_CENTER,
	  NULL, NO_FKEYS, NO_MENU, NO_HELP },
	{ ProgressMeter, 20, 50, 27, 1,
	  NULL, NULL, 100,
	  STYLE_XYRELATIVE | STYLE_WHCHAR,
	  NULL, NO_FKEYS, NO_MENU, NO_HELP }
};

LHWINDOW MeterDialog = {
	DialogBox, 160, 50, 320, 80,
	(PLHRES)&msgMeterBox, (PLHDATA)MeterDlgArray, countof(MeterDlgArray), 0,
	NULL, NO_FKEYS, NO_MENU, NO_HELP
};

/*
 * Meter̃_CAOJ
 */
void OpenMeter(void)
{
	MeterDlgArray[0].Data = NULL;
	MeterDlgArray[1].LogicalSize = 100;
	MeterDlgArray[1].Selection = 0;
	SendMsg(&MeterDialog, CREATE, CREATE_FOCUS, 0);
}

/*
 * bZ[Wƍőlݒ肵Aݒl[ɖ߂
 */
void InitMeter(const char *Msg, UINT Max)
{
	MeterDlgArray[0].Data = (PLHDATA)Msg;
	SendMsg(&MeterDlgArray[0], DRAW, DRAW_CLIENT, 0);
	MeterDlgArray[1].LogicalSize = Max;
	MeterDlgArray[1].Selection = 0;
	SendMsg(&MeterDlgArray[1], DRAW, DRAW_ALL, 0);
}

/*
 * ݒlύX
 */
void SetMeter(UINT Value)
{
	SendMsg(&MeterDlgArray[1], DRAW, DRAW_CLIENT_UPDATE, Value);
}

/*
 * Meter̃_CAO
 */
void CloseMeter(void)
{
	SendMsg(&MeterDialog, DESTROY, DESTROY_NORMAL, 0);
}


/***************************************************************************
* Select Dialog (FileOpenDialogBox)
***************************************************************************/

char SelectFile[MAXPATH];
char SelectDir[MAXPATH];
char SelectMask[MAXFILE];

/* StringTableɓo^Ȃ߂̏׍H */
#define NOFIXUP
NOFIXUP char far *msgNull1		= "";
NOFIXUP char far *msgNull2		= "";
NOFIXUP char far *msgNull3		= "";
NOFIXUP char far *msgNull4		= "";
NOFIXUP char far *msgNull5		= "";
NOFIXUP char far *msgNull6		= "";

int far SelectDlgHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra, ...);

LHWINDOW SelectDlgArray[] = {
	{ PathText, 0, 0, 0, 0,
	  (PLHRES)&msgNull1, (PLHDATA)SelectFile, sizeof(SelectFile),
	  STYLE_WHCHAR,
	  NULL, PARENT_FKEYS, (PLHMENU)&SelectMask, NO_HELP },

	{ StaticText, 0, 0, 0, 0,
	  (PLHRES)&msgNull2, (PLHDATA)SelectDir, sizeof(SelectDir),
	  STYLE_NOBORDER | STYLE_NOBORDER,
	  NULL, PARENT_FKEYS, NO_MENU, NO_HELP },

	{ FileListBox, 0, 0, 0, 0,
	  (PLHRES)&msgNull3, NULL, 0,
	  STYLE_WHCHAR | STYLE_NOTIFY,
	  NULL, PARENT_FKEYS, (PLHMENU)0, NO_HELP },

	{ DirListBox, 0, 0, 0, 0,
	  (PLHRES)&msgNull4, NULL, 0,
	  STYLE_WHCHAR | STYLE_NOTIFY,
	  NULL, PARENT_FKEYS, (PLHMENU)0, NO_HELP },

	{ PushButton, 0, 0, 0, 0,
	  (PLHRES)&msgNull5, (PLHDATA)CMD_DONE, ENTERKEY,
	  STYLE_PUSHBUTTON | PUSHB_SENDMSG,
	  NULL, PARENT_FKEYS, NO_MENU, NO_HELP },

	{ PushButton, 0, 0, 0, 0,
	  (PLHRES)&msgNull6, (PLHDATA)CMD_ESC, 0, STYLE_PUSHBUTTON | PUSHB_SENDMSG,
	  NULL, PARENT_FKEYS, NO_MENU, NO_HELP }
};

LHWINDOW FileSelectDialog = {
	(PLHCLASS)SelectDlgHandler, 0, 0, 0, 0,
	(PLHRES)&msgSelFile, (PLHDATA)SelectDlgArray, countof(SelectDlgArray), 0,
	NULL, SelectFKeys, NO_MENU, NO_HELP
};

#define MAXLISTFILE		256
#define MAXLISTDIR		64

int far SelectDlgHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra, ...)
{
	static char *(*FileList)[MAXLISTFILE];
	static char (*FileSpace)[MAXLISTFILE][MAXFILE];
	static char *(*DirList)[MAXLISTDIR];
	static char (*DirSpace)[MAXLISTDIR][MAXFILE];
	static APPINF *Inf;
	UINT i;

	switch (Msg) {
	case CREATE:
		Inf = (APPINF *)Extra;
		FileList = m_alloc(sizeof(*FileList));
		FileSpace = m_alloc(sizeof(*FileSpace));
		DirList = m_alloc(sizeof(*DirList));
		DirSpace = m_alloc(sizeof(*DirSpace));
		FixupFarPtrs();
		if (!FileList || !FileSpace || !DirList || !DirSpace) {
			ShowErrMsg("Not enough memory.");
			return FALSE;
		}
		for (i=0; i<countof(*FileList); ++i)
			(*FileList)[i] = &(*FileSpace)[i][0];
		for (i=0; i<countof(*DirList); ++i)
			(*DirList)[i] = &(*DirSpace)[i][0];
		SelectDlgArray[2].Data = (PLHDATA)FileList;
		SelectDlgArray[2].LogicalSize = MAXLISTFILE;
		SelectDlgArray[2].Menu = (PLHMENU)MAXLISTFILE;
		SelectDlgArray[3].Data = (PLHDATA)DirList;
		SelectDlgArray[3].LogicalSize = MAXLISTDIR;
		SelectDlgArray[3].Menu = (PLHMENU)MAXLISTDIR;
		break;
	case DESTROY:
		m_free(FileList); m_free(FileSpace);
		m_free(DirList);  m_free(DirSpace);
		break;
	case KEYSTROKE:
		if (Data == F10KEY) Data = ENTERKEY;
		break;
	case COMMAND:
		if (Data == CMD_F10KEY) {
			Msg = KEYSTROKE;
			Data = ENTERKEY;
		} else if (Data == CMD_DONE) {
			strcpy(Inf->Target, SelectDir);
			if (SelectDir[0] != '\0' && SelectDir[strlen(SelectDir)-1] != '\\')
				strcat(Inf->Target, "\\");
			strcat(Inf->Target, SelectFile);
			strlwr(Inf->Target);
			Inf->Flags &= ~AF_LOADENV;
			return SendMsg(Wnd, DESTROY, DESTROY_NORMAL, 0);
		}
		break;
	}
	return SubclassMsg(FileOpenDialogBox, Wnd, Msg, Data, Extra);
}

int fnsplit(const char *, char *, char *, char *, char *);

void far DoSelect(void)
{
	PLHWINDOW EditWindow;
	char Tmp[MAXPATH];
	UINT Len;

	EditWindow = GetFocus();
	fnsplit(EditWindow->Data, SelectDir, Tmp, SelectFile, SelectMask+1);
	strcat(SelectDir, Tmp);
	if ((Len = strlen(SelectDir)) > 3 && SelectDir[Len-1] == '\\')
		SelectDir[Len-1] = '\0';
	SelectFile[0] = '\0';
	SelectMask[0] = '*';
	SendMsg(&FileSelectDialog, CREATE, CREATE_FOCUS,
		(WORD)((BYTE *)(EditWindow->Data) - TARGET_OFS));
}

void far DoDefault(void)
{
	APPINF *Inf = (APPINF *)((BYTE *)(GetFocus()->Data) - TARGET_OFS);

	GetPathInEnv(Inf);
	SendFocusMsg(SETFOCUS, SETFOCUS_NORMAL, 0);
	Inf->Flags |= AF_LOADENV;
}


/***************************************************************************
* Launch Dialog
***************************************************************************/

int far AppListHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra, ...);
int far FileListHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra, ...);
int far ViewTextHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra, ...);
int far LaunchDlgHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra, ...);

#define AListBox	(LaunchDlgArray[0])
#define FListBox	(LaunchDlgArray[1])
#define ViewText	(LaunchDlgArray[2])

LHWINDOW LaunchDlgArray[] = {
	/* Applications */
	{ (PLHCLASS)AppListHandler, 14, 21, 21, 5,
	  (PLHRES)&msg_Appli, (PLHDATA)&AppList, 0, STYLE_WHCHAR|STYLE_XYRELATIVE,
	  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP },

	/* Files */
	{ (PLHCLASS)FileListHandler, 238, 21, 22, 5,
	  (PLHRES)&msg_Files, NULL, 0, STYLE_WHCHAR | STYLE_XYRELATIVE,
	  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP },

	/* Text Image */
	{ (PLHCLASS)ViewTextHandler, 14, 100, 448, 14,
	  NULL, NULL, 42, STYLE_XYRELATIVE,
	  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP },

	/* Search after launch */
	{ CheckBox, 14, 128, 100, 14,
	  (PLHRES)&msg_After, (PLHDATA)&GlobalFlags, GF_SEARCHINAPP,
	  STYLE_XYRELATIVE,
	  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP },

	/* Launch */
	{ PushButton, 300, 124, 0, 0,
	  (PLHRES)&msgLaunch, (PLHDATA)CMD_DONE, ENTERKEY,
	  STYLE_PUSHBUTTON | PUSHB_SENDMSG | STYLE_XYRELATIVE,
	  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP, STATUS_DEF_PUSHB },

	/* Cancel */
	{ PushButton, 390, 124, 0, 0,
	  (PLHRES)&msgCancel, (PLHDATA)CMD_ESC, ESCKEY,
	  STYLE_PUSHBUTTON | PUSHB_SENDMSG | STYLE_XYRELATIVE,
	  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP }
};

LHWINDOW LaunchDialog = {
	(PLHCLASS)LaunchDlgHandler, 80, 20, 480, 160,
	(PLHRES)&msgLaunchTit, (PLHDATA)LaunchDlgArray, countof(LaunchDlgArray),
	STYLE_PUSHB_WIDTH,
	NULL, LaunchFKeys, LaunchMenu, NO_HELP
};

/*
 * AvP[VXg̃nh
 */
int far AppListHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra, ...)
{
	UINT Sel;
	int Result;
	APPINF *CurrApp;

#if defined(CURSOR_MOVE)
	/* EJ[\Ńt@CXgɈړ */
	if (Msg == KEYSTROKE && Data == RIGHTKEY) {
		LaunchDialog.Selection++;
		return SendMsg(&LaunchDialog, SETFOCUS, SETFOCUS_NORMAL, 0);
	}
#endif

	/* Ƃ肠ListBoxɏācc */
	Sel = Wnd->Selection;
	Result = SubclassMsg(ListBox, Wnd, Msg, Data, Extra);

	/* IAvĂFListBox̓eւčĕ` */
	if (Sel != Wnd->Selection) {
		CurrApp = ((APPINF **)Wnd->Data)[Wnd->Selection];
		FListBox.Data = (PLHDATA)(CurrApp->Files);
		FListBox.LogicalSize = CurrApp->Count;
		FListBox.Selection = 0;
		SendMsg(&FListBox, DRAW, DRAW_CLIENT, 0);
	}
	return Result;
}

/*
 * t@CXg̃nh
 */
int far FileListHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra, ...)
{
	static APPFILE *Last = NULL;
	APPFILE *Curr;
	int Result;

#if defined(CURSOR_MOVE)
	/* J[\ŃAvXgɈړ */
	if (Msg == KEYSTROKE && Data == LEFTKEY) {
		LaunchDialog.Selection--;
		return SendMsg(&LaunchDialog, SETFOCUS, SETFOCUS_NORMAL, 0);
	}
#endif

	/* Ƃ肠ListBoxɏācc */
	Result = SubclassMsg(ListBox, Wnd, Msg, Data, Extra);

	/* OƑIt@CĂViewTextĕ` */
	if (Last != (Curr = ((APPFILE **)(Wnd->Data))[Wnd->Selection])) {
		Last = Curr;
		if (ViewText.Status & STATUS_XY_ABS)
			SendMsg(&ViewText, DRAW, DRAW_ALL, 0);
	}
	return Result;
}

/*
 * ʕ\̃nh
 */
int far ViewTextHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra, ...)
{
	NBFILE fp;
	char Path[MAXPATH];		/* I𒆃t@C̃tpX */
	static UCHAR s[64];		/* t@Cǂ񂾕 */
	int i;

	/* DRAWbZ[Wt@C̓eǂ */
	if (Msg == DRAW && (Data & DRAW_CLIENT)) {
		strcpy(Path, ((APPINF **)AListBox.Data)[AListBox.Selection]->Dir);
		strcat(Path, ((APPFILE **)FListBox.Data)[FListBox.Selection]->FileName);
		if (m_openro(&fp, Path, strlen(Path), 0, 1) != 0)
			s[0] = '\0';
		else {
			m_seek(&fp, 0, ((APPFILE **)FListBox.Data)[FListBox.Selection]->Ofs);
			m_read(&fp, s, sizeof(s)-1, &i);
			s[i] = '\0';
			while (i--)
				if (s[i] < 0x20) s[i] = 0x07;	/* 䕶𒆍 */
			m_close(&fp);
		}
		Wnd->Data = s;
	}
	return SubclassMsg(StaticText, Wnd, Msg, Data, Extra);
}

/*
 * AvN_CAÕnh
 */
int far LaunchDlgHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...)
{
	char Path[MAXPATH];		/* Iꂽt@C̃tpX */
	APPINF *Inf;			/* IꂽAv̏ */
	UINT TaskNum;			/* NAṽ^XNԍ */

	if (Msg == COMMAND && Data == CMD_DONE) {
		/* AvP[VUClose */
		Inf = ((APPINF **)AListBox.Data)[AListBox.Selection];
		Event.norm.do_event = DO_CLOSE_APP;
		Event.l.e_launch_task = TaskNum = GetTaskNum(Inf->HotKey);
		m_action(&Event);
		FixupFarPtrs();

		/* ENVt@CɃt@CZbg */
		strcpy(Path, Inf->Dir);
		strcat(Path, ((APPFILE **)FListBox.Data)[FListBox.Selection]->FileName);
		PutPathInEnv(Inf, Path);
		/* Nbv{[hɌZbg */
		CopyToClipboard(KeyWord);
		/* L[obt@ɑ@ */
		if (Inf == &MemoInf) {
			PushKey(ALTFKEY); PushKey('1');
		}
		if (GlobalFlags & GF_SEARCHINAPP) {
			if (Inf == &PhoneInf || Inf == &DBaseInf || Inf == &NoteInf) {
				/* Subset -> Home -> Ok */
				PushKey(F6KEY); PushKey(HOMEKEY); PushKey(F10KEY);
			} else if (Inf == &ApptInf) {
				/* Goto -> Year+ -> Ok */
				PushKey(F5KEY); PushKey(F8KEY); PushKey(F10KEY);
			}
			PushKey(F4KEY);
			PushKey(PASTEKEY);
			if (GlobalFlags & GF_CASESENS) PushKey(ALTCKEY);
			if (Inf == &ApptInf)
				PushKey(F3KEY);
			else
				PushKey(F10KEY);
		}

		/* AvP[VN */
		Event.norm.do_event = DO_LAUNCH;
		Event.l.e_launch_task = TaskNum;
		Event.l.e_launch_type = LT_YIELD_THEN_LAUNCH;
		DeactivateLHAPI();
		m_action(&Event);
		switch(Event.norm.kind) {
		case E_ACTIV:
		case E_REFRESH:
			FixupFarPtrs();
			ReactivateLHAPI(&LHAPIData);
			SetIme();
			break;
		case E_TERM:
			FixupFarPtrs();
			SaveMyEnvFile(MyEnvPath);
			Event.norm.do_event = DO_FINI;
			m_action(&Event);
			break;
		}
		if (Event.norm.return_status == 0)
			SendMsg(Wnd, SETFOCUS, SETFOCUS_NORMAL, 0);
		else {
			m_flush_kb();
			ShowErrMsg("Cannot launch this application.");
		}
		return TRUE;
	}
	return SubclassMsg(DialogBox, Wnd, Msg, Data, Extra);
}


/***************************************************************************
* 񌟍
***************************************************************************/

void *(*pmemchr)(const void *, int, UINT);
int (*pmemcmp)(const void *, const void *, UINT);

#define BUFPAGELEN	8192
char *SearchBuf;

/*
 * t@C̕
 */
long bfind(char *FileName, long fsize, char *str)
{
	char *p;
	NBFILE fp;
	UINT i, Pages, Len, MoveLen;

	if (m_openro(&fp, FileName, strlen(FileName), 0, 1) != 0)
		return -1;
	Pages = (fsize - 1) / BUFPAGELEN + 1;
	InitMeter(FileName, Pages);
	MoveLen = strlen(KeyWord) - 1;
	memset(SearchBuf, 0, MoveLen);
	for (i=0; i<Pages; ++i) {
		m_read(&fp, SearchBuf+MoveLen, BUFPAGELEN, &Len);
		for (p=SearchBuf; p < SearchBuf+Len; ++p) {
			if ((p = (*pmemchr)(p, str[0], Len-(p-SearchBuf))) == NULL) break;
			if ((*pmemcmp)(p, str, strlen(str)) == 0) goto ENDOFSEARCH;
		}
		memcpy(SearchBuf, SearchBuf+BUFPAGELEN, MoveLen);
		SetMeter(i);
	}
	p = NULL;
ENDOFSEARCH:
	SetMeter(Pages);
	m_close(&fp);
	if (p == NULL)
		return -1;
	else
		return i * BUFPAGELEN + (p - SearchBuf) - MoveLen;
}

/*
 * ChJ[hWJȂet@C̕
 */
void SearchFiles(APPINF *Inf)
{
	MATCH Match;
	int Flag;
	long Pos;

	Inf->Count = 0; Inf->Files = &FileList[WholeCount];
	if (m_setpat(&Match, Inf->Target, strlen(Inf->Target), 0) == 0) {
		while (m_match(&Match, &Flag) == 0
		 && Flag
		 && WholeCount <= countof(WholeFiles)) {
			if (Match.m_attr & (FA_SYSTEM|FA_HIDDEN)) continue;
			if ((Pos = bfind(Match.m_path, Match.m_size, KeyWord)) == -1)
				continue;
			strcpy(WholeFiles[WholeCount].FileName, Match.m_name);
			strlwr(WholeFiles[WholeCount].FileName);
			WholeFiles[WholeCount].Ofs = Pos;
			++WholeCount;
			++(Inf->Count);
		}
		strcpy(Inf->Dir, Match.m_path);
		Inf->Dir[strlen(Match.m_path)-strlen(Match.m_name)] = '\0';
	}
}

/*
 * SAvP[V̑Ώۃt@C̕
 */
BOOL GetFileList(void)
{
	UINT i;

	/* pobt@p */
	if ((SearchBuf = m_alloc(BUFPAGELEN + MAXKEYWD)) == NULL)
		return FALSE;
	FixupFarPtrs();

	/* 񌟍֐̑I */
	if (GlobalFlags & GF_CASESENS) {
		pmemchr = &memchr;  pmemcmp = &memcmp;
	} else {
		pmemchr = &memichr; pmemcmp = &memicmp;
	}

	OpenMeter();
	WholeCount = 0;
	AListBox.LogicalSize = 0;
	for (i=0; i<countof(AppInf); ++i) {
		if (AppInf[i].Flags & AF_ACTIVE) {
			SearchFiles(&AppInf[i]);
			if (AppInf[i].Count > 0)
				AppList[AListBox.LogicalSize++] = &AppInf[i];
		}
	}
	AListBox.Selection = 0;
	CloseMeter();

	m_free(SearchBuf);
	return TRUE;
}


/***************************************************************************
* Main Dialog
***************************************************************************/

int far KeyEditHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra, ...);
int far CBoxHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra, ...);
int far EditHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra, ...);
int far MainDlgHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra, ...);

#define CMD_QUIT	(CMD_USER)
#define FirstCBox	ApptCBox
#define FirstEdit	ApptEdit
#define ApptCBox	(MainDlgArray[4])
#define ApptEdit	(MainDlgArray[5])
#define PhoneCBox	(MainDlgArray[6])
#define PhoneEdit	(MainDlgArray[7])
#define DBaseCBox	(MainDlgArray[8])
#define DBaseEdit	(MainDlgArray[9])
#define NoteCBox	(MainDlgArray[10])
#define NoteEdit	(MainDlgArray[11])
#define MemoCBox	(MainDlgArray[12])
#define MemoEdit	(MainDlgArray[13])
#define LastCBox	MemoCBox
#define LastEdit	MemoEdit
#define StartButton	(MainDlgArray[14])

LHWINDOW MainDlgArray[] = {
	/* Search */
	{ GroupBox, 10, 15, 630-10, 55-15,
	  (PLHRES)&msgSearch, NULL, 0, STYLE_NOFOCUS,
	  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP },

	/* Key Word */
	{ (PLHCLASS)KeyEditHandler, 27, 30, 434-27, 14,
	  (PLHRES)&msg_KeyWord, (PLHDATA)&KeyWord, sizeof(KeyWord), EDIT_INSERT,
	  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP },

	/* Case sensitive */
	{ CheckBox, 454, 30, 616-454, 14,
	  (PLHRES)&msg_CaseSens, (PLHDATA)&GlobalFlags, GF_CASESENS, 0,
	  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP },

	/* Target Files */
	{ GroupBox, 10, 62, 520, 184-62,
	  (PLHRES)&msgTarget, NULL, 0, STYLE_NOFOCUS,
	  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP },

	/* ApptBook */
	{ (PLHCLASS)CBoxHandler, 26, 78, 150-26, 14,
	  (PLHRES)&msg_Appt, (PLHDATA)&ApptInf.Flags, AF_ACTIVE, 0,
	  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP },
	{ (PLHCLASS)EditHandler, 160, 78, 513-160, 14,
	  NULL, (PLHDATA)ApptInf.Target, sizeof(ApptInf.Target), EDIT_INSERT,
	  NULL, PathEditFKeys, PARENT_MENU, NO_HELP },

	/* PhoneBook */
	{ (PLHCLASS)CBoxHandler, 26, 99, 150-26, 14,
	  (PLHRES)&msg_Phone, (PLHDATA)&PhoneInf.Flags, AF_ACTIVE, 0,
	  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP },
	{ (PLHCLASS)EditHandler, 160, 99, 513-160, 14,
	  NULL, (PLHDATA)PhoneInf.Target, sizeof(PhoneInf.Target), EDIT_INSERT,
	  NULL, PathEditFKeys, PARENT_MENU, NO_HELP },

	/* Database */
	{ (PLHCLASS)CBoxHandler, 26, 120, 150-26, 14,
	  (PLHRES)&msg_DBase, (PLHDATA)&DBaseInf.Flags, AF_ACTIVE, 0,
	  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP },
	{ (PLHCLASS)EditHandler, 160, 120, 513-160, 14,
	  NULL, (PLHDATA)DBaseInf.Target, sizeof(DBaseInf.Target), EDIT_INSERT,
	  NULL, PathEditFKeys, PARENT_MENU, NO_HELP },

	/* NoteTaker */
	{ (PLHCLASS)CBoxHandler, 26, 141, 150-26, 14,
	  (PLHRES)&msg_Note, (PLHDATA)&NoteInf.Flags, AF_ACTIVE, 0,
	  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP },
	{ (PLHCLASS)EditHandler, 160, 141, 513-160, 14,
	  NULL, (PLHDATA)NoteInf.Target, sizeof(NoteInf.Target), EDIT_INSERT,
	  NULL, PathEditFKeys, PARENT_MENU, NO_HELP },

	/* Memo */
	{ (PLHCLASS)CBoxHandler, 26, 162, 150-26, 14,
	  (PLHRES)&msg_Memo, (PLHDATA)&MemoInf.Flags, AF_ACTIVE, 0,
	  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP },
	{ (PLHCLASS)EditHandler, 160, 162, 513-160, 14,
	  NULL, (PLHDATA)MemoInf.Target, sizeof(MemoInf.Target), EDIT_INSERT,
	  NULL, PathEditFKeys, PARENT_MENU, NO_HELP },

	/* Start */
	{ PushButton, 548, 115, 80, 0,
	  (PLHRES)&msgStart, (PLHDATA)CMD_DONE, ENTERKEY,
	  STYLE_PUSHBUTTON | PUSHB_SENDMSG | STYLE_GRAY | STYLE_NOFOCUS,
	  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP, STATUS_DEF_PUSHB },

	/* Quit */
	{ PushButton, 548, 155, 80, 0,
	  (PLHRES)&msgQuit, (PLHDATA)CMD_QUIT, 0,
	  STYLE_PUSHBUTTON | PUSHB_SENDMSG,
	  NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP }
};

LHWINDOW MainDialog = {
	(PLHCLASS)MainDlgHandler, 0, 9, 640, 200-9-8,
	NULL, (PLHDATA)MainDlgArray, countof(MainDlgArray),
	STYLE_NOBORDER | STYLE_NOSHADOW,
	NULL, MainFKeys, MainMenu, NO_HELP
};

/*
 * Start{^/j[/t@NVL[Lɂ
 */
void EnableStart(void)
{
	/* tOύX */
	StartButton.Style &= ~(STYLE_GRAY | STYLE_NOFOCUS);
	StartMenu.Style &= ~MENU_GRAY;
	(&StartFKey1)[-1].KeyNum &= ~FKEY_LAST;
	(&StartFKey2)[-1].KeyNum &= ~FKEY_LAST;

	/* ĕ` */
	SendMsg(&StartButton, DRAW, DRAW_ALL, 0);
	DrawFKeys(GetFocus(), FKEY_ALONE);
}

/*
 * Start{^/j[/t@NVL[𖳌ɂ
 */
void DisableStart(void)
{
	/* tOύX */
	StartButton.Style |= (STYLE_GRAY | STYLE_NOFOCUS);
	StartMenu.Style |= MENU_GRAY;
	(&StartFKey1)[-1].KeyNum |= FKEY_LAST;
	(&StartFKey2)[-1].KeyNum |= FKEY_LAST;

	/* ĕ` */
	SendMsg(&StartButton, DRAW, DRAW_ALL, 0);
	DrawFKeys(GetFocus(), FKEY_ALONE);
}

/*
 * KeyWord͗pEdit̃nh
 * ͂Ă邩ǂɂāAStart{^/j[ON/OFF
 */
int far KeyEditHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra, ...)
{
	BOOL Last, IsNull;
	int Result;

	Last = (*(Wnd->Data) == '\0');
	Result = SubclassMsg(Edit, Wnd, Msg, Data, Extra);
	IsNull = (*(Wnd->Data) == '\0');
	if (Msg == KEYSTROKE && Last != IsNull) {
		if (IsNull)	DisableStart();
		else        EnableStart();
	}
	return Result;
}

/*
 * eAvCheckBox̋ʃnh
 * `FbN}[NON/OFFɉāAEditEBhE̕\/tH[JX𐧌䂷
 */
int far CBoxHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra, ...)
{
	PLHWINDOW EditWindow;
	UINT Last, Active;
	int Result;

#if defined(CURSOR_MOVE)
	if (Msg == KEYSTROKE) {
		switch (Data) {
		case RIGHTKEY:
			MainDialog.Selection++;
			return SendMsg(&MainDialog, SETFOCUS, SETFOCUS_NORMAL, 0);
		case UPKEY:
			if (Wnd > &FirstCBox) {
				MainDialog.Selection -= 2;
				return SendMsg(&MainDialog, SETFOCUS, SETFOCUS_NORMAL, 0);
			}
			break;
		case DOWNKEY:
			if (Wnd < &LastCBox) {
				MainDialog.Selection += 2;
				return SendMsg(&MainDialog, SETFOCUS, SETFOCUS_NORMAL, 0);
			}
			break;
		}
	}
#endif
	/* CheckBoxɃbZ[W𑗂Õ`FbN}[NL */
	Last = *(UINT *)Wnd->Data & Wnd->LogicalSize;

	Result = SubclassMsg(CheckBox, Wnd, Msg, Data, Extra);

	/* `FbN}[NωĂAEditEBhȄԂύX */
	if ((Active = *(UINT *)(Wnd->Data) & Wnd->LogicalSize) != Last) {
		EditWindow = Wnd + 1;
		if (Active)	EditWindow->Style &= ~STYLE_NOFOCUS;
		else		EditWindow->Style |= STYLE_NOFOCUS;
		SendMsg(EditWindow, DRAW, DRAW_ALL, 0);
	}
	return Result;
}

/*
 * eAṽt@CEdit̋ʃnh
 * STYLE_NOFOCUSɂ̓eLXgGRAYŕ\
 */
int far EditHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra, ...)
{
	int Result;

	if (Msg == CREATE) {
		if (*(UINT *)((Wnd-1)->Data) & (Wnd-1)->LogicalSize)
			Wnd->Style &= ~STYLE_NOFOCUS;
		else
			Wnd->Style |= STYLE_NOFOCUS;
	}
#if defined(CURSOR_MOVE)
	else if (Msg == KEYSTROKE) {
		switch (Data) {
		case UPKEY:
			if (Wnd > &FirstEdit) {
				MainDialog.Selection -= 2;
				return SendMsg(&MainDialog, SETFOCUS, SETFOCUS_NORMAL, 0);
			}
			break;
		case DOWNKEY:
			if (Wnd < &LastEdit) {
				MainDialog.Selection += 2;
				return SendMsg(&MainDialog, SETFOCUS, SETFOCUS_NORMAL, 0);
			}
			break;
		}
	}
#endif
	Result = SubclassMsg(Edit, Wnd, Msg, Data, Extra);
	switch (Msg) {
	case DRAW:
		if (Wnd->Style & STYLE_NOFOCUS)
			Rectangle(Wnd->x+1, Wnd->y+1, Wnd->w-2, Wnd->h-2, 0, G_PATTERNFILL);
		break;
	case KEYSTROKE:
		if ((Wnd->Status & STATUS_NOT_EDITED) == 0)
			((APPINF *)((BYTE *)(Wnd->Data) - TARGET_OFS))->Flags &= ~AF_LOADENV;
		break;
	}
	return Result;
}

int far MainDlgHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra, ...)
{
	UINT i;
	APPINF *Inf;

	switch (Msg) {
	case COMMAND:
		switch(Data) {
		case CMD_DONE:
			if (!GetFileList()) {
				ShowErrMsg("Not enough memory.");
				return TRUE;
			}
			if (WholeCount == 0) {
				ShowErrMsg("No file matched.");
				return TRUE;
			}
			Inf = ((APPINF **)AListBox.Data)[0];
			FListBox.Data = (PLHDATA)(Inf->Files);
			FListBox.LogicalSize = Inf->Count;
			FListBox.Selection = 0;
			SendMsg(&LaunchDialog, CREATE, CREATE_FOCUS, 0);
			return TRUE;
		case CMD_QUIT:
			Done = TRUE;
			return TRUE;
		case CMD_ESC:
			m_thud();
			return TRUE;
		}
	}
	return SubclassMsg(DialogBox, Wnd, Msg, Data, Extra);
}


/***************************************************************************
* ݒt@C̑
***************************************************************************/

/*
 * Av̊ݒt@CҏWt@C擾
 */
void GetPathInEnv(APPINF *Inf)
{
	NBFILE fp;
	int Len;

	if (m_openro(&fp,Inf->EnvFile,strlen(Inf->EnvFile),0,1)==0) {
		m_seek(&fp, 0, Inf->EnvOfs);
		m_read(&fp, Inf->Target, sizeof(Inf->Target), &Len);
		m_close(&fp);
	}
	strlwr(Inf->Target);
}

/*
 * Av̊ݒt@CɕҏWt@Cݒ
 */
void PutPathInEnv(APPINF *Inf, const char *FileName)
{
	NBFILE fp;

	if (m_open(&fp, Inf->EnvFile, strlen(Inf->EnvFile), 0, 1) == 0) {
		m_seek(&fp, 0, Inf->EnvOfs);
		m_write(&fp, FileName, strlen(FileName)+1);		/* +1'\0'̕ */
		m_close(&fp);
	}
}

/*
 * ݒt@CȌԂ𕜌
 */
BOOL LoadMyEnvFile(const char *EnvFile)
{
	FILE fp;
	int i, Len;

	if (m_openro(&fp, EnvFile, strlen(EnvFile), 0, 0) != 0)
		return FALSE;
	m_read(&fp, &GlobalFlags, sizeof(GlobalFlags), &Len);
	m_read(&fp, &KeyWord, sizeof(KeyWord), &Len);
	for (i=0; i<countof(AppInf); ++i) {
		m_read(&fp, &AppInf[i].Flags, sizeof(AppInf[i].Flags), &Len);
		m_read(&fp, &AppInf[i].Target, sizeof(AppInf[i].Target), &Len);
	}
	m_close(&fp);
	return TRUE;
}

/*
 * ݒt@CɊeݒZ[u
 */
BOOL SaveMyEnvFile(const char *EnvFile)
{
	FILE fp;
	int i;

	if (m_fcreat(&fp, EnvFile, strlen(EnvFile), 0, 0) != 0)
		return FALSE;
	m_write(&fp, &GlobalFlags, sizeof(GlobalFlags));
	m_write(&fp, &KeyWord, sizeof(KeyWord));
	for (i=0; i<countof(AppInf); ++i) {
		m_write(&fp, &AppInf[i].Flags, sizeof(AppInf[i].Flags));
		m_write(&fp, &AppInf[i].Target, sizeof(AppInf[i].Target));
	}
	m_close(&fp);
	return TRUE;
}


void main(void)
{
	UINT i;

	m_init_app(SYSTEM_MANAGER_VERSION);
	m_reg_app_name(msgAppName);
	InitializeLHAPI(&LHAPIData);
	SetDefaultFont(FONT_NORMAL);

	/* ̊ݒt@Cǂ */
	InitListPtrs();
	if (!LoadMyEnvFile(MyEnvPath)) {
		MyEnvPath[0] = 'c';
		LoadMyEnvFile(MyEnvPath);
	}
	/* Av̊ݒt@CҏWt@C擾 */
	for (i=0; i<countof(AppInf); ++i)
		if (AppInf[i].Flags & AF_LOADENV)
			GetPathInEnv(&AppInf[i]);

	/* Cʂ\ */
	SendMsg(&MainDialog, CREATE, CREATE_FOCUS, 0);
	SendMsg(&MainTitle, CREATE, CREATE_NORMAL, 0);
	SetIme();

	/* 񂪋łȂStart@\L */
	if (KeyWord[0] != '\0') EnableStart();

	do {
		Event.norm.do_event = DO_EVENT;
		m_action(&Event);
		switch(Event.norm.kind) {
		case E_ACTIV:
		case E_REFRESH:
			FixupFarPtrs();
			ReactivateLHAPI(&LHAPIData);
			SetIme();
			break;
		case E_DEACT:
			DeactivateLHAPI();
			break;
		case E_TERM:
			FixupFarPtrs();
			Done = TRUE;
			break;
		case E_KEY:
			SendFocusMsg(KEYSTROKE, Event.norm.data, Event.norm.scan);
			break;
		case E_NONE:
			SendMsg(&TDateTime, DRAW, DRAW_ALL, 0);
			break;
		}
	} while (!Done);

	SaveMyEnvFile(MyEnvPath);

	Event.norm.do_event = DO_FINI;
	m_action(&Event);
}
