'/* SRTF.BAS Sort a text file by text line or binary record length */
'/*          By: Dale Thorn                                        */
'/*          Rev. 08.07.2002                                       */

'$include: 'basdef.h'
'$include: 'filekill.h'
'$include: 'fileopen.h'
'$include: 'longname.h'
'$include: 'messages.h'
'$include: 'midchar.h'
'$include: 'parmstr1.h'
'$include: 'string.h'
'$include: 'lsort.h'

declare function io.ktst(inop)

'$include: 'basdef.bas'
'$include: 'filekill.bas'
'$include: 'fileopen.bas'
'$include: 'longname.bas'
'$include: 'messages.bas'
'$include: 'midchar.bas'
'$include: 'parmstr1.bas'
'$include: 'string.bas'
'$include: 'lsort.bas'

dim ioffset(10), iseglen(10)

ccmd = ucase$(rtrim$(command$))         'get the user's command-line parameters
if ccmd = "" then                              'a command line was NOT supplied
   cls                                                'clear the display screen
   cmsg = "Usage:  SRTF  filename                        "
   ctmp = space$(4)                        'initialize the messages left margin
   locate 3, 1, 1                         'move display cursor to screen row #5
   print ctmp; cmsg                            'display the first usage message
   ipos1 = len(cmsg) - 22                         'position for '/?' parameters
   mid$(cmsg, ipos1) = "[offset  seglen .....]"    'insert the segments message
   print ctmp; cmsg                               'display second usage message
   mid$(cmsg, ipos1) = "/Bnn(binary sort)     "    'insert the bin.sort message
   print ctmp; cmsg                                'display third usage message
   mid$(cmsg, ipos1) = "/Exx(exclude chars xx)"   'insert the exc.chars message
   print ctmp; cmsg                                'display sixth usage message
   mid$(cmsg, ipos1) = "/C(ase sensitive)     "   'insert the case-sens.message
   print ctmp; cmsg                               'display fourth usage message
   mid$(cmsg, ipos1) = "/J(ustify left)       "     'insert the justify message
   print ctmp; cmsg                                'display fifth usage message
   mid$(cmsg, ipos1) = "/N(o spaces)          "    'insert the no-space message
   print ctmp; cmsg                              'display seventh usage message
   mid$(cmsg, ipos1) = "/R(everse sort)       "     'insert the reverse message
   print ctmp; cmsg                               'display eighth usage message
   print                                           'blank line between messages
   print ctmp; "If 'offset' and 'seglen' specified, sort begins after offset"
   print ctmp; "column for 'seglen' no. of bytes.  Up to 5 segments allowed."
   print                                           'blank line between messages
   print ctmp; "If '/Bnn' specified, perform a binary sort where 'nn' is the"
   print ctmp; "                     fixed record length of the binary file."
   print ctmp; "If '/Exx' specified, exclude char(s) 'xx' from the 'N' sort."
   print ctmp; "If '/C'   specified, do not ignore case in sort comparisons."
   print ctmp; "If '/J'   specified, sort begins at 1st non-blank/tab column."
   print ctmp; "If '/N'   specified, ignore spaces when comparing sort data."
   print ctmp; "If '/R'   specified, sort data in reverse (descending) order."
   close                              'close all files in case not closed above
   system                                   'return control to operating system
end if                              'display the usage message [above] and exit

imaxlen = 255                     'maximum sort length (length of all segments)

nc.sdno = 1                       'file channel/unit# for sort data file (.sdx)
nc.ndno = 2                      'file channel/unit# for sort index file (.ndx)
isrcfil = 3                                    'source file-unit/channel number
idstfil = 4                               'destination file-unit/channel number

ibinary = 0                                 'initialize the binary-sorting flag
ibinlen = 0                                 'initialize the binary-length value
icassen = 0                                 'initialize the case-sensitive flag
iexchr1 = 0                                   'initialize 1st exclude character
iexchr2 = 0                                   'initialize 2nd exclude character
ijustfy = 0                                   'initialize the left-justify flag
inonspc = 0                                      'initialize the no-spaces flag
irevord = 0                                  'initialize the reverse-order flag
imsgdisp = not 0                               'initialize message display flag

ipos1 = instr(ccmd, "/E")              'possible exclude-chars. switch position
if ipos1 then                               'possible exclude-characters switch
   ibeg = istr.lcsp(ipos1 + 2, ccmd, " ")     'exclude-character begin position
   iend = istr.lcfn(ibeg + 0, ccmd, " ")        'exclude-character end position
   itst = istr.lcfn(ibeg + 0, ccmd, "/")           'exclude "test" end position
   if iend > itst then                               '/' encountered before ' '
      iend = itst                                      'set end to '/' position
   end if
   if ibeg < iend then                       '1st valid exclude character found
      iexchr1 = midchar(ccmd, ibeg)             'save the 1st exclude character
   end if
   if ibeg + 1 < iend then                   '2nd valid exclude character found
      iexchr2 = midchar(ccmd, ibeg + 1)         'save the 2nd exclude character
   end if
   ccmd = rtrim$(left$(ccmd, ipos1 - 1) + mid$(ccmd, iend)) 'remove '/E' switch
   inonspc = not 0                                   'set the no-spaces flag ON
end if

ipos1 = instr(ccmd, "/B")                    'position of binary sort specifier
if ipos1 then                                   'binary sort mode was specified
   ibinlen = pdqvali(mid$(ccmd, ipos1 + 2))       'get the binary record length
   if ibinlen < 1 or ibinlen > 9999 then          'invalid binary record length
      i = ifn.msgs("Invalid binary record length", 5, 24, 79, 1, 1)
   end if                               'display error message [above] and exit
   ccmd = rtrim$(left$(ccmd, ipos1 - 1))               'remove '/Bnn' parameter
   ibinary = not 0                                     'set binary sort flag ON
end if

do                                 'begin loop to process command-line switches
   select case right$(ccmd, 2)                'select on a possible User switch
      case "/C"                                  'a CASE parameter was supplied
         ccmd = rtrim$(left$(ccmd, len(ccmd) - 2))   'remove the '/C' parameter
         icassen = not 0                            'set case-sensitive flag ON
      case "/J"                          'a left-justify parameter was supplied
         ccmd = rtrim$(left$(ccmd, len(ccmd) - 2))   'remove the '/J' parameter
         ijustfy = not 0                              'set left-justify flag ON
      case "/N"                                     'no-spaces switch specified
         ccmd = rtrim$(left$(ccmd, len(ccmd) - 2))   'remove the '/N' parameter
         inonspc = not 0                             'set the no-spaces flag ON
      case "/R"                         'a reverse-order parameter was supplied
         ccmd = rtrim$(left$(ccmd, len(ccmd) - 2))   'remove the '/R' parameter
         irevord = not 0                             'set reverse-order flag ON
      case else                              'no (more) User switches specified
         if right$(ccmd, 3) = "/NO" then   'no-displays parameter was specified
            ccmd = rtrim$(left$(ccmd, len(ccmd) - 3))'remove the '/NO' parameter
            imsgdisp = 0                   'set the message display flag to OFF
         else                                'no (more) User switches specified
            exit do                         'no (more) User switches; exit loop
         end if
   end select
loop

iprm = parmstr1(ccmd, cfil, cnam, cext, cprm())  'parse command-line parameters
if cnam = "" or len(cnam) > 8 or len(cext) > 3 or instr(cext, ".") then
   i = ifn.msgs("Invalid filename", 5, 24, 79, 1, 1)
end if                                  'display error message [above] and exit
if iprm >= 10 then                              'user input too many parameters
   i = ifn.msgs("Invalid number of parameters", 5, 24, 79, 1, 1)
end if                                  'display error message [above] and exit
if iprm < 0 then             'offset and segment-length parameters were omitted
   cprm(0) = "0"                              'set final-segment default offset
   cprm(1) = "40"                     'set final-segment default segment length
   iprm = 1                        'set parameter count to include final seglen
elseif iprm mod 2 = 0 then              'a segment-length parameter was omitted
   iprm = iprm + 1               'increment param count to include final seglen
   cprm(iprm) = "40"                  'set final-segment default segment length
end if
if cext = "out" then                      'target filename has '.OUT' extension
   cout = cnam + ".tmp"                 'add '.TMP' extension to temporary file
else                                      'target filename has '.???' extension
   cout = cnam + ".out"                 'add '.OUT' extension to temporary file
end if

i = ifn.open(isrcfil, cfil, "B", llof)     'open the source file in binary mode
if llof < 0 then                                'user input a wildcard filespec
   i = ifn.msgs("Invalid filename", 5, 24, 79, 1, 1) 'disp.error message & exit
elseif llof = 0 then                          'source file nonexistent or empty
   i = ifn.kill(isrcfil, cfil)                       'kill the zero-length file
   i = ifn.msgs(cfil + " not found", 5, 24, 79, 1, 1)
end if                                  'display error message [above] and exit

nc.slen = 3                            'initialize the total sort-buffer length
for i = 0 to iprm                       'loop thru the optional User parameters
   indx = i \ 2                    'array index for offsets and segment lengths
   if i mod 2 then                     'a segment-length parameter was supplied
      iseglen(indx) = pdqvali(cprm(i))   'get value of segment-length parameter
      if iseglen(indx) < 1 or iseglen(indx) > imaxlen then'bad seglen parameter
         i = ifn.msgs("Invalid segment-length parameter", 5, 24, 79, 1, 1)
      end if                            'display error message [above] and exit
      nc.slen = nc.slen + iseglen(indx) 'add seglen to total sort-buffer length
   else                                       'an offset parameter was supplied
      ioffset(indx) = pdqvali(cprm(i))           'get value of offset parameter
      if ioffset(indx) < 0 or ioffset(indx) > 9999 then   'bad offset parameter
         i = ifn.msgs("Invalid offset parameter", 5, 24, 79, 1, 1)
      end if                            'display error message [above] and exit
   end if
next
if nc.slen < 5 or nc.slen > imaxlen + 3 then         'invalid total sort length
   i = ifn.msgs("Total sort length invalid", 5, 24, 79, 1, 1)
end if                                  'display error message [above] and exit

if imsgdisp then                              'user said OK to display messages
   i = ifn.msgs("Please standby", 5, 24, 79, 0, 0)           'OK to proceed....
end if

if ibinary then                                 'binary-file sorting mode is ON
   ieof = 0                                  'initialize the end-of-file status
   clin = space$(ibinlen)                 'allocate buffer for binary-file read
else                                           'binary-file sorting mode is OFF
   close isrcfil                          'close the binary-access file channel
   open cfil for input as isrcfil               'open the source file for input
   ieof = eof(isrcfil)                       'initialize the end-of-file status
   clin = space$(1536)                      'allocate buffer for text-file read
end if

cnc.sdat = space$(nc.slen)                             'sort data record buffer
cbuf = space$(ibinlen)                         'allocate buffer for binary file
cndx = space$(300)                        'temporary source-file pointer buffer
cptr = space$(4)                                'long-integer conversion buffer
lptr = 1                                    'read-begin position in source file
insbeg(0) = 1                               'segment begin pointer for cnc.sdat
inslen(0) = nc.slen                                   'sort data segment length
insseq(0) = irevord - not irevord       'segment sort sequence (ascend/descend)
nc.oper = 0                            'add records to sort (initial operation)
if imsgdisp then                              'user said OK to display messages
   locate 5, 5, 0                        'position cursor for following message
   print "Sorting        lines";                       'number-of-lines-counter
end if

do while not ieof                                     'loop to add data to sort
   if ibinary then                              'binary-file sorting mode is ON
      if lptr + ibinlen - 1 > llof then         'file pointer is already at EOF
         ieof = not 0                            'set the end-of-file status ON
         ilen = 0                             'no more data; set length to zero
      else                                     'file pointer NOT already at EOF
         get isrcfil, lptr, cbuf               'get 1st record from binary file
         ilen = ibinlen                        'set the length of the text line
      end if
   else                                        'binary-file sorting mode is OFF
      do while not ieof                      'loop to get a non-empty text line
         line input #isrcfil, cbuf              'load the source-file text line
         ieof = eof(isrcfil)                        'get the end-of-file status
         ilen = len(cbuf)                      'get the length of the text line
         if ilen then                          'text line has a non-zero length
            exit do                            'exit loop and process text line
         else                                 'text line is empty (zero length)
            lptr = lptr + 2                  'increment file pointer by c/r-l/f
         end if
      loop                               'loop until non-empty text line or EOF
   end if
   if ilen = 0 and ieof then          'current text line empty and status = EOF
      exit do                          'no more data available; exit processing
   end if
   if ijustfy then                   'OK to left-justify line; flag set by User
      for ipos = 1 to ilen             'loop thru leading whitespace characters
         ichr = midchar(cbuf, ipos)     'ASCII character value at this position
         if ichr <> 9 and ichr <> 32 then     'current character not whitespace
            exit for             'exit loop with begin-byte at current position
         end if
      next
   else                         'do NOT left-justify line; flag not set by User
      ipos = 1                    'set begin-byte position to beginning of line
   end if
   if icassen then                     'case-sensitive flag ON; don't uppercase
      lset cbuf = mid$(cbuf, ipos)    'set source text to justify column (or 1)
   else                               'case-sensitive flag OFF; OK to uppercase
      lset cbuf = ucase$(mid$(cbuf, ipos))'uppercase and justify text as needed
   end if
   lset cnc.sdat = ""                   'initialize (pre-clear) the sort buffer
   ipos = 1                         'initialize segment position in sort buffer
   for iseg = 0 to iprm \ 2         'loop thru the segment offset/length arrays
      if inonspc then                      'User specified the no-spaces option
         i = ioffset(iseg) + 1             'set loop position to parse position
         iptr = ipos                         'initialize parse-position pointer
         do while i <= ilen and iptr - ipos < iseglen(iseg) 'begin parsing loop
            ichr = midchar(cbuf, i)          'buffer character at loop position
            if ichr > 32 and ichr <> iexchr1 and ichr <> iexchr2 then 'char. OK
               mid$(cnc.sdat, iptr) = char(ichr)'last character found in buffer
               iptr = iptr + 1                'increment parse-position pointer
            end if               'text mismatch at search-text position [below]
            i = i + 1                          'increment current loop position
         loop                          'loop while ilen < itxtlen (no mismatch)
      else                            'User didn't specify either spaces option
         mid$(cnc.sdat, ipos) = mid$(cbuf, ioffset(iseg) + 1, iseglen(iseg))
      end if                'add the current segment to the sort buffer [above]
      ipos = ipos + iseglen(iseg)    'increment segment position in sort buffer
   next
   lset cptr = mkl$(lptr)           'put file position into long-integer buffer
   mid$(cnc.sdat, nc.slen - 2) = char(midchar(cptr, 3))     'put position bytes
   mid$(cnc.sdat, nc.slen - 1) = char(midchar(cptr, 2))     '...into far end of
   mid$(cnc.sdat, nc.slen - 0) = char(midchar(cptr, 1))     '..sort data buffer
   lptr = lptr + ilen                        'increment file pointer by linelen
   if not ibinary then                       'file access is ASCII (NOT binary)
      lptr = lptr + 2                        'increment file pointer by c/r-l/f
   end if
   i = psort(nc, cnc.data, cnc.indx, cnc.lng, cnc.nbuf, cnc.sdat, insbeg(), _
             inslen(), insseq(), lnsptr())            'add a record to the sort
   if (nc.rptr - 1) mod 100 = 0 then      'another 100 records have been sorted
      if imsgdisp then                        'user said OK to display messages
         locate 5, 13, 0                 'position cursor for following message
         print ltrim$(str$(nc.rptr - 1));    'display the current counter value
      end if
      if io.ktst(0) = 27 then                   'check for User-pressed Esc key
         i = ifn.msgs("Abort selected - Program terminated", 5, 24, 79, 0, 1)
      end if                            'display abort message [above] and exit
   end if
loop

close isrcfil                              'close the source file in input mode
open cfil for binary as isrcfil          'reopen the source file in binary mode
if ibinary then                                 'binary-file sorting mode is ON
   open cout for binary as idstfil            'open the destination (.OUT) file
else                                           'binary-file sorting mode is OFF
   open cout for output as idstfil            'open the destination (.OUT) file
end if

ctot = ltrim$(str$(nc.rptr - 1))            'total records sorted (string form)
lcnt = 0                                'total records retrieved (numeric form)
lptr = 1                                   'write-begin position in output file
iptr = 0                               'position index for temp. pointer buffer
nc.oper = -2          'set flag to retrieve records from sort (final operation)
if imsgdisp then                              'user said OK to display messages
   locate 5, 5, 0                        'position cursor for following message
   print "Retrieving "; space$(len(ctot)); " of "; ctot; " lines";'line counter
end if
i = psort(nc, cnc.data, cnc.indx, cnc.lng, cnc.nbuf, cnc.sdat, insbeg(), _
          inslen(), insseq(), lnsptr())        'retrieve first record from sort
ilen = len(cnc.sdat)             'save length of sort buffer for loop-exit test
do while ilen               'loop until all records read (cnc.sdat returned "")
   mid$(cndx, iptr + 1) = char(midchar(cnc.sdat, nc.slen - 0))   'get pos.bytes
   mid$(cndx, iptr + 2) = char(midchar(cnc.sdat, nc.slen - 1))   '..from end of
   mid$(cndx, iptr + 3) = char(midchar(cnc.sdat, nc.slen - 2))   '..sort buffer
   iptr = iptr + 3                    'increment the temp.-index buffer pointer
   i = psort(nc, cnc.data, cnc.indx, cnc.lng, cnc.nbuf, cnc.sdat, insbeg(), _
             inslen(), insseq(), lnsptr())      'retrieve next record from sort
   ilen = len(cnc.sdat)          'save length of sort buffer for loop-exit test
   if iptr = 300 or ilen = 0 then         'another 100 records have been sorted
      for indx = 1 to iptr step 3             'loop thru the temp. index buffer
         mid$(cptr, 1) = mid$(cndx, indx, 3)   'put source-file pointer to long
         get isrcfil, cvl(cptr), clin             'get the original source line
         if ibinary then                        'binary-file sorting mode is ON
            put idstfil, lptr, clin             'put binary line to output file
            lptr = lptr + ibinlen            'increment file pointer by linelen
         else                                  'binary-file sorting mode is OFF
            irtn = instr(clin, char(13))     'find c/r at the end of the "line"
            if irtn = 0 then               'line is longer than buffer (no c/r)
               irtn = imaxlen + 1          'set "c/r" position to end-of-buffer
            end if
            print #idstfil, left$(clin, irtn - 1)    'print line to output file
         end if
      next
      lcnt = lcnt + iptr \ 3                 'increment total records retrieved
      if imsgdisp then                        'user said OK to display messages
         locate 5, 16, 0                 'position cursor for following message
         print ltrim$(str$(lcnt));           'display the current counter value
      end if
      if io.ktst(0) = 27 then                   'check for User-pressed Esc key
         i = ifn.kill(idstfil, cout)           'kill the incomplete output file
         i = ifn.msgs("Abort selected - Program terminated", 5, 24, 79, 0, 1)
      end if                            'display abort message [above] and exit
      iptr = 0                            'reset the temp.-index buffer pointer
   end if
loop
if ibinary then                                 'binary-file sorting mode is ON
   llof = lof(isrcfil)                'get the full length of the original file
   if lptr <= llof then               'dest. file is shorter than original file
      clin = space$(llof - lptr + 1)  'set for remaining bytes in original file
      get isrcfil, lptr, clin         'get remaining bytes in the original file
      put idstfil, lptr, clin           'put remaining bytes to the output file
   end if
end if
close                                                          'close all files

if imsgdisp then                              'user said OK to display messages
   if ibinary then                              'binary-file sorting mode is ON
      if ibinlen <= 260 then                    'view file at its actual length
         ivuelen = ibinlen                    'set view length to actual length
      elseif ibinlen <= 521 then                 'view at 1/2 its actual length
         ivuelen = ibinlen \ 2               'set view length=1/2 actual length
      elseif ibinlen <= 782 then                 'view at 1/3 its actual length
         ivuelen = ibinlen \ 3               'set view length=1/3 actual length
      elseif ibinlen <= 1043 then                'view at 1/4 its actual length
         ivuelen = ibinlen \ 4               'set view length=1/4 actual length
      else                                    'view file at default length (80)
         ivuelen = 80                      'set view length to VIEW.EXE default
      end if
      shell "view " + cout + " " + str$(ivuelen)   'view the sorted output file
   else                                        'binary-file sorting mode is OFF
      shell "brow " + cout                       'browse the sorted output file
   end if
end if

close                                 'close all files in case not closed above
system                                              'return to operating system

function io.ktst(inop)                               'return last key (no wait)
   key$ = inkey$                                       'get key from key buffer
   if len(key$) then                                 'key buffer contains a key
      if asc(key$) then                                'key value in first byte
         inop = asc(key$)                                  'key value to return
      else                                         'zero value ("extended" key)
         inop = asc(mid$(key$, 2)) + 128            'add 128 to 2nd byte of key
      end if
   else                                      'key buffer does NOT contain a key
      inop = 0                                    'set return key value to zero
   end if
   io.ktst = inop                          'return key value to calling program
end function                                         'return to calling program
