@ECHO OFF
::    ASCI2DBG.BAT converts ASCII text file to DEBUG script
::  By: (c) John Paul Jones, v1.00, Nicholas Owen Society
::    At: 16:48:10.20 Mon 10/28/2002
:: Use: ASCI2DBG InFile.TXT OutFile.DBG
:: Requires: QBASIC.EXE in system path
IF [%1]==[] GOTO Asci2Hlp
IF [%2]==[] GOTO Asci2Hlp
IF NOT EXIST %1 ECHO File %1 not found.
IF NOT EXIST %1 GOTO xAsci2
FOR %%v IN (. %path%) DO IF EXIST %%v\QBASIC.EXE GOTO Asci2Go
ECHO QBASIC.EXE not found in system path or current directory
GOTO xAsci2
:Asci2Go
ECHO ASCI2DBG.BAT v0.20(DOS) Copyright (c) John Paul Jones, 2002
TYPE %1 > ASCI2ISO.TMP
> Q.BAS ECHO DIM LineOfText AS STRING, AscVal  AS INTEGER, HexVal AS STRING 
>>Q.BAS ECHO DIM zCharacter AS STRING, Cnt AS INTEGER, LineNumber AS LONG 
>>Q.BAS ECHO DIM CharNumber AS LONG, ByteNumber AS LONG
>>Q.BAS ECHO DIM PrintNumbr AS LONG, HexNumber AS INTEGER
>>Q.BAS ECHO HexNumber = 4096
>>Q.BAS ECHO PRINT "ASCI2ISO.BAS v1.00(DOS) Copyright (c) John Paul Jones, 2002"
>>Q.BAS ECHO   OPEN "%1" FOR INPUT AS #1
>>Q.BAS ECHO   OPEN "%2" FOR OUTPUT AS #2
>>Q.BAS ECHO   PringNumbr = 1
>>Q.BAS ECHO   LineNumber = 0
>>Q.BAS ECHO   Bld$ = ""
>>Q.BAS ECHO   Cnt = 0
>>Q.BAS ECHO   DO UNTIL EOF(1)
>>Q.BAS ECHO     LineNumber = LineNumber + 1
>>Q.BAS ECHO     LINE INPUT #1, LineOfText
>>Q.BAS ECHO       zCharacter = ""
>>Q.BAS ECHO       FOR i = 1 TO LEN(LineOfText)
>>Q.BAS ECHO         Cnt = Cnt + 1
>>Q.BAS ECHO           CharNumber = CharNumber + 1
>>Q.BAS ECHO             zCharacter = MID$(LineOfText, i, 1)
>>Q.BAS ECHO             PRINT STR$(LineNumber) "] CHR: " + zCharacter + " ";
>>Q.BAS ECHO             AscVal = ASC(zCharacter)
>>Q.BAS ECHO             PRINT "ASC: " + STR$(AscVal) + " ";
>>Q.BAS ECHO             HexVal = HEX$(AscVal) + " "
>>Q.BAS ECHO             PRINT "HEX: " + HexVal
>>Q.BAS ECHO             Bld$ = Bld$ + HexVal
>>Q.BAS ECHO             IF Cnt = 16 THEN PRINT #2, "E " + HEX$(256 + (PrintNumbr * 16)) + " " + Bld$
>>Q.BAS ECHO             IF Cnt = 16 THEN PrintNumbr = PrintNumbr + 1
>>Q.BAS ECHO             IF Cnt = 16 THEN Bld$ = ""
>>Q.BAS ECHO             IF Cnt = 16 THEN Cnt = 0
>>Q.BAS ECHO             IF Cnt = 16 THEN PRINT Bld$
>>Q.BAS ECHO       NEXT i
>>Q.BAS ECHO       FOR z = 1 TO 2
>>Q.BAS ECHO             IF z = 1 THEN Bld$ = Bld$ + "0D "
>>Q.BAS ECHO             IF z = 2 THEN Bld$ = Bld$ + "0A "
>>Q.BAS ECHO             Cnt = Cnt + 1
>>Q.BAS ECHO             IF Cnt = 16 THEN PRINT #2, "E " + HEX$(256 + (PrintNumbr * 16)) + " " + Bld$
>>Q.BAS ECHO             IF Cnt = 16 THEN PrintNumbr = PrintNumbr + 1
>>Q.BAS ECHO             IF Cnt = 16 THEN Bld$ = ""
>>Q.BAS ECHO             IF Cnt = 16 THEN Cnt = 0
>>Q.BAS ECHO             IF Cnt = 16 THEN PRINT Bld$
>>Q.BAS ECHO             CharNumber = CharNumber + 1
>>Q.BAS ECHO       NEXT z
>>Q.BAS ECHO   LOOP
>>Q.BAS ECHO   IF NOT Bld$ = "" THEN PRINT #2, "E " + HEX$(256 + (PrintNumbr * 16)) + " " + Bld$
>>Q.BAS ECHO   Bld$ = ""
>>Q.BAS ECHO   ByteNumber = CharNumber
>>Q.BAS ECHO   PRINT #2, "N" + "%1"
>>Q.BAS ECHO   PRINT #2, "RCX"
>>Q.BAS ECHO   HexSize$ = LTRIM$(HEX$(ByteNumber))
>>Q.BAS ECHO   PRINT #2, HexSize$ ' Tells DEBUG memory to allot
>>Q.BAS ECHO   PRINT #2, "W" ' Tells DEBUG to write source file to disk
>>Q.BAS ECHO   PRINT #2, "Q" ' Quit
>>Q.BAS ECHO   PRINT #2, ' Blank line tells DEBUG to execute Quit command
>>Q.BAS ECHO   PRINT "ByteNumber: " + STR$(ByteNumber)
>>Q.BAS ECHO   PRINT "LineNumber: " + STR$(LineNumber)
>>Q.BAS ECHO   PRINT "PrintNumbr: " + STR$(PrintNumbr)
>>Q.BAS ECHO   PRINT "Number of characters in file is "  + STR$(CharNumber)
>>Q.BAS ECHO SYSTEM
QBASIC /RUN Q.BAS
IF EXIST Q.BAS DEL Q.BAS
GOTO xAsci2
:Asci2Hlp
ECHO ::    ASCI2DBG.BAT converts ASCII text file to DEBUG script
ECHO ::  By: (c) John Paul Jones, v1.00, Nicholas Owen Society
ECHO ::    At: 16:48:10.20 Mon 10/28/2002
ECHO :: Use: ASCI2DBG InFile.ASC OutFile.DBG
ECHO :: Requires: QBASIC.EXE in system path
ECHO   :: : : : : : : : : : : : : : : : : : : : : : : : : : : : : ::
ECHO   :: Use to pack .HTM, .BAS, .TXT, or other ASCII files into ::
ECHO   :: batch files in DEBUG format. Makes a DEBUG script which ::
ECHO   :: re-creates the original InFile if the OutFile is passed ::
ECHO   :: through DEBUG.EXE.  The original file,  if it exists in ::
ECHO   :: in the current folder by the same name, is over-written ::
ECHO   :: or replaced.  Program ASSUMES that InFile is ASCII. See ::
ECHO   :: the internal documentation at the end of the source for ::
ECHO   :: more details on usage and uses.                         ::
ECHO   :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:xAsci2
: ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
: ***************** ASCI2ISO Design Mission ****************** :
: ************************************************************ :
: This batch script has been tested on the 200LX Palmtop, plus :
: Windows XP VDM (Virtual DOS Machine). It can be used to pack :
: any ASCII file, including ASCII source code, e.g., BAT, BAS, :
: or HTM files, into a DEBUG script,  such that, if the output :
: file is run through DEBUG.EXE,  the original ASCII file will :
: be generated. So, say you pack a HTML file called README.HTM :
: into a DEBUG script, with the following command:             :
:              ASCI2DBG README.HTM README.DBG                  :
: which would create the DEBUG script README.DBG, such that if :
: the DEBUG script is executed with the following command:     :
:                DEBUG < README.DBG                            :
: the original file, README.HTM, is generated and saved in the :
: current folder.  It might be asked why, if the input file is :
: simply re-created, should one bother to convert the ASCII to :
: a DEBUG script that simply re-creates what already  existed. :
: Possible uses of the program are manifold,  but for the sake :
: of brevity, twofold:                                         :
: ************************************************************ :
: ********* Generation of HTML pages from DOS or VDM ********* :
: ************************************************************ :
: One use is to create HTM from within a batch file using DOS, :
: which would not be otherwise possible, unless QBasic is used :
: and packed in the batch script. Trouble is, QBasic is not as :
: commonly distributed as DEBUG: several versions of Microsoft :
: OS that include DEBUG do not include QBASIC, whereas,  as of :
: this writing,  every version of Microsoft OS,  up to Windows :
: and back to DOS 5.0 is bundled with DEBUG. Thus creating HTM :
: pages with DEBUG is the better choice, and in fact, the only :
: choice in any version of Windows or DOS that doesn't include :
: QBASIC.EXE and doesn't support the up-pointing carrot as the :
: special symbol to redirect redirectors. That is, if you want :
: to create the HTML source code from within the batch script, :
: not relying on any external help files, you will need to use :
: DEBUG, because the less-than and greater-than symbols cannot :
: be redirected from within a batch  file, unless the FIND.EXE :
: filter is used to extract the redirectors from the BAT file, :
: a technique that works well, provided the FIND.EXE filter is :
: in the system path,  but will require that each line of HTML :
: include an HTML comment with a unique signature string, thus :
: making the technique less than ideal for the stated purpose. :
: ************************************************************ :
: *** Protecting non-compiled source code from prying eyes *** :
: ************************************************************ :
: Another use is to convert non-compiled source code to DEBUG, :
: so that the code becomes less intelligible to prying eyes or :
: amatuer tampering.  This of course won't protect the code in :
: all cases, but it will provide some protection insofar as an :
: amatuer will find the code incomprehensible, whereas a salty :
: pirate will find it more toilsome to plunder any programming :
: pearls packed in the DEBUG code.  Pirates are good at guting :
: oysters, though, so you'll need a tougher oyster shell if or :
: when pirate-proofing is important to you.                    :
: ************************************************************ :
: Once you've converted the ASCII source code to  DEBUG  using :
: this program, use DBGS2BAT.BAT, a utility included on the HP :
: Palmtop Paper InfoBase 2000 CD-ROM, to convert the .DBG file :
: into batch code, then paste the Batch wrapped DEBUG sccripts :
: into the batch file where you want to re-make the ASCII file :
: source code files, whereupon, once the needed code is kicked :
: out, execute and terminate as needed.                        :
: ************************************************************ :
: The program had a bug such that, if the file to be converted :
: was evenly  divisible by  10,  it appended an  uneeded  line :
: in the DEBUG script, which caused an error;  this bug is now :
: squashed.                                                    :
: ************************************************************ :
: Any donations to the Nicholas Owen Society are appreciated:  :
: Nicholas Owen Society, USA                                   :
: 1550 Larimer Street, PMB 527                                 :
: Denver, CO 80202                                             :
: ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
