/*
 * 123paste.c
 * Copyright(C) 1996 Hiroyuki Sekiya
 */

#include <lxapi.h>
#include <bridge.h>
#include <limits.h>
#include <stdlib.h>
#include "morelib.h"

const char copyright[] = "123PASTE Copyright(C) 1996 Hiroyuki Sekiya";

#if 1
unsigned int _version = 0x0500;
void _terminate(int retcode) { exit(1); }
void _checknull(void) {}
void _restorezero(void) {}
void _cleanup() {}
#endif

EVENT Event;

/*
 * vOI
 * retcode0Ȃ琳IA0ȂُI(r[v)
 */
void exit(int retcode)
{
	if (retcode) m_thud();
	DeactivateFloat();		/* NKIT̕_Z𖳌 */
	if (MoreInit() == 0) MoreVoidNextCls();
	m_fini();
}

/*
 * ClipboardőmaxlenoCgǂݍ
 * ߂l͎ۂɓǂ񂾃oCg
 */
int ReadClipboard(const char *buf, int maxlen)
{
	int len = 0;
	int	index;

	m_lock();
	if (m_open_cb() == 0) {
		if (m_rep_index("TEXT", &index, &len) == 0) {
			if (len > maxlen) len = maxlen;
			m_cb_read(index, 0, buf, len);
		}
		m_close_cb();
	}
	m_unlock();
	return len;
}

/*
 * 1-2-3 Bridge ServiceR[
 * ߂lBridge ServicẽUgR[h
 */
int BridgeServ(BRIDGE_BP *Bridge)
{
#if 1
	bridge_serv(Bridge);
	return Bridge->bpb_retcode;
#else
	/* ̂ł͂Ȃ܂s܂ */
	Event.norm.bridge = Bridge;
	Event.norm.do_event = DO_BRIDGE;
	m_action(&Event);
	return Bridge->bpb_retcode;
#endif
}

/*
 * obt@LF菜
 */
void DeleteLF(char *Buffer)
{
	char *p = Buffer;

	do {
		if (*Buffer == '\n') ++Buffer;
	} while (*p++ = *Buffer++);
}

/*
 * src̃J}ŋ؂ꂽ1[hdstɎo
 * ߂lsrc̎̃[h̐擪
 */
char *GetWord(char *dst, char *src)
{
	BOOL is_string;

	while (*src == ' ') ++src;
	if (is_string = (*src == '"'))
		*dst++ = *src++;
	while (1) {
		switch (*dst++ = *src++) {
		case 0:
		case '\r':
			goto DONE;
		case ',':
			if (!is_string) goto DONE;
			break;
		case '"':
			if (is_string) {
				if (*src == '"')
					++src;
				else {
					is_string = FALSE;
					--dst;
				}
			}
			break;
		}
	} 
DONE:
	*(dst-1) = 0;
	return src;
}

/*
 * ͐񂩁H()
 */
BOOL IsInteger(const char *s)
{
	long l = atol(s);

	if (l < INT_MIN || INT_MAX < l) return FALSE;

	if (*s == '+' || *s == '-') ++s;
	while ('0' <= *s && *s <= '9') ++s;
	return *s == 0;
}

/*
 * ͐񂩁H()
 */
BOOL IsNumber(const char *s)
{
	if (*s == '+' || *s == '-') ++s;
	while ('0' <= *s && *s <= '9') ++s;
	if (*s == '.') ++s;
	while ('0' <= *s && *s <= '9') ++s;
	if (*s == 'e' || *s == 'E') return IsInteger(s + 1);
	return *s == 0;
}

void main(void)
{
	static LHAPIBLOCK LHAPIData;
	static BRIDGE_BP Bridge;
	static char ClipBuffer[10*1024+1];
	static char WordBuffer[256];
	static char LineBuffer[10*1024];
	char *src, *dst;
	int Len, WordCount;

	/* 񑩂̏ */
	m_init_app(SYSTEM_MANAGER_VERSION);
	m_reg_app_name("123PASTE");
	InitializeLHAPI(&LHAPIData);
	ActivateFloat();		/* NKIT̕_ZL */

	/* ClipboardǂASCIIZ`ɂ */
	if ((Len = ReadClipboard(ClipBuffer, sizeof(ClipBuffer)-1)) == 0)
		exit(0);		/* Clipboard */
	ClipBuffer[Len] = 0;

	/* LF폜āAsCRɂ */
	DeleteLF(ClipBuffer);

	/* Bridge Servicepł邩ǂmF */
	Bridge.bpb_funcode = BRIDGE_TEST;
	if (BridgeServ(&Bridge) != 1) exit(1);

	/* 1-2-3̃J[\W擾 */
	Bridge.bpb_funcode = BRIDGE_GET_CURSOR;
	if (BridgeServ(&Bridge) != 1) exit(1);

	/* Clipboard̃f[^1-2-3Ƀy[Xg */
	src = ClipBuffer;
	do {
		/* 1s̃f[^LineBufferɗ߂ */
		dst = LineBuffer;
		WordCount = 0;
		if (*src == '\r' || *src == 0) {
			++src;
		} else {
			do {
				src = GetWord(WordBuffer, src);
				if (*WordBuffer == 0) {					/*  */
					*dst++ = 'B';
				} else if (IsInteger(WordBuffer)) {		/*  */
					*dst++ = 'I';
					*(int *)dst = atoi(WordBuffer);
					dst += sizeof(int);
				} else if (IsNumber(WordBuffer)) {		/* _ */
					*dst++ = 'N';
					*(double *)dst = atof(WordBuffer);
					dst += sizeof(double);
				} else {								/*  */
					*dst++ = 'S';
					if (WordBuffer[0] == '"') {
						lstrcpy(dst, WordBuffer+1);
						dst += lstrlen(WordBuffer+1);
					} else {
						lstrcpy(dst, WordBuffer);
						dst += lstrlen(WordBuffer);
					}
					*dst++ = 0;
				}
				++WordCount;
			} while (*(src-1) != '\r' && *(src-1) != 0);
		}

		/* 1s̃f[^1-2-3ɑ */
		if (WordCount > 0) {
			Bridge.bpb_funcode = BRIDGE_SETRANGE_DATA;
			Bridge.bpb_buffer = LineBuffer;
			Bridge.bpb_bufsize = dst - LineBuffer;
			Bridge.bpb_order = 0;
			Bridge.bpb_endcol = Bridge.bpb_startcol + WordCount - 1;
			Bridge.bpb_endrow = Bridge.bpb_startrow;
			if (BridgeServ(&Bridge) < 0) exit(1);
		}
		++Bridge.bpb_startrow;
	} while (*(src-1) != 0);

	exit(0);
}
