/* This file is a part of SecureDevice 1.4
   Copyright (C) 1994 by Max Loewenthal and Arthur Helwig
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <bios.h>
#include <dos.h>
#include <string.h>
#include <ctype.h>
#include "globals.h"

#define MinorName "LOGOUT"
#define MinorVer "1.01"

void main(int argc,char *argv[])
{ unsigned char SubUnit;
  int i,nofdrivers;
  char DriveOK=0;
  unsigned char Driveletter;
  union REGS regs;
  struct SREGS segregs;

  printf("%s %s's %s %s\n",MajorName,MajorVer,MinorName,MinorVer);
  printf("Written by %s\n",AuthorName);

  if(argc<2)
    { printf("Usage: LOGOUT <driveletter>|ALL\n");
      exit(0);
    }

  regs.x.ax = 0xE209;
  regs.x.dx = 0;
  int86x(0x2F, &regs, &regs, &segregs);
  if(regs.x.ax != 0x1DEA)
    { printf("SECDEV.SYS not loaded\n");
      exit(1);
    }
  nofdrivers=regs.x.dx;

  if(!strcmpi(argv[1],"ALL"))
    { printf("Logging out all drives...\n");
      regs.h.dl = 0xFF;              /* Select all drives */
    } else
    { Driveletter=toupper(*argv[1]);
      for(i=0;i<nofdrivers && !DriveOK;i++)
        { regs.x.ax = 0xE201;            /* Get information */
          regs.x.dx = i;
          int86x(0x2F, &regs, &regs, &segregs);

          DriveOK = ((Driveletter-'A') >= regs.h.dl) &&
                    ((Driveletter-'A') < regs.h.dl+regs.h.al);
        }
      if(!DriveOK)
        { printf("Drive %c: is not an encrypted drive\n",Driveletter);
          exit(1);
        }
      printf("Logging out drive %c:\n",Driveletter);
      regs.h.dl = Driveletter-'A';
    }
  regs.x.ax = 0xE203;               /* Log out */
  int86x(0x2F, &regs, &regs, &segregs);
  printf("Done\n");
}

