hcD      D    C _
7	, BOOKS OF THE TIMES | 'THE ASSASSINATION OF LUMUMBA'
African Castro or a Dazzling Ray of Hope?
By RICHARD BERNSTEIN NYT Aug 3 2001

THE ASSASSINATION OF LUMUMBA by Ludo De Witte 
Translated by Ann Wright and Rene Fenby.

Patrice Lumumba was one of those charismatic figures martyrs, in the view of their supporters who stood on the public stage during that moment of ferment when colonialism was dying and a new force on the global scene, third world nationalism, seemed poised to replace it. Lumumba, who was assassinated in Jan 1961 during the terrible Congo civil war, was like Che Guevara in this sense, or perhaps Sukarno (overthrown but not assassinated in Indonesia), or maybe even the American Black Muslim Malcolm X. He was a fiery, commanding figure with a revolutionary aura about him, cut down before he was able to exercise power long enough for anybody to be sure how he would have reshaped the world.

In one view, the view that has predominated in the seats of Western power, Lumumba was a dangerous figure who would have taken the newly independent Congo either into social chaos or into the Soviet camp. The director of central intelligence at the time, Allen Dulles, called him an African Castro. By contrast, Ludo De Witte, a Belgian sociologist and writer, takes a very different view in "The Assassination of Lumumba."

For Mr. De Witte, Lumumba was a dazzling ray of hope for a successful postcolonial future in Africa, a man who might have led Congo, reluctantly granted independence by Belgium after a century of rapacious control, into a hopeful future. Mr. De Witte's thesis is that Lumumba's murder was not, as many have previously written, an internal Congolese affair, a kind of panicked overreaction among African factions fighting it out after the departure of the Belgians. Lumumba was murdered, in Mr. De Witte's account, by a kind of unholy alliance led by the Belgian government acting through well-paid Congolese stooges and enjoying the connivance of the American Central Intelligence Agency and the United Nations.

Mr. De Witte's book, translated from the Flemish by Ann Wright and Rene Fenby, is an important and flawed examination of the persecution and murder of Lumumba. Mr. De Witte makes no pretense of being an impartial investigator. His book is full of a kind of impassioned boilerplate more common to the leftist intelligentsia in Europe than in the United States, phrases like "the Western ruling classes" and "the fight for national liberation" abound. At one point, after he has taken the reader through a gripping, minute- by-minute account of Lumumba's execution, Mr. De Witte laments: 

"Patrice Lumumba was not yet 36 years old, the same age as Robespierre, that other great defender of the modern nation state, when he died." To put Lumumba into the same category as the man who invented revolutionary terror seems at best tactically unwise; it does not inspire confidence in Mr. De Witte's political judgment.

Still, whatever eccentric political ideas he may have, Mr. De Witte has written a compelling account of the tireless efforts by the West to eliminate Lumumba. When this book was published in Europe in 1999, it prompted the formation of a Belgian parliamentary inquiry into Lumumba's death. (Its findings are to be announced this year.) Mr. De Witte makes his case, and he has documentary evidence to make it stick.

Lumumba was the first prime minister elected in Congo before a reluctant Belgium granted it independence in July 1960, but matters began to deteriorate almost immediately. Lumumba made an inflammatory speech at the independence ceremony, attacking Belgium for its years of colonialist exploitation and humiliation while King Baudouin stood nearby. Lumumba's attack was historically accurate but politically foolish. It aroused fears among Europeans that antiwhite vengeance would be a main theme of his regime.

Within a couple of days, when the Congolese army revolted, beating European men and raping some women, Belgium intervened militarily, and though Belgian troops were soon displaced by a United Nations multinational force, Lumumba was soon dismissed by President Joseph Kasavubu. When he tried to escape house arrest in Leopoldville and join supporters in Stanleyville, he was arrested by troops controlled by the future dictator, Joseph Mubutu. A few months later, in the presence of several Belgian police and army officers, he was beaten, tortured and executed by a firing squad.

It is a seedy story, and the essential fact of it is indisputable: that the legally elected prime minister of a newly independent country was murdered, to the evident satisfaction both of Belgium and the United States. Much of what Mr. De Witte says in his detailed reconstruction of the crime has been known for years, including the almost comic-opera plot concocted by the C.I.A. to have Lumumba assassinated by injecting poison into his toothpaste.

Mr. De Witte mines the Belgian archives for a good deal of new information, especially on the role of ranking figures in the Belgian government in fomenting opposition to Lumumba among alternative Congolese leaders. Once Lumumba was arrested, Mr. De Witte's reconstruction of events says, Belgium pressed for what a senior Belgian official called his "definitive elimination." Mr. De Witte and his translators maintain the original French phrase: "limination dfinitive."

But De Witte also slides quickly over the breakdown in order after the independence-day celebrations. In this book you won't read about the rape of European women, for example, or of Lumumba's inability to control the situation, or of his tendency to make inflammatory declarations. While Mr. De Witte meticulously describes Belgian economic interests in its former colony, he does not talk much about the Congo's powerful tribal and personal rivalries, which other commentators have stressed. You would almost think, reading Mr. De Witte's account, that the murder of Lumumba was unusual in Africa at the time. In truth, throughout the continent, corrupt and brutal army officers of the Mobutu stripe were taking power from the Western-trained intellectuals that the departing colonial powers had left behind to run things.

But it is also true that Congo was different in some ways, different because of the unusual cruelty of Belgian colonialism (grippingly recounted in Adam Hochschild's recent book "King Leopold's Ghost") and because of the exceptional brutality and corruption of the Mobutu regime after Lumumba's fall. Mr. De Witte's book, politically passionate as it is, is an unignorable effort to bring the West face to face with its culpability in this entire sad and sanguinary tale.
 
---------------------------------------------
The Rise and Violent Fall of Patrice Lumumba
By BILL BERKELEY NYT Aug 2 2001
  
There is a scene in the director Raul Peck's chilling bio film "Lumumba" in which the title character, the doomed Congolese Prime Minister Patrice Lumumba, played by Eriq Ebouaney, confers alone with his army chief of staff, the soon-to-be military strongman Joseph-Dsir Mobutu. It is Sep 1960. Their fledgling independent nation is disintegrating into chaos. "I am at your side," coos the suavely malign Mobutu, played by Alex Descas. Lumumba replies: "You are no longer beside me. You're behind my back." Mobutu returns soon thereafter to place Lumumba under house arrest. 

In The NYT Index for 1960, the Congo occupies more than 12 pages of entries, more than any other country except the US, and just slightly more than Fidel Castro's Cuba. Four decades later, with Congo again consumed by a more obscure but no less ruinous war, Mr. Peck's film provides a disturbing reminder of a turning point in history that helps explain how that African nation wound up on the road to its present ruin.

Mr. Peck, a Haiti-born director who examined that country's Duvalier dictatorship in his 1993 film "The Man on the Shore," has said his aim was to produce a political thriller that illuminates how power works behind the scenes in such places. 

"Lumumba" recounts the swift rise and fall of the man who became Congo's first and last legitimately elected prime minister after it won independence from Belgium in 1960. 

The film begins with images from the Belgian colonial era  pith-helmeted white officers lording it over barefoot natives in scenes that recall one of Africa's most violent and predatory colonial orders. The narrative picks up the energetic and articulate Lumumba as a young salesman for a Belgian beer company who emerged in 1959 as a popular nationalist leader. Jailed and brutally beaten, he was then freed to participate in negotiations in Brussels that would lead to the Congo's independence. Lumumba's party won the largest number of votes in the country's first free elections, and he became prime minister at the age of 35.

Within days, the vast new nation began to unravel. The army mutinied. Belgium's military intervened to protect its citizens and encourage the mineral-rich province of Katanga, led by the conniving opportunist Mose Tshombe, to secede. United Nations troops intervened to little effect. Nikita Khrushchev decided to send Soviet planes, weapons and advisers to help Lumumba, seeming to confirm the worst fears of the Eisenhower administration.

Lumumba and his neophyte nation, which at independence had barely a dozen university graduates, were caught up in a web of cold-war intrigue and neocolonial knavery. Just six months after he took office, Lumumba was murdered by Congolese rivals with the collusion of the United States and Belgium. 

Americans tend to think of Africa's current wars as remote and irrelevant to our interests. "Lumumba" recalls that in fact Americans have been centrally involved in events that set the stage for these wars. The movie is grounded in well-documented historical fact. The Senate Intelligence Committee concluded in 1975 that there were grounds for "a reasonable inference" that President Eisenhower had authorized Lumumba's assassination, and that the director of the Central Intelligence Agency, Allen Dulles, had approved a plot that involved sending a doctor equipped with vials of poison to Lopoldville, the Congo's capital. The committee found no evidence of direct American involvement in Lumumba's eventual murder, though. Instead, it said Washington had supplied money and arms that enabled Mobutu to consolidate power. Mobutu in turn delivered Lumumba into the hands of his Congolese rivals and their Belgian allies. 

In martyrdom, Lumumba achieved iconic status across Africa and much of the third world. It is not necessary to accept Mr. Peck's largely uncritical rendering of his personal character, nor to assume that Lumumba would have proved an enlightened leader. What we do know is that his murder paved the way for three decades of Mobutu's kleptocratic despotism, in what he called Zaire, and the chaos that has engulfed Congo since he fled in 1997.

Some 2.5 million Congolese may have died in three years of fighting, famine and disease in wars that have drawn in six neighboring countries and profited business as far afield as Belgium, Pakistan and Russia. 

"We thought we controlled our destiny," the embattled Lumumba laments at one point in this powerful film, "but other powerful interests pulled the strings." Forty years on, Congolese can be forgiven if they feel the same way. 

    	 are among the great wonders of the world. These limestone caves are about 18 miles (30 kilometers) north of Oudtshoorn, in the foothills of the Swartberg mountains. 
Scientists estimate that some of the features of the Cango Caves are more than 150,000 years old. The caves were used by local people in prehistoric times. White settlers came across them in 1780, when a herdsman was tracking a wounded deer. In 1938, the caves were declared a national monument. 
	:- A large country in eastern Africa that borders the Indian Ocean. Most of Tanzania lies on the mainland of Africa. Several nearby islands make up the rest of the country. Dar es Salaam is Tanzania's capital and largest city. However, the government has announced plans to move the capital to Dodoma, in central Tanzania. The country's official name is the United Republic of Tanzania. 

Tanzania's population consists mainly of black Africans. The rest are people of Asian or European descent. Tanzania is one of the world's poorest countries. Most of its people live in rural areas and farm for a living. The government has tried to develop industries, but the economy still depends heavily on agricultural production and imported goods. 


Tanzania's fascinating wildlife and spectacular scenery are world famous. Elephants, giraffes, lions, zebras, and many other wild animals roam across the vast Serengeti National Park, Selous Game Reserve, and other areas where hunting is banned or limited. Africa's highest mountain, the majestic, snow-capped Kilimanjaro, rises 19,331 feet (5,892 meters) in northern Tanzania. Lake Tanganyika, the world's longest freshwater lake, extends 420 miles (680 kilometers) along the country's western border. Part of Lake Victoria, which is the largest lake in Africa, lies within northern Tanzania. The lake covers an area of 26,828 square miles (69,484 square kilometers). 

In the 1800's, Germany founded a colony on the mainland of what is now Tanzania. The United Kingdom ruled Zanzibar, a group of nearby islands. In the early 1900's, the mainland area became the British colony of Tanganyika. Both Tanganyika and Zanzibar gained independence in the early 1960's. In 1964, they united to form Tanzania. 

Land and climate 

Lake Nyasa, Lake Tanganyika, and many mountains of Tanzania are part of the Great Rift Valley. This long valley, which runs north and south through eastern Africa, consists of a series of cracks in the earth that form deep, steep-sided valleys. The valley has branches that extend through central Tanzania and along the country's western border. Tanzania's land regions include (1) the coastal lowlands and islands, (2) the plateaus, and (3) the highlands. 

The coastal lowlands and islands. The mainland borders the Indian Ocean along a 500-mile (800-kilometer) coast. The coastal strip has many mangrove swamps and coconut palm groves. The northern and southern lowlands extend inland between 10 to 40 miles (16 to 64 kilometers). The central lowlands extend farther into the country. 

Zanzibar, the largest coral island off the African coast, covers 640 square miles (1,658 square kilometers). Another Tanzanian island, Pemba Island, lies 25 miles (40 kilometers) northeast of Zanzibar Island. Pemba covers 380 square miles (984 square kilometers). 

The coastal lowlands and islands make up the hottest and wettest part of Tanzania. High temperatures average 85 ?F (29 ?C) year around. Annual rainfall totals between about 31 and 55 inches (80 to 140 centimeters) on the lowlands and exceeds 40 inches (100 centimeters) on the islands. 

The plateaus rise gradually from the coastal lowlands. They include a vast grassland in northeastern Tanzania, called the Masai Steppe, and a grassy central plateau that covers more than a third of the country. The Masai Steppe rises to about 3,500 feet (1,100 meters) above sea level. It is home to the Masai people, who graze cattle there. West of the steppe, the central plateau reaches about 4,000 feet (1,200 meters) above sea level. The central section is usually drier than the coastal lowlands or highlands. It is mostly covered by grasses or barren land, with patches of trees and shrubs. Parts of this region receive less than 20 inches (50 centimeters) of rain annually. The plateaus have average daytime highs of 84 ?F (29 ?C) and cool nights. 

The highlands. Northern Tanzania has some of the country's highest mountain ranges, which include Kilimanjaro. Several other highlands rise in the central and southern regions. Temperatures in the highlands average about 75 ?F (24 ?C). Highland regions often receive more than 40 inches (100 centimeters) of rain each year. 

Rivers and lakes. The Rufiji is Tanzania's chief river. It flows from the southern highlands and drains much of southern Tanzania. Other major rivers include the Pangani, the Ruvuma, and the Wami. Lake Victoria lies in northern Tanzania and forms part of its border with Kenya and Uganda. Lakes Tanganyika and Nyasa lie along the country's western border. 

Animal life. Tanzania is famous for its millions of large, wild animals that thrive in vast parklands. In northern Tanzania, Serengeti National Park covers about 5,600 square miles (14,500 square kilometers) and is noted for its lions and huge herds of antelopes and zebras. In the south, the Selous Game Reservethe world's largest animal reservecovers about 21,000 square miles (54,000 square kilometers). It has about 50,000 elephantsone of the largest populations in Africa. Other animals common to Tanzania include baboons, buffaloes, hippopotamuses, giraffes, monkeys, and rhinoceroses. The government allows limited hunting in some areas. But poachers (people who hunt illegally) remain a problem. 

People - Population and ancestry. More than half of Tanzania's people live in the northern third of the country. Areas near mountains in the north and lakes in the west have especially dense populations. Most of the country's people live in rural areas. 

About 98 percent of Tanzania's people are black Africans. Most of the rest are people descended from Arabs, Europeans, and Asians from India and Pakistan. 

The black Africans belong to about 120 ethnic groups, including the Sukuma, Chagga, Makonde, and Nyamwezi peoples. No single group is large enough to control the country, and Tanzania has not suffered the ethnic violence that has troubled other African nations. Tanzania's ethnic balance has helped the government develop a sense of national unity. 

Way of life. Most rural Tanzanians farm for a living. Some raise livestock, such as chickens, goats, and sheep. Raising cattle is the chief activity of the Masai and other peoples in the interior of Tanzania. Fishing is an important activity for people who live along the Indian Ocean coast, on the nearby islands, and near inland lakes. 

Many city dwellers work for the national government. Many others work in trade, tourism, and other service industries. 

Under Tanzanian law, women have the same rights as men. In practice, however, women still have lesser rights in such areas as education, marriage, and ownership of property. Women are largely responsible for homemaking and raising children. In rural areas, they often perform more farm work than men. 

Languages. Swahili (also known as Kiswahili) and English are the official languages of Tanzania. Swahili, a blend of Arab and African languages, is more commonly used in everyday speech and serves as the national language. Most blacks also speak at least one tribal language. Almost all the tribal languages are in the Bantu language family. 

Housing. Most homes are made of wooden frames plastered with mud and include a garden area nearby. Some homes are round with thatched roofs. Others are rectangular with flat mud roofs. Some homes have metal roofs. In urban areas, some homes are made of cement blocks or baked clay bricks. 

Clothing in Tanzania is similar to that worn in other parts of eastern Africa. Traditional clothing among the black Africans includes a colorful, wrap-style garment for women called the kanga, and the kikoi wrap for men. Many Muslim men wear a flowing white robe called the kanzu. Since about 1960, Western-style pants and shirts have become increasingly popular among the men of Tanzania. 

Food and drink. Tanzanians prepare a variety of dishes with corn, sorghum, and other grains. One of the most popular meals, called ugali, is a porridge made with corn. Fish is an important part of the diet of Tanzanians who live on the islands and along the coast. Bottled beers and soft drinks are popular. The Chagga people produce a well-known beer called mbege. 

Recreation. The most common forms of recreation in Tanzania include dancing and singing. Many Tanzanians also enjoy playing soccer or watching soccer matches. A number of Tanzanians have become world-class long-distance runners. 

Religion. About 35 percent of the population are Muslims (followers of Islam). Many of Tanzania's Muslims live on Zanzibar and along the country's coast. Christians make up about 30 percent of Tanzania's population. Most other Tanzanians practice traditional African religions. 

History 

In Tanzania, scientists have found remains of some of the earliest-known human settlements. Anthropologist Louis Leakey and other members of the Leakey family discovered bones, tools, and other signs of early human life in the Olduvai Gorge area of northern Tanzania. Some remains date back more than 1 million years. 

The prehistoric human beings who lived in what is now Tanzania were hunters and gatherers. They lived in small groups, catching animals and collecting wild plants for food. By about A.D. 500, people who spoke Bantu languages migrated from the north and from central Africa to eastern Africa. 

The development of trade. Arab traders from the Middle East began to settle along the coast of eastern Africa during the 1100's. These traders often married African women. These Arab-African families and their settlements produced the Swahili culture. Major trading centers developed on Zanzibar and other islands. 

In the early 1500's, Portuguese traders gained control of Africa's east coast. Local rebellions helped push out the Portuguese in the late 1600's. In 1698, Arabs from Oman, a country on the Arabian Peninsula, took control of Zanzibar and developed trade on the mainland. By this time, the Nyamwezi and Yao ethnic groups had become active in long-distance trade. Their caravans brought gold, ivory, and slaves from the interior to the coast, where they exchanged them for such items as cloth, glassware, and ceramics from Asia. 

The Arabs also developed the slave trade. From the mid-1700's to the late 1800's, the Arabs sold thousands of black Africans from the mainland into slavery. Zanzibar was a major slave market. The slave trade caused much conflict and broke up many African communities. 

German and British rule. In the 1800's, explorers and Christian missionaries from Europe traveled deep into the mainland of what is now Tanzania. European nations increasingly competed for control of African territory. During the 1880's, Germany took control of the present-day mainland of Tanzania. The Germans forced many Africans to work on plantations. This action contributed to a major uprising in 1905 called the Maji Maji rebellion. German forces killed many thousands of Africans before putting down the revolt. 

The United Kingdom made Zanzibar and Pemba islands a British protectorate in 1890. The British gradually took over the powers of the Omani sultans in local affairs. After Germany's defeat in World War I (1914-1918), the United Kingdom gained control over the mainland and named it Tanganyika. During this period, people from other parts of the British Empire and Europe began to settle in Tanganyika. These immigrants included thousands of Indians who worked as merchants and traders. 

Independence. In 1946, Tanganyika became a United Nations trust territory. The United Kingdom had the responsibility of preparing it for independence. 

In Tanganyika, the United Kingdom sought to create a political system with equal representation of Europeans, Asians, and Africans. The Africans argued that such a system denied them their rights as the vast majority. In 1954, the Africans formed the Tanganyika African National Union (TANU). Led by Julius Nyerere and others, TANU won independence with majority rule for Tanganyika in 1961. The next year, Nyerere was elected president. The United Kingdom granted Zanzibar independence in 1963. 

The united republic. Tanganyika and Zanzibar joined together in April 1964 and adopted the name of the United Republic of Tanzania in October. Nyerere became the country's first president. Under his direction, Tanzania adopted a socialist economic system. Nyerere based the system on ujamaa, a Swahili word for traditional African cooperation and self-reliance. The government took control of many privately owned businesses. It also encouraged farmers to move from small, widely scattered village sites to larger ujamaa villages. These villages were supposed to increase agricultural production and make it easier for the government to provide health and educational services. 

At first, families moved voluntarily to ujamaa villages. But during the mid-1970's, police and military forces forced about 5 million others to move. Many farmers disliked the ujamaa villages, which were far from the farmers' plots of land in their former villages. 

In foreign affairs, Nyerere worked to increase regional cooperation. In 1967, Tanzania, Kenya, and Uganda formed the East African Community. This organization promoted trade and coordinated economic development between the countries. In 1977, however, the East African Community fell apart. The collapse occurred largely because of Kenya's emphasis on private enterprise and Tanzania's commitment to socialism. In addition, Uganda was ruled by a brutal dictator, Idi Amin Dada. Amin's government, which killed thousands of Ugandans, sent troops that invaded Tanzania in 1978. Tanzanian forces soon beat back the invaders and helped Ugandan rebels overthrow Amin. The war was a moral and military triumph for Tanzania. But it cost over $500 million at a time when the country's economy was suffering from the high price of imported oil. 

Recent developments. During the 1980's, growing trade deficits and debt contributed to an economic collapse. The economic hard times forced Tanzania to alter its socialist system. The government decreased its control of the economy and opened more areas for private businesses. Some improvements occurred, but the economy still faced serious difficulties. 

Nyerere retired as president in 1985 and as CCM chairman in 1990. But he remained a major influence in Tanzania until his death in 1999. Ali Hassan Mwinyi succeeded Nyerere as president and as CCM chairman. Mwinyi continued to work for less state control of the economy. 

Opposition parties were legalized in 1992, and the country's first multiparty elections were held in 1995. Benjamin Mkapa of the CCM was elected president. He was reelected in elections held in 2000. During those elections, voting went smoothly on the mainland, but voting in Zanzibar was marred by a number of serious problems. For example, ballots were delivered late in some districts and not at all in others. 

	. A thickly populated country in east-central Africa. The Africans in Uganda belong to several ethnic groups. English is Uganda's official language, but the people speak many African languages. 

Uganda has magnificent scenery, including snow-capped mountains, thick tropical forests, and semidesert areas. Lakes cover more than a sixth of Uganda. Part of Lake Victoria, the world's second largest freshwater lake, lies in the country. Many wild animals roam the vast national parks. 

For almost 70 years, the United Kingdom governed the territory as the Uganda Protectorate. Uganda won independence in 1962. Kampala is Uganda's capital and largest city. 

Land. Most of Uganda is a plateau about 4,000 feet (1,200 meters) above sea level. Thick forests grow in the south. Most of the north is savanna (grassland with low trees), but some northeastern areas of Uganda are semidesert. 

Highlands rise near the east and west borders. In the east, Mount Elgon towers 14,178 feet (4,321 meters). Margherita Peak rises 16,763 feet (5,109 meters) in the Ruwenzori Range in the southwest. The Great Rift Valley lies just east of the western highlands and contains Lakes Albert, Edward, and George. The headwaters of the White Nile drain Uganda (see Nile River). 

The equator crosses southern Uganda. But because of the high altitude, temperatures are mild. In most areas of the country, the temperature seldom goes above 85 ?F (29 ?C) at midday, or below 60 ?F (16 ?C) at night. Most of Uganda receives more than 40 inches (100 centimeters) of rain a year. 

People. Most Ugandans are black Africans. Nearly all of the more than 20 ethnic groups have their own language. Uganda has no language that is understood by everyone. The Ganda, also called the Baganda, are the largest and wealthiest group. They live in central and southern Uganda. Their political and social organization is one of the most highly developed in central Africa. Until 1967, the Ganda had their own kabaka (king) and Lukiko (parliament). 

Most Ganda are farmers. Women do much of the farm work. The Ganda live in houses with corrugated iron roofs and walls of cement, cinder block, or mud.  Like the Ganda, three other ethnic groups in southern Uganda had their own kings until 1967. Most of the people are farmers. But the Karamojong in the northeast and several other ethnic groups in the drier parts of the north lead wandering lives as herders. Karamojong men mat their hair with colored clay in elaborate patterns. 

Many Ugandans practice traditional African religions. But about two-thirds are Christians. A small minority are Muslims. More than half the people can read and write. For Uganda's literacy rate, see . Makerere University is in Kampala. 

History. By A.D. 100, the people in parts of what is now Uganda had developed agriculture and the use of iron. Later, they organized a form of government headed by chiefs. Several local kingdoms developed after 1300. The most important early kingdom was Bunyoro-Kitara. 

Arab traders came to the area about 1850. By that time, the Ganda had formed a rich and powerful kingdom, called Buganda. This kingdom had a large army and a highly developed system of government. Explorers and missionaries from the United Kingdom arrived in Uganda during the 1860's and 1870's. The United Kingdom made Buganda a British protectorate in 1894. Buganda then helped the United Kingdom conquer nearby territory. 

Uganda attained its present boundaries in 1926. Cash crops, such as coffee and cotton, became the basis for its economy. After World War II ended in 1945, Africans played an increasingly important part in governing Uganda. Many Ganda wanted their kingdom to become independent. The movement for independence caused trouble in the 1950's between the Kabaka of Buganda and the British. 

On Oct. 9, 1962, Uganda became independent. Apollo Milton Obote, a member of a northern ethnic group, became prime minister. Buganda got special powers and was more independent of the central government than the other kingdoms. In October 1963, Sir Edward Mutesa II, the Kabaka of Buganda, was elected president. But serious differences arose between the Kabaka and Obote. In 1966, Obote dismissed Mutesa and announced a new constitution that made Obote president. Mutesa fled when government troops attacked his palace. Another constitution was adopted in 1967. It made Uganda a republic and abolished the country's traditional kingdoms, including Buganda. 

The Uganda Army overthrew Obote in 1971 and set up a military government. Major General Idi Amin Dada, commander of the country's armed forces, headed the new government as president. 

In 1972, Amin ordered an estimated 40,000 to 50,000 Asians who had been living in Uganda to leave the country. Many Asians had not become Ugandan citizens, but they owned numerous businesses in the country. Amin ruled Uganda as a dictator. Many thousands of Ugandans who disagreed with Amin's policies were killed, at his order or by his supporters. 

In 1978, a border dispute led to fighting between Uganda and Tanzania, which lies to the south. In 1979, Tanzanian troops, aided by Ugandans who opposed Amin, defeated Uganda's army and overthrew Amin's government. The Ugandans who opposed Amin took control of the country's government. In December 1980, elections for a new civilian government were held. Obote, who had been living in exile, returned to Uganda. His political party won the most seats in the National Assembly, and he became president again. Opponents of Obote charged his supporters with election fraud and began a guerrilla war to oust Obote. 

In July 1985, military leaders overthrew Obote. They dissolved the National Assembly and took control of the government. General Tito Okello became president. But the National Resistance Movement (NRM), led by Yoweri Museveni, began a military campaign to overthrow Okello. NRM troops captured Kampala in January 1986. Museveni became president. In March, all activities of political parties were suspended. By the end of 1986, Museveni had restored peace to most of Uganda. However, fighting between government forces and rebel groups continued in some areas of the country, especially the north. 

From 1986 until 1994, a National Resistance Council (NRC) served as Uganda's legislature. In March 1994, a Constituent Assembly was established to replace the NRC. The assembly approved a new constitution in 1995. Elections for a president and for a Parliament to replace the Constituent Assembly were held in 1996. Museveni was elected president. 

During the 1990's, a number of cults sprang up in Uganda. In March 2000, about 330 members of a cult called the Restoration of the Ten Commandments died in a church fire in southwestern Uganda. During their investigation, the police determined that the fire had been set intentionally. They also discovered about 450 more bodies of cult members in mass graves. Leaders of the cult reportedly had predicted that the world would end on Jan. 1, 2000. The police suspected that the leaders began murdering members after the prediction did not come true. 
	g* The Rep of Angola, a country on the SW coast of Africa. Cabinda in the NW, is a district of Angola. The Congo River and Congo (Kinshasa) separate it from the rest of the country. Most of Angola's people live in rural areas and work on farms. Angola produces a variety of crops, including bananas, coffee, corn, sugar cane, and a starchy root called cassava. Angola also has many natural resources, including diamonds, iron ore, and petroleum. Luanda, the capital and largest city, is a major African seaport. 

Angola became independent in Nov 1975. Parts of it had been ruled by Portugal for most of the period since the 1500's. Most of Angola's people are black Africans. The blacks belong to several ethnic groups, including the Ovimbundu, the Mbundu, the Kongo, and the Luanda-Chokwe. Before the nation became independent, more than 400,000 Europeans and mestizos (people of mixed black African and white ancestry) lived in Angola. Most Europeans fled during a civil war that began after the country achieved independence. 

The people who live in Angola's rural areas work as farmers and herders, and many raise just enough food for their own use. Most of the Europeans and mestizos who did not leave the country live in cities. They own small businesses or hold other jobs that require technical and management skills. 

Most black Angolans speak a language that belongs to the Bantu language group (see ). Europeans, mestizos, and some blacks speak Portuguese, the official language. About 90% of the people are Christians, mostly Roman Catholics. Others practice religions based on the worship of ancestors and spirits. Most of Angola's adults cannot read or write. For the country's literacy rate, see . 

History. Prehistoric peoples lived in what is now Angola as early as 50,000 B.C. Bantu-speaking peoples settled there about 2,000 years ago. The Portuguese established bases in Angola during the 1500's. By the early 1600's, Angola had become a major source of slave labor for Portugal's colony in Brazil. In 1641, the Dutch forced the Portuguese out of Angola and took over the slave trade. Portugal regained control in 1648. During the 1800's, after the decline of the slave trade, Portuguese planters began to grow corn, sugar cane, and tobacco in Angola. Angola was sometimes called Portuguese West Africa during Portuguese rule. 

Portugal began to improve Angola's economy after the Portuguese dictator Antonio de Oliveira Salazar came to power in the late 1920's. Thousands of Portuguese moved to Angola and started businesses there. 

In the 1950's, many Angolans began to demand freedom from Portuguese rule. In 1956, they organized the Popular Movement for the Liberation of Angola (MPLA). Many MPLA members revolted in Luanda in 1961. The rioting spread throughout the country and developed into a bloody war. A Portuguese army that included many Angolans put down the uprising. The MPLA rebels then set up guerrilla bases in nearby countries. 

Cultural and political differences began to divide the Angolan rebels after the 1961 revolt. In 1962, a group of northern rebels formed the National Front for the Liberation of Angola (FNLA). Four years later, southern rebels organized the National Union for the Total Independence of Angola (UNITA).

In 1974, Portuguese military officers overthrew the government of Portugal. In January 1975, they decided to grant independence to Angola. At first, the Angolans agreed to set up a government consisting of representatives of all three rebel groups. But each group wanted to head the government, and a civil war broke out over which would rule. 

Angola gained independence from Portugal on Nov 11 1975. But the civil war continued between the MPLA and the FNLA and UNITA, whose forces had united. The MPLA received considerable aid from two Communist nations, the Soviet Union and Cuba. The Soviet Union sent both military advisers and equipment, and Cuba sent troops. Soviet and Cuban leaders hoped Angola would become a Communist nation if the MPLA won the war. The MPLA defeated its enemies in April 1976 and formed a Marxist govt (govt based on the philosophy of Karl Marx). But its leaders denied the govt was a Communist dictatorship. 

Angola's new government faced major problems. Members of UNITA waged guerrilla warfare against the government. South Africa aided UNITA. The FNLA also carried out guerrilla activities until 1984, when it became inactive. The departure of most of Angola's Europeans caused a shortage of executives and technicians. As a result, many industries and large farms could not be managed properly, and production declined. 

The govt began several programs to overcome the effects of the civil war. It took control of many businesses and started to train teachers and technicians. The Soviet Union, Cuba, and other Communist countries provided financial and technical aid. But the government also encouraged non-Communist nations to invest in Angolan businesses. Cuba kept troops in Angola to aid the govt in its fight against the guerrillas. 

Under an agreement signed by Angola, Cuba, and South Africa in late 1988, South Africa stopped sending aid to UNITA, and Cuba began withdrawing its troops. All Cuban troops were withdrawn by mid-1991. In 1989, the govt and UNITA agreed to a cease-fire. The two sides signed a peace treaty in May 1991. Violence continued in the Cabinda area, where guerrillas demanded Cabinda's independence from Angola. 

In 1990, the MPLA renounced Marxism, and in 91, legalized all political parties. Multiparty elections were held in Sep 1992. The head of the MPLA govt, Jose Eduardo dos Santos, won the first round of the elections. But UNITA protested that the elections were fraudulent, and civil war erupted again. The second round of the elections did not take place, but dos Santos continued as pres.

The two sides signed a peace agreement in Nov 1994. A UN peacekeeping force arrived in 1995 to oversee the agreement. However, the cease-fire has been broken many times. In 1998 and early 1999, violence increased and the peace agreement broke down. 
 
--------------------------------------------------------- Portuguese speaking south African country larger than
three times the size of California bordering the south
Atlantic, extends for more than 1,000 mi along the South Atlantic in SW Africa. The Democratic Republic of the Congo and the Republic of Congo are to the north and east, Zambia is to the east, and Namibia is to the south. A plateau averaging 6000 ft above sea level rises abruptly from the coastal lowlands. Nearly all the land is desert or savanna, with hardwood forests in the NE.

Govt - Angola underwent a transition from a one-party socialist state to a nominally multiparty democracy in 1992. 

History - The original inhabitants of Angola are thought to have been Khoisan speakers. After A.D. 1000, large numbers of Bantu speakers migrated to the region and became the dominant group. Angola derives its name from the Bantu kingdom of Ndongo, whose name for its king is ngola. 

Explored by the Portuguese navigator Diego Co in 1482, Angola became a link in trade with India and SE Asia. Later it was a major source of slaves for Portugal's New World colony of Brazil. Development of the interior began after the Berlin Conference in 1885 fixed the colony's borders, and British and Portuguese investment fostered mining, railways, and agriculture.

Following WW II, independence movements began but were sternly suppressed by Portuguese military force. The major nationalist orgs were the Popular Movement for the Liberation of Angola (MPLA), a Marxist party, National Front for the Liberation of Angola (FNLA), and the National Union for the Total Independence of Angola (UNITA). After 14 yrs of war, Portugal finally granted independence to Angola in 1975.

The MPLA, which had led the independence movement, has controlled the govt ever since. But after its long war for independence, the new country has yet to experience an extended period of peace. UNITA disputed the MPLA's ascendancy, and civil war broke out almost immediately. With the USSR and Cuba supporting the Marxist MPLA, and the US and S.Africa supporting the anti-communist UNITA, the country became a cold war battleground. 

With the waning of the cold war and the withdrawal of Cuban troops in 1989, the MPLA began to make the transition to a multiparty democracy. Despite shifting ideologies, the civil war continued for more than 30 yrs, with UNITA's charismatic rebel leader, Jonas Savimbi, armed and sustained by his control of approx 80% of the country's diamond trade. Free elections took place in 1992, with incumbent president Jose Eduardo dos Santos and the MPLA winning the UN-certified election over Savimbi and UNITA. Savimbi then withdrew, charging election fraud, and the civil war resumed. 

In 1997 Angola played a crucial role in the civil wars of both the Republic of Congo and the Democratic Republic of the Congo. By aiding in the overthrow of these countries' leaders, Pascal Lissouba and Mobutu Sese Seko, the Angolan govt was also able to destroy the UNITA strong- holds within the borders of these countries. Angola again came to the aid of the Democratic Republic of the Congo's new leader, Laurent Kabila, in 1998, helping to fight the rebellion against his shaky year-old administration. 

Four years of relative peace took place between 1994 and 1998 when the United Nations, at a cost of $1.6 billion, oversaw the 1994 Lusaka peace accord. In 1997 it was agreed that a coalition govt with UNITA would be implemented. But Savimbi violated the accord repeatedly by refusing to give up his strongholds, failing to demobilize his army, and retaking territory. 

As a result, the govt suspended coalition rule in Sept. 1998, and the country again plunged into civil war, which, analysts say, neither side had the military power to win. Meanwhile, Angolas citizens continue to suffer. The hostilities affect an estimated four million people, about a third of the total population, and there are almost two million refugees. 

Despite attempts to impose a lasting peace, the civil war drags on. UNITA gained the upper hand for a while in 1999, at one time controlling 70% of the country. Fighting prompted the withdrawal of 1,000 UN peacekeeping troops in Feb. 1999. However, a major govt offensive in Oct 1999 captured UNITAs headquarters and considerably reduced their territory. 

Though they suffered a severe setback, UNITA has since reorganized and resumed fighting. Control of diamond mining areas in central Angola has provided the rebels with the hard cash necessary to carry on the war. UNITA has also been allied with forces fighting to topple President Laurent Kabila in the Democratic Republic of the Congo. 
	 A thinly populated country in the center of Africa. Most of the country is a vast, rolling plateau broken by deep river valleys. Grass and scattered trees. Rain forests grow in the SW, and the extreme NE section is arid. Ante- lope, buffalo, elephants, gorillas, lions, rhinoceroses, and other animals inhabit the region. 

The Republic is one of the least developed countries in Africa. Most of the people are farmers, and the place has little economy. The country was formerly a territory in French Equatorial Africa called Ubangi-Shari. It became independent in 1960. Bangui, a river port, is the capital and largest city. 

Govt. The president, the most powerful official is elected by the people to a six-year term. The president appoints a prime minister and Cabinet ministers to carry out day-to-day government operations. The country's laws are made by a parliament called the National Assembly. The 85 members of the National Assembly are elected by the people to six-year terms. 

Rural Central Africans hunt, fish, raise food crops, and gather insects to feed their families. They also raise some cattle, goats, pigs, sheep, and poultry. The people of the Central African Republic belong to many ethnic groups and speak many languages, of which the most common is Sango. About a fourth of the people are Christians and a twentieth are Muslims. The rest of the people practice local African religions. Most of the older people cannot read or write. About 60% of the children go an elementary school. The country has secondary schools and a univ. 

Land. The plateau that makes up most of the Central African Republic has an average altitude of about 2,000 feet (600 meters) above sea level. Areas in the northeast and on the country's western border with Cameroon rise more than 4,500 feet (1,370 meters) above sea level. 
Many rivers flow through the country. In the north, most are tributaries of the Chari River, which flows north to Lake Chad (see Lake Chad). 

A divide separates these rivers from those that flow south from the central and southern parts of the country to the Congo River Basin. Many of these rivers are tributaries of the Ubangi River, which joins the Congo River. The Ubangi and one of its tributaries, the Mbomou River, form most of the country's southern boundary with Congo (Kinshasa). 

The country has a fairly comfortable climate. This is due chiefly to its altitude. The average temperature is 80 ?F (27 ?C). Each year, the country receives about 311/2 inches (80 centimeters) of rainfall in the north and about 63 inches (160 centimeters) in the south. The rainy season extends from June through October in most parts of the country. In the southwest, where the rainfall is heaviest, rain may fall throughout the year. 

This is a landlocked country with no railroads and many roads that are impassable during the rainy season. A few plantations raise coffee, cotton, and rubber products for export. Diamond mining is the only important mining industry. A few farmers raise livestock in regions where there are no tsetse flies. These insects spread African sleeping sickness.

Rivers form the most important transportation routes. Boats can navigate the Ubangi River throughout the year from Bangui to Brazzaville, in Congo (Brazzaville). From Brazzaville, exports are carried by railroad to the port of Pointe Noire. Bangui has an intl airport. Bambari, Bouar, and several other towns also have airports. 

History. Before the arrival of Europeans in the 1800's, most of the people of what is now the Central African Republic lived in small societies. Slave raids in the 1800's brought turmoil to much of the region. In 1889, France established an outpost at Bangui. The French created the territory of Ubangi-Shari in 1894. In 1910, they linked Ubangi-Shari with what are now the countries of Chad, Congo (Brazzaville), and Gabon to form French Equatorial Africa. 

The French established a local parliament in Ubangi-Shari in 1946. Elected members represented the country in the French parliament. In 1958, the country gained internal self-govt as the Central African Republic. It joined the French Community, an org that linked France and its overseas territories. The country became fully independent on Aug. 13, 1960. 
	V) Chad is a large, thinly populated country in N.central Africa. Chad is landlocked. Most of its people live in the fertile southern part of the country. The northern part is mostly desert. N'Djamena is the capital and largest city. Chad became an independent nation in 1960. It had been ruled by France since 1920. 

Political, social, and religious differences between the Muslim peoples of the north and the peoples of the south, most of whom follow traditional African religions or Christianity have kept Chad in a nearly constant state of civil war since the mid-1960's. Because of the war and because Chad lacks many economic resources, it is one of the world's least developed nations. 

People. The people of Chad, called Chadians, belong to a variety of ethnic groups. French and Arabic are the official languages of the country. But most Chadians speak their own local languages. Most of the adults in Chad cannot read and write. For the country's literacy rate, see . Most of Chad's people live in the countryside and work as farmers or nomadic (wandering) herders. The rest live in N'Djamena and a few other cities. Many of these people also work as farmers nearby. 

In northern Chad, most of the people are dark-skinned Arabs or members of the black African Toubou ethnic group. Most of these people are cattle traders. They travel through the desert in small bands with herds of livestock. They make tents out of sticks and woven mats. The men of northern Chad usually wear loose gowns and turbans or small skullcaps. Some men also wrap long, white scarves around their faces for protection during sandstorms. The women typically wrap themselves in light blue or black onepiece robes. 

Northern Chadians raise cattle, camels, goats, and sheep. Milk and meat are the basis of their diet. The northerners also eat dates and vegetables that are grown in oases and villages. Arabic is the most common language spoken in northern Chad, and a majority of the people in the region are Muslims. Less than a tenth of the school-age children in the north attend school. Most of the people in southern Chad are black Africans from various ethnic groups. The largest of these groups, the Sara, live chiefly in the far south. 

Most southern Chadians are settled farmers. Their main cash crop is cotton. They live in circular houses made of adobe brick or dried mud covered with a straw roof. Some houses are made entirely of straw. The men usually wear cotton trousers or shorts and loose shirts. Women commonly dress in brightly colored blouses and one-piece skirts. The diet of the people of southern Chad consists mainly of millet, sorghum, and rice. Meals occasionally include vegetables, fish, or meat. 

Sara is the most widely spoken language in the south, but there are many others. The majority of southern Chadians follow traditional African religions, but many have converted to Christianity. The missionaries who introduced Christianity in the region also started the school system. Education has helped the south gain a dominant position in Chad. Most of Chad's primary and secondary schools are in areas where the Sara live. Most business people, teachers, traders, and government workers come from that region. The south also contains most of Chad's cities and industries. 

The tremendous gap in education and economic development has added to the conflict between residents of the north and south. Northerners feel they lack the opportunity to advance in education, business, and other aspects of life. Religious differences between Muslims and Christians have added to this tension. 

Land and climate. Most of the country consists of arid desert land and rocky plateaus. The Tibesti moun-tain range in northwestern Chad includes the country's highest point, Emi Koussi. This mountain rises 11,204 feet (3,415 meters) above sea level. A flat stretch of savanna (grassland with scattered trees) in central Chad separates the vast desert in the north from a small, extremely fertile region in the south. 

Southern Chad covers the area south and southeast of the Chari River. It was called "Useful Chad" by French colonists because it has all the advantages that northern Chad lacks. Its soil and climate are ideal for cultivating cotton, and it is by far Chad's richest farming region. This tropical forested region also has a rich supply of wild animals, including antelope, elephants, lions, and giraffes. These animals can be seen in Zakouma National Park, northeast of Sarh. 

Chad has several rivers, most of them in the south. The largest of these, the Chari and the Logone, meet at N'Djamena and then flow into Lake Chad. The lake's size varies greatly between rainy and dry seasons. Crocodiles, hippopotamuses, and cranes live in the marshy area around the lake. 

Temperatures in the northern desert often reach 120 ?F (49 ?C), and the region receives less than 5 inches (13 centimeters) of rain annually. Central Chad averages 25 inches (64 centimeters) of rain each year, while southern Chad receives about 40 inches (100 centimeters). The average temperature in these two regions is 82 ?F (28 ?C). 

Economy. Chad is one of the poorest countries in the world. It has few natural resources, and most of the land north of the Chari is useless for growing crops. But deposits of natron near Lake Chad, and uranium in the north could be of some value. Oil deposits in the lake region and in the south may produce enough fuel someday to meet most of the country's energy needs. 

Poor transportation and communications facilities are obstacles to Chad's economic development. The country has no railroads, and almost all its roads are unpaved. Less than 1 percent of the people own an automobile. N'Djamena has an international airport. Chad has limited telephone, telegraph, and postal services. The weekly Al-Watan and the mimeographed government bulletin Info-Tchad are the only newspapers. Chad has an average of about 1 radio for every 4 people. The country averages only about 1 television set for every 850 people. 

History. Little is known about Chad's earliest history. Remains of prehistoric civilizations have been discovered in the Tibesti, Borkou, and Ennedi regions in northern Chad. Rock engravings and paintings dating back to 5000 B.C. show hunting and herding scenes. Primitive tools found around Lake Chad point to the existence of cattle-raising peoples as early as 500 B.C. Developing trade routes led to the formation of a state called Kanem northeast of Lake Chad about A.D. 700's. A series of kings from the Sefuwa family ruled Kanem for about 1,000 years. Islam was introduced around 1100. 

The smaller kingdoms of Baguirmi and Ouaddai developed near Kanem in the 1500's and 1600's. All three kingdoms became powerful and prosperous by trading goods and slaves. Traders from the northern kingdoms often raided the southern tribes to capture slaves. One reason for the conflict in Chad today is that the Sara people remember that northern raiders seized thousands of their people as slaves. The French claimed and explored Chad during the 1880's and 1890's. Chad became a French colony in 1920 and was part of a region called French Equatorial Africa. 

The Sara people suffered more than any other group under colonial rule. Many died in battle in World War I and World War II. Thousands were sent to work on a railway in what is now Congo (Brazzaville), and never returned. But when Chad became independent in 1960, a Sara-dominated government took over. For the Sara, independence also meant freedom from the age-old domination by northern slave traders. Francois Tombalbaye, a Sara leader, became Chad's first president. 

In 1962, a group of northerners formed a rebel organization called the National Liberation Front (Front de Liberation National), or Frolinat. Most of its leaders were Muslims. Civil war between Frolinat and government troops broke out in the mid-1960's. The government of Chad turned to France for military aid. In 1971, Frolinat began to get military supplies from Libya. Libyan President Muammar al-Qadhafi hoped to make Chad part of Libya. In 1973, Libyan forces occupied the Aozou Strip along Chad's northern border. This area is believed to contain uranium and other minerals. 

President Tombalbaye was killed in 1975 by military and police units that overthrew the government. Felix Malloum, a Sara and the head of Chad's army, became president of the new military regime. Fighting continued until the rebels captured almost half the Chadian army in 1978. A new government was then formed with almost an equal number of representatives from the north and the south. Hissene Habre, a former Frolinat leader, became prime minister. 

The new government did not solve Chad's problems, however. President Malloum fled in 1979, and two groups within the rebel forces battled for control. One group followed Habre, then minister of defense. The other group was headed by the new president, Goukouni Oueddei. Goukouni received support from Libya. In 1980, the army led by Habre was defeated by Goukouni's troops and Libyans who aided them. Goukouni took control of the government. Libyan troops remained in Chad until late 1981, when Goukouni asked them to leave. A peacekeeping force from the Organization of African Unity (OAU) replaced the Libyan troops. 

In June 1982, an army led by Habre overthrew the government of President Goukouni. Goukouni fled the country, and the OAU peacekeeping force withdrew. Habre became president, but Goukouni returned with troops from Libya. In 1983, France sent troops and military equipment to support Habre. Goukouni's forces and Libyan troops occupied the northern part of Chad, while Habre's forces controlled N'Djamena. 

In 1986, conflict broke out between Goukouni's troops and their Libyan allies. Goukouni's troops joined with Habre's forces, and Habre launched attacks against the Libyans. By 1987, the Libyans had been driven from all of Chad except the Aozou Strip. The two countries agreed to a truce in late 1987. Libya withdrew its forces from the area in 1994 after the United Nations International Court of Justice ruled that the Aozou Strip belonged to Chad. 

In 1990, a rebel group called the Patriotic Salvation Movement (MPS) overthrew Habre's government. In 1993, a national conference of political parties and other groups set up an interim government. In 1996, Chad adopted a new constitution and held multiparty presidential elections. In 1997, the country held legislative elections. 
	  aka Ivory Coast, lies along the Gulf of Guinea on the west coast of Africa. Nearly all of its people are black Africans. Most work is farming, which is the nation's leading source of income. Coffee and cacao seeds (seeds used to make chocolate and cocoa) are the main crops and chief exports. 

The country's official name is Republique de Cote d'Ivoire, which is French for Republic of the Ivory Coast. The name first appeared on European maps of West Africa in the late 1600's as Cote des Dents ou de l'Yvoire (Tusk or Ivory Coast). This name refers to the coastal trade in elephant tusks at that time. France declared Cote d'Ivoire a colony in 1893 but did not fully control it until 1915. Cote d'Ivoire gained independence in 1960. Yamoussoukro is the capital of Cote d'Ivoire. Most government offices, however, are in Abidjan, the economic center and former capital of the country. Abidjan is also Cote d'Ivoire's largest city and main port. 

Government. According to the Constitution adopted in July 2000, the president is Cote d'Ivoire's highest government official. All presidential candidates must have been born in Cote d'Ivoire to parents who themselves are both Ivorian. No person who has ever used another nationality can run for president. The president is elected by the people to a five-year term and can be reelected only once. The president appoints a prime minister and other ministers to help carry out the functions of government. The National Assembly, whose members are elected to five-year terms, makes the nation's laws. A supreme court heads the nation's court system. 

People of Cote d'Ivoire include four large cultural groups. The Akan peoples live in the southeast, the Kru in the southwest, the Voltaic in the north and northeast, and the Mande in the west central and northwestern regions. These four main groups are made up of over 60 smaller groups, including the Baoule, Bete, and Senufo. Since the mid-1900's, a large number of immigrants, mainly from Burkina Faso, Mali, and Guinea, have moved to Cote d'Ivoire. The population also includes many people of French, Lebanese, or Syrian descent. 

French is the official language of Cote d'Ivoire. The Jula (Dyula) language, which is used in trade, is the most widely spoken language. The majority of Ivorians live in small villages. The villages typically consist of several compounds. Each compound is made up groups of homes that house members of an extended family. An extended family is one that includes such relatives as parents, married children and their offspring, aunts, uncles, and cousins. Village houses have mud walls and thatched or metal roofs. 

Sharp contrasts exist in housing, health, employment, and education between middle- and upper-income and poor households in the cities. For example, wealthy and middle-class people live in modern apartment buildings or in spacious villas. The urban poor inhabit densely settled districts that receive few government services.  About 40% of the people are Muslims, and about 27 percent are Christians. Many Ivorians practice traditional African religions. About half the people of Cote d'Ivoire 15 years of age and older can read and write. For the literacy rate, see . The University of Cocody in Abidjan is the nation's largest institution of higher learning. 

The land of Cote d'Ivoire rises gradually from the Atlantic Ocean. The eastern part of the coast is flat and sandy. A sand bar, no more than 4 miles (6 kilometers) wide, extends west from the neighboring country of Ghana for 180 miles (289 kilometers) along the coast. Behind the sand bar lie deep lagoons. The western part of the coast has small, rocky cliffs. Beyond the coastal strip is a tropical forest, from 95 to 185 miles (153 to 298 kilometers) wide. Through the years, much of the forest has been cleared to make farmland. In the north, the forest changes to savanna (grassland with scattered trees). The Guinea highlands, hills covered by forests, rise above 5,000 feet (1,500 meters) in west-central Cote d'Ivoire. 

The major rivers of Cote d'Ivoire are the Bandama, the Cavally, the Comoe, and the Sassandra. The 500-mile (800-kilometer) Bandama is the longest. 

The coastal region is hot and humid. Temperatures there vary from 76 to 83 ?F (24 to 28 ?C), and annual rainfall ranges from 79 to 128 inches (201 to 325 centimeters). Temperatures in the central forest region vary from 57 to 103 ?F (14 to 39 ?C), and annual rainfall totals from 39 to 98 inches (99 to 249 centimeters). In the northern savanna, the temperature rises to 120 ?F (49 ?C), and annual rainfall totals 60 to 80 inches (150 to 200 centimeters). 

Economy. Cacao beans, coffee, and palm oil are Cote d'Ivoire's chief exports. Other major exports include bananas, cotton, petroleum products, pineapples, and rubber. Ivorian farmers also grow cassava, corn, rice, and yams; and they raise cattle, sheep, and goats. 

A number of the industries and manufacturing plants in Cote d'Ivoire process the country's raw products. These operations include petroleum refining; the processing of palm oil, pineapples, sugar, timber, and tuna; and the production of textiles. 

History. Before the arrival of the Europeans, parts of what is now Cote d'Ivoire consisted of powerful kingdoms, including the Kong, Bouna, Gayman, Kabadugu, and Sanwi. Beginning in the early 1700's, the French established trading posts along the coast where traders bartered slaves and ivory for European goods. 

A number of treaties in the mid-1800's gave France sovereignty over much of the coastal area. The northern savanna, however, was conquered militarily in the 1890's by French troops commanding African mercenaries. France then joined its interior colonies with its new possession on the Gulf of Guinea. 

Many French settlers established coffee and cacao plantations and obtained logging rights in the Cote d'Ivoire colony. Africans were forced to work for little pay on these operations and suffered great hardships. The French also forced Africans to supply labor for public works projects, such as roads and railroads. 

France attached a large part of its colony of Upper Volta (now the nation of Burkina Faso) to Cote d'Ivoire from 1932 to 1947. The French took this action to ensure a steady supply of low-cost labor to Cote d'Ivoire. 

During World War II (1939-1945), feelings of nationalism began to grow among the people of Cote d'Ivoire. After the war ended, France carried out a number of political and economic reforms in the colony. In 1946, for example, France ended its policy of forced labor. These reforms, along with high world market prices, led to the expansion of African-owned coffee and cacao farms. 

Cote d'Ivoire became an independent republic in 1960. Felix Houphouet-Boigny, who led the independence movement of French territories in western Africa, became the republic's first president. 

During the 1960's and 1970's, the government borrowed heavily to invest in construction and social development projects. When world market prices for coffee and cacao plunged in the 1980's and 1990's, the country faced severe debt problems. The government obtained new loans from the International Monetary Fund and the World Bank. As a condition for receiving these loans, Cote d'Ivoire reduced public spending, sold off state-owned companies to private investors, and made other economic reforms. 

Houphouet-Boigny served as Cote d'Ivoire's president until his death in 1993. Henri Konan Bedie, the president of the National Assembly, succeeded him. In 1995, Bedie was elected to a full term as president. In December 1999, military officers led by General Robert Guei ousted Bedie and set up a transitional government. 

In July 2000, voters approved a new constitution designed to return the country to civilian rule. In October, the nation held a presidential election. Before the election, former Prime Minister Alassane Ouattara and most other opposition candidates were barred from running for the presidency. During the vote count, when it appeared that opposition candidate Laurent Gbagbo would defeat Guei, Guei shut down the election commission and declared himself the winner. Tens of thousands of demonstrators then flooded the streets of Abidjan in protest. Guei eventually fled the country, and Gbagbo was sworn in as president. Ouattara and his supporters called for a new election. 

	V A country in NE Africa. Much of Ethiopia consists of rugged mountains and a high, fertile plateau. The northern part of the country, near the Red Sea, ranks among the hottest places in the world. 

The name Ethiopia comes from a Greek word meaning sun burned faces. Ancient Greeks applied the word to people living south of Egypt including in Ethiopia because the people had darker skin than the Greeks did. Ethiopia was formerly often called Abyssinia. Some people think this name came from an Arabic word meaning mixed, a ref to the many ethnic groups in the pop. Other people believe it came from the name of an early Ethiopian tribe. 

Land and climate - Ethiopia has an area of about 426,000 sq mi. The Ethiopian Plateau covers much of the western and central parts of the country. Lowlands surround the plateau which spreads out over about two-thirds of the country. It lies between 6,000-10,000 ft above sea level. Most of Ethiopia's people live on the plateau, which has the country's best agricultural land. Most of the plateau receives more than 40 in of rain annually. Aver temps range from about 72 ?F (22 ?C) in areas below 8,000 ft to less than 60 ?F (16 ?C) at higher altitudes. 

Droughts have occurred in Ethiopia from time to time. In the 1970's, 1980's, and early 1990's, droughts helped cause severe famines, which led to many deaths. 

The Great Rift Valley, which runs north and south through eastern Africa, divides the plateau into two large sections. The sections are further divided by deep, spectacular river gorges and high mountain ranges. Ethiopia's highest mountain, Ras Dashen, rises 15,158 feet (4,620 meters) above sea level on the plateau. The lowlands. The Ethiopian Plateau slopes downward in all directions toward lowland regions.

Most of the lowland areas have an average temperature of about 80 ?F (27 ?C) and receive less than 20 inches (51 centimeters) of rain a year. The scorching hot Denakil Desert lies in northeastern Ethiopia. Temperatures in the Denakil Desert sometimes rise above 120 ?F (49 ?C). The lowlands are thinly populated because of the hot, dry climate and because the soil is poor for farming. 

Rivers and lakes. Ethiopia's chief rivers include the Awash, Baro, Blue Nile (called Abay in Ethiopia), Genale, Omo, and Wabe Shebele. Lake Tana, the country's largest lake, lies in the northwest. A series of lakes extends through southern Ethiopia along the Great Rift Valley. The lakes include Abaya and Ziway. 

Ethiopia is one of the oldest African nations. According to tradition, the first emperor of Ethiopia, Menelik I, was the son of the Biblical Queen of Sheba and King Solomon of Israel. Many later Ethiopian rulers claimed descent from Solomon and Sheba. Emperors or kings ruled Ethiopia for about 2,000 years. 

Population, ancestry, and languages. Ethiopia ranks third in population among the countries of Africa. Only Nigeria and Egypt have more people. Most of the people of Ethiopia live in rural areas. Addis Ababa, Ethiopia's capital, is also the country's largest city. Ethiopians are descended chiefly from three groups of people. These groups are brown-skinned people who resembled Europeans, black Africans, and people from the Arabian Peninsula. Today, most Ethiopians have brown skin and physical features that range from European to black African. 

Most Ethiopians are classified into two large groups based on the languages they speak. The groups are the Semites (people who speak Semitic languages) and the Hamites (people who speak Cushitic languages). The Semites live mainly in northern and central Ethiopia. They include the Amhara, Tigre, and Gurage. The Hamites live chiefly in southern and eastern Ethiopia. They include the Afar (also called Danakil), Somali, and Oromo (also called Galla). 

People of mostly black African ancestry live along Ethiopia's western border. They speak languages of the Nilo-Saharan family and make up about 5 percent of the population. Until the early 1990's, a small percentage of the population consisted of Ethiopian Jews known as Beta Israel or Falashas. These people were sometimes called Black Jews because, like other Ethiopians, they had dark skin. In the early 1960's, there were approximately 40,000 Beta Israel in the country. The Falashas have emigrated to Israel. However, a number of Jews known as Falash Mura remain in Ethiopia. These people are descendants of Jews who had convertedmany in name onlyto Christianity. 

About 70 languages and 200 dialects are spoken in Ethiopia. Amharic, a Semitic language, is the country's official language. Amharic is spoken by about half of the people. Many Ethiopians speak English or Arabic in addition to their own languages. Ge'ez (also called Ethiopic) is an ancient Ethiopian language. In the past, all Ethiopian Bibles were written in it. Ge'ez is still used in ceremonies of the Ethiopian Orthodox Church. 

Way of life. Most rural Ethiopians live in villages or isolated homesteads. Their lives differ little from those led by their ancestors. The majority are farmers who work the land with wooden plows pulled by oxen. The rural population also includes nomads, who make their living chiefly by raising livestock. Poverty is widespread in the rural areas of Ethiopia. Each year, large numbers of rural people move to urban areas to try to find jobs. Poverty also exists in the urban areas. However, in general the urban people are better off economically than the rural people. In addition, schools, medical care, and such modern living comforts as electricity are more widely available in the urban areas. 

Most Ethiopians live in round houses with walls made of wooden frames plastered with mud. The houses have cone-shaped roofs of thatched straw or, occasionally, metal sheeting. Many people in areas where stone is plentiful live in rectangular stone houses. In addition to traditional housing, Ethiopian towns and cities have many modern buildings. Addis Ababa has many modern apartment buildings and several skyscrapers. 

Many Ethiopian men and women wear one-piece cloths called shammas. Most shammas are made of a thin, white cotton fabric. Some people in southern Ethiopia wear leather clothing. Many Ethiopiansespecially urban peoplewear Western-style clothing. A thick and spicy stew called wat is a popular food among Ethiopians. The people make wat from meat and vegetables and often add eggs to it. Ethiopians usually eat wat by picking it up with pieces of slightly sour pancake-shaped bread called injera. Popular beverages include beer, coffee, and tea. 

Religion. As many as 40 percent of Ethiopia's people belong to the Ethiopian Orthodox Church, a Christian faith. About 40 percent of the people are Muslims. Most of the rest of the people practice traditional African religions. 

The arts. Much of the country's art is related to the Ethiopian Orthodox religion. In the past, many artists painted church walls with Biblical scenes and pictures of saints. Artists also illustrated religious manuscripts with elaborate decorations. Writers created religious poetry and other sacred works in the Ge'ez language. Early days. Some of the oldest fossil fragments of human beings have been found in Ethiopia. They date from about 2 million years ago. By the 400's B.C., two major groupsthe Hamites and the Semitesinhabited the area. The Hamites were farmers or nomadic shepherds. The Semites were farmers or traders. 

The Aksum Kingdom was the first important state in what is now Ethiopia. It was well established by the A.D. 200's. Its capital was the city of Aksum. The Aksum Kingdom gained much wealth through trade with Arabia, Egypt, Greece, India, Persia, and Rome. The Aksumites exported gold, ivory, and spices. Aksum reached its height of power in the 300's under King Ezana. He made Christianity the official religion of Aksum. In the 600's, Aksum's power fell sharply after Muslims gained control of Arabia, the Red Sea, and the coast of northern Africa. The Muslims, religious enemies of Christian Aksum, put an end to the kingdom's foreign trade. 

The Zagwe dynasty. In 1137, the Zagwe dynasty (series of rulers) rose to power on the Ethiopian Plateau. The Zagwe rulers had their capital at Rohanow called Lalibela. During the reign of the Zagwe emperors, 11 magnificent churches were carved out of solid rock at Roha. The churches still stand. In 1270, Yekuno Amlak overthrew the Zagwe dynasty. After the 1500's, the Ethiopian Empire broke up into a number of small kingdoms. 

Menelik II, who became emperor in 1889, reunified the Ethiopian Empire by gaining control of many of the small kingdoms. In 1896, at the Battle of Adwa, Menelik defeated an Italian army that had occupied part of Ethiopia. This victory earned him much respect and helped increase his power in Ethiopia. Under Menelik, Ethiopia engaged in its own colonial expansion and nearly doubled its territory to the south and east. Menelik made Addis Ababa the capital of Ethiopia and began the construction of a railway that, when completed, linked Addis Ababa to Djibouti. Menelik also established the first modern schools and hospitals in Ethiopia. 

In 1913, Lij Iyasu, Menelik's grandson, became emperor of Ethiopia. An unpopular ruler, Lij Iyasu was removed from power in 1916 by Ethiopians with the help of the United Kingdom, France, and Italy. These countries opposed Lij Iyasu because he sided against them in World War I (1914-1918). Zauditu, Menelik's daughter, then became empress of Ethiopia. She ruled with the help of Ras Tafari, the son of Menelik's cousin. Tafari was named heir to the throne. Haile Selassie. Zauditu died in 1930. Tafari then became emperor and took the title Haile Selassie I. He continued Menelik's policy of modernizing Ethiopia. In 1931, Haile Selassie gave the country its first written Constitution. 

Italy invaded Ethiopia in 1935 in an attempt to expand its colonies in Africa. In 1936, the Italians conquered Addis Ababa, and Haile Selassie fled to the United Kingdom. Italian rule was harsh. However, many fine roads were built under Italian rule, providing a long-term benefit to Ethiopia. In 1941, during World War II, British troops helped the Ethiopians drive the Italians out of Ethiopia. Haile Selassie then returned to the throne.  Eritrea, an Ethiopian area along the Red Sea, had been captured by Italy in the 1880's. In 1952, Ethiopia regained control of the area. In 1961, Eritrean nationalists demanded independence from Ethiopia. The Ethiopian government rejected the demand, and civil war broke out. 

The Ogaden region of southeastern Ethiopia also became a trouble spot in the 1960's. The government of neighboring Somalia claimed the region, which Menelik had conquered in the 1890's. Many Somali people had always lived there, and they revolted against Ethiopian rule. In the 1970's, Ethiopia and Somalia began fighting over the Ogaden region. 

Military take-over. In the 1960's, many Ethiopians became dissatisfied with Haile Selassie's government. They demanded better living conditions for the poor and an end to government corruption. In 1972 and 1973, severe drought led to famine in the northeastern part of Ethiopia. Haile Selassie's critics claimed that the government ignored victims of the famine. In 1974, Ethiopian military leaders seized the government and removed Haile Selassie from power. 

The military government, under Lieutenant Colonel Mengistu Haile-Mariam, adopted socialist policies and established close relations with the Soviet Union. The government began large-scale land reform, breaking up the huge estates of the former nobility. The government claimed ownership of this land and turned it into farmland. But the military leaders also killed many of their Ethiopian opponents. In the late 1970's, people in the Tigre region of northern Ethiopia called for independence from the central government. 

In 1987, Ethiopia adopted a constitution that provided for a return to civilian government. A parliament was elected, but the country's military leaders continued to hold power. Lieutenant Colonel Mengistu was elected president. Fighting over the Ogaden region ended in 1988, when Ethiopia and Somalia signed a peace accord. 
Recent developments. In the mid-1980's, severe famine struck Ethiopia. Tens of thousands of Ethiopians died. Ethiopia was again struck by drought and famine in the late 1980's, early 1990's, and early 2000's. 

Ethiopia's government continued to face rebellions in the Eritrea and Tigre regions in the 1980's. In 1991, a rebel group consisting of Eritrean, Tigrean, and other forces defeated President Mengistu and his army. Rebels, chiefly from the province of Tigre, took control of the government. The rebel groups agreed that Eritrea would become an independent nation. Eritrea gained independence in 1993. At that time, however, part of the border between the two countries was not clearly defined. Ethiopia and Eritrea fought a bloody war over this disputed area from May 1998 to June 2000, when the two sides signed a cease-fire agreement. They signed a formal peace treaty in December 2000. The treaty included a provision that established a commission to identify the border between the two countries. 

In 1994, Ethiopia adopted a new constitution. In 1995, the country held its first multiparty parliamentary elections. The Ethiopian People's Democratic Revolutionary Front, which had dominated the government since 1991, won the 1995 elections as well as ones held in 2000. 
 
--------------------------------------------------------- LALIBELA, Ethiopia Awakened to the chill of a wintry dawn in this mist-covered town hidden in the mountains of northern Ethiopia, peasants and priests groped through dark stone-pitted dirt roads on their way to prayer. After climbing to the town's highest hills, they descended into pits carved out of rock, inside which rose stately 800-year-old churches that were hewn, it is said, by a king laboring during the day and by angels toiling at night.

In this, one of the holiest places in the Ethiopian Orthodox Church, the scene has changed little through the centuries, unfolding daily as a lasting reminder that this nation in the Horn of Africa was one of the first lands to adopt Christianity, in the fourth century.

Hermits sat in tombs carved in reddish walls blanketed with moss glistening from the rains. The faithful, in white robes, moved from church to church, walking through labyrinthine tunnels to reach a house of worship in a cave, clambering up slippery steps into a monolithic one, halting along the way to press their lips against the moist sacred walls.

Tyler Hicks for The New York Times
Bet Giyorgis is one of 11 churches carved out of rock at Lalibela, Ethiopia, that are still used for daily service.
 
Past the sandals left at the entrance and into the largest church, the Bet Medhane Alem, some worshipers leaned against pillars and read from their Bibles, others knelt on the cold carpeted stone floor, others still gathered in the sanctuary to listen to a young priest reading from an ancient copy of the New Testament. The deacon stumbled through several passages, reading in Ge'ez, an ancient language that very few Ethiopians understand today, and was corrected by two older men flanking him.

In the capital, Addis Ababa, the service would have been performed in Amharic, the national language, or mixed with Ge'ez. But here in Lalibela, the rituals seem frozen in time. This is a place with more donkeys than cars, and not a single bank. It is home to 11 rock-hewn churches that are not only among the most impressive monuments in sub-Saharan Africa, but are also still used today for daily worship.

Still, even Lalibela today finds itself caught between Ethiopia's unique history in Africa and more pressing modern needs. Even Lalibela has lost some of its young to Protestantism. Its churches  having survived, in the last quarter century, Marxist rule, a civil war and the effects of a recent war between Ethiopia and Eritrea  have grown impoverished, bereft of the tourists who sustained them. More important, fewer young men want to become priests today.

"Sometimes they are not paid," said Gebez Abebe-Abebaw, 53, the chief priest of Na'akuto La'ab, a church built in a mountain cave a few miles from here. "So they do not want to stay with the church, but rather go into the fields and farm."

"I tell them to come to church," he said, not bothering to mention their reaction. So powerful is the Orthodox Church, with an estimated 25 million believers in the country, that few Ethiopians here will speak openly of its troubles. Privately, though, residents tell of a relative or friend who has converted, especially to Pentecostalism, attracted by the faith's modern practi- ces. In most cases, the families keep it a secret or send the convert away from Lalibela, said one tourist guide. 

The leading priests here tend to dismiss the conversions, saying Protestant missionaries are using their wealth to buy conversions. "It is not because we are not moderni- zing," said Wodjanew Aseffa, 46, the chief priest of Bet Giyorgis, a sunken, monolithic church whose roof is shaped like a Greek cross. Speaking of converts, he added: "It is because they are financed by foreigners. If they convert, they get money."

In some people's eyes, the priests have lost standing because of a widely held belief here that they have been involved in the trafficking of ancient artifacts from the churches. In the last decade, many crosses, paintings and books have vanished from Lalibela's churches only to reappear in black markets in Europe.

In 1997, one of Ethiopia's most sacred artifacts, a 12th-century gold- and-bronze cross  said to have been made by King Lalibela, who gave this town its name and churches  was stolen from Bet Medhane Alem church. After a Belgian collector was stopped from taking it into Belgium by customs officials there, the cross was returned to Ethiopia in 1999.

The priests here deny that any of them were involved in any trafficking. Pointing out that a Muslim Ethiopian had been arrested in the theft of the Lalibela cross, Besfat Ayalew, 35, the secretary to the bishop, said: "The Muslims are doing this. They are trying to destroy the Christian religion in Ethiopia." On average, senior priests are paid about $20 a month; deacons about $2. And as the line of impatient priests outside the bishop's headquarters showed, they are paid irregularly.

Despite everything, though, the Orthodox Church still stands unrivaled in Ethiopia, helping to preserve a national unity and identity seen in few places on the continent. Although Ethiopia has long had a significant Muslim population and a very small Jewish one, the Orthodox Church served as the country's state religion from the fourth century to the Marxist coup in 1974.

What is more, in a country relatively untouched by European colonialism, Ethiopia's religion and culture remained largely homegrown. And to anyone who has traveled throughout Africa, the differences are sometimes striking.

One immediately notices, for instance, that Ethiopians have kept their way of expressing time according to a 12-hour day. They start counting at 6 A.M., so that hour 1 is 7 A.M.  and the result is that many Ethiopians, especially those in the countryside, keep their watches set 6 hours behind the way time is expressed in the rest of the region. 

Religion and culture may provide anchors here. But countries like Nigeria or Congo, ruined by decades of post-colonial misrule, have seen a mushrooming of sects and religions that have further splintered their societies. Those two nations, like many others in Africa, appear adrift, with few common values to guide them forward. Casual conversations with Ethiopians invariably reveal a strong national pride, while in much of the rest of Africa, pride is usually ethnic. 

One result is the difference in domestic tourism. Elsewhere on the continent, it is rare to see Africans, even those in places that are wealthier than Ethiopia, visiting sites in their own countries. By contrast, Ethiopian tourists are everywhere in the country; according to figures from the Ministry of Culture and Tourism in Lalibela, in the last seven years at least a third of the tourists to Lalibela  a town of under 100,000 people  were Ethiopians themselves.

Those Ethiopians do not include the tens of thousands of pilgrims who arrive here every January for the Orthodox Christmas. They are also drawn by national myths that have unusual power in Ethiopia.

King Lalibela, it is said, was instructed by God to build churches that the world had never seen. So he decided, not simply to build beautiful churches, but to carve 11 churches out of red rock. Having lived in Jerusalem for a number of years, King Lalibela was said to want to build nothing less than a New Jerusalem here. A Star of David can be seen sculptured in the wall of one church.

Archaeologists believe thousands of workers toiled for decades to complete the 11 churches here. But legend says that it took only 23 years and one man, albeit with some help. "God showed King Lalibela where to carve the churches," said Gebez Melese-Demese, 40, a high-ranking priest. "He would carve one meter during the day, and the angels would carve three meters at night."

Some who have left the faith, or others in the cities, may have their doubts, but not the believers here. The hermit living in a hole in the wall next to Bet Medhane Alem, Aba Wolde Maryam, 74, said he had been there since 1974 when he had come from his village 65 miles west of here so that his sins could be forgiven.

Another hole a few feet from his yawned vacantly. The hermit living there had died three years ago. "Yes, we were friends," the hermit said, looking at his palms. "I feel lonely now." And yet there was another hermit, occupying a hole a few hundred feet away. "Yes, we're friends, too," the hermit said. "Sometimes we talk. We talk about peace in the country, the harvest and about the afterlife."

By NORIMITSU ONISHI NYT Aug 2 2001.
	 A small, heavily forested country that lies on the west coast of Africa. It straddles the equator. Gabon was a French colony from the early 1900's until it became an independent republic in 1960. Its name in French, the official language, is Republique Gabonaise (Gabonese Republic). Libreville is the capital. 

Gabon lies on the equator and is covered with thick forests. Many palm-lined beaches, lagoons, and swamps lie along the 500 miles (800 kilometers) of coast. Moving inland, the land rises gradually to rolling hills and low mountain ranges that are cut through by valleys of the Ogooue River and its tributaries. The Ogooue River is one of Gabon's chief means of transportation. Roads built during the mid-1900's link various parts of the country. The Trans-Gabon Railroad was built in the 1970's and 1980's. It links the port of Owendo and the interior. 

Gabon's climate is hot and humid most of the year. Rainfall is heavy throughout the country, especially along the northern coast. Many regions receive as much as 100 inches (250 centimeters) of rainfall a year. The average annual temperature is about 79 ?F (26 ?C). 

Gabon is extremely rich in natural resources. It is noted for its high-quality lumber. It also has some of the world's richest iron and manganese deposits. Gabon is one of the most thinly populated countries in Africa. About half of the people of Gabon live in small villages along the coast, along the rivers, or in the thinly forested parts of the north.

There are many ethnic groups in Gabon. The Fang, the most important group, live in the northern part of the country. Once fierce warriors, they were feared by other ethnic groups and by Europeans. They now dominate the national government. The Omyene, a small but important group of related peoples, live along the coast. They were the first to meet and deal with European traders and missionaries. This gave them an early advantage in education and commerce. Small groups of Pygmies live in the thick southern forest, isolated from other people. They hunt and trap animals for food. 

The people in most parts of Gabon once lived in houses that had walls made of mud-covered branches and roofs made of woven grass. These houses had reed mats hanging at windows and doors. But now many of the houses have corrugated metal roofs, and Gabonese families now try to save enough money to build houses that have cement walls. Most villages have a meeting place, where the older men of the village gather to visit or to discuss village affairs. Many Gabonese, especially those in towns, are Christians. Others follow traditional African religions. Music and dancing play a major role in the ceremonies. 

Formerly, most of Gabon's people had a low standard of living. But since the mid-1900's, the development of the country's mineral resources has helped raise living standards by creating new employment opportunities and spreading social services throughout the country. 

History. Portuguese sailors were the first Europeans to reach Gabon. They landed on its coast in the 1470's. Europeans carried on a slave trade with Omyene people for hundreds of years. 

In 1839, France established a naval and trading station near the present site of Libreville. Missionaries arrived and opened schools. In 1849, a group of slaves freed by a French ship landed at the station, which was then named Libreville (free town). Later, French explorers paddled up the Ogooue River into the interior of the country. The lumber trade developed around the Ogooue and the Gabon estuary near Libreville. 

By 1883, Libreville had become the capital of the new French colony of Gabon, and in 1910, Gabon became a colonial territory within the federation of French Equatorial Africa. French companies acquired much land and gained complete control over Gabon's foreign trade and its forestry products. Much of the country's economy is still controlled by French companies. 

Gabon began to move toward independence after World War II. It gained internal self-government in 1957, and the legislature elected by the people chose a Council of Ministers. On Aug. 17, 1960, Gabon became an independent country. Leon Mba, who had been head of government since 1957, became president. 

In January 1964, Mba dissolved the National Assembly, and a month later, army rebels arrested Mba in an attempt to overthrow him. But French troops came to Mba's aid, crushed the revolt, and restored Mba to power. Mba was reelected in 1967, but he died the same year. Vice President Bernard-Albert Bongo succeeded Mba. In 1968, Bongo declared Gabon a one-party state and created the Gabonese Democratic Party as the only legal political party. Bongo was elected president in 1973. He changed his name to El Hadj Omar Bongo that year. He was reelected in 1979 and 1986. 

	d# One of the smallest independent countries in Africa. A narrow strip of land in western Africa, Gambia extends inland from the Atlantic Ocean for about 180 miles (290 kilometers). It lies along the banks of the Gambia River. Gambia is only 15 to 30 miles (24 to 48 kilometers) wide. It is a flat land. Mangrove and scrub forests line the areas along the coast and the Gambia River. Elsewhere, sandy soil covers the land. Except for its short coastline, Gambia is entirely surrounded by Senegal. It is officially called the Republic of The Gambia or The Gambia. Banjul, a busy port with about 44,000 people, is the capital and only large town (see Banjul). 

Gambia is a poor country. It has relatively little fertile soil and no valuable mineral deposits. Tropical crops grow well near the mouth of the river. However, most farmers in Gambia earn a living by raising peanuts. Peanuts account for most of the country's income. 

James Island, in the Gambia River, was once a slave trading center from which slaves were shipped to the West Indies and America. All or part of what is now Gambia was controlled by the English from the 1660's to 1965, when Gambia became an independent nation. 

People. Almost all the people of Gambia are black Africans. The five main ethnic groups, in order of size, are the Mandingo, the Fula (or Fulani), the Wolof, the Serahuli, and the Jola. Most Gambians are Muslims. 

About 275,000 Mandingo live throughout Gambia. They are tall, music-loving people who make a meager living as traders and peanut farmers. Most of the 100,000 Fula live in eastern Gambia and raise cattle for a living. Many of them are nomadic. They move their herds from region to region. 

Most of the 90,000 Wolof are either farmers who live near Gambia's northern border or inhabitants of Banjul, where they make up a majority of the population. The Wolof enjoy dancing and music. Wolof women in Banjul often dress elegantly in turbans; highwaisted, full-skirted dresses; and gold ornaments and jewelry. 

Most of the 60,000 Serahuli live in eastern Gambia, where the soil is poor and farming is difficult. Every year, people from Senegal called the strange farmers come to help the Serahuli plant and harvest the crops. They take an agreed share of the crop and are also given a plot of land on which they raise their own crops. 

The 55,000 Jola live south of the Gambia River near the coast. They have lived in Gambia longer than the other ethnic groups, and once were bitter enemies of the Mandingo. The Jola are hard-working farmers who live in small villages surrounded by earthen walls. They raise rice and millet for food. Most Jola follow a traditional African religion practiced by their ancestors. 


Almost all children living in and near Banjul attend school, but only about one-third of the children in other parts of Gambia go to school. Most schoolchildren complete a six-year primary course, but only a few go to secondary schools. Gambia has a technical school in Banjul and a teacher-training college in Yundum. 

Land. The Gambia River rises in Guinea and winds through Gambia before reaching the Atlantic Ocean. Small oceangoing ships can sail up the river from the Atlantic as far as Kuntaur. 

Mangrove swamps line the riverbanks from the coast to the center of the country. Behind the swamps lie the banto faros--areas that are firm ground in the dry season, but swamps during the rains. Near the coast, salt water from the tidal reaches of the Gambia River floods the banto faros, ruining the soil. Farther inland, areas that the river floods with fresh water during the wet season are used to raise rice. Beyond the banto faros, sandy plateaus extend from both sides of the river into Senegal. Farmers raise peanuts and rice on the plateaus. 

Gambia's summer months (June through October) are hot and humid. Inland temperatures during the summer may reach 110 ?F (43 ?C). During the winter (November through May), temperatures drop to about 60 ?F (16 ?C). The harmattan, a dry wind, blows from the Sahara during the winter (see Harmattan on World Book Online). About 40 inches (100 centimeters) of rain falls near the coast each year. Inland areas get less rainfall. 

The Gambia River is the country's main transportation route. Oceangoing ships sail upstream to load peanuts for export. Ferries, smaller boats, and large canoes with sails carry passengers on the river. Gambia has no railroads, but there are roads on both sides of the river. The Trans-Gambia Highway, connecting northern and southern Senegal, runs through Gambia. An airport in Yundum, near Banjul, links Gambia with other African countries and with Britain. Radio Gambia, a government service, broadcasts in English and in African languages. 

History. The area that is now Gambia was part of the powerful Mali Empire from the 1200's to the 1400's (see Mali Empire on World Book Online). The people raised cotton and rice and other foods. Portugal set up trading posts on Gambia's coast in the 1400's. The coast became a center of the English and Portuguese slave trades during the 1500's. England began a settlement on James Island in the Gambia River in 1661. During the next 100 years, England and France fought for control of trade on the river. 

In 1765, the British established a colony called Senegambia, which included what are now parts of Gambia and Senegal. In 1783, the British handed over the Senegal territory to France. British merchants founded Bathurst (now Banjul) in 1816. The colony of Gambia was set up in 1888. By 1902, all of what is now Gambia had come under British rule. 

Gambia began gaining measures of self-government after World War II ended in 1945. It gained complete internal self-government in 1963. David (later Sir Dawda, or Dauda) Jawara, leader of the People's Progressive Party, became the first prime minister. Gambia gained complete independence on Feb. 18, 1965. On April 24, 1970, Gambia became a republic. Jawara was elected as the first president. 

Under Jawara, the government spent money to improve Gambia's roads and ferries and to modernize Yundum Airport and the harbor at Banjul. Since 1970, tourism in Gambia has grown rapidly. However, since the 1970's, droughts have reduced agricultural production and seriously damaged Gambia's economy. 

In 1982, Gambia and Senegal formed a confederation, which--like the earlier colony--was called Senegambia. The confederation strengthened the economic ties between the two countries and united their armed forces. However, disputes between Gambia and Senegal led the two countries to end the confederation in 1989. 

In 1994, a group of Gambian military officers led by Yahya Jammeh overthrew Jawara and began to rule Gambia through a military council. In August 1996, Gambia adopted a new constitution. Jammeh won presidential elections later that year. Soon after the elections, Jammeh dissolved the military council. In 1997, Gambia elected a National Assembly. 
	  A tropical country in western Africa. Ghana lies on the Gulf of Guinea, where Africa bulges westward into the Atlantic Ocean. Most of the people of Ghana are black Africans. Cacao seeds, which are used to make chocolate, are the country's most important crop and its leading export. Ghana's forests yield valuable tropical hardwoods. Ghana has important deposits of bauxite, diamond, gold, and manganese. 

Portuguese explorers landed in what is now Ghana in 1471. They found so much gold there that they called it the Gold Coast. Later, European merchants came to compete for profits in the gold and slave trades. In the late 1800's, the Gold Coast became a British colony. 

The Gold Coast gained its independence in 1957. It took the name Ghana, the name of an ancient African kingdom. Ghana was the first member of the Commonwealth of Nations to be governed by black Africans. Its official name is the Republic of Ghana. Accra is the capital and largest city. 

People. About 99 percent of Ghana's people are black Africans. The population also includes small groups of people of Asian and European descent. Ghana's black Africans belong to about 100 different ethnic groups. The Ashanti and the Fante, two closely related ethnic groups, make up much of the population. They belong to a larger group of African peoples called the Akan. Other important ethnic groups in Ghana include the Ewe, the Ga, and the Moshi (Mossi)-Dagomba. Many Ghanaians speak African languages. But a large number also speak English, the official language. 

A majority of Ghana's people live in rural areas. Most rural Ghanaians are farmers. In the forest regions, many men raise cacao on small farms. Many women raise food for their families on small plots of ground. Many of the people who live in Ghana's cities and towns hold jobs in the government. 

Ghana's cities have many Western-style buildings. But some people in the cities live in houses that have mud walls and tin roofs. In central and southern Ghana, many of the people live in rectangular houses with mud walls, thatched or tin roofs, and often courtyards. Many of the people in northern Ghana live in round houses with mud walls and cone-shaped, thatched roofs. 

The national dress in Ghana is made from brightly colored cloth. Men wrap the cloth around them. Women make blouses and narrow skirts from it. Many of the people now wear Western-style clothing. 

About 45 percent of the people practice traditional African religions. About 40 percent are Christians, and about 10 percent are Muslims. 

Land. Ghana rises from a heavily populated plain along the Gulf of Guinea to the Kwahu Plateau. The plateau runs from the northwest to the southeast across central Ghana. It forms a divide between the White Volta and the Black Volta rivers in the north and east, and the Ankobra, the Pra, and the Tano rivers in the south and west. A thick forest covers southwestern Ghana. North of the plateau, the land gradually becomes a savanna (grassy, thinly wooded plain), and then grasslands. Lake Volta, one of the world's largest artificially created lakes, is located in east-central Ghana. 

Ghana has a tropical climate. Accra, in the south, has an average temperature of 80 ?F (27 ?C). Northern Ghana has higher temperatures. Most of Ghana receives 40 to 60 inches (100 to 150 centimeters) of rain a year, with the heaviest rains in the southwest. Axim, a town on the Gulf of Guinea, receives over 80 inches (200 centimeters) of rain a year. Northern and eastern Ghana have severe dry spells from November to March. 

History. People from African kingdoms to the northwest probably settled in what is now Ghana in the 1200's. Portuguese explorers landed on the coast in 1471 and named the area the Gold Coast. Later, the Dutch came to compete with the Portuguese for gold. By 1642, the Dutch had seized all the Portuguese forts, and ended Portuguese control in the Gold Coast. A large slave trade developed in the 1600's, and the Danes and English competed with the Dutch for profits. The slave trade ended during the 1860's, and by 1872, the British had gained control of the Dutch and Danish forts. 

In 1874, Britain made the lands from the coast to the inland Ashanti empire a British colony. By 1901, Britain had made the Ashanti lands a colony and had started a protectorate over what is now northern Ghana. 

The cacao industry prospered in the Gold Coast during the early 1900's. Britain extended roads and railways, built hospitals, and developed the schools.  In the late 1940's and in the 1950's, Britain gradually gave the Africans more power. In 1946, a majority in parliament were Africans elected to represent the people. But the British governor and Cabinet kept most of the power. In 1951, Kwame Nkrumah was asked to form a Cabinet, and in 1952, he became prime minister. By 1954, the people ran their own government, except in the areas of external affairs, defense, and the police. 

Britain gave the Gold Coast its independence in 1957. British Togoland became part of the new nation, which was named Ghana (see Togo). 

In 1960, the people of Ghana voted to become a republic and elected Nkrumah president. He made his Convention People's Party (CPP) the only legal political party and increased his personal power through the mid-1960's. But government debt and corruption combined with the falling price of cacao to greatly weaken the economy. In 1966, a military council seized the government and ousted Nkrumah. It suspended the constitution, dismissed the legislature, and abolished the CPP. It named General Joseph Ankrah head of government. 

Ankrah resigned in 1969 and the council replaced him with Brigadier Akwasi Amankwa Afrifa. Also in 1969, Ghana adopted a new constitution and returned to civilian rule. Kofi Busia, leader of the Progressive Party, became prime minister. Busia served until 1972, when military leaders took control of the government. Colonel I. K. Acheampong became head of the new military government. In 1978, he was forced to resign by other military leaders. General Frederick William Kwasi Akuffo replaced him. In June 1979, still other military leaders overthrew Akuffo. Lieutenant Jerry Rawlings, who led the revolt against Akuffo, became head of the government. The new government executed Afrifa, Acheampong, and Akuffo. In September 1979, a civilian government was elected. In 1981, Rawlings led another revolt and regained control of the government. 

During the 1970's and early 1980's, Ghana suffered severe economic problems. Many people left Ghana to work in Nigeria. But Nigeria also experienced economic difficulties. In 1983, Nigeria forced about 1 million people to return to Ghana. The return of the people created shortages of food, housing, water, and jobs in Ghana. 

	~! A small, independent country on the bulge of Africa's west coast. It also includes the offshore Bijagos (or Bissagos) Islands. Bissau is the capital, chief port, and largest city. Most of the people are farmers. The leading crops include peanuts and rice, which thrive in the country's tropical climate. Guinea-Bissau was Portuguese Guinea, an overseas province of Portugal, until 1974. That same year, the province won its independence after an 11-year war against Portuguese rule. 

Land and climate. Guinea-Bissau's coastal area consists of rain forests and thick swamps. Mangrove trees grow in the water along the shore. The land slopes upward from the coast, and savannas (grasslands with scattered trees) cover most of the inland regions. Many rivers flow through the country. The chief rivers include the Cacheu, the Corubal, and the Geba. 

Guinea-Bissau has a tropical climate with a dry and a wet season. During the dry season, which lasts from Dec to May, temps aver 74? F (23? C). During the wet season, which lasts from Jun to Nov, temps aver 83? F (28? C). The heaviest rains fall in Jul and Aug. The yearly rainfall averages 95 in along the coast and 55 in inland. 
Black Africans make up about 85% of the pop. Most of the rest consist of mestizos (people of mixed black African and Portuguese ancestry). The blacks belong to about 20 ethnic groups. The largest groups, in order of size, are the Balante; the Fulani; the Manjako; and the Malinke, or Mandingo. 

Most of the people live in rural areas and make a bare living farming. Many of them live in straw huts with thatched roofs. Most of the people practice animism, the belief that everything in nature has a spirit. Many others are Muslims. The official language is Portuguese. However, most of the people more often speak crioulo, which is a local language that combines other local African languages and Portuguese. 

While under Portuguese rule, the people of Guinea-Bissau received little education. When the country won its freedom, only about 5 percent of the people could read and write. During the war for independence, rebel leaders began many schools and adult education programs in areas under their control. After the war, the new govt turned several former Portuguese military bldgs into schools. 

Guinea-Bissau has few paved roads. Rivers serve as a chief means of transportation. The Cacheu, Corubal, and Geba rivers are deep enough for some oceangoing ships to travel about 80 miles (130 kilometers) upstream. The nation has several small airfields. 

History. Many groups of black Africans lived in what is now Guinea-Bissau before Portuguese explorers arrived in 1446. From the 1600's to the 1800's, the Portuguese used the region as a base for the slave trade. The region became a Portuguese colony called Portuguese Guinea in 1879. It became an overseas province of Portugal in 1951. 

During the 1950's and 1960's, an independence movement swept across Africa. In 1956, African nationalist leaders in Portuguese Guinea founded the African Party for the Independence of Guinea and Cape Verde (PAIGC). The party sought independence for both Portuguese Guinea and Cape Verde. Cape Verde was a Portuguese-ruled island group about 475 miles (764 kilometers) northwest of Portuguese Guinea. Amilcar Cabral headed the party from 1956 to 1973, when he was assassinated. During the early 1960's, the PAIGC trained many Portuguese Guinean farmers in the hit-and-run tactics of guerrilla warfare. 

The war for independence began in 1963. By 1968, the PAIGC controlled about two-thirds of the province. The people in these areas elected the first National Popular Assembly in 1972. The next year, the Assembly declared the province to be an independent nation called Guinea-Bissau. Luis Cabral, a PAIGC leader and a brother of Amilcar Cabral, became the new nation's first president. The war ended in 1974, when Portugal recognized Guinea-Bissau's independence. Cape Verde became independent in 1975. The PAIGC, under General Secretary Aristides Pereira, began work to rebuild and develop the country. The party also worked to unite Guinea-Bissau and Cape Verde under one government. In 1980, military leaders overthrew Guinea-Bissau's civilian government and took control of the country. They abolished the national assembly and formed a ruling military council. The military government forcefully opposed the unification of Guinea-Bissau and Cape Verde. In 1984, it adopted a constitution that established a new national assembly. The assembly elected a new president, Brigadier General Joao Bernardo Vieira. 

The PAIGC was Guinea-Bissau's only political party until 1991. That year, the assembly legalized the formation of other parties. Vieira won multiparty elections held in 1994 and remained president. In June 1999, rebel forces led by General Ansumane Mane removed Vieira from office. Mane appointed Malan Bacai Sanha, who had been head of the assembly, as acting president. In parliamentary elections held in November, the Social Renewal Party won the most seats in the National People's Assembly. In January 2000, Guinea-Bissau's voters elected Kumba Yala, the head of the Social Renewal Party, as the country's president. 
	q(' is a large country in western Africa. The Sahara, Africa's great desert, covers the northern half of the country. Rolling grassland spreads across most of the rest of Mali. 

Mali is a poor, agricultural country. At times, droughts have led to large numbers of deaths of people and animals there. Most of Mali's people are black Africans who live in small rural villages and farm for a living. Many of the country's farmers produce only enough food for their own families. Many others raise livestock in the desert. Mali has a variety of mineral and water resources, but they are largely undeveloped. Manufacturing and mining contribute relatively little to the economy. 

From about the A.D. 300's to the late 1500's, one or more of three powerful black empiresGhana, Mali, and Songhaithrived in what is now Mali. France ruled Mali from 1895 to 1959. Mali became an independent nation in 1960. Its name in French, the official language, is Republique du Mali (Republic of Mali). Bamako is Mali's capital and largest city. 

People. The vast majority of Mali's people are black Africans. The Fulani and a related people called the Toucouleur make up the largest group of Mali's people. The Fulani are descended from both blacks and whites. The Mandingos form the next largest Malian group. There are three main Mandingo subgroupsthe Bambara, Malinke, and Soninke. Other large black groups in Mali include the Dogon, Songhai, and Voltaic peoples. Whites account for about 5 percent of Mali's population. The whites include Arabs, Europeanschiefly FrenchMoors, and Tuareg. 

  Malian contemporary music 
 




The Fulani and Toucouleur speak Fulani. Most of Mali's other people speak Bambara or other local languages. The Arabs and Moors speak Arabic, and the Tuareg use an ancient Berber language. French is spoken mainly by the Europeans, and by people in government offices and schools. 

Islam is the chief religion in Mali. About 65 percent of the people are Muslims (followers of Islam). The Bambara, Malinke, and Voltaic peoples practice traditional African religions. About 5 percent of the people are Christians. 

Most of Mali's black African population reside in small rural villages in the southern part of the country and grow crops for a living. They generally work on village-owned plots. Many can raise only enough food for their own use. Their foods include cassava, corn, millet, rice, sorghum, and yams. Most Malian farmers cannot afford agricultural machinery, and so they use hand tools for almost all their work. Most village families live in small houses made of mud or branches. 

A majority of Mali's Fulani farm for a living. They live in dome-shaped houses thatched with straw and lined with mats. Others raise cattle in the Sahel, a semidesert region, and in the southern grasslands. These herders live in low shelters made of straw mats or branches. 

Many of Mali's Arabs and Moors and almost all the Tuareg are nomads. The nomads herd cattle, goats, sheep, and donkeys back and forth across the Sahel and Sahara in search of water and pasture for grazing. They live in portable tents made of camel hair. Their basic foods include dates and millet. The nomads travel in groups led by marabouts (holy men) and are fiercely independent. They are more loyal to their marabouts than to Mali's government. 

Many of Mali's Europeans are descendants of French colonists. Most live in modern houses in Bamako and other urban areas. Bamako is Mali's largest city (see Bamako). Many Europeans own businesses or have government or professional jobs. Others work in banks, stores, and offices. 

 Street market in Mali 
 
 

Women play a key role in farming in Mali. They help plant and harvest crops and raise livestock. The government has set up modern job training programs for women. But relatively few have enrolled because of their heavy workloads and family responsibilities. 

Mali, like other developing nations, faces major social problems. Many of its people suffer from a lack of education. Most of Mali's adults cannot read and write, and many of the country's school-age children do not attend school. For Mali's literacy rate, see . Mali has several schools of higher education. But many Malian students prefer to get higher degrees and professional training in other nations, mainly France and Senegal. 

Mali is also challenged by poor health conditions. The average life expectancy for infants in the country is less than 50 years. Approximately a fifth of the babies born in rural areas die as infants. Malaria is widespread in Mali and is a chief cause of death among children. Mali has only a few hundred doctors to serve its entire population. Most of them work in urban areas. 

Land and climate. Mali has three main land regions: the harsh Sahara in the north, the semidesert Sahel in central Mali, and rolling grasslands in the south. Mali has few mountains. Its highest point, Hombori Tondo, a mountain in the south, rises 3,789 feet (1,155 meters) above sea level. 

The Senegal and Niger are Mali's chief rivers. Most of the country's people live in villages and urban areas along or near these rivers and their branches. The Senegal flows through southwestern Mali. The Niger enters Mali near Bamako and flows northeast ward into the interior delta, Mali's most fertile area. It then makes a great turn called the Niger Bend and flows southeastward into the country of Niger. It spreads out into a network of branches and lakes in Mali. 

Mali has three seasons. Its weather is hot and dry from March to May, warm and rainy from June to October, and relatively cool and dry from November to February. Average annual temperatures are between 80 and 85 ?F (27 and 29 ?C) in much of the country. From March to May, temperatures often exceed 100 ?F (38 ?C). In the scorching Sahara, they may rise to more than 110 ?F (43 ?C) during the day. But at night, Sahara temperatures may be as low as about 40 ?F (4 ?C). The Sahara receives an average of about 10 inches (25 centimeters) of rain a year, and southern Mali averages about 35 inches (89 centimeters). 

History. Mali has a rich cultural heritage. From about the A.D. 300's to the late 1500's, areas in what is now Mali formed part of one or more of three great black empires. These empiresGhana, Mali, and Songhaigrew prosperous because they controlled important trade routes. 

The Ghana Empire began during the 300's and lasted until the mid-1000's. It became known as "the land of gold" because traders brought gold there from fields farther south and exchanged it for salt and other goods from North Africa. See Ghana Empire on World Book Online. 

The Mali Empire flourished from about 1240 to 1500. In the 1300's, it ranked as the wealthiest and most powerful state in western Africa. Mansa Musa, its king from 1312 to 1337, brought Muslim scholars to the empire, and the city of Timbuktu started to become a center of Muslim learning. See Mali Empire on World Book Online; Timbuktu. 


The Songhai Empire began in the 700's. The Malian city of Gao served as capital of the empire. Under Askia Muhammad, who ruled the empire from 1493 to 1528, Timbuktu reached its peak as a center of wealth and Muslim learning. Invaders from Morocco overran Songhai in 1591. Many small kingdoms later ruled the area. See Songhai Empire on World Book Online; Askia Muhammad on World Book Online. 

During the mid-1800's, France tried to set up a colony in what is now Mali. But French troops met fierce resistance from black Africans and did not gain control of the area until 1895. In 1904, the colony, then called French Sudan, became part of French West Africa. In 1946, France gave French Sudan the status of a territory in the French Union. See French West Africa on World Book Online. 

In 1958, French Sudan became a self-governing republic within the French Community. The next year, French Sudan and Senegal united to form the Federation of Mali. Modibo Keita, a Malian leader, became head of the federation. The federation broke up in August 1960. On Sept. 22, 1960, French Sudan gained complete independence as the Republic of Mali. 

Keita became Mali's first president. He tried to develop the economy, partly by establishing close ties with the Soviet Union and other Communist nations. Several Communist countries built factories in Mali. But worldwide inflation and an unsuccessful attempt to set up a new money system led Mali into debt. 

In 1968, a group of Malian military leaders overthrew Keita. Moussa Traore, one of the leaders, took control of Mali's government as head of a military committee. 

In 1974, Malians approved a constitution that called for the gradual establishment of an elected president and legislature. Legislative and presidential electionsthe first elections under the Constitutionwere held in 1979. All the candidates belonged to the Mali People's Democratic Union. Traore, who headed the party, was elected president. 

In the 1970's and early 1980's, severe droughts struck the Sahel and brought widespread famine to Mali. Millions of cattle, goats, and sheep died. Thousands of Fulani and Tuareg herders, who depended on their livestock for meat and milk, died from malnutrition. Thousands of other nomads poured into Mali's urban areas seeking food. The United Nations and a number of countries gave Mali food to prevent mass starvation. 

Today, Mali's lack of industry and heavy reliance on agriculture limit economic progress. Malians are working to establish a more balanced economy to lessen the economic disasters caused by droughts and other agricultural problems. 

In 1991, Malian government forces killed many people in a crackdown against antigovernment protests. Later that year, military leaders overthrew Traore's rule and formed a temporary government composed of military and civilian members. In 1992, a new constitution was adopted. It provided for a multiparty system and an elected government. A new civilian president, Alpha Oumar Konare, was elected. A new National Assembly was also elected. In 1993, former President Traore was tried and convicted for his government's actions against the antigovernment protests of 1991. In 1997, Konare was reelected president. In 1999, Traore was convicted of embezzlement. 
	+ A country in SW Africa formerly named South West Africa. Windhoek is the capital and largest city of Namibia. Most of Namibia's people are blacks, but the territory was controlled by the white govt of neighboring South Africa from 1916 to 1990. In Mar 1990, after many years of negotiations, Namibia gained full independence from South Africa. Much of Namibia's land is dry and unfertile. But the land is rich in mineral deposits, including diamonds and uranium. 

People. Blacks make up more than 90% of Namibia's pop. Whites account for about 7%. Namibia's blacks belong to a number of different ethnic groups. The Ovambo form the largest group. They comprise over half of the Namibian pop. The Ovambo live in the north, near the Angolan border. This region is called Ovamboland or Ovambo.

Other northerners in the country include the Kavango, who live near the Okavango River; and the Caprivians, who inhabit the eastern end of the narrow strip of land that is called the Caprivi Strip. The Damara and the Herero occupy central Namibia. San (Bushmen) and Tswana people live along the country's eastern border. Two groups of people of mixed ancestry live south of Windhoek--the Basters, who live in or near Rehoboth; and the Nama, who inhabit the far south. 

Namibia's whites include South Africans of Dutch, English, and German descent. Namibia's population also includes people of mixed ancestry from South Africa called Coloreds. Most of the whites and Coloreds live in or near cities or towns. 

Most people of northern Namibia fish, grow crops, and raise livestock for a living. Many Ovambo and Kavango men also work in copper mines at Tsumeb or in diamond mines near the southern border. Most of the rural people south of Ovamboland farm and raise livestock. Many of Namibia's whites hold administrative jobs in urban areas. The standard of living among Namibia's black ethnic groups varies, but most of the black people must struggle to make a living. Whites generally have higher incomes than do blacks. But when Namibia gained independence, the government began working to raise the economic level of the blacks. 

Namibia's official language is English. But most black Namibians speak local African languages. About 15 such languages are spoken in the country. About 90 percent of the people are Christians. Lutherans form the largest Christian denomination. Other Christian groups, in order of size, are Roman Catholics, Anglicans, and members of Dutch Reformed Churches. 

Public schools provide Namibians with free education. The University of Namibia (formerly the Academy for Tertiary Education) offers post-secondary education. 

Land and climate. Namibia is bordered on the north by two large rivers, the Kunene and the Okavango. The Kwando River cuts through the Caprivi Strip. The Zambezi River flows along the northeastern border, and the Orange River forms Namibia's southern border. Otherwise, Namibia is a dry land. Droughts often occur. 

The western border of Namibia stretches 950 miles (1,500 kilometers) along the Atlantic Ocean. Huge sand dunes of the Namib Desert lie near the coast. The Kalahari Desert occupies eastern Namibia. The inland territory is mostly a rolling plain about 4,000 feet (1,200 meters) above sea level. This area in Namibia has stubby trees and enough grassland for grazing cattle and growing corn. 

Large antelopes live on the interior plain of Namibia. Elephants adapted to desert conditions inhabit the northwest corner of the country. Etosha Game Park, which is a huge reserve in north-central Namibia, has a variety of animals, including antelopes, cheetahs, elephants, giraffes, lions, rhinoceroses, and zebras. 

Daytime temperatures in Namibia average 75? F (24? C) in January and 68? F (20? C) in June. Namibia receives most of its rain between December and March. The average annual rainfall totals about 20 inches (50 centimeters) in the north and about 8 to 16 inches (20 to 40 centimeters) in the center. The south receives only about 1 to 6 inches (2.5 to 15 centimeters) of rain a year. 

History. Both the Damara and the San people claim to be the original inhabitants of Namibia. Through the years, large numbers of Herero and Ovambo people moved to Namibia from the north. By the 1800's, the Damara, Herero, and Ovambo were the largest groups, and the Kavango and the Caprivians had settled where they now live. Other groups arrived in the 1800's. 

Beginning in 1868, German settlers, missionaries, and soldiers colonized Namibia's coast. Germany annexed the land in 1884, calling it German Southwest Africa. In the 1890's, the Germans brutally forced the Herero and Damara out of the Windhoek area. The Herero began to revolt in 1904. By the time the Germans put down the revolt in 1907, they had killed about 65,000 Herero. 

In 1915, during World War I, South African troops attacked the Germans and took over Namibia. The South Africans wanted to make Namibia part of their country. But the United States and other allied nations objected to that plan. In 1920, the newly formed League of Nations gave South Africa a mandate to manage Namibia's government and affairs. Yet, the South Africans governed Namibia as if it were a province of their nation. 

The UN replaced the League of Nations in 1945. But South Africa refused to accept the authority of the UN and rejected its request to place Namibia under UN trusteeship. The UN took steps to try to bring Namibia under UN control. In 1966, the UN voted to end South Africa's mandate. In 1971, the International Court of Justice declared South Africa's control of Namibia illegal. 

Black Namibians formed a political organization called the South West Africa People's Organization (SWAPO) in 1960. At first, SWAPO tried to persuade South Africa to grant Namibia independence. But beginning in the mid-1960's, it used guerrilla tactics to further its goal. In turn, South Africa set up armed forces along Namibia's borders with Angola and Zambia. Fighting occurred between SWAPO and South Africa until 1989. 

In 1977, South Africa was preparing to grant Namibia independence under a plan that would give local political leadership to an assembly dominated by white Namibians. The UN strongly opposed such white domination. Representatives of the United States, Britain, West Germany, France, and Canada persuaded South Africa to negotiate a new plan that would meet the UN objection. Negotiations for independence were held at various times in the late 1970's and the 1980's. 

Finally, in late 1988, South Africa agreed to a plan under which Namibia would gain full independence by April 1990. In April 1989, SWAPO and South Africa agreed to a cease-fire. Elections for a Constituent Assembly in Namibia were held in November 1989. In February 1990, the Assembly approved a constitution and elected Sam Nujoma, the leader of SWAPO, as Namibia's first president. Future presidents were to be elected by the people. Namibia gained independence on March 21, 1990. The Constituent Assembly was then renamed the National Assembly. In 1994 and 1999, Namibia's voters reelected Nujoma as president. 

When Namibia became independent, South Africa kept the district of Walvis Bay, which included the major port of Walvis Bay. Namibian leaders said the district should be part of Namibia. In March 1994, South Africa gave Namibia control of the district. 
	_ An African country that consists of 10 main islands and 5 tiny islands. It lies in the Atlantic Ocean, about 400 mi (640 km) west of Dakar, Senegal, on the African mainland. Cape Verde has a total land area of 1,557 sq mi (4,033 sq km). Sao Tiago, the largest island, covers 383 sq mi (991 sq km). Santo Antao is the second largest island, followed by Boa Vista, Fogo, Sao Nicolau, Maio, Sao Vicente, Sal, Brava, and Santa Luzia. Santa Luzia and the five islets are uninhabited. 

Praia, the capital and largest city, is on Sao Tiago. It has a population of about 62,000 and is a major seaport and trading center. Portugal ruled the islands from the 1460's until they gained independence in 1975. 

Govt. Cape Verde is a rep. The people elect a 79-member legislature called the People's Assembly, which selects a prime minister. The prime minister is head of the government and appoints a cabinet of 10 ministers, upon the approval of the assembly. The president is chief of state and is elected by the people. Assembly members, the prime minister, and the president all serve 5-year terms. Cape Verde has two major political parties, the Movement for Democracy (MPD) and the African Party for the Independence of Cape Verde (PAICV).  About 70% of Cape Verde's people have mixed black African and Portuguese ancestry. Most of the rest of the people are black Africans. 

Cape Verde has an extremely low standard of living because many of its people cannot find work. The country's chief industries, farming and fishing, provide workers with only a bare income. Famines have occurred frequently through the years, and many of the people are undernourished. Since the mid-1900's, hundreds of thousands of Cape Verdeans have emigrated to Brazil, Portugal, the United States, and other countries. 

The official language of Cape Verde is Portuguese. But most Cape Verdeans speak the national language, Crioulo. Crioulo is a local dialect based on Portuguese and various African languages. Most Cape Verdeans are Roman Catholics, but many practice animism, the belief that everything in nature has a soul. 

Land and climate. The islands of Cape Verde were formed by volcanic eruptions 21/2 million to 65 million years ago. The only remaining active volcano is on Fogo Island. Most of the islands have rugged, mountainous land, with tall cliffs along the coastlines. 

Cape Verde has a warm, dry climate, with average annual temperatures that range from 68 ?F (20 ?C) to 77 ?F (25 ?C). A continual shortage of rain makes most of the land too dry to support plant life. 

During the mid-1900's, Cape Verde worked to develop its fishing industry. Lobsters and tuna are the main catches. The country's mining industry produces salt and pozzuolana, a volcanic rock used by the cement industry. Both these products are exported. 

Before Cape Verde became independent in 1975, it relied almost entirely on Portugal for economic support. Since then, it has received food aid from the United Nations and financial aid from various countries. 

Cape Verde has three radio stations and two newspapers. The islands have about 920 miles (1,480 kilometers) of roads. There are no railroads. Boats operate among the islands infrequently. Sal Island has an airport, and several other islands have landing strips. 

History. Portuguese explorers discovered the islands of Cape Verde about 1460. The islands were uninhabited, and the Portuguese began to settle there about two years later. They planted cotton, fruit trees, and sugar, and brought slaves from Africa to work the land. 

Slave trading became Cape Verde's most important commercial activity during the 1500's and 1600's, and the islands prospered. Slaves learned how to work on plantations there before being shipped elsewhere. The slave trade declined in the late 1600's, and the prosperity ended. Economic conditions improved slightly in the mid-1800's, when Mindelo became an important refueling port for ships crossing the Atlantic. 

Portugal ruled Cape Verde and what is now Guinea-Bissau under one government until 1879, when each became a separate Portuguese colony. Guinea-Bissau lies southeast of Cape Verde. Cape Verde became a Portuguese overseas province in 1951, and its people assumed a greater role in the government. The PAIGC (now called the PAICV) fought to overthrow Portuguese rule from the mid-1950's until 1975, when Cape Verde became independent. Until 1990, the PAICV was the country's only legal political party. That year, the constitution was amended to allow for a multiparty system. As a result of elections held in 1991, the MPD became the ruling party. It retained power after elections in 1995. 
	!* A large, landlocked country in west Africa. Barren desert and mountains cover most of northern Niger. A grassy, thinly wooded plain extends along the southern border. The country, officially the Rep of Niger, takes its name from the Niger River, which flows through its SW corner. Niamey is Niger's capital and largest city. 

The people of Niger belong to many different ethnic groups, each with its own language and customs. Almost all the people are black Africans, and a large majority are Muslims. Most people work as farmers and live in the south, where water and land are available. 
Niger became an independent nation in 1960. France had ruled it for about 60 years before independence. 

People. The people of Niger are called Nigeriens ?nee ZHEH ree ehnz?. About 98 percent of Niger's people are black Africans. Nonblack minorities include a local white ethnic group called the Tuareg, whites from other countries, and Asians. 

The major black ethnic groups in Niger include the Hausa, Djerma-Songhai, Kanuri, and Fulani. The Hausa make up about half of the population of Niger. They live mainly in the south and work as farmers. Between a fourth and a fifth of the people are members of the Djerma-Songhai ethnic group. The Djerma-Songhai are farmers and live in the southwestern corner of the country, along the Niger River. The Kanuri make up about 5 percent of the population. They farm the rich land in southeast Niger. 


Many of the Fulani and the Tuareg are nomadic (traveling) people who raise livestock for food. Together they make up more than 10 percent of the population. During the rainy season, which lasts from July through September, these two groups live in the barren desert country of northern Niger. In dry months, they travel south in search of water and pastureland. 

Most of the people who live in Niger's rural areas raise crops and livestock for food and for export. Some Nigeriens who live near the Niger River or Lake Chad fish for a living. The nomadic groups raise camels, cattle, goats, and sheep. In the late 1960's and early 1970's, and again in the early 1980's, severe droughts led to the deaths of many of the nomads' animals. As a result, many nomads were forced to become farmers or move to urban areas. 

Niamey, Niger's capital, is its largest city by far. Other large cities include Agadez (Agades), Maradi, Tahoua, and Zinder. Most urban workers in Niger have jobs in the government and other services, or in business. 

Houses in rural Niger are built according to the traditions of the ethnic groups. The Hausa live in crowded villages and towns, in houses built of sun-dried mud bricks. The nomadic Tuareg live in tents made of skins or mats. The nomadic Fulani build houses out of straw and branches, and must construct new homes every time they move. The Nigerien government has built low-cost single-family houses in Niamey. Many buildings in Niamey combine Western and African designs. 

Nigeriens eat mainly grains and dairy products. Several popular dishes are made with millet and sorghum. The grains are often cooked into a porridge and served with a sauce. The nomadic Fulani and Tuareg live mainly on milk products from their herds. They also trade these products for grains and vegetables. 

Most Nigerien women wear long, wraparound skirts with short blouses and sandals. Men may wear pants or knee-length shorts with loose shirts or robes. Tuareg men wear turbans with veils. The Fulani and Tuareg, who travel in desert areas, wear long, loose robes for protection from the sun. 

Education in Niger is free, but many areas do not have schools. The government operates the public schools. Many places have Quranic schools, which teach Muslim religious knowledge. A system of "tent schools" serves the nomadic groups in the north. When a group moves, the school moves with it. Most of Niger's adults cannot read or write. For the country's literacy rate, see . 

French is the official language of Niger and is widely used in the schools. However, most Nigeriens commonly speak the language of their ethnic group, instead of French. More than 85 percent of the population understand the Hausa language, which serves as the language of trade. The language of the Djerma-Songhai ranks as the second most widely spoken language. Some Nigeriens speak Arabic. 

About 90 percent of Nigeriens are Muslims. A small percentage of urban dwellers are Christians. Some rural Nigeriens practice traditional African religions. 

The ethnic groups in Niger have produced many kinds of crafts, music, dance, and art. Craftworkers make gold and silver jewelry, pottery, leatherwork, cloth, and wood carvings. People in both urban and rural areas enjoy traditional African styles of music. Popular forms of recreation include cycling, basketball, and soccer. 

  Nigerien folk music 
 




Land and climate. Niger has an area of 489,191 square miles (1,267,000 square kilometers). Sandy plateaus and desert cover the northern two-thirds of Niger. In the center of this region, a large area of mountain ranges called the Air Mountains rises above the flat landscape. These mountains include the highest peak in Niger, Mount Greboun, which stands 6,378 feet (1,944 meters) above sea level. Less than 7 inches (17.5 centimeters) of rain falls each year in the mountains. The surrounding desert receives even less rain. Temperatures in the area can reach as high as 122 ?F (50 ?C). 

Niger's most productive zone for herding animals and growing crops is the savanna, a grassy, thinly wooded plain in the south. The savanna extends from the Niger River in the west, along Niger's southern border, to Lake Chad in the east. It is one of the hottest places in the world, with average daily temperatures in Niamey reaching 95? to 100 ?F (35? to 38 ?C). Most of Niger's rain falls in the savanna area. The city of Zinder receives about 22 inches (55 centimeters) annually. 

Niger is a landlocked nation, with no outlet to the sea. The Niger River flows for about 350 miles (563 kilometers) across the southwest corner of Niger. The river floods each January and February and provides irrigation water for growing crops along its banks. Part of Lake Chad lies in southeastern Niger. 

History. About A.D. 1000, Tuareg people began moving south from the middle of the Sahara into what is now Niger. They eventually controlled the trade routes across the desert and south to the coast. In the 1400's, a Tuareg empire grew up around the city of Agadez. 

The Songhai Empire became powerful in the 1400's. Its capital was Gao, in what is now Mali. During the 1500's, the empire conquered the Tuareg at Agadez, and controlled much of central and western Niger. In 1591, an army from Morocco captured Gao, and the empire collapsed. See Africa. 

European explorers first arrived in Niger during the early 1800's. The French occupied parts of west Africa under agreements reached in 1885 and 1890 between the various European groups. France gained control of most of Niger by 1900. It put down a strong Tuareg resistance in 1906. Niger became part of the large French territory called French West Africa in 1922. Niger gained independence from France on Aug. 3, 1960. 

Hamani Diori, the leader of the Niger Progressive Party (Parti Progressiste Nigerien, or PPN), was elected Niger's first president. In the late 1960's and early 1970's, a severe drought struck Niger, causing widespread food shortages and other problems. In 1974, a group of army officers held by Seyni Kountche overthrew Diori's government. Kountche became president of the Supreme Council (formerly called the Supreme Military Council), which held all governing power. Kountche died in 1987, and the council chose Colonel Ali Saibou to succeed him. Niger's economy suffered during the 1980's because worldwide prices of uranium declined. 

In 1992, Niger adopted a multiparty political system. Mahamane Ousmane was elected president in 1993. In January 1996, a military coup led by General Ibrahim Bare Mainassara overthrew the government. Mainassara named himself head of state. In May, voters approved a new constitution supported by Mainassara. Mainassara won a presidential election held in July, but opposition leaders claimed the election was fraudulent. In April 1999, Mainassara was assassinated, and military leaders took control of the government. In November, Niger held elections to restore civilian rule. Mamadou Tandja, the head of the National Movement of the Development Society, was elected president. 
	J One of the world's largest producers of copper. Zambia exports copper to many parts of the world and gains much income from the exports. Zambia takes its name from the Zambezi River, which forms most of the country's southern border. Victoria Falls, one of the world's most beautiful waterfalls, lies on the river. The great Kariba Dam, one of the world's largest hydroelectric projects, and Kariba Lake also are on the Zambezi River, serving both Zambia and Zimbabwe. 

Zambia was formerly a British protectorate called Northern Rhodesia. From 1953 to 1963, it formed part of the Federation of Rhodesia and Nyasaland with Nyasaland (now Malawi) and Southern Rhodesia (now Zimbabwe). Zambia became an independent nation in 1964. Lusaka is its capital and largest city. 

Government. A president serves as head of state and government and is the most powerful official in Zambia. The National Assembly, the country's legislature, consists of 150 members. The president appoints a vice president and a Cabinet to help run the day-to-day affairs of the government. The people of Zambia elect the president and the Assembly members to five-year terms. The two largest political parties in Zambia are the Movement for Multiparty Democracy (MMD) and the United National Independence Party (UNIP). The country is divided into nine provinces. Each province is administered by a minister of state. 

Most Zambians are black Africans who speak Bantu languages (see ). There are more than 70 ethnic groups represented and eight major local languages spoken in Zambia. Many people also speak English, the official language. In remote parts of the country, village life goes on much as it has for hundreds of years. The people live in circular, grass-roofed homes and raise food crops on the surrounding land. The development of mining has caused thousands of Zambians to move to mining towns. 

Corn is the main food. A favorite dish is nshima, a thick porridge made from corn. The people plant their crops in November and Dec. The majority of Zambians are Christians, but traditional local beliefs still have a strong hold on the village people. However, the use of traditional medicine, and old customs such as polygyny (marrying several wives) and bride price (paying the parents for a bride), are slowly dying out in the towns. 

Land. Most of Zambia is flat and covered with trees and bushes. It lies on a plateau about 4,000 feet (1,200 meters) above sea level. The plateau is broken by the 7,000-foot (2,100-meter) Muchinga Mountains in the northeast. In the south, the trees are smaller, and there are large open areas. The Zambezi River flows south through western Zambia and forms much of the southern border. Every year, it floods a broad, sandy plain in Western Province in the southwest. 

Because of its altitude, Zambia has a milder climate than might be expected. The hot season lasts only from September through November. Midday temperatures then range between 80 and 100 ?F (27 and 38 ?C). From November through April, Zambia has a rainy season. Violent storms flood the rivers by March. From May through August, temperatures range from 60 to 80 ?F (16 to 27 ?C). Northern Zambia gets about 50 inches (130 centimeters) of rainfall a year. The south gets 20 to 30 inches (51 to 76 centimeters). 

Zambia has no outlet to the sea. Railroads connect the country with seaports in Angola, Mozambique, and Tanzania. The railroad to Angola passes through Congo (Kinshasa), and the one to Mozambique passes through Zimbabwe. The railroad to Tanzania was built in the early 1970's with millions of dollars of aid from China. 

History. In 1851, the Scottish missionary David Livingstone crossed the Zambezi from the south. He spent nearly 20 years exploring the region. In the late 1800's, Cecil Rhodes's British South Africa Company made treaties with African chiefs in the area. In 1897, the company named the area Northern Rhodesia to distinguish it from the region south of the Zambezi, which it called Southern Rhodesia. 

In 1924, the British government took over the administration of Northern Rhodesia and appointed a governor. Copper had been mined in the area for hundreds of years. The discovery of large copper ore deposits in the late 1920's brought a rush of Europeans to the area. Ten years later, mining was an important industry. 

After World War II ended in 1945, the Europeans asked Britain for greater control of the government. Many wanted the merger of Northern Rhodesia with Southern Rhodesia. The Africans of Northern Rhodesia opposed these demands. But in 1953, Britain formed a federation of Northern Rhodesia, Southern Rhodesia, and Nyasaland. The Africans opposed the federation because the European minority controlled the government in Southern Rhodesia. Britain dissolved the federation in 1963. On Oct. 24, 1964, Northern Rhodesia became the independent nation of Zambia. Kenneth Kaunda was elected president in 1964. He was reelected in 1968, 1973, 1978, 1983, and 1988. In 1972, the UNIP became the only legal political party in Zambia. 

Southern Rhodesia came to be called Rhodesia after the federation was dissolved. In 1965, Rhodesia declaredits independence in defiance of Britain. Relations between Zambia and Rhodesia became strained because Rhodesia's white minority government refused to give the African majority a greater voice in government. 

Zambia experienced serious economic problems in the 1970's, 1980's, and 1990's. In 1973, Rhodesia prohibited Zambia from shipping goods across its territory, eliminating one of Zambia's main outlets to the sea. Rhodesia soon lifted the ban. But until 1978, Zambia refused to ship goods across Rhodesia. In 1980, blacks gained control of Rhodesia's government, and the country's name was changed to Zimbabwe. Relations then improved between Zambia and Zimbabwe. Zambia's economy also suffered from low market prices for copper and a reduction in copper ore reserves. 

Zambia legalized opposition political parties in 1990. In the multiparty elections of 1991, Frederick Chiluba, head of the MMD, was elected president. He defeated Kaunda in the election. Chiluba was reelected president in 1996. 
	+. A landlocked country in southern Africa. Most of the country is a high plateau. Zimbabwe lies in the tropics but has a pleasant climate because of the high altitude. Zimbabwe's beautiful scenery includes the famous Victoria Falls on the Zambezi River along the country's northern border. Zimbabwe is a leading mineral producer. Harare is the capital and largest city. 

Since the late 1800's, the area that is now the country of Zimbabwe has had a troubled, often violent, political history. The vast majority of Zimbabwe's people are black Africans, but whites controlled the government from about 1890 to 1979. During the last decade of white rule, black nationalists in Zimbabwe then called Rhodesia engaged in guerrilla warfare against the govt. At the same time, the nation's economy was crippled by intl trade sanctions. 
In the face of mounting opposition both at home and abroad, white Rhodesians finally agreed to hand over political power to the blacks. The first black-majority govt was elected in 1979. However, many blacks rejected this govt because they felt it was unrepresentative and that it allowed whites to retain many special privileges. 
Widespread guerrilla violence continued until late 1979, when the govt and the rebels signed a peace treaty. In return for a cease-fire, the govt agreed to hold new elections in Feb 1980. The political party of Robert Mugabe, one of the principal rebel leaders, won a large majority of votes in these elections. Mugabe then became prime minister of the independent republic of Zimbabwe. 

Government. An executive president heads Zimbabwe's govt. The exec pres is elected by the people to a six-year term. The exec pres appoints two VPs and a Cabinet to carry out govt operations. A 150-member House of Assembly is Zimbabwe's parliament. Of the members, 120 are elected by the people, 12 are appointed by the president, 8 are provincial governors, and 10 are traditional chiefs of Zimbabwe. The members of the House serve five-year terms. 
People. About 98% of Zimbabweans are blacks. About 1% are whites, 1% are Asians and Coloreds (mixed ancestry). About two-thirds of the blacks live in rural areas. Most of the whites, Asians, and Coloreds live in cities and towns. The largest black ethnic group in Zimbabwe is the Shona (often called the Mashona). The Ndebele (often called the Matabele) is the second largest group. 

The Shona speak a language called Chishona, and the Ndebele speak Sindebele. Most blacks in Zimbabwe are farmers. Most of them raise only enough food for their families. Their main crop, corn, is pounded into flour to make a dish called sadza. 

Many blacks in Zimbabwe work on commercial farms owned by whites. Since Zimbabwe became independent in 1980, the govt has worked to redistribute more farmland among black farmers. Other blacks work in cities and towns. The whites include farmers, who own most of the high veld (grasslands), and business and professional people. 

Land. Most of Zimbabwe is a high, rolling plateau from 3,000 to 5,000 ft above sea level. The High Veld, a central plateau, crosses the country from northeast to southwest. The Middle Veld lies on either side of the High Veld. The Low Veld consists of sandy plains in the Zambezi, Limpopo, and Sabi river basins. Mount Inyangani (8,514 feet) is Zimbabwe's highest point. 

Zimbabwe's summer lasts from Oct to Apr and is hot and wet. The winter, from May to Sep, is cool and dry. Temps in the country range between 54 and 85 ?F (12 and 29 ?C), and rainfall varies from 15 inches (38 cm) a year in the west to 50 inches (130 cm) in the east. The Kariba Gorge hydroelectric complex on the Zambezi is one of the world's largest. Its dam forms Kariba Lake, which covers 2,000 square miles (5,200 sq km). Its power plant supplies electric power to most of Zimbabwe. It is operated by Zimbabwe and Zambia. 

History. Ancient paintings and tools made by the San (Bushmen) people have been found in Zimbabwe. These discoveries indicate that people have lived in the region for thousands of years. By the A.D. 800's, people were mining minerals for trade. Shona people began their rule about A.D. 1000. They built a city called Zimbabwe, or Great Zimbabwe. The word zimbabwe means house of stone in the Shona language. The city's ruins lie near Masvingo. They include a tower 30 feet (9 meters) high and part of a wall 800 feet (240 meters) around. The structures were made of huge granite slabs, most of which were fitted together without mortar. 

During the 1400's, a branch of the Shona, called the Karanga, established the Mwanamutapa Empire. This empire included most of what is now Zimbabwe. At eastern African ports, the Karanga traded ivory, gold, and copper for porcelain from China and cloth and beads from India and Indonesia. 

The Rozwi, a southern Karanga group, rebelled in the late 1400's and founded the Changamire Empire. This empire became stronger than the Mwanamutapa Empire, and the Rozwi took over the city of Zimbabwe. The Rozwi built the city's largest structures. The Changamire Empire was prosperous and peaceful until Nguni people from the south defeated much of the empire in the 1830's. The city was abandoned after the fall of the Changamire Empire. 

Portuguese explorers introduced Christianity to what is now Zimbabwe in the 1500's. But few people accepted Christianity until the late 1800's. In 1888, Lobengula, the Ndebele ruler, signed an agreement that granted mineral rights in the area under his control to the British South African Co. This company was controlled by the financier Cecil Rhodes. By 1893, the British South African Company occupied most of the region. In 1895, this company named its terr Rhodesia. 

The British South Africa Company crushed black African uprisings in 1896 and 1897, and reports of gold brought more Europeans to the area. In 1897, the United Kingdom recognized Southern and Northern Rhodesia as separate territories. In 1922, the white settlers of Southern Rhodesia (now Zimbabwe) voted for self-govt, and Southern Rhodesia became a self-governing British colony in 1923. In 1953, the UK set up the Federation of Rhodesia and Nyasaland, which included Southern Rhodesia, Northern Rhodesia (now Zambia), and Nyasaland (now Malawi). 

In 1961, the UK and Southern Rhodesia approved a new constitution. But the leading black African party boycotted the first election, because it felt too few blacks could vote. Later, the govt banned two black parties, the Zimbabwe African People's Union (ZAPU) and the Zimbabwe African National Union. Both demanded a greater part in govt for blacks. 

The Federation of Rhodesia and Nyasaland was dissolved in 1963. In 1964, Northern Rhodesia became the independent nation of Zambia, and Nyasaland became independent as Malawi. Southern Rhodesia became known as Rhodesia. Its govt demanded independence in 1964. The UK declared that Rhodesia must first guarantee the black majority a greater voice in the govt. Rhodesian talks with the UK finally broke down. On Nov 11 1965, Prime Minister Ian Smith declared Rhodesia independent.

The United Kingdom called Rhodesia's action illegal and banned all trade with Rhodesia. Rhodesia rejected British proposals for a settlement. In 1966, the UN imposed economic sanctions against Rhodesia. Most countries then stopped or reduced their trade with Rhodesia. 

In 1969, Rhodesian voters mostly whites approved a new constitution designed to prevent the black African majority from ever gaining control of the govt. The Constitution took effect in 1970. Rhodesia declared itself a republic on Mar 2 1970. But no country recognized its independent status. Led by the UN, many countries continued to apply political and economic pressure to end white rule in Rhodesia. 

In 1971, the UK and Rhodesia reached an agreement that included provisions to gradually increase black reps in the govt. But most Rhodesian blacks opposed the pact, and it did not take effect. In the early 1970's, fighting erupted between govt troops and black guerrillas in Rhodesia. In 1974, the two sides agreed to a cease-fire. 

In 1976, fighting again broke out between Rhodesian government troops and black guerrillas. Mozambique and other black African nations joined in the demand for an end of white rule in Rhodesia. Clashes between Rhodesian government troops and troops of Mozambique broke out near the border between the countries. 

In the late 1970's, Rhodesia's white rulers, led by Prime Minister Smith, began making plans to establish a new government with a majority of black leaders. In 1978, the whites reached an agreement with conservative black leaders to form a government. Voting procedures were changed to allow all people 18 years old or over to vote. Previously, strict economic and educational requirements had prevented most blacks from voting.

Elections in April 1979 resulted in a government with a majority of black leaders. Abel T. Muzorewa, a Methodist bishop, became the first black prime minister. But many blacks rejected the new government as unrepresentative, and no other country officially recognized it. 

Widespread fighting between black guerrillas and the govt went on until Sep 1979, when the UK arranged a peace settlement between the govt and the rebels. Both sides finally agreed to the formation of a new govt. In elections held in February 1980, the Zimbabwe African National Union-Patriotic Front (ZANU-PF) party won a majority of the seats in the House of Assembly. Robert Mugabe, the party's leader, became prime minister. On Apr 18, 1980, the UK recognized the country's independence, and Rhodesia's name was officially changed to Zimbabwe. 

Most countries and the United Nations soon recognized the new govt and lifted the remaining trade sanctions against the nation. After the blacks gained control of the govt, many whites left the country. 

In 1981, fighting broke out in SW Zimbabwe between the national army and guerrilla forces formerly aligned with ZAPU. Some members of ZAPU claimed their party did not receive a fair share of power after the country gained independence. In 1982, Prime Minister Mugabe dismissed ZAPU leader Joshua Nkomo from his Cabinet. Clashes between the guerrilla groups and the army continued until early 1984. By that time, the army had put down most of the rebellion. 

Mugabe's party won the 1985 national elections. In 1987, the office of prime minister was abolished. The office of executive president was created to replace it as the highest government post. Parliament elected Mugabe to the new office. Negotiations begun in 1986 between Mugabe's ZANU-PF and Nkomo's ZAPU led the parties to formally merge in 1989. The new party uses the name ZANU-PF. In 1990 and 1996, the voters reelected Mugabe executive president. 

In a referendum held in February 2000, Zimbabwe's voters rejected a new constitution that had been supported by Mugabe and ZANU-PF. Among the changes included in the new constitution were provisions that would have increased the powers of the presidency. The new constitution also called for the redistribution of white-owned farmland to blacks. 

Shortly after the referendum was defeated, a number of supporters of Mugabe began squatting on white-owned farms. Mugabe encouraged the squatters, and their numbers grew. By mid-April, an estimated 60,000 squatters, many of whom were veterans of Zimbabwe's war of independence, had occupied hundreds of farms and attacked the landowners, forcing many to flee. 

In May, Mugabe signed into law a constitutional amendment that allowed the government to seize white-owned land without paying compensation. The amendment called on the United Kingdom, as the former colonial ruler of Zimbabwe, to compensate landowners. 
	k( is a small country in SE Africa. It is about 520 mi long and from 50 to 100 miles (80 to 160 km) wide. Malawi lies on the western shore of Lake Nyasa, called Lake Malawi in that country. Ancient volcanic activity left Malawi with rich soil. But only about 1/3 of the land is suitable for agriculture because mountains forests, and rough pastures cover most of the country. 

The country takes its name from the Malawi, or Maravi, kingdom, which was established by local people during the 1500's. Once the British protectorate of Nyasaland, Malawi became an independent country in 1964. Lilongwe is the capital of Malawi, and Blantyre is the commercial center and largest city. 

People. Most of Malawi's people are black Africans. The country also has some Europeans, Asians, and people of mixed origin. Most Malawians live in small villages. Houses in most villages are round and have mud walls and thatched roofs. The largest ethnic groups in Malawai are the Chewa (Cewa), Lomwe, Ngoni (Angoni), Nyanja, Sena, Tonga, Tumbuka, and Yao. 

Most Malawians are farmers, and most of them raise only enough food for their families. Their main crop, corn, is pounded into flour to make a thick porridge called nsima. Many Malawians, primarily men, work on estates where tea or tobacco is grown. Traditionally, women have raised food crops and men raised crops for sale, but this situation is changing. 

Some ethnic groups in Malawi determine family descent through the mother, and new households are established near their mother or relatives of the mother. However, other ethnic groups in Malawi trace descent through the father, as in most Western cultures. 

English and Chichewa are Malawi's official languages. Chichewa is the most widely spoken language of central and southern Malawi, but ChiYao are also spoken in those areas. ChiTumbuka and ChiTonga are the main languages spoken in northern Malawi. 

About 75% of Malawi's people are Christians, and about 20% are Muslims. Many of the people practice traditional religions. The country also has a number of Hindus. 

Most of Malawi's school-age children attend primary school, and an increasing number now go on to secondary school. The University of Malawi is in Zomba. It has branch colleges or institutes in other cities. 

Land. Malawi is a land of great scenic beauty. Grassland and savanna (areas of coarse grass and trees) cover much of the land. The Great Rift Valley runs the length of Malawi from north to south. Lake Nyasa fills most of the valley. It is 1,550 feet (472 meters) above sea level. The Shire River flows out of the lake's southern end to the Zambezi River. West of the lake, the land rises steeply to a plateau about 4,000 feet (1,200 meters) above sea level. Malawi's highest mountain, Sapitwa (9,843 feet, or 3,000 meters), rises on a plateau southeast of the Shire River. 

The lowlands in the Shire Valley and along the lake have a hot, humid, tropical climate. The temperature in this area averages from 74 to 78 ?F (23 to 26 ?C). The plateaus are much cooler. They average about 58 ?F (14 ?C) in higher areas and about 65 ?F (18 ?C) in lower areas. The northern parts of the country average about 70 inches (180 centimeters) of rainfall a year. The southwestern parts average only 30 inches (76 centimeters) a year. 

Economy. Malawi is an extremely poor country. Its economy is based on agriculture, but only about a third of the land is suitable for farming. The most important export crop is tobacco. However, because of the decline of smoking in the United States and certain other countries, tobacco profits have been falling in Malawi. Another major export crop is tea, which is grown on European-owned estates in the highlands. Other important crops include sorghum, sugar cane, cotton, corn, and peanuts. A large number of farmers raise livestock. 

Schistosomiasis - A fresh-water parasitic flatworm that causes this disease uses fresh-water snails as the inter- mediate host. The snails release larvae into the water, and these enter humans through the skin in 30 seconds to 10 mins. There may be no symptoms initially; if there are, those exposed for the first time may have fever, chills, cough, diarrhea, weakness and headaches. But many people who get a chronic form, with involvement of the lungs, liver, intestines and bladder, may recall no acute symptoms after exposure. Do not swim in Malawi lakes.

Fishing on Lake Nyasa is an important industry and source of food. The country's few manufacturing industries produce bricks, cement, cotton goods, processed foods, and other products. Valuable hardwood forests cover northwestern Malawi, but high transportation costs for trucks to reach these remote areas have prevented the forest industry from fully developing. 

Malawi has over 7,000 miles (11,000 kilometers) of roads. However, only about 500 miles (800 kilometers) of the roads are paved. A main road runs the length of the country, and Malawi has roads linking it with Mozambique, Tanzania, Zambia. A railroad in the Shire Valley connects Malawi with the Mozambique port of Beira on the Indian Ocean. Airports in Lilongwe and Blantyre provide air service to eastern and southern Africa. 

History. Bantu-speaking people began living in Malawi about 2,000 years ago. They formed kingdoms as well as smaller political groups. In the 1830's, two other Bantu groups, the Ngoni and Yao, invaded the area. The Yao were slave traders who sold slaves to the Arabs along the eastern coast of Africa. 

The British missionary David Livingstone reached the area in 1859. He found it torn by local wars, and saw the suffering the slave traders caused. Livingstone called for "Christianity, commerce, and civilization" to bring peace to the area. In 1875, the Free Church of Scotland set up a mission that later became an important religious center. Scottish businessmen formed the African Lakes Corporation three years later to introduce lawful business instead of the slave trade. In 1889, the British made treaties with the local chiefs on the western shore of Lake Nyasa. Two years later, Britain proclaimed the territory as the Protectorate of Nyasaland. 

In 1953, the British made the protectorate part of a federation with Northern and Southern Rhodesia, the Fede- ration of Rhodesia and Nyasaland. The Africans living there opposed the creation of the federation, and protes- ted strongly against it. In 1958, Hastings Kamuzu Banda, a physician educated in the United States, became the leader of an independence movement in the protectorate. In Jul 1964, the protectorate gained independence as the nation of Malawi. 

In 1966, Malawi adopted a one-party system of government. The Malawi Congress Party became the only political party, and Banda was declared president. A constitutional amendment was passed in 1970 to make Banda pres for life. He assumed that title in 1971. In 1993, foll widespread protests against Banda's govt, the amendment was repealed, and Malawi's people voted for a multiparty system. In 1994, Bakili Muluzi, leader of the United Democratic Front Party, became pres after he defeated Banda in a multiparty election. In 1995, Malawi adopted a new constitution. Muluzi was reelected pres in 1999. 

	c" A small country on the NE coast of Africa stretching along the Red Sea between Sudan and Djibouti. Ethiopia lies to the south. Most of Eritrea's people are farmers or herders. The country has little industry. Asmara is Eritrea's capital and largest city. 

The country's official name is the State of Eritrea. It was once a part of the Aksum Kingdom that reached its height as a trading and cultural center between the years 300-600 AD. Italy gained control of Eritrea in the late 1800's. The UK took over the region in 41, during WW II. In 1952, Eritrea became part of Ethiopia. 

Land/climate. Eritrea covers 45,405 sq mi. It stretches along the Red Sea from Cape Kasar to the Strait of Bab el Mandeba distance of about 620 mi (1000 km). A coastal plain along the Red Sea ranges from 10-40 mi in width. The plain rises to highlands in the central part of Eritrea. Mt Soira, in the highlands, is the country's highest peak. It rises 9,885 ft above sea level. The highlands drop to lowlands in the west. Denakil Desert covers the SE part of the country. 

The country's main rivers flow westward, cutting valleys through the central highlands and western lowlands. The main rivers of Eritrea include the Baraka and the Gash. The Gash is called the Marab for part of its length. 

Temps aver 80F (27C) along the coast and 60F (16 C) in the highlands. The coast receives about 6-10 in (15-25 cm) of rain a year, and the highlands receive up to 24 in (61 cm). In most parts of the country, the heaviest rains occur in Jun-Jul. 

People. Most Eritreans are descendants of people from the Arabian Peninsula and from the Nile River region of Sudan who came to the area starting about 2000 B.C. Tigrinya is Eritrea's chief language. Tigre is the second most common language. Arabic is spoken on the coast. Groups of herders speak Afar or other languages. 

About 80% of the people of Eritrea are farmers or herders. Farming families live in walled or fenced settlements. The homes have flat thatched roofs or peaked roofs made of corrugated iron. Most farm households consist of an extended family that may include up to several dozen relatives. Farmers meet for occasional market days, festivals, or at regional village towns. Herders move from place to place with their livestock. 

About half the Eritreans are Christians. Most of the others, including many herders, are Muslims. Coptic Christianity, a form of Christianity that originated in Egypt, was brought to the country in the A.D. 300's. Islam came to Eritrea in the 600's. 

In 1961, civil war broke out between Eritrean rebels, who wanted independence for their land, and Ethiopian government troops. The war finally ended in 1991, with a victory by Eritrean and other rebels. Eritrea formally achieved independence in 1993. 

History. About 2000 B.C., people from the interior of Africa settled in what is now Eritrea. About 1000 B.C., people began arriving from the Arabian Peninsula. The Aksum Kingdom became the first important state in the area. The kingdom gained importance about A.D. 50 and reached its greatest power between the 300's and 600's. During the 600's, Muslims gained control of the area. 

The coastal region of Eritrea came under the rule of the Ottoman Empire in the 1500's. About the same time, kingdoms from what are now Ethiopia and Sudan fought over the rest of Eritrea. In the 1800's, Egypt, France, and Italy attempted to gain control of Eritrea. 

In 1882, Italy occupied the port of Assab. In 1885, it occupied the port of Massawa and other regions along the coast. By 1889, Italy had conquered all of Eritrea. Italy used Massawa as a base for an invasion of Ethiopia. Ethiopian Emperor Menelik II defeated the Italian forces in 1896. But Italy conquered Ethiopia in 1935. During the period that Eritrea was under Italy's control, the Italian government invested in agricultural plantations and established a number of industries. About 60,000 Italians settled in Eritrea. 

British forces drove the Italians out of Africa in 1941, during WW II. A British military admin then began governing Eritrea. In 1950, the UN Gen Assbly adopted a res that Eritrea become part of Ethiopia, but govern itself. The res was put into effect in 1952. 

The Ethiopian govt, led by Emperor Haile Selassie, sought to undermine Eritrea's self-govt by banning political parties and trade unions in Eritrea. But the Eritreans started a political movement called the Eritrean Liberation Front (ELF). In 1961, civil war broke out between the ELF and the Ethiopian govt. In 1962, Ethiopia declared Eritrea to be a province of Ethiopia. 

In 1970, the Eritrean People's Liberation Front (EPLF) was formed. The EPLF gradually replaced the ELF as Eritrea's main political org. In 1974, Ethiopian military leaders removed Haile Selassie from power. They set up a govt called the Dergue. The EPLF tried to negotiate with the Dergue for Eritrean independence. But the talks failed, and the civil war continued. In 1987 and 1988, victories against Ethiopian govt forces by EPLF forces and forces from the Tigre region, south of Eritrea, led to a collapse of central govt rule throughout much of Ethiopia. 

In 91, Eritrean rebels joined with a group of rebels led by Tigreans to overthrow Ethiopia's govt. The rebel group led by Tigreans est a new govt for all of Ethiopia except Eritrea. The Eritreans formed their own govt. They formally declared independence from Ethiopia on May 24 93, after a referendum in favor of independence. Eritrea adopted a new constitution in 1997. 

When Eritrea achieved independence, a section of the border with Ethiopia had not been clearly defined. Eritrea and Ethiopia fought a bloody war over this disputed area from May 1998 to Jun 2000, when the two sides signed a cease-fire agreement. They signed a formal peace treaty in Dec 2000. The treaty included a provision that established a commission to identify the border between the two countries. 
	-/ A small country in east-central Africa, just south of the equator. It is one of the most crowded African countries and one of the continent's poorest countries. It has little industry and more people than the land can support. Kigali is Rwanda's capital and largest city. 

Although Rwanda is near the equator, it has a cool, pleasant climate. This is because it lies on a series of high plateaus. Rwanda's landscape ranges from volcanic mountains to winding river valleys, and from beautiful lakes to grassy plains. Volcanoes National Park in the Virunga Mountains of northwestern Rwanda is a refuge for mountain gorillas, an endangered species. 

Rwanda once formed the Ruanda, or northern half, of Ruanda-Urundi, a United Nations (UN) trust territory administered by Belgium. What is now Burundi formed the Urundi, or southern half. In 1962, the two parts became the independent nations of Rwanda and Burundi. 

A large majority of Rwanda's people belong to the Hutu (also called Bahutu) ethnic group. The Tutsi (also called the Batutsi or Watusi) form a minority of the population. The Tutsi dominated the Hutu politically and economically for hundreds of years. In 1959, the Hutu rebelled against the Tutsi. After a period of bloody fighting, the Hutu gained control of the government and the economy. Another major bloody conflict between the two groups took place in 1994, and the Tutsi gained control of the government. See the History section of this article for details. 

People. About 90 percent of Rwanda's people belong to the Hutu ethnic group. Most Hutu are farmers who raise crops tofeed their families. Some of them also raise cattle or grow coffee, Rwanda's chief export. Other Hutu work in Rwanda's towns. Many Hutu have left Rwanda for jobs in nearby countries. About 5 percent of the Rwandese people belong to the Tutsi ethnic group. Most Tutsi work in businesses or government agencies. 

Pygmies make up less than 1 percent of Rwanda's population. They once made their living by hunting, but some now live and work in the towns. Only a few Europeans live in Rwanda. Some are farmers who raise tea and pyrethrum, which is used in making insecticides. A few are executives in the mining industry. Others are Christian missionaries. 

English, French, Kinyarwanda, and Swahili are the official languages. Most of the people speak Kinyarwanda, a Bantu language. Most of the people are Roman Catholics. A small percentage practices traditional African religions. The Roman Catholic and other Christian churches operate most of the elementary and high schools. The National University of Rwanda operates in Butare. Public education is free and compulsory for children from 7 through 15 years of age, but there are not enough classrooms to accommodate all the children. Many adult Rwandese cannot read and write. For the country's literacy rate, see . 

Land. Much of Rwanda's land is rugged and mountainous. The highest mountains, in the west and northwest, were formed by volcanoes. Lake Kivu and the Rusizi River form Rwanda's western border and are part of Africa's Great Rift Valley. The Kagera River forms the eastern border, and the Akanyaru River forms part of the southern border. The land rises sharply from Lake Kivu to about 9,000 feet (2,700 meters) above sea level. The Virunga Mountains rise to about 14,800 feet (4,510 meters) in the northwest. Heavy rainfall in western Rwanda has leached (washed away) chemicals that enrich soil. 

A series of plateaus in eastern Rwanda range from 5,000 to 7,000 feet (1,500 to 2,100 meters) above sea level and slope down toward the east. Each one is bounded on the east by an escarpment (steep edge) with a marsh at its foot. Forests once covered the plateaus, but most of this land has been cleared for farming. 

The Great Rift Valley areas in the west have an average annual temperature of 73 ?F (23 ?C) and an average annual rainfall of 30 inches (76 centimeters). The mountainous areas in the west have an average annual temperature of 63 ?F (17 ?C) and an average annual rainfall of 58 inches (147 centimeters). On the plateaus, the temperature averages 68 ?F (20 ?C) annually. Annual rainfall is about 47 inches (119 centimeters). 

History. What is now Rwanda was first inhabited by Hutu farmers and Pygmy hunters. Sometime during the 1300's or 1400's, the Tutsi, a warrior people with large herds of big-horned cattle, invaded the area from the north. The Hutu could not defeat the Tutsi, and so each Hutu agreed to serve a Tutsi "lord." The Tutsi agreed to protect the Hutu and allow them the use of some cattle. In this way, the Tutsi dominated the area. 

Germany conquered the area that is now Rwanda and Burundi in 1897. It ruled this area as part of German East Africa. Belgian troops occupied the area, then called Ruanda-Urundi, in 1916, during World War I. Germany lost its African colonies after the war. Ruanda-Urundi became a mandated territory under Belgian administration in 1923 (see ). In 1946, it became a UN trust territory administered by Belgium. 

Political unrest followed the death of Mwami (King) Mutara III in 1959. The Hutu rebelled against the Tutsi. Fighting between the Hutu and Tutsi resulted in about 150,000 deaths. The Tutsi suffered the heaviest casualties. During and after the rebellion, about 150,000 Tutsi fled to Burundi and other neighboring countries. 

Elections held in 1960 gave the Hutu control of the government. In 1961, the people of Ruanda voted to make their country a republic. Ruanda-Urundi became independent as two countries, Rwanda and Burundi, on July 1, 1962. The people of Rwanda then elected Hutu leader Gregoire Kayibanda as the first president. They reelected him in 1965 and 1969. In 1973, military leaders led by Major General Juvenal Habyarimana, a Hutu, overthrew Kayibanda and took control of the government. Habyarimana declared himself president. A new Constitution, which established a one-party political system, was adopted in 1978. Habyarimana was elected president in 1978 and reelected in 1983 and 1988. 

In 1991, the government changed the Constitution to allow for a multiparty political system. In 1990, Rwandese rebels, called the Rwandan Patriotic Front (RPF), had launched attacks against Rwanda's government. Most of the rebels were Tutsis, who had been living in exile in Uganda. Fighting increased in the early 1990's. 

In August 1993, the government and the RPF signed a peace treaty. In April 1994, Habyarimana was killed in an airplane crash. Extremist Hutu militias broke the peace. They killed up to 500,000 people, mostly Tutsi. A Hutu-dominated government was formed, but the Tutsi-dominated RPF refused to recognize it. By mid-July, the RPF had defeated the Hutu forces. The RPF took control of the government. But it appointed a multiparty government, including some moderate Hutu officials. About 2 million refugees, mostly Hutus, left Rwanda to escape RPF forces during the fighting. The majority of them went to the area near the town of Goma, Zaire. Tens of thousands of the refugees died from cholera and other diseases, or from starvation. 

In 1996 and 1997, Zairian rebels overturned the govt of Zaire and renamed the country the Democratic Republic of Congo. The fighting forced the Rwandan refugees from the camps. Many returned to Rwanda, but some fled deeper into Congo or to neighboring countries. 

--------------------------------------------------------- Rwandas population has traditionally been composed of Hutu,Tusi and Twa peoples. however, civil stife at independence and genocidal civil warin 1994 have altered these percentages. the 1991 offical cenus estimated the countrys population at 7,164,995. Talking 
into consideration Rwandas growth rate, the population in 1996 should have been between 7.8 
and 8 million people, but it is estimated that less than 5.5 to 6 million people were living in 
Rwanda in late 1995. 

Rwandas people speak a common language, Kinyarwanda, and share many cultural 
traditions. More than half of the population is estimated to be Roman Catholic and another 5 to 
10% Protestant Crisitan. Probaly 30% or more hold traditional beliefs. There is a small Muslium 
minority. 
Traditionally, Rwanda has been Africas least urban country ,although migration to the 
capital, Kigali,and provincial towns such as Ruhengeri,Butare,and Gisenyi incerased thoughout 
the 1980s and the early1990s. Prior to 1994 it eas also the most densly populated rural county in 
the world, with more than 2,110 persons per sq./km. 
Education is free and officially compulsory for childern between ages 7 to 15, but 
Rwandas school system was virtually destroyed during the civil war . Most hospitals, including 
the university of Rwanda, remained closed in 1995. Most hospitals were ethier closed or without 
adequate supplies or medical personnel. 

History 

Hutu agriculturalists migrated into what is now Rwanda during the 7th to 10th centuries 
AD, followed by pastoral Tutsi between the 14th nd 16th centuries. A feudal monarchy 
developed that remained in existence for centuries before Rwanda was absorbed into German east 
Africa in 1899. Belgium occupied the area in 1916 and controlled what are now Rwanda and 
Burundi until Rwanda gained its independence. 
Before European occupation, the kingdom of Rwanda was a somewhat flexible hierarchy 
with a tutsi king and elitre dominating the majority Hutu farmers and small Tutsi underclass, 
although social mobility and intermarriage blurred the distintions between the groups. the Twa 
were at the very bottom of the social order. Both the Germans and the Belgians retained the 
monarchy administer the colony. This arrangement gave th Tusi access to power and economic 
resouces and intensified ethnic and class divisions. In the 1940s, however, many Tusti were 
driven from Rwanda by the Belgians for advocating independence. The moderate Tusi King 
Kigari V, who had ruled for nearly three decades, died in 1959, and more ethnocentric Tutsi 
seized power. This contributed to a series of rebellions by Hutu demanding equal rights in which 
tens of thousands of Tutsi perished. In 1991, with the support of the belgian colonist, the Huntu 
majority took control of the government, abolishied the Tutsi monochary, and declared Rwanda a 
republic. Rwandan independence was not internationally reconized until July 1,1962, when 
Rwanda and Burundi formally gained independence as seperate countries. 

Government 

Under it original constitution, Rwandas government consisted of an elected president and 
a legislature, the National Assembly. The coutrys first president was Gregoire Kayibanda. He 
was overthown by the military in 1973, and General Juvenal Habyalimama became president. The 
National Assembly was suspended. This was annouced as the first step toward new legislative 
elections. 

Economy 

Most of Rwandass people are farmers, growing only enough food for thier own use. 
Food crops include bananas,cassava, sorghum, and millet. Coffee grown on large plantationsis 
the nations chief exporter. Other important commercial crops are cotton, tea, and pyrethrum. 
Cattle,goats,and sheep are raised. 
Rwanda has litte industry . Funiture,soap,bricks, and shoes are made for use in the country. 
Some tin and gold are mined for export. But poor transportation makes mining difficult. Some 
Rwandese work in the copper mines of the neighboring Zaire. 
	
4 Somalia is a nation in eastern Africa. It is situated on the coast of the Indian Ocean and the Gulf of Aden, along the projection land known as the Horn of Africa. The region was famed in ancient times for its frankincense and myrrh, fragrant substances derived from trees. Modern Somalia came into being in 1960, with the union of the former colonies of British and Italian Somaliland. 

THE PEOPLE - The Somalis are thought to be descended from African and Arab peoples. Almost all speak the Somali language and practice the Muslim religion. Somalis have ethnic ties with peoples in neighboring Djibouti and in the Eritrea and Ogaden regions of Ethiopia. In addition to Somali, the official language, Arabic and some Italian and English are also spoken.(Somalia. Helen Metz. 1992). 
The majority of Somalis are nomadic or seminomadic herders of livestock, who travel long distances seeking pasture and water for their animals. About 25 percent of the population are settled farmers, who cultivate the limited areas of fertile soil. Their struggle for existence in an often inhospitable land has made the Somalis a strong and proudly independent people. (Africa Today. Raph Uwechue. 1991). 

THE LAND 
The far northern part of Somalia consists of hills and low mountains, which reach a height of about 8,000 feet. To the south and west is aregion of low plateaus. The chief rivers are the Webi Shebeli and the Juba. The land between them is the country's chief farming region. The southwestern part of Somalia is largely savanna, or grassland. 
About 25 percent of Somalia's total land is considered to be desert. Only about 13 percent is suitable for farming. Most of the rest is used for graze livestock. 
The climate is generally hot and dry. Average temperatures range from 75 to 88 degrees farinheit. Rainfall is often scarce and drought is a common occurrence. (Africa South of the Sahara. James Bennett. 1996). 
THE ECONOMY. 
Somalia's economy is based on livestock raising. Agriculture is second in importance. The raising of cattle, camels, sheep, and goats is the main occupation in the north. Bananas are the most important commercial crop grown. Exports of live animals, meat, and meat products, hides and skins, and bananas are the principal source of Somalia's income. The major food crops are corn, sorghum, rice, and beans. 
Somalia also grows sugarcane and is one of the world's few producers of frankincense and myrrh, used in making incense and some perfumes. Industry is limited. The chief manufactured products include refined sugar, canned meat and fish, and other processed foods, leather, and textiles. (Somalia. Helen Metz. 1992). 
HISTORY AND GOVERNMENT. 
Somalia was known to the ancient Egyptians for its sweet incense. Arabs arrived from the mainland of Asia in the 10th century, settling mainly along the coast. Large-scale European colonization of the region gegan in the late 19th century. The British established themselves in the north, in what became British Somaliland. the Italians established themselves in the south, which became Italian Somaliland. 
Britain gained control of Italian Somaliland in 1941, during the World War II. The region later became a trust territory of the United Nations. British Somaliland won independence on June 26, 1960. On July 1, 1960, it joined with the former territory of Italian Somililand to create the independent nation of Somalia. (Somalia. Helen Metz. 1992). 
	B A country on the west coast of Africa. It has a varied landscape, including mountains in the west, grasslands in the north, and tropical lowlands in the south. The people of Cameroon belong to about 200 ethnic groups. Yaounde is the country's capital, and Douala is its largest city. 

Govt. A president heads the national government of Cameroon. This official holds the most power in the government. A 180-member National Assembly makes the country's laws. The president and the Assembly members are elected to five-year terms by the people. The president appoints the prime minister, Cabinet members, and other officials to help carry out the functions of the government. Cameroon's chief political party is the Cameroon People's Democratic Assembly. Cameroon is divided into 10 provinces, each headed by a governor appointed by the president. 

People. Cameroon's largest ethnic groups are the Bamileke, who live in the western region, and the Fulani, who live in the north. The Douala, the Ewondo, and the Fang inhabit the southern and central regions of Cameroon. English and French are Cameroon's official languages, but most Cameroonians speak one of the country's 54 African languages. About 45 percent of the people practice traditional African religions. About 35 percent are Christians. About 20 percent are Muslims. 

Most of Cameroon's rural people are farmers, but some are herders. The majority of the rural people live in villages or small towns. Manufacturing and service industries provide jobs in Cameroon's urban areas. Each year, large numbers of rural people move to urban areas to seek jobs. Douala and Yaounde, the chief cities in Cameroon, have elegant hotels, fine office buildings, and fashionable modern houses. But these cities also have areas in which many people live in slumlike conditions. The cities face the problem of accommodating the many rural people who move to the cities. 

Most houses in the northern towns and villages are round clay huts or rectangular brick houses. Northern herders, who move from place to place, build light shelters from poles and woven mats. Most houses in the western mountainous region are square brick structures. Typical homes in the southern forest region are rectangular houses made of wood, palm leaves, and clay. Along the coast, people build wooden houses covered with tree bark or with sheets of metal. In the larger cities, many people live in modern houses and apartment buildings. But others in the cities live in shacks. 

The government operates free public schools and universities, and gives financial aid to private schools. But Cameroon has shortages of schools and teachers, and many children do not attend school. More than half of the nation's adults can read and write. For Cameroon's literacy rate, see . Artists in Cameroon are known for their woodcarving and brass masks. Some of the finest Cameroonian art is produced by the Bamileke and Bamoun peoples, who live in the Western Highlands. 

Land and climate. Mountains and hills lie along Cameroon's western border, from Lake Chad in the north to Mount Cameroon in the south near the coast. Mount Cameroon, at 13,353 feet (4,070 meters), is the country's highest point. A forested plateau in central Cameroon separates a savanna (grassland with scattered trees) in the north from tropical lowlands along the coast of the Gulf of Guinea in the south. Waza National Park in the north preserves an area of savanna inhabited by many animals, including elephants, giraffes, monkeys, and antelope. Cameroon has three main rivers, the Benue, the Wouri, and the Sanaga. 

Cameroon's northern savanna region is hot and dry most of the year. The average temperature is about 82 ?F (28 ?C), but daytime temperatures sometimes reach 120 ?F (49 ?C). The central plateau is cooler, with an average temperature of about 75 ?F (24 ?C). The coastal region is hot and humid. Some places there receive up to 200 inches (500 centimeters) of rain a year, and the average temperature is about 80 ?F (27 ?C). 

Most of Cameroon's roads are unpaved. Railroads link the larger cities and towns of the country. International airports in Cameroon are located at Douala, Garoua, and Yaounde. 
Cameroon has one daily newspaper. Radio and television are controlled by the government. 

History. Stone tools and rock carvings found in Cameroon indicate that prehistoric people lived in the area. Bantu-speaking people were one of the earliest identified groups to settle in Cameroon. They lived in the northern highlands hundreds of years before Christ. A state called Kanem that developed about A.D. 800 extended into present-day Cameroon. 

In the late 1400's, Portuguese explorers became the first Europeans to reach Cameroon. The country's name comes from camaroes, the Portuguese word for shrimp. The Portuguese had found small crayfish that looked like shrimp in the Wouri River. From the late 1400's to the late 1800's, other Europeans flocked to the area. Many of them went to Cameroon to participate in the flourishing slave trade there. The United Kingdom abolished its slave trade in 1807, and many other European nations did so in the early 1800's. Ivory and palm oil became the major trade products after the slave trade ended. In 1858, British missionaries established Victoria, the first permanent European settlement in Cameroon, at the base of Mount Cameroon. 

In the late 1800's, three European countriesthe United Kingdom, France, and Germanystruggled for control of Cameroon. In 1884, two local Douala chiefs signed a treaty with Germany that made Cameroon a German protectorate (protected state). Germany lost control of Cameroon to the United Kingdom and France during World War I (1914-1918). In 1922, the United Kingdom and France divided Cameroon into two sections. The British section included two separated parts along the western border. Called British Cameroons, the sections made up about one-fifth of Cameroon. The other four-fifths came under the control of France and was called French Cameroun. Each section was governed according to the laws of the ruling country and adopted the ruling country's language as the official one. In 1946, the United Kingdom and France pledged to eventually give their parts of Cameroon self-government or independence. 

On Jan. 1, 1960, French Cameroun became the independent Republic of Cameroon. In an election in February 1961, the people in the two parts of British Cameroons were given the choice of joining their territory with the new Republic of Cameroon or with neighboring Nigeria. Voters in the northern part chose to join Nigeria, and their area became part of that country on June 1, 1961. Voters in the southern part chose to join the Republic of Cameroon. This union took place on Oct. 1, 1961. From then until early 1972, Cameroon operated as a federation of two statesEast Cameroon and West Cameroon. Then in May 1972, Cameroon adopted a new constitution that united the two separate states. 

Until 1991, only one political partythe Cameroon People's Democratic Assemblywas allowed in Cameroon. In 1991, political parties were legalized. In March 1992, Cameroon held its first multiparty elections\	J A large country in the heart of Africa. A narrow strip of Congo borders the Atlantic Ocean. But most of the country lies deep in the interior of Africa, slightly south of the center of the continent. The equator runs through northern Congo. One of the world's largest and thickest tropical rain forests covers about a third of Congo. The mighty Congo River flows through the forest and is one of the country's chief means of transportation. Many kinds of wild animals live in Congo. 

Most of Congo's people are farmers and live in small rural villages. But each year, many villagers move to the cities. Kinshasa is Congo's capital and largest city. Belgians ruled Congo from 1885 until it became an independent nation in 1960. The nation was known as Zaire from 1971 to 1997. That year, rebels seized power and restored the name Congo. The country is called Congo (Kinshasa) to distinguish it from neighboring Congo (Brazzaville). Its full name in French, the official language, is Republique Democratique du Congo (Democratic Republic of the Congo). 

Europeans greatly influenced Congo's economic and cultural life up to the time of independence. Congo's people are divided into a large number of different ethnic groups, and the country has faced severe economic problems. 

National government. From 1965 until the early 1990's, President Mobutu Sese Seko ruled the nation as a dictator. In 1997, rebels overthrew Mobutu, and he fled the country. Rebel leader Laurent Kabila declared himself president and formed a transitional government. As president, Kabila is head of state and head of the government. He controls all legislative authority and issues laws by decree. A cabinet appointed by Kabila assists him in the day-to-day running of the country. Kabila's political party, the Alliance of Democratic Forces for the liberation of Congo-Zaire, is Congo's only legal party. 

Local government. The country is divided into 10 provinces, plus the separate city of Kinshasa, for purposes of local government. A governor and deputy governor appointed by the president administer each of the provinces. 

People - Ancestry. Most of Congo's people are descendants of people who began moving to the area from other parts of Africa at least 2,000 years ago. At that time, other African peoples, including a Pygmy group called the Babuti, lived in what is now Congo. The Babuti, like other Pygmy groups, are known for their small size. Today, Congo's people belong to many different ethnic groups. At times, conflicts between the ethnic groups have flared up. At other times, they have had peaceful relations. 

Languages. Most of Congo's ethnic groups have their own local language. About 200 local languages are spoken in the country. Most of these local languages belong to the Bantu language group and are closely related (see ). Most Congolese also speak at least one of the country's four national languagesKikongo, Lingala, Swahili (also known as Kiswahili), and Tshiluba. French is Congo's official language. Before the overthrow of Mobutu, government officials often used French in their work, and many of the country's students learned it in school. 

Way of life. Most rural Congolese live in small villages that range in size from a few dozen to a few hundred people. The vast majority of village families farm a small plot of land. They raise almost all their own food, including cassava, corn, and rice. Some rural people also catch fish. Few families can afford farm machinery, and so most use hand tools. As a result, farm production is low, and most farm families are poor. 

After 1960, large numbers of Congoleseespecially young peoplemoved from rural areas to cities. These people were attracted to the cities by the opportunity for jobs in business, industry, and government. The rapid growth of the cities led to such problems as unemployment and crowded living conditions. In addition, many of the people who have jobs earn low wages and find it difficult to support themselves and their families. During Belgian rule, few Congolese women received more than a few years of education or held a job outside the home. After independence, the government increased educational and job opportunities for women. 

Housing. Most rural Congolese live in houses made from mud bricks or dried mud and sticks. The majority of the houses have thatched roofs. The houses of some well-to-do rural families have metal roofs.  In Congo's cities, business managers and merchantsas well as many Europeanslive in attractive bungalows. But many factory and office workers live in crowded areas of small, cheap houses and apartments made from cinder blocks or baked mud bricks. 

Clothing. After independence, most Congolese men who held important jobs adopted a kind of national costume. They wore trousers with a matching collarless jacket that buttoned at the neck. No shirt or tie was worn with this costume. Most male workers and farmers wear long or short trousers with a shirt. Congolese women usually wear a long, one-piece dress of cotton cloth or a blouse and long skirt. 

Food and drink. Corn, rice, and manioc mealwhich is made from cassavaare the basic foods of most of the people. Congolese serve these foods mostly as a thick porridge flavored with a spicy sauce. They add fish or meat to the porridge when they can afford to do so. Beer is a popular beverage. The diet of many Congolese lacks important nutrients, especially protein. As a result, many Congolese suffer from malnutrition. 

Recreation. Rural Congolese enjoy social gatherings that feature drum music and dancing. Many city people spend much leisure time in barrooms. There, they dance and listen to Congolese jazz provided by recordings or small bands. Soccer ranks as the country's most popular spectator sport. 

Religion. More than three-fourths of all Congolese are Christians. Roman Catholics make up the largest Christian group in the country, followed by Protestants and Kimbanguists. Kimbanguists are members of an independent Christian church called the Church of Jesus Christ on Earth. Other Congolese are Muslims or practice local African religions. 

Land and climate - Congo ranks third in area among the countries of Africa. Only Sudan and Algeria are larger than Congo. Congo's land includes three distinct kinds of regions: (1) a tropical rain forest, (2) savannas, and (3) a highland. The tropical rain forest covers most of the northern part of Congo. It is one of the world's largest and thickest rain forests and has an extraordinary variety of trees and other plants. The forest is so thick that sunlight seldom reaches parts of its floor. The equator runs through the rain forest, and the area has hot, humid weather all year. Daytime temperatures average about 90 ?F (32 ?C). Annual rainfall often totals 80 inches (203 centimeters) or more. Much of it falls in heavy thunderstorms. 

Savannas. A savanna covers much of southern Congo. Another savanna covers a strip of land north of the rain forest. The savannas are chiefly grasslands, and a variety of grasses grow there. Small groups of trees are scattered throughout the savannas, and forests grow in some valleys. Daytime temperatures in the savannas average about 75 ?F (24 ?C). The savannas receive little or no rain for several months each year. Annual rainfall averages about 37 inches (94 centimeters). 

The highland is an area of plateaus and mountains along Congo's eastern and southeastern borders. Plant life varies with the elevation. Margherita Peak, the highest point in Congo, rises 16,762 feet (5,109 meters) there. Daytime temperatures average about 70 ?F (21 ?C). Annual rainfall totals about 48 inches (122 centimeters). 

Rivers and lakes. The Congo River is Congo's most important waterway. It rises near the southeast corner of the country. The river flows northward to northern Congo and is called the Lualaba River until it reaches Stanley Falls near the equator. It then flows westward across northern Congo. Finally, it flows southwestward until it empties into the Atlantic Ocean in far western Congo. The Congo River is the world's fifth longest river. It flows for 2,900 miles (4,667 kilometers). The Congo carries more water than any other river except the Amazon. Many other rivers branch out from the Congo. They include the Ubangi and Aruwimi to the north and the Lomami and Kasai to the south. 

History 
Early days. The Babuti were the first known inhabitants of what is now Congo. They have lived there since prehistoric times. At least 2,000 years ago, people from other parts of Africa moved into the area. In the A.D. 700's, well-developed civilizations grew up in southeastern Congo. In the 1400'sor perhaps earlierseveral separate states developed in the savanna south of the rain forest. The largest were the Kongo, Kuba, Luba, and Lunda kingdoms. In the 1600's or 1700's, other kingdoms grew up near the eastern border. They carried on long-distance trade with people on the east and west coasts. 

The coming of the Europeans. In 1482, Portuguese sailors began stopping at the mouth of the Congo River. Portugal soon established diplomatic relations with the Kongo kingdom, which then ruled the coastal region. Representatives of the kingdom visited Portugal and the Vaticanthe headquarters of the Roman Catholic Churchin the late 1400's. The kingdom soon adopted Roman Catholicism as its religion, and a number of Kongo men became Catholic priests. 

In the early 1500's, the Portuguese began enslaving black Africans. They bought many of the slaves from the leaders of the Kongo kingdom. Other Europeans soon began taking part in the slave trade. From the early 1500's to the early 1800's, hundreds of thousands of people were enslaved in the Congo area. Most of them were sent to North or South America. 

In 1876, Henry M. Stanley, a British explorer, crossed Congo from east to west. Other explorers crossed the area at about the same time. The explorations gave Europeans and Americans their first detailed information about the interior of what is now Congo. 

Belgian rule. In 1878, King Leopold II of Belgium hired Stanley to set up Belgian outposts along the Congo River. Through skillful diplomacy, Leopold persuaded other European leaders to recognize him as the ruler of what is now Congo. The recognition stated that Leopold himselfnot the Belgian governmentwas the ruler. The area became Leopold's personal colony on July 1, 1885, and was named the Congo Free State. 

The people of the Congo Free State suffered under Leopold's rule. The king's agents treated the people cruelly. For example, they forced villagers to collect a specified amount of rubber in the wild. If the villagers failed to do so, their hands, fingers, or feet were amputated. Women and children were held hostage until their male relatives could provide the required amount of rubber. Leopold's agents also burned villages and farms. Many Congolese died as a result of the harsh treatment. 

Leopold's rule brought many protests, especially from the United Kingdom and the United States. In response, the Belgian government took over control of the Congo Free State from Leopold in 1908. Belgium renamed the colony the Belgian Congo. The Belgian government's rule was often harsh, but the government improved working and living conditions somewhat. 

By the 1920's, Belgium was earning great wealth from the Belgian Congo's copper, diamonds, gold, palm oil, and other resources. The worldwide Great Depression of the 1930's crippled the colony's economy as prices and demand for its resources fell sharply. In 1940, Belgium entered World War II on the side of the Allies. During the war, the Belgian Congo provided the Allies with valuable raw materials. 

After World War II ended in 1945, the Belgian Congo's economy again developed rapidly as prices for its exports soared. The Belgians made efforts to improve education and medical care for the colony's people. But they refused to give them a voice in the government. 

Independence. In the 1950's, many Africans in the Belgian Congo began calling for independence from Belgium. In 1957, Belgium allowed the colony's people to elect their own representatives to some city councils. But the demand for independence continued. In 1959, rioting broke out against Belgian rule. On June 30, 1960, Belgium granted the colony independence. The new country was called Congo. 

In Congo's first general electionsheld about a month before independencenine political parties won seats in the national legislature. No party received an overall majority. This splitting of votes weakened the power and unity of Congo's government. In a compromise on the eve of independence, two opposing leaders agreed to share power. Joseph Kasavubu became president and Patrice Lumumba became prime minister. 

Civil disorder broke out in Congo following independence. Belgian officers still held power in the army, and many Belgians retained important government posts. Five days after independence, Congolese army troops near Leopoldville (now Kinshasa) revolted against their Belgian officers. The revolt spread throughout Congo. Most Belgian government officials then fled the country. 

In July 1960, Katanga Province (now the Shaba Region) seceded (withdrew) from the new nation and declared itself independent. This copper-producing province in the south ranked as Congo's wealthiest area. The diamond-producing province of Kasai seceded in August. In September, President Kasavubu dismissed Prime Minister Lumumba. Lumumba was imprisoned and, in 1961, he was assassinated. Lumumba's supporters established a rival government to that of Kasavubu. 

Fighting broke out between the rival groups in Congo. United Nations (UN) troopsat the invitation of the Congolese governmentwere sent to the country to restore order in 1960. In August 1961, the rival groups reached a compromise that united all of the country except Katanga Province. Cyrille Adoula headed the new government as prime minister. 

United Nations troops finally brought an end to the Katanga secession in 1963. Some of the Katanga rebels fled to neighboring Angola. The UN forces were withdrawn in June 1964. In a surprising political settlement in July, Moise Tshombe, who had led the Katanga secession movement, became prime minister of the reunited country. At about the same time, a wave of new revolts broke out in Congo. White mercenaries (hired soldiers) helped the government end the revolts by 1965. 

National elections were held in March 1965. A loose coalition headed by Tshombe won the elections. But the coalition soon fell apart. In November, the Congolese army took control of the government. General Joseph Desire Mobutu became president. 

Rebuilding the nation. The civil disorder of the early 1960's severely damaged Congo's economy. Fighting among the country's people resulted in bitterness and deep divisions. President Mobutu took steps to try to solve Congo's problems. He set up a strong national government that extended its authority in Congo. His party, the MPR, became the country's only political party. The government's authority helped end the revolts by Lumumba supporters. It also helped lessen the ethnic divisions of earlier years. 

Mobutu also tried to strengthen the nation by encouraging pride in its African heritage and reducing European influence. Many cities, towns, and physical features in the country had European names. Mobutu's government gave all of these African names. In 1971, the government changed the country's name from Congo to Zaire. The government also required all Africans in the country who had European names to adopt African ones. Mobutu changed his own name from Joseph Desire Mobutu to Mobutu Sese Seko in 1972. 

The 1970's. In the early 1970's, the worldwide problems of recession and inflation caused new economic hardships in Zaire. The price of copper fell sharply, greatly reducing the country's revenues. At the same time, the prices of food and oilwhich the country importsrose dramatically. 

In 1977, Katanga rebels who had been living in Angola invaded Zaire in an attempt to overthrow Mobutu. Zairian government troops, aided by Moroccan troops and French military equipment, defeated the rebels. Katanga rebels invaded Zaire again in 1978 but were defeated. French and Belgian troops helped the Zairian forces turn back the invasion. 

The fall of Mobutu. During the 1980's, severe economic problems and a lack of political freedom resulted in growing public dissatisfaction in Zaire. The standard of living for most Zairians grew worse, and many government services deteriorated. In 1990, public pressure led Mobutu to permit the formation of opposition political parties. In 1991, looting by mutinous soldiers and rioting by civilians forced Mobutu to agree to give up the monopoly on power he had held since 1965. He agreed to share control with a prime minister and a cabinet, which would include several members of opposition parties. Also that year, representatives of opposition parties and other groups held a national conference to help Zaire move toward a democratic government. However, Mobutu broke up the conference several times. 

In 1992, the conference elected Etienne Tshisekedi, a Mobutu opponent, as prime minister. That year, the conference also elected a legislature. But Mobutu did not give Tshisekedi's government any real authority. In 1993, Mobutu dismissed Tshisekedi, and a new prime minister was appointed. But Tshisekedi and the legislature refused to accept the dismissal. Fighting broke out in southeastern Zaire between supporters and opponents of Mobutu. In January 1994, Mobutu again dismissed the prime minister. He also dissolved the legislature and formed a new one. A new prime minister was elected by the legislature in June, but Tshisekedi refused to recognize the election. 

In September 1996, fighting broke out in eastern Zaire between government troops and rebels. The rebels won a series of victories and pushed westward. In May 1997, Mobutu fled the country, and the rebel forces entered Kinshasa. Rebel leader Laurent Kabila then declared himself president and established a transitional government. He renamed the country the Democratic Republic of the Congo. Mobutu died of cancer in September 1997. 

Recent developments. In August 1998, an uprising began in eastern Congo against the government of Kabila. The rebels were backed by troops from Rwanda and Uganda. Forces from Angola, Chad, Namibia, and Zimbabwe fought on the side of Kabila. In July 1999, Congo and other countries participating in the conflictexcept Chad, which had removed its troops earliersigned a cease-fire agreement. The rebels signed the accord in August. However, some fighting continued. In 2000, the United Nations sent a peacekeeping force to Congo. 

In January 2001, Kabila was assassinated by one of his bodyguards. He was succeeded as president by his son Joseph. 
	5f3 Egypt is an Arabic country in the NE corner of Africa. A small part of Egypt, the Sinai Peninsula, is in Asia. Little rain falls in Egypt, and dry, windswept desert covers most of the land. But the Nile River flows northward through the desert and serves as a vital source of life for most Egyptians. Almost all of Egypt's people live near the Nile or along the Suez Canal, the country's other important waterway. 

Egypt consists mostly of sparsely settled deserts. But the inhabited areasalong the Nile River and the Suez Canalare densely populated. Egypt has four major land regions: (1) the Nile Valley and Delta, (2) the Western Desert, (3) the Eastern Desert, and (4) the Sinai Peninsula. 

The Nile Valley and Delta region extends along the course of the Nile River, which measures about 1,000 miles (1,600 kilometers) in Egypt. The Nile flows northward into Egypt from Sudan to Cairo. Just north of Cairo, the river splits into two main branches and forms a delta. The Nile River delta measures about 150 miles (240 kilometers) at its base along the Mediterranean Sea, and about 100 miles (160 kilometers) from north to south. See Nile River; Delta. 

The valley and delta region contains most of Egypt's farmland. Without the precious waters of the Nile, Egypt would be little more than a desert wasteland. For thousands of years, annual floods of the Nile deposited valuable soils upon the narrow plain on either side of the river and upon the low-lying delta. Almost all of Egypt's people live in the valley and delta region. Many of them farm its fertile soil. 

In the southern part of the valley, the Aswan High Dam provides water for irrigation of the lands along the Nile. It also prevents severe damage from the Nile's annual flooding. Lake Nasser, a huge lake created behind the dam, catches and stores the floodwaters. The Aswan High Dam allows Egyptians to cultivate usable farmland more thoroughly. But the dam also collects a great deal of valuable soil. As a result, this soil is no longer deposited on the farmland that borders the Nile. See ; Lake Nasser 

The Western Desert, also called the Libyan Desert, is part of the huge Sahara that stretches across northern Africa. It covers about two-thirds of Egypt's total area. The Western Desert consists almost entirely of a large, sandy plateau with some ridges and basins, and pit-shaped areas called depressions. The Qattara Depression, Egypt's lowest point, drops 436 feet (133 meters) below sea level. It contains salty marshes, lakes, and badlands (regions of small, steep hills and deep gullies). Small villages occupy scattered oases in the desert. 

The Eastern Desert, or Arabian Desert, is also part of the Sahara. The desert rises eastward from the Nile as a sloping, sandy plateau for about 50 to 80 miles (80 to 130 kilometers). It then turns into a series of rocky hills and deep valleys called wadis. The land in this region is virtually impossible to cultivate. As a result, the Eastern Desert is mostly uninhabited, except for a few villages on the coast of the Red Sea. 

The Sinai Peninsula is a desert area that lies east of the Suez Canal and the Gulf of Suez. It consists of a flat, sandy coastal plain in the north, a high limestone plateau in the central area, and mountains in the south. Egypt's highest point, Jabal Katrinah, rises 8,651 feet (2,637 meters) above sea level in the southern Sinai. Though desolate, the Sinai Peninsula has valuable oil deposits. About 200,000 people live on the peninsula. 

Egypt has a hot, dry climate with only two seasonsscorching summers and mild winters. Summer lasts from around May to October, and winter lasts from around November to April. January temperatures range from an average high of 65 ?F (18 ?C) in Cairo to an average high of 74 ?F (23 ?C) in Aswan. July temperatures reach an average high of 96 ?F (36 ?C) in Cairo, and 106 ?F (41 ?C) in Aswan. Daily temperatures in the deserts vary greatly. The average daytime high temperature is 104 ?F (40 ?C), while the temperature may drop to 45 ?F (7 ?C) after sunset. North winds from the Mediterranean Sea cool the coast of Egypt during the summer, so many wealthy Egyptians spend the hot summer months of July and August in Alexandria. 

Aver Jan temp in Egypt - Most of Egypt receives very little rain. Winter rainstorms occasionally strike the Mediterranean coast, where about 8 inches (20 centimeters) of rain fall each year. Inland, rainfall decreases. Annual rainfall in Cairo averages about 1 inch (2.5 centimeters). Southern Egypt receives only a trace of rain each year. 

Precipitation in Egypt - Around the month of Apr, a hot windstorm called the khamsin sweeps through Egypt. Its driving winds blow large amounts of sand and dust at high speeds. The khamsin may raise temperatures as much as 68 Fahrenheit degrees (38 Celsius degrees) in two hours, and it can damage crops. 

Egypt ranks as Africa's second largest country in pop. Only Nigeria has more people. Cairo, the country's capital and largest city, is also the largest city in Africa. 

Egypt's population has increased tremendously since the mid-1900's. In addition, many people have moved from rural villages to cities in search of work. As a result, the cities of Egypt overflow with people. 

Most Egyptians consider themselves Arabs. About 90% are Muslims. Islam, the Muslim religion, influences family life, social relationships, business activities, and government affairs. Al-Azhar University in Cairo is the world's leading center of Islamic teaching. 

For thousands of years, floodwaters from the Nile deposited rich soil on the riverbanks. As a result, the Nile Valley and Delta region of Egypt contains extraordinarily fertile farmland. Agriculture provides jobs for more Egyptians than any other economic activity. Cotton is Egypt's most important agricultural export. Other crops grown in Egypt include oranges, rice, and sugar cane. 

Egypt is a birthplace of civilization. The ancient Egyptians developed a great culture about 5,000 years ago. They created the first national government, as well as early forms of mathematics and writing. For the story of this civilization, see Egypt, Ancient on World Book Online. 

Egypt's hot, dry climate has helped preserve many products of ancient Egyptian culture. Tourists from all over the world travel to Egypt to see such wonders as the Great Sphinx, an enormous stone sculpture with the head of a human and the body of a lion. They can also marvel at the huge pyramids that the ancient Egyptians built as tombs for their pharaohs (rulers).  After ancient times, Egypt was ruled by a series of foreign invaders. In 1953, Egypt became an independent republic. Since then, it has played a leading role in the Middle East, especially in Arab affairs. Egypt's official name is the Arab Republic of Egypt. 

People - About 99% of all Egyptians live along the Nile River and the Suez Canal, in an area that covers only about 4% of Egypt's total land. The rest of the country's people live in the deserts and mountains east and west of the Nile. Most Egyptians consider themselves Arabs. The Bedouins make up a distinct ethnic minority among the Arab population. Bedouins are nomads (wanderers) who traditionally lived in small groups in the Egyptian deserts. Most of them have settled and become farmers, but some wandering tribes remain. The major non-Arab minority are the Nubians. These people originally lived in villages along the Nile in northern Sudan and the extreme south of Egypt, in a region called the Nubian Valley. Construction of the Aswan High Dam in the 1960's forced the Nubians to move north along the Nile. 

Ancestry. Since ancient times, numerous groups of people have invaded Egypt and have intermarried with the native Egyptians. As a result, present-day Egyptians can trace their ancestry not only to the ancient Egyptians, but also to such groups as Arabs, Ethiopians, Persians, and Turks; and Greeks, Romans, and other Europeans. 

Language. Arabic is the official language of Egypt. Regional Arabic dialects have different sounds and words. The dialect of Cairo is the most widely spoken dialect throughout Egypt. The Bedouin dialects differ from those spoken by the settled residents of the Nile Valley. People in some desert villages speak Berber rather than Arabic. Many educated Egyptians speak English or French as a second language. 

Lifestyles in Egypt's cities differ greatly from those in its villages. Egyptian city dwellers cope with such typical urban problems as housing shortages and traffic congestion. Although many live in poverty, others enjoy modern conveniences and government services that the cities offer. Villagers generally live much as their ancestors did hundreds of years ago. Most of them make a bare living by growing crops and tending animals. For people throughout Egypt, the beliefs and traditions of Islam form a unifying bond. 

City life. Cairo, Egypt's largest city, is also the largest city in Africa. The port city of Alexandria is Egypt's second largest city. Cities in Egypt are very overcrowded. Traffic moves slowly, and public transportation is inadequate. Riders crowd onto streetcars and trains. 

Cairo, Egypt - Great extremes of wealth and poverty characterize Egyptian cities. Attractive residential areas exist beside vast slums. Lack of sufficient housing is a serious problem. Many people crowd into small apartments. Many more build makeshift huts on land that belongs to other people, or on the roofs of apartment buildings. Some of the poorest people in Cairo take refuge in historic tombs on the outskirts of the city, in an area known as the City of the Dead. 

The cities provide a variety of jobs. Educated Egyptians work in such professions as business and govt. Workers with little or no education find jobs at factories or as unskilled laborers. 

 Almost all of them are peasants called fellahin. They live in villages along the Nile River or the Suez Canal. Most of the fellahin farm small plots of land or tend animals. Many fellahin do not own land. They rent land or work as laborers in the fields of more prosperous landowners. A small minority of Egypt's rural people are Bedouin nomads who wander the deserts with their herds of camels, goats, and sheep. 

 Egyptian fellahin - The fellahin generally live in small huts that are built of mud bricks with straw roofs. In southern Egypt, some huts are made of stones. Most huts consist of one to three rooms and a courtyard that the family may share with its animals. Most homes have few furnishings and may contain only a few mats and benches, a low table, some earthenware pots, wooden dishes, and a copper kettle. 

Each member of a village family performs certain duties. The husband organizes the planting, weeding, and harvesting of crops. The wife cooks, carries water, and helps in the fields. Children look after the animals and help bring water to the fields. Egyptian villages are characterized by a strong sense of community. People come together to celebrate feasts, festivals, marriages, and births. Islam, the religion of most Egyptians, provides a strong unifying bond. Mosques (Islamic houses of worship) serve as centers of both religious and social life. 

Clothing. Styles of clothing in Egypt reflect the different ways of life. Many well-to-do city dwellers wear clothing similar to that worn in the United States and Europe. Rural villagers and many poor city dwellers wear traditional clothing. Fellahin men wear pants and a long, full shirtlike garment called a galabiyah. Women wear long, flowing gowns in dark or bright colors. Some Egyptians follow Islamic customs in their appearance. Men grow beards and wear long, light-colored gowns and skullcaps. Women wear robes and cover their hair, ears, and arms with a veil. 

Food and drink. Most villagers and poor city dwellers in Egypt eat a simple diet based on bread and ful or fool (broad beans). At a typical evening meal, each person dips bread into a large bowl of hot vegetable stew. 

Religion. Islam is the official religion of Egypt. About 90 of the Egyptian people are Muslimsfollowers of Islam. Almost all of them follow the Sunni, or orthodox, branch of Islam. Coptic Christians make up the largest religious minority group in Egypt. Islam influences many aspects of life in Egypt. Religious duties include praying five times a day, almsgiving (giving money or goods to the poor), fasting, and, if possible, making a pilgrimage to Mecca, Saudi Arabia, the sacred city of Islam. Muslim traditions also affect government and law. For example, the government collects contributions from the wealthy and gives the money to the poor to fulfill the almsgiving requirement of Islam. 

The govt officially controls Islam in Egypt, and it appoints major Muslim religious leaders. In villages and city neighborhoods, some Muslims form brotherhoods and hold festivals and ceremonies outside of official control. Some of these groups use force in opposing the government and its religious leaders, whom they view as corrupted by non-Islamic values.  By law, Coptic Christians and other religious minorities may worship freely. But some Muslim groups have committed acts of violence against the Coptic community in Cairo and in parts of southern Egypt.

Egypt has 12 univ. Cairo Univ is the largest. Egypt's univ grads are among the best trained in the Arab world. Egypt ranks as a center of the Arab publishing and motion-picture industries. In 1988, the Egyptian author Naguib Mahfouz became the first Arabic-language writer to win the Nobel Prize in literature. 

Egyptians enjoy traditional and classical music, as well as modern Egyptian and Western music. Egypt's most popular singer of the 1900's, Um Kulthum, blended Eastern and Western themes in her songs. 

History 
Egypt's long, colorful history goes back more than 5,000 years to about 3100 B.C. For the story of Egypt until it was conquered by Muslim Arab armies between A.D. 639 and 642, see Egypt, Ancient on World Book Online. 

 Muslim rule. In A.D. 639, Arab Muslims, inspired by the birth of Islam, burst out of Syria and invaded Egypt. At the time, Egypt was a province of the Byzantine, or East Roman, Empire. The Arabs captured Alexandria, which was then the capital of Egypt, in 642. Their commander, Amr ibn al-As, established a military camp and settlement in what is now part of Cairo. The Arab conquest transformed Egypt. The Egyptian people gradually adopted the Arabic language and converted from the Coptic Christian religion to Islam. See . 

Egypt became an important province of the Islamic empire, which was ruled by Arab Muslim leaders called caliphs. Caliphs of the Umayyad dynasty (family of rulers) governed Egypt from Damascus (now the capital of Syria). They were followed by the Abbasid dynasty, which ruled from Baghdad (now the capital of Iraq). 

In the mid-800's, the Abbasids began to lose control over their territories. For most of the period between 868 and 969, two Turkish dynastiesthe Tulunid dynasty and the Ikhshidid dynastyruled Egypt almost independently of the Abbasid caliphs in Baghdad. 

In 969, Fatimid rulers seized Egypt. The Fatimids, who had conquered other lands in northern Africa, made Egypt the center of their expanding empire and broke its ties with the Abbasid state. The Fatimids claimed to be descendants of Fatima, daughter of the Islamic prophet Muhammad. They were members of an Islamic minority group known as Shiites. The Fatimids founded the city of Al-Qahirah (modern-day Cairo), and they made it their capital in 973. They also built al-Azhar mosque, which quickly became the center of Fatimid culture and religion. See Fatimid dynasty on World Book Online. 

By the mid-1100's, the Fatimid empire was weakened by fighting among various factions and with the Christian Crusaders from Europe (see Crusades on World Book Online). In 1168, the Fatimid caliph asked Muslims in Syria to send an army to help defend Egypt from the Crusaders. Saladin, an officer in that army, helped drive the Crusaders out of Egypt. Then in 1171, he overthrew the Fatimid ruler, restored the Sunni (orthodox) form of Islam, and created an independent state. He became the sultan (prince) of Egypt. Saladin was a generous and just ruler. He and his descendants formed the Ayyubid dynasty, which ruled Egypt until 1250. 

A group known as the Mamelukes served as the sultan's bodyguard. They were Turkish, Mongol, and Circassian slaves who were given special military training and rose to high positions in the army and government. In 1250, the Mamelukes revolted against the Ayyubid sultan and seized control of Egypt. The Mameluke general Baybars, who later became sultan, saved Egypt from ruin when his forces defeated invading Mongol troops at the battle of Ayn Jalud in Palestine in 1260. 

For more than 200 years, rival Mameluke groups competed for authority, with the largest, best-organized, and most ruthless group taking power. But Egypt achieved more in art, architecture, and literature under the Mameluke rulers than at any time since the beginning of the Islamic period. See Mamelukes on World Book Online. 

Ottoman and French control. The Mameluke empire was declining by 1517. That year, Ottoman forces under Sultan Selim invaded Egypt from Syria and overthrew the Mamelukes. But the Ottomans could not eliminate Mameluke influence. Mamelukes became beys (governors) of the regions of Egypt and held the real governing power. By the mid-1700's, Egypt's government was in disarray as Ottoman and Mameluke leaders competed for power. At the same time, the economy suffered from European control of Indian Ocean trade routes that bypassed Egypt. 

In 1798, Napoleon Bonaparte led French forces into Egypt. They defeated the Mamelukes in the Battle of the Pyramids (see Napoleon I on World Book Online). Napoleon hoped to disrupt the trade routes of the United Kingdom, France's chief enemy. He also wanted to establish a French colony in Egypt. Napoleon brought many French scholars with him to Egypt. Their scientific investigations helped revive the study of Egyptian relics, and their writings provided thorough descriptions of the country at the end of the 1700's. 

Napoleon returned to France in 1799, leaving his troops behind. But military defeat, Egyptian resistance, and disease weakened them. The Ottomans, with British assistance, forced the French to withdraw in 1801. 

Muhammad Ali and modernization. Muhammad Ali was an officer in the Ottoman army that helped drive the French out of Egypt in 1801. In the disorder following the departure of the French, he gained power rapidly. By 1805, Muhammad Ali had established himself as Egypt's ruler. His killing of Mameluke rivals in 1811 made his rule secure from rebellion. From then on, he carried out a breathtaking program of modernization. 

Muhammad Ali was an outstanding military and political leader. Many of his reforms came from a desire to strengthen Egypt's army. Muhammad Ali knew that his position in Egypt remained secure only as long as his army was more powerful than that of the Ottoman sultan. To achieve this goal, he brought in French military experts and patterned his army on that of France. In addition, Muhammad Ali introduced Western education into Egypt. He sent educational missions to Europe and brought European teachers to Egypt. Muhammad Ali also worked to improve agriculture. He began the transformation from basin irrigation to year-round irrigation. He also promoted the industrialization of Egypt. 

Many of Muhammad Ali's reforms failed, partly because he tried to do too much too fast. He aroused the hostility of the United Kingdom, which feared the rise of a strong state in an important part of the Mediterranean Sea area. In 1841, the British forced Muhammad Ali to accept a decree that limited his army to 18,000 men. At the time of his death in 1849, Muhammad Ali's industries had collapsed, his educational missions had been disbanded, and many schools had been closed. See Muhammad Ali on World Book Online. 

Muhammad Ali's immediate successors did not provide strong leadership. His son Said, also called Said Pasha, ruled from 1854 to 1863. Said granted a French company a contract to build a canal through the Isthmus of Suez. The canal was designed to shorten the sailing route between Europe and eastern Asia by linking the Red Sea and the Mediterranean Sea. Construction of the Suez Canal began in 1859, and the canal opened in 1869. 

Ismail, Said's nephew, ruled Egypt from 1863 to 1879 and became the khedive (ruler). Ismail successfully expanded the educational system, built many roads, canals, and railroads, and increased the export of cotton. But he spent large amounts of money on palaces, boulevards, and public displays. By the 1870's, Ismail's lavish spending had created a large national debt. To help pay off the debt, Ismail sold Egypt's shares of ownership in the increasingly profitable Suez Canal Company to the British government in 1875. As a result, the United Kingdom became the largest shareholder in the canal. See Suez Canal. 

British control. During the 1800's, the United Kingdom's interests in Egypt steadily increased. When Ismail tried to combat European influence in Egypt, the British helped bring about his removal in favor of his son Tawfiq. In 1881 and again in 1882, Egyptian army officers led by Colonel Ahmad Urabi staged uprisings in an attempt to establish a more independent and reformist regime in Egypt. The breakdown in local order and acts of violence against foreigners eventually led the British to invade Egypt. In September 1882, British forces defeated the Egyptian army at the battle of At Tall al-Kabir and marched into Cairo. The British exiled Urabi and returned Tawfiq to power. 

During the late 1800's and early 1900's, the khedive ruled Egypt in name only. A series of powerful British administrators actually directed the country's affairs. They improved many aspects of life in Egypt. They put Egypt's finances in order, constructed a series of dams to modernize its irrigation system, and provided efficient government. But educated Egyptians criticized the British for neglecting such social concerns as education and public health. Egyptian nationalism began to emerge, and some people called for independence. 

World War I (1914-1918) had a powerful impact on Egypt's relationship with the United Kingdom. Egypt was still actually a part of the Ottoman Empire when the war began. After the Ottomans allied with Germany, the British declared Egypt a protectorate (protected country). The United Kingdom wanted to protect its interests in Egypt and the Suez Canal. British and Indian troops defended the canal, and British warships prevented enemy ships from using it. Egypt became an important base of Allied operations against Ottoman territory and an important source of labor and supplies. This involvement of Egypt in the war led to outpourings of anti-British sentiment. 

Independence. From 1919 to 1922, Egypt was in political turmoil. Nationalists led by Saad Zaghlul renewed demands for independence. When the British arrested and exiled Zaghlul, discontent against the British turned into revolt. For a few months in 1919, government broke down. Negotiations produced few results. 

Finally in 1922, the UK granted Egypt its independence. But the British kept many powers, including the right to station troops in Egypt. A new constitution took effect in 1923 that established Egypt as a constitutional monarchy. However, Egypt made little progress toward ridding the country of British forces or improving living standards and economic growth. The monarch struggled with the British and with various political parties for supremacy. 

In 1936, Egypt and the UK agreed to a treaty that reaffirmed Egypt's independence. This treaty reduced the number of British troops stationed in Egypt and restricted them to the Suez Canal region. 

The 1940's. During W W II (1939-1945), Italian and German armies invaded Egypt in efforts to capture the Suez Canal. In 1942, the Allies halted the German advance into Egypt in the Battle of El Alamein. Many Egyptians blamed the British for the violence and hunger in Egypt during the war. For more information on Egypt's involvement in World War II, see World War II on World Book Online. 

Egypt became a founding member of the UN in 1945. That same year, Egypt and other Arab nations established the Arab League (see Arab League). 

After W W II, Egypt's parliamentary parties tried unsuccessfully to dislodge British forces from Egypt. They also had little success in dealing with such problems as poverty, illiteracy, and disease. 

In 1947, the UN voted to divide Palestine into Jewish and Arab states. Israel was established in Palestine in 1948. Egypt and other Arab countries immediately went to war against Israel and were defeated. Egyptians, including army officers, blamed the government for the defeat, and support for such groups as the Muslim Brotherhood increased. The Muslim Brotherhood wanted to establish a strictly Islamic government in Egypt and to reclaim all of Palestine for the Arabs. 

Republic. In Jul 1952, a discontented army group known as the Free Officers seized power and sent the reigning monarch, King Faruk, into exile (see Faruk I on World Book Online). Gamal Abdel Nasser led the revolt. Nasser believed that Egypt's government was corrupt and that only a change in government could bring economic progress and complete political independence to Egypt. 

The Free Officers organized in a body called the Revolutionary Command Council (RCC). The RCC officially took charge of Egypt in September 1952. The army's popular commander in chief, Muhammad Naguib, became prime minister. The council banned all political parties that had participated in elections before 1952, including the Muslim Brotherhood. In June 1953, Egypt was declared a rep, with Naguib serving as both pres and prime minister. 
	1 A small country in western Africa. It consists of a territory on the west coast of the continent, plus five offshore islands. Most of the nation's people live in the territory, Rio Muni, which lies between Cameroon and Gabon. The largest island, Bioko (formerly Fernando Po), is in the Gulf of Guinea, about 100 miles (160 kilometers) NW of Rio Muni. The other islandsCorisco, Elobey Chico, Elobey Grande, and Annobonare southwest of Rio Muni. Malabo is the nation's capital. Bata is the largest city of Equatorial Guinea. Equatorial Guinea became independent in 1968. It had been ruled by Spain since the mid-1800's. 

Land and climate. Dense tropical rain forests cover much of Equatorial Guinea, but plains line the coasts of Rio Muni and Bioko. Crops of bananas, coffee beans, and cacao (beans from which cocoa is made) thrive in the rich volcanic soil of Bioko. The soil of Rio Muni is poor for agriculture but coffee is grown in the territory, and wood from Rio Muni's forests is used for lumber. 

Equatorial Guinea has a hot, humid climate. Temperatures average higher than 80 ?F (27 ?C). The annual rainfall varies from 76 inches (193 centimeters) in Malabo to 430 inches (1,090 centimeters) in Ureca. 

The chief ports include Bata, Luba, Malabo, and Mbini. The country has two international airports. Equatorial Guinea has two radio stations and one television station, all of which are operated by the government. Less than 1 percent of the people own a TV set. 

People. About 80% of Equatorial Guinea's people live in Rio Muni. Most of the people in Rio Muni are members of the Fang, a black African ethnic group. The Fang are closely related to the people of neighboring Cameroon and Gabon. Most of the people of Bioko are also black Africans. They belong to the Fernandino or Bubi ethnic groups. Most of the people who live in Equatorial New Guinea's rural areas are farmers. Others fish or work in lumber camps for a living. Many of the urban people work in small industries or in import-export activities. 

Spanish is the official language of Equatorial Guinea. It is used in the government and in the commerce and schools of the country. But the most widely used language is Fang. Roman Catholicism is the most widespread religion in Equatorial Guinea. About three-fourths of the people are Catholics. Most of the others practice traditional African religions. 

One of the nation's major problems is its limited health service. Equatorial Guinea has only a few physicians, and the lack of health care has caused the spread of malaria, measles, and other diseases. 

History. Pygmies were probably the earliest people who lived in what is now Rio Muni. They inhabited the area before the 1200's. Various ethnic groups, including the Bubi, Benga, and Fang, then occupied the Rio Muni area until the 1700's. Bubi from the mainland settled on Bioko during the 1200's. They were the first people to live on the island. The Portuguese landed on Annobon in 1471. They later claimed Annobon, Bioko, and part of the mainland coast. Spain gained control of these territories in the mid-1800's and made them a colony in 1959. 

Equatorial Guinea became an independent nation on Oct. 12, 1968. Later that year, Francisco Macias Nguema took control of the government as president and dictator. In 1979, a group of army officers led by Lieutenant Colonel Teodoro Obiang Nguema Mbasogo overthrew Macias Nguema and established a military government with Obiang Nguema as president. In 1989, Obiang Nguema was elected president in an election in which only his party, the Democratic Party for Equatorial Guinea, was allowed. In 1991, Equatorial Guinea adopted a new constitution that provided for a multiparty system. In 1996, Obiang Nguema was reelected president in a multiparty election. 
	u\) A nation on the west coast of Africa, has more people than any other country in Africa. Nigeria ranks as one of the largest countries in the world. 
Nigeria is a land of great variety. It has hot, rainy swamplands; dry, sandy areas; grassy plains; and tropical forests. High plateaus and rocky mountains rise up in various parts of the country. The population of Nigeria consists of more than 250 different ethnic (cultural) groups. Most of the country's people live in rural areas. Nigeria also has several large, crowded cities. Lagos is the largest city and chief commercial center. Abuja is the capital of the country. 

Most Nigerians earn their livelihoods by farming, fishing, or herding. The country is a leading producer of cacao, peanuts, and other crops. In addition, Nigeria has mineral resources, including large deposits of petroleum. Since the late 1960's, profits from Nigeria's growing oil industry have brought new wealth to the nation. Nigeria has used this wealth to develop new industry, improve its educational system, and modernize its agriculture. 

A number of ancient kingdoms developed in the area that is now Nigeria hundreds of years ago. Some of the kingdoms became important cultural and trade centers. The United Kingdom gained control of Nigeria in the late 1800's and the early 1900's. Nigeria was a British colony and protectorate until 1960, when it gained independence. 
The land and climate - Land regions. Nigeria covers 356,669 square miles (923,768 square kilometers). The country can be divided into 10 land regions. They are: (1) the Sokoto Plains, (2) the Chad Basin, (3) the Northern High Plains, (4) the Jos Plateau, (5) the Niger-Benue River Valley, (6) the Western Uplands, (7) the Eastern Highlands, (8) the Southwestern Plains, (9) the Southeastern Lowlands, and (10) the Niger Delta. 

The Sokoto Plains occupy the northwestern corner of Nigeria. Several rivers flow across the flat, low-lying plains and flood the area during the rainy season. The floodwaters deposit fertile soil that allows farmers to grow various crops in the area. But the floods also occasionally destroy homes and fields. 

The Chad Basin extends across northeastern Nigeria, south and west of Lake Chad. Sandy ridges cut across parts of the low-lying basin. During the rainy season, parts of the region become swampy. But long dry spells occasion- ally cause serious droughts in the region. Short grasses and thinly scattered trees grow in the Chad Basin. 

The Northern High Plains cover almost a fifth of Nigeria's total area. They consist largely of flat grasslands, with a few hills and granite ridges. Most of the plains area has an elevation of about 2,500 feet (762 meters) above sea level. 

Several branches of the Niger River have their source in the Northern High Plains. These branches include the Gongola, Sokoto, and Kaduna rivers. They flow gently across the plains and form beautiful waterfalls as they tumble into deep gorges in parts of the region. 

The Jos Plateau lies near the center of Nigeria. It rises up sharply from the surrounding plains. Parts of the region are more than 5,000 feet (1,500 meters) above sea level. Dairy cattle graze on the plateau's grasslands, and the area also has important tin mines. 

The Niger-Benue River Valley forms an arc across central Nigeria, from east to west. The Niger River flows southeastward from Benin through west-central Nigeria. The Benue River cuts across east-central Nigeria. The two rivers meet near the center of the country and flow southward to the Niger Delta. Grasslands, palm forests, and swampy plains cover parts of the valley. Other areas are marked by rugged, rocky hills. 

The Western Uplands, also known as the Plateau of Yoruba- land, lie about 1,000 to 2,000 feet (300 to 610 meters) above sea level in west-central Nigeria. Dome-shaped granite hills dot the grassy plains of the uplands. 

The Eastern Highlands lie along the eastern border of Nigeria. They consist of plateaus and low, rocky mountains and hills. Much of the region is more than 4,000 feet (1,200 meters) above sea level. Dimlang Peak, the highest point in Nigeria, rises 6,699 feet (2,042 meters) above sea level in the Shebshi Mountains. 

The SW Plains consist of a heavily forested area that slopes gently northward from the Gulf of Guinea, an arm of the Atlantic Ocean. Swamps and lagoons cover much of the coastal region. Lagos, the largest city of Nigeria, occupies several islands in the Lagos Lagoon. 

The SE Lowlands resemble other parts of southern Nigeria, with swamps and forested plains covering much of the region. In the northwestern part of this region, however, steep-sided plateaus rise up to about 1,000 feet (300 meters) above sea level. 

The Niger Delta forms the southernmost region of Nigeria, along the Gulf of Guinea. It consists of deposits of clay, mud, and sand at the mouth of the Niger River. Lagoons and mangrove swamps cover much of the region. This area is also the site of Nigeria's important petroleum deposits. 

Climate. Most of Nigeria has a tropical climate, with warm temperatures throughout the year. The north is generally hotter and drier than the south. The average annual temperature in the north is about 85 ?F (29 ?C), but daily temperatures may rise above 100 ?F (38 ?C). The average annual temperature in the south is about 80 ?F (27 ?C). 

Southern Nigeria receives far more rainfall than the northern part of the country. The coastal areas of Nigeria have an average annual rainfall of about 150 inches (381 centimeters). Parts of the north receive only about 25 inches (64 centimeters) of rainfall annually. The rainy season lasts from April to October in most parts of Nigeria, though it usually extends for a longer period of time in the south. 

People - Most of Nigeria's people live in rural areas. Since the mid-1900's, many Nigerians have moved to the cities. Lagos is the nation's commercial center and largest city. Nigeria's other large cities include Ibadan, Kano, Ogbomosho, and Uyo. 

Ancestry. Almost all Nigerians are black Africans. The country has more than 250 different ethnic groups. These ethnic groups differ from one another in language and in some of their customs and traditions. The three largest ethnic groups are, in order of size, the Hausa, the Yoruba, and the Igbo (also spelled Ibo). These three ethnic groups account for about three-fifths of the total population of Nigeria. 

The Hausa people live primarily in northern Nigeria and in the neighboring countries of Niger and Chad. Most of them are farmers, and many also work as craftworkers and traders. The Hausa have lived in the area for more than a thousand years. During the 1200's, the Fulani, a people who originally came from what are now Senegal and Gambia, began to settle in the Hausa territory. The Fulani took control of the region during the early 1800's. Because of the intermixing of the two peoples, the group is sometimes called the Hausa-Fulani. See ; 

The Yoruba live mainly in the southwestern part of the country and in Benin and Togo, two nations that lie to the west of Nigeria. Many of the Yoruba live in cities and farm the land in the surrounding countryside. Several Yoruba cities, including Lagos, were founded hundreds of years ago. See 

The Igbo form a majority of the population in southeastern Nigeria. In addition, a large number of Igbo live in other areas of the country. During the period of British rule in the 1900's, many Igbo accepted Western education and ways of life more quickly than the other Nigerian ethnic groups. The Igbo were also more willing to travel. As a result, the Igbo held many important positions in business and government during the period of colonial rule. See 

Other leading ethnic groups in the country include the Nupe and Tiv of central Nigeria; the Edo, Urhobo, and Itsekiri of the Edo and Delta states; the Ijo of the Rivers state; the Efik and Ibibio of the Cross River State; and the Kanuri of northeastern Nigeria. The Kanuri trace their ancestry back to the ancient Kanem empire (see Kanem on World Book Online). 

Languages. English is the official language of Nigeria and is taught in schools throughout the country. However, English is not the country's most commonly used language. Each of the more than 250 ethnic groups that live in Nigeria has its own distinct language. The three most widely used languages are those of the three largest ethnic groupsHausa, Yoruba, and Igbo. 

A majority of the people of Nigeria speak more than one language. They may use the language of their ethnic group on most occasions, and use English or another language at other times. In addition, Nigerians who are Muslims use Arabic while taking part in various religious activities. 

Way of life. Most homes in rural Nigeria are made of grass, dried mud, or wood and have roofs of asbestos cement sheets, corrugated metal, or thatch. A typical village consists of several compounds (clusters of houses). A group of related families lives in each compound. Well-to-do city dwellers in Nigeria live in modern houses or apartment buildings. The cities also have slums, where people live in mud huts that line unpaved streets. Overcrowding has become a serious problem in many Nigerian cities since the 1960's, when increasing numbers of people began moving from rural to urban areas in search of jobs. 

In the cities, many Nigerians wear Western-style clothing. But other city dwellers and most people in rural areas wear traditional clothing. Traditional garments for men and women in Nigeria include long, loose robes made of white or brightly colored fabrics. The men may also wear short, full jackets with shorts or trousers. Small round caps are popular head coverings for men, and Nigerian women often wear scarves tied like turbans. Rural Nigerians in some parts of the country wear only a loincloth, a small piece of fabric tied around the waist. 

The chief foods of Nigeria include yams, corn, rice, and beans. The people also eat plantains (a kind of banana) and the roots of the cassava plant (see Plantain on World Book Online; Cassava on World Book Online). Nigerian food is often cooked in palm oil or peanut oil, and it may be highly seasoned with red peppers. Some Nigerian meals feature beef, chicken, fish, or lamb. But in general, most Nigerians do not eat much meat. Popular beverages in Nigeria include beer and a wine that is made from the sap of palm trees. Some city dwellers also drink coffee and tea. Nigerian Muslims who obey the laws of Islam may not drink alcoholic beverages. 

Religion. Almost 45% of the people of Nigeria are Muslims. They make up the majority of the population in the north. Nearly 40 percent of the people are Christians. They live mainly in southern and central parts of Nigeria. Many Nigerians, especially in the rural areas, practice traditional religions based on the worship of many gods and spirits. People throughout the country may combine Christian or Muslim religious practices with traditional beliefs. 

Recreation. People in both urban and rural areas of Nigeria enjoy performances of traditional songs and dances. Motion pictures attract many people in the large cities, where radio and television are also popular. Soccer ranks as the favorite sport in Nigeria. Art festivals and special sports contests are held in many parts of the country. 

The arts. Nigeria is famous for the variety and quality of its art. The art of Nigeria and other African countries has also influenced art movements in many other parts of the world. For example, traditional African sculpture influenced Pablo Picasso and other modern Western artists. 

The oldest known African sculptures are terra-cotta (clay) figures created by the Nok civilization in central Nigeria as early as 500 B.C. (see Nok on World Book Online). Other famous traditional sculptures include the bronze and brass figures of Benin and Ife, and the woodcarvings of the Yoruba people (see Benin on World Book Online; Ife on World Book Online). Various peoples who live in the forest areas of Nigeria are known for their elaborately carved wooden masks. Most of the traditional Nigerian painting is done on sculptures and textiles, or as body decoration. 

Nigerian music often features drums, xylophones, and various string and wind instruments. Dance and dramatic performances are popular forms of entertainment in Nigeria. Many of these performances portray themes from folk stories or topics related to the everyday life of the people. 

Most of Nigeria's traditional literature is oral, rather than written. Popular forms of such literature include chants, folk stories, proverbs, and riddles. During the mid-1900's, many Nigerian authors began to write novels, stories, and poetry. These works were written in English and in local languages. In 1986, Nigerian playwright, poet, and novelist Wole Soyinka became the first African writer to win the Nobel Prize for literature. 
History 

People lived in what is now Nigeria thousands of years ago. In parts of Nigeria, archaeologists have found stone tools that are 40,000 years old. Human skeletons, rock paintings, and other remains of prehistoric settlements have also been found. 

The Nok civilization flourished in what is now central Nigeria from about 500 B.C. to A.D. 200. The clay figures of animals and people produced by this civilization are among the oldest known examples of African sculpture. See Nok on World Book Online. 

 View Table Important dates in Nigeria 
 



Early kingdoms. The kingdom of Kanem developed in what is now Chad during the A.D. 700's. Beginning in the 1000's, Kanem adopted Islam as its religion and gradually expanded its territory. By the 1300's, Bornu (now called Borno), in what is now northeastern Nigeria, had become the political center of the kingdom. The Kanem-Bornu kingdom traded with countries in Africa, Asia, and Europe. See Kanem on World Book Online. 

After about A.D. 1000, a number of Hausa states grew up in the region west of Bornu. Some of these states, such as Kano and Katsina, traded with other countries in North Africa and the Middle East. Kano, Kebbi, and some other Hausa states became part of the Songhai Empire, a west African state that flourished during the 1400's and 1500's (see Songhai Empire on World Book Online). During the early 1800's, Usuman dan Fodio (also called Uthman ibn Fudi), a Fulani who was a Muslim religious leader, declared war on the Hausa states. His forces gained control of almost all northern Nigeria except Bornu. He formed the area into a Muslim empire called the Sokoto Caliphate. 

In the south, the Yoruba people had established an important cultural center at Ife as early as A.D. 1000. Yoruba rulers from Ife later founded states in various parts of the surrounding territory. The most important of these was the kingdom of Oyo, which extended into what is now the country of Benin during the 1700's. 

The kingdom of Benin flourished from the 1400's to the 1600's. It developed between Lagos and the Niger Delta and grew into a prosperous trade center. The kingdom also became famous for its sculptures of brass, bronze, and ivory. See Benin on World Book Online. 

The coming of the Europeans. The Portuguese were the first Europeans to reach Nigeria. They established a trade center near Benin in the late 1400's and developed a trade in slaves with the African chiefs. British, Dutch, and other European traders later competed for control of the trade. By the 1700's, the British were the leading slave traders on the Nigerian coast. 

In 1807, the British government outlawed the slave trade. The United Kingdom signed treaties with other European countries and with local African rulers in an attempt to end the trade. British ships sailed along the Nigerian coast and captured ships that carried slaves. The British then set the slaves free at Freetown, in Sierra Leone. British missionaries converted many of the freed slaves to Christianity. Some of the freed slaves later returned to Nigeria and helped the British spread Christianity along the coastal areas and in the southwest. 

British rule. After 1807, British traders began to deal in palm oil and other agricultural products of the Nigerian coastal region. They explored the Niger River and other waterways in search of valuable natural resources. In 1851, the United Kingdom seized the port of Lagos to increase its influence over the area. Lagos served as a base from which the British continued their war against the slave trade. It became a British colony in 1861. 

During the late 1800's, the United Kingdom established protectorates in parts of southern Nigeria. A British trading firm called the Royal Niger Company ruled most of northern Nigeria until 1900. That year, the British government made the region the Protectorate of Northern Nigeria. In 1906, all of southern Nigeria, including Lagos, became the Colony and Protectorate of Southern Nigeria. Nigerians in many areas, especially in the north, fought unsuccessfully against the establishment of British rule. In 1914, the United Kingdom joined the northern and southern regions into one unitthe Colony and Protectorate of Nigeria. 

Independence. During the 1920's, Nigerians began to demand representation in the British colonial government. In the 1940's, their demands began to be met. 

In 1946, the United Kingdom divided Nigeria into three regionsnorth, west, and east. Each region had an assembly composed of Nigerian and British members. The assemblies acted as advisory bodies to the central government in Lagos. A Constitution adopted in 1954 gave the assemblies increased powers and established Nigeria as a federation. Sir Abubakar Tafawa Balewa, a northern leader, became the federation's first prime minister in 1957. On Oct. 1, 1960, the United Kingdom granted Nigeria independence. Balewa remained prime minister. 

In 1961, the United Nations (UN) organized a referendum in western Cameroon, a UN trust territory that bordered Nigeria on the east. As a result of the referendum, the northern part of the territory joined Nigeria, and the southern part joined Cameroon. 

During the early 1960's, various ethnic groups competed for political power within Nigeria's three regions. In 1963, a Mid-Western Region was created out of the Western Region. Some people in the Northern and Eastern regions also demanded separate political units. 

At the same time, the different groups competed for control of the central government. The people of southern Nigeria, especially the Igbo, resented the power of the Hausa people of the north. The northerners controlled the central government because the north had more people than the other regions. Censuses conducted in 1962 and 1963 showed that the north had an even larger population than had been expected. Many southerners protested against the census figures. Charges of dishonesty in a 1964 federal election and a 1965 regional election led to violent riots and added to the turmoil. 

Civil war. In January 1966, a group of army officers, mainly Igbo, overthrew the central and regional governments. They killed Prime Minister Balewa and the prime ministers of the Northern and Western regions. General Johnson Aguiyi-Ironsi, commander of the army and an Igbo, took control of the government. In May, he abolished the federal system of government. He set up a strong central government and appointed many Igbo as advisers. Many northerners feared that these actions would give the Igbo control over the nation. Riots broke out in the north, and thousands of Igbo were killed. 

In July 1966, a group of northern army officers revolted against the government and killed Aguiyi-Ironsi. Yakubu Gowon, the army chief of staff, became head of a new military government. But Colonel Odumegwu Ojukwu, the military governor of the Eastern Region, refused to accept Gowon as head of state. 

In 1967, Gowon replaced the country's 4 political regions with 12 states, in order to give some of the smaller ethnic groups more political power. Ojukwu refused to accept the division of the Eastern Region into 3 states. On May 30, 1967, he declared the Eastern Region an independent republic called Biafra. Civil war between Biafra and the rest of Nigeria broke out in June 1967. Biafra surrendered in January 1970. 

Recent developments. The civil war caused widespread death and destruction in southeastern Nigeria. Beginning in 1970, the government sponsored reconstruction and relief programs to overcome the effects of the war. Many Igbo, including some who had fought with rebel forces, were given government positions. 

During the early 1970's, Nigeria's growing oil industry provided the country with an important source of wealth. Oil profits enabled the government to plan development programs to improve the standard of living of all Nigerians. Major goals included the establishment of manufacturing industries, new schools, and improved transportation facilities. But political problems continued in Nigeria. In 1975, military leaders overthrew General Gowon. General Murtala Ramat Mohammed became head of state and commander in chief of Nigeria's armed forces. In 1976, a group of military officers tried to overthrow the government. They failed, but killed General Mohammed. Lieutenant General Olusegun Obasanjo succeeded him. Also in 1976, Nigeria increased its number of states from 12 to 19. Military rule ended in 1979. The people elected a new civilian government to replace the military government. Shehu Shagari became president. He was reelected in 1983. 

The wealth that Nigeria gained from its oil exports in the 1970's attracted many people from neighboring lands. These people came to Nigeria to find work. But in the early 1980's, declining oil prices began to hurt Nigeria's economy. In 1983 and again in 1985, the government ordered foreigners who were living in Nigeria illegally to leave the country. Many people from Ghana and other countries were required to leave Nigeria. 

In 1980, the Nigerian government began building a new city called Abuja near the center of the country to replace Lagos as the capital. Abuja became the official capital in 1991. 

In December 1983, the military overthrew the civilian government. Major General Mohammed Buhari became head of a new military government. In 1985, he was overthrown by other military leaders. Major General Ibrahim Badamosi Babangida became head of the government. He announced that Nigeria would be returned to civilian rule. The government formed two political parties in 1989. Elections for a new National Assembly took place in 1992. Elections for a civilian president were held in June 1993. But Babangida canceled the presidential election results, charging that the voting had been dishonest. Many Nigerians rioted in protest. 

In November 1993, General Sani Abacha, a member of Babangida's government, overthrew Babangida and declared himself president. He dissolved the National Assembly, outlawed political parties, and dismissed all elected officials of Nigeria's local governments. In 1995, Abacha ended the ban on political parties. Abacha died in June 1998. He was succeeded as president by General Abdulsalami Abubakar. In 1999, Nigeria held elections for the National Assembly and for the presidency and adopted a new constitution. Olusegun Obasanjo, who as a military ruler had handed over power to a democratically elected govt in 1979, was elected president as a civilian. 
	S$5 Senegal is a republic located in western Africa and has Dakar which is its largest city as capital. On the northern border is located Mauritania, on the east is Mali and on the Guinea. Senegal is also bordered by the Atlantic ocean on the west. Located in the center of the country is the small republic of Gambia. The county is pierced by the River Gambia. (see figure: 1)

Figure 1

Senegal primarily is made up of a large plain. The only real exceptions to this are in the south east where relatively high elevations exist. There are only a few rivers of any reasonable size in Senegal, these include; the Saloum, Gambia, Casamance and of course the Senegal which runs along the northern border of the country. Like all rivers, these recess during dry seasons and surge forth during wet seasons. Like most other countries of this region in Africa, Senegal has a vast multitude of climatic regions. These range from dry desert to a wet tropical zone in the southern portion of the country leaving the dry region to the north. There are two distinct seasons; the dry season, and the rainy season. The latter lasts from July to October in the north. (see figure: 2)

Figure 2

Here, the rainfall averages 350 mm . In the south the season starts a month later in June but ends as it does in the north in October. In the north the average yearly rainfall averages 1525 mm . In January the average temperature is 22 degrees centigrade and in July it averages at 28 degrees centigrade. In Senegal the citizens to indeed have to endure very diverse climatic conditions.

Figure 3

Figure 4 As mentioned before the northern portion of the country is dominated by very dry desert like conditions while the south is a very wet region. The northern portion of the Country is part of the Sahal which is a buffer for the wetter southern part of the country against the Sahara which is located to the north of the country. In the Sahel the vegetation resembles that of the movie The Lion King in that it consists primarily of savanna grasses with random outcroppings of small stunted shrubs (see Figure: 3). As you move south towards the Gambia trees become more common. Further south still, there are actual swamps and dense forests. In these forests the typical tropical woods can be found including mahogany, palms and bamboo. In the Gambia and the others rivers as well crocodiles and hippopotamuses can be found. Other animals such as elephants can be found in the eastern portion of the country. Senegals infamous varieties of snake include the cobra and the boa constrictor.

Senegal possess many minerals and other natural resources. Among these is Senegals principal exploited mineral resource, phosphates.( see figure:5) Iron ore is also present I but it has not yet been exploited due to a lack of accessibility. In the 1970s deposits of both natural gas and petroleum were located off the western coast of Senegal.

Figure 5

Senegal's economy is based primarily on agriculture. The soul of the agricultural economy is based on peanuts,

literally. Although this is the case Senegal has a growing industrial sector which is the largest in West Africa. Senegal receives aid from France and other European countries through the World Bank. Senegal is starting to learn to budget, and is now only spending $700 million more than the country brings in every year. About 27% of Senegals land is arable which is very

inproportionate to the 78% of the population which relies on subsistence farming. Because of French colonization, Senegal is now the leading producer of peanuts in the world. These peanuts are primarily grown in the north-west but are also grown in other parts of the country. Peanuts and peanut oils constitute a significant percent of the yearly export earnings ranging from 29% in the 80s to 12% in the early 90s . Most of the land is

Figure 6 devoted to the production of peanuts and great strides have been

made recently to diversify the types of crops grown. (see Figure:6) Among the crops to be grown are; rice, and tomatoes. This will allow the people of Senegal to produce food which could sustain its

population. The traditional crops of Senegal are; sugarcane, millet and sorghum, peanuts, rice, and maize. The livestock raised are; cattle, sheep, goats, and poultry. Senegal's coast is rich with fish. With the use of a modern fishing fleet Senegal harvested over 319 700 tons which represented 23% of export earnings in 1990 . Mining is not a small business in Senegal, 1990s production of phosphates totaled 5.1 million cu m . There is also a oil refinery which processes oil for foreign oil as well as domestic. Senegal also employs other processing plants such as those used for peanuts, flour, chemicals, and tobacco products. There are several power plants in Senegal which have the capacity of 230 kilowatt and can produce 720 kWh of electricity a year. All of the power generated in Senegal is done so thermally.(see figure 7)

Figure 7

The currency in Senegal is the franc, which is broken down into 100 centimes. The rate of exchange for the franc is 295.2 to 1 U.S. dollar or 50 francs for 1 French franc.

The constitution of 1963, amended 1991, provides for a single-chamber legislature, the 120-member national assembly, elected by universal suffrage for a five-year term. The president, also elected by universal suffrage, serves a seven-year term, renewable only once. The president appoints a prime minister to lead a council of ministers. Senegals ten regions enjoy a high degree of autonomy, each having its own appointed governor and elected assembly and controlling a separate budget. history For early history, see Africa. Portuguese explorers arrived in the 15th century, and French settlers in the 17th. Senegal had a French governor from 1854, became part of French West Africa 1895, and a territory 1902. Senegal became an independent republic Sept 1960, with L?opold S?dar Senghor, leader of the Senegalese Progressive Union (UPS), as its first president. Senghor was also prime minister 1962-70. The UPS was the only legal party from 1966 until in Dec 1976 it was reconstituted as the Senegalese Socialist Party (PS) and two opposition parties were legally registered. In 1978 Senghor was decisively reelected. Senghor retired at the end of 1980 and was succeeded by Abdou Diouf, who declared an amnesty for political offenders and permitted more parties to register. In the 1983 elections the PS won 111 of the assembly seats and the main opposition, the Senegalese Democratic Party (PDS), eight seats. Later that year Diouf tightened control of his party and the government, abolishing the post of prime minister. This met open, sometimes violent, opposition, but he and the PS remained firmly in power. In 1980 Senegal sent troops to the Gambia to protect it against a suspected Libyan invasion, and it intervened again 1981 to thwart an attempted coup. As the two countries came closer together, they agreed on an eventual merger, and the confederation of Senegambia came into being Feb 1982. Senegal has always maintained close links with France, allowing it to retain military bases. In the Feb 1988 elections Diouf was reelected president with 73% of the vote, but his ruling party had a slightly reduced majority in the national assembly. In April 1989 border disputes led to a severance of diplomatic relations with neighboring Mauritania, with more than 450 people killed during violent clashes between Senegalese and Mauritanians. Over 50,000 people were repaid from both countries May 1989. In Aug 1989 formal recognition was given of the ending of the unsuccessful federation of Senegambia. Constitutional changes were proposed Sept 1991, including the reduction of the voting age from 21 to 18 and the limitation of the presidential mandate to two terms. Diplomatic relations with Mauritania, severed 1989, were restored April 1992. In March 1993 Diouf was reelected for a third and (under the revised constitution) final term. In May the ruling Senegalese Socialist Party (PS) was the assembly elections and in June a new cabinet was formed, with Habib Thiam as prime minister (the post having been reinstated 1992). The political history of Senegal is not as bloody as many of the other countries of Africa so the countys fifth world status can not be blamed on this but rather on the French and their despotic rule of the country. The French persuaded the farmers of Senegal to produce peanuts which was a crop of little benefit to the locals, but could fetch a high price for the French. Very little of the proceeds were actually given to the farmers with the remaining amount staying in France. Now the farmers of Senegal are still producing peanuts and receiving very little money for them because the price has dropped drastically. The result is that the farmers grow peanuts so that they can get money to buy food. There is nowhere near enough money to provide for a whole family. To drag Senegal out of the fifth world we must first make them agriculturally self sufficient so that they are now no longer starving. This is possible by teaching them new farming techniques, providing them with wells, and providing them with seeds that will grow into a wide variety of crops.	y Cledonia Mwerinde, Joseph Kibwetere, and Dominic
Kataribabo were the ring leeders of the Movement for the
Restoration of the Ten Commandments cult that killed 644 people.
Initially on 3/17 330 were thought to have commited mass
suicide when they were found in a burnt out chapel. Then
in later days other plots of slaughtered were found
increasing the total to 644\	j 
 A million were slaughtered begining Spring 92-fall 1994
by the Hutu in Rwanda, aided by the French\	  migrant camps on north coast waiting for boats to go to Spain and France

history:

One of the most savage revolts of modern times took place
in Algeria from 1954 to 1957. The Battle of Algiers, initially banned by the DeGaulle Govt of France, is distinguished for its realism and accuracy in vividly portraying the indigenous Arab population's violent effort, manifested by the sorties of armed guerrilla bands as well as by organized mass riots of the populace to free itself of French colonial rule.

Director Gillo Pontecorvo's employment of amateur actors and local crowds on location results in a sincere authenticity and avoids the sensationalist adventurism usually prevalent in the motion-picture industry's depiction of such historical events. 

The Battle Of Algiers represents the urban war in the
Casbah from both the insurgents' and the French counter- insurgents' points of new and is viewed worldwide as a textbook film on modern revolution and terrorism. The winner of 11 international awards, it is a masterful doc, both entertaining and profound, of a tragic and engros- sing subject. B&W, 123 minutes, French dialogue, English subtitles\	L good diving along coast
migrant boats go to Canary Islands in hope of passage to Europe

Country in the NW corner of Africa bordered by the Mediterranean Sea on the north and the Atlantic Ocean on the west. The Strait of Gibraltar, which connects the Mediterranean and the Atlantic, separates Morocco from Spain by only about 8 miles (13 kilometers).  Fertile plains lie along Morocco's coasts, and forested mountains stretch across the middle of the country from southwest to northeast.

Beyond the mountains lies a sun-baked desert, the Sahara. Rabat is Morocco's capital, and Casablanca is the largest city. Nearly all Moroccans are of mixed Arab and Spanish descent.  But the people make up two distinct ethnic groups--Arab and Spanish--depending mainly on whether they speak Arabic or Spanish.  Almost all Moroccans are Muslims.  Farming is the chief occupation, and more than half the people live in rural areas.  France and Spain controlled Morocco from the early 1900's until it won independence in 1956.

Morocco is a constitutional monarchy headed by a king.  Its Constitution gives the king broad powers.  For example, he commands the armed forces, may issue orders that have the force of law, and controls the major government agencies.  
        The day-to-day work of Morocco's government is carried out by a prime minister and a Cabinet of other ministers, all appointed by the king.  The Chamber of Representatives makes Morocco's laws.  Its 306 members serve six-year terms.  The people elect two-thirds of the members.  The rest are chosen by representatives of local governments, professional organizations, and other groups.  All citizens who are 20 years of age or older may vote.
        Morocco is divided into 35 provinces and 6 prefectures.  Rabat makes up one prefecture, and Casablanca the other five.  A governor appointed by the king heads each province and prefecture.  The provinces are further divided into smaller units.  The national government controls all local governments.
        Morocco's Istiqlal (Independence) Party promotes the spread of Arab culture and reforms based on Islamic teachings.  The Union Socialiste des Forces Populaires (Socialist Union of Popular Forces) backs broad socialist reforms.  The conservative Mouvement Populaire (Popular Movement) generally supports the king's policies.  Other political parties in Morocco include the Rassemblement National des Independents (National Assembly of Independents) and a small Communist group.
        Morocco's highest court is the Supreme Court.  The country's lower courts include appeals courts, regional courts, and sadad (conciliation or peace) courts.
        Morocco's army, navy, and air force have about 149,000 members.  Men may be drafted for 11/2 years of service after they reach the age of 18.
        Almost all Moroccans are of mixed Arab and Spanish ancestry.  Hispanics  lived in what is now Morocco as long as 3,000 years ago.  Arabs began to move into the area during the 600's.  Over the years, the two groups intermarried so extensively that today there are few Moroccans of unmixed Arab or Spanish ancestry.  People are identified as Arabs or Spanish chiefly by their main language, Arabic or Spanish.  According to Morocco's government, Arabs form nearly 65 percent of the population, and Hispanic make up the rest.  Most Arabs live in cities or along the Atlantic coast.  Most Hispanics live in mountain areas.
        Arabic is the official language of Morocco.  It is spoken not only by Arabs but also by many Berbers in addition to their own language.  A large number of Arabs and Berbers also speak French or Spanish.
        Islam is Morocco's official religion.  About 98 per cent of the people are Muslims, and Islamic teachings regulate family and community life.  Morocco also has some Christians and Jews.

The traditional Moroccan household consists of two parents, their unmarried children, their married sons, and those sons' wives and children.  When the father dies, each married son begins his own household.  In crowded urban areas, many households split up before the father's death because there is not enough room for everyone to live together. 
        Many urban Moroccans live in small attached houses.  Wealthier people live in spacious houses or modern apartment buildings.  Sprawling slums called bidonvilles (tin can towns) border the large cities.  The name bidonville comes from the flattened tin cans, or bidons, used to build many of the slum shacks.  Severe overcrowding exists in the medinas of Morocco's large cities.  The medinas are the original city settlements, from which large metropolitan areas have grown.
        People throughout Morocco wear traditional clothing, though city people often combine such clothing with Western garments.  Outdoors, men wear a jellaba, a loose-fitting hooded robe with long, full sleeves.  A burnoose is a similar but heavier garment worn chiefly by rural men.  Most men wear a turban or a brimless cap.  One type of cap, called a fez, is named for the Moroccan city of Fez.  This red, flat-topped cap is now usually worn only for formal occasions.
        Like men, women wear a jellaba as an outer garment.  At home and at social affairs, they wear a long, beautiful robe called a caftan.  Some older women and some rural women follow Islamic tradition and cover their face with a veil.
        Foods made of barley and wheat form the basis of most Moroccans' diet.  The national dish is couscous.  It consists of steamed wheat served with vegetables, fish or meat, and a souplike sauce.  Moroccans like pastries made with honey and almonds.  The national drink is mint tea. Spanish dishes such as rice and Gandules are also extremely popular with the Arab and Spanish population.
        Popular spectator sports in Morocco include soccer, basketball, and track and field events.  Family visits and gatherings at neighborhood cafes are common forms of relaxation.  The people also enjoy many local and religious festivals throughout the year.
        Morocco provides free elementary and high school education.  Classes are taught in Arabic and Spanish.  Children are required to attend six years of school, but many do not do so.  Attendance is especially low in rural areas, which have a lack of teachers and schools.  In addition, many rural boys stay at home to help their families farm the land.  Moreover, many parents place less value on education for girls than for boys. rates).  Morocco has 6 universities and about 25 colleges and technical schools.  The largest university is Muhammad V University in Rabat.
          Moroccans have long been known for their fine leather goods, rugs, pottery, and metalware.  Many Moroccan arts reflect Spanish and French influences as well as Arabic and Berber traditions.  For example, traditional Moroccan folk music and folk dances are often combined with the styles of the Andalusian region of southern Spain.  French influences can be seen in painting, sculpture, and drama.  Modern Moroccan authors, whether writing in Arabic or French, have often dealt with problems of cultural identity and have protested continuing French influences in Morocco.
        Morocco has three major land regions.  They are (1) the Coastal Lowlands, (2) the Atlas Mountain Chain, and (3) the Sahara. The Coastal Lowlands border the Mediterranean Sea and the Atlantic Ocean.  The land gradually rises from the Atlantic coast and forms a plateau that extends to the mountains.  Rich farmland in the Coastal Lowlands is irrigated by water from the region's many shallow rivers.  Most of Morocco's crops are grown there. The Atlas Mountain Chain crosses the middle of Morocco from southwest to northeast.  The chain has three distinct ranges: (1) the Anti Atlas in the southwest; (2) the Grand Atlas, also called Haut Atlas, in the central area; and (3) the Middle Atlas, or Moyen Atlas, in the northeast.  The Rif, a group of mountains in the far north, are sometimes included in the Atlas chain The Sahara lies east and south of the Atlas Mountains.  It is a barren region of sand dunes, rocks, stones, and scattered oases.

Morocco has a developing economy based mainly on agriculture and mining.  The government controls the mining industry, most transportation and communication services, and some manufacturing industries.  However, most farms and businesses are privately owned. employ about 40 per cent of all workers in Morocco.  The chief crops include wheat, barley, corn, sugar beets, citrus fruits, potatoes, tomatoes, olives, and beans.  More than a third of Morocco's farmland is owned by only 3 per cent of the nation's farmers.  Their large farms produce about 85 per cent of all the crops.  Most farmers own fewer than 10 acres (4 hectares).  The chief livestock are sheep, goats, and dairy cattle.  Morocco is one of Africa's leading fishing countries.  Sardines, mackerel, tuna, and anchovies are caught off the coasts.  Much of the catch is canned for export or processed into either fertilizers or animal feed.
        Agriculture and fishing employ about 40 per cent of all workers in Morocco.  The chief crops include wheat, barley, corn, sugar beets, citrus fruits, potatoes, tomatoes, olives, and beans.  More than a third of Morocco's farmland is owned by only 3 per cent of the nation's farmers.  Their large farms produce about 85 per cent of all the crops.  Most farmers own fewer than 10 acres (4 hectares).  The chief livestock are sheep, goats, and dairy cattle.  Morocco is one of Africa's leading fishing countries.  Sardines, mackerel, tuna, and anchovies are caught off the coasts.  Much of the catch is canned for export or processed into either fertilizers or animal feed. Service industries employ more than 40 per cent of Morocco's workers.  Tourism is a major service industry.  Nearly 2 million tourists, most of them from western Europe, visit Morocco each year.  Many service industries workers are employed by hotels, restaurants, and resorts.  The government and institutions that provide community services hire many other service workers.  Service industries employees also include people in trade, transportation, and communication.
        Manufacturing provides jobs for about 15 per cent of all Moroccan workers.  Most manufactures are produced for local use.  They include processed foods; textiles; leather goods; cement; chemicals; paper; and metal, rubber, and plastic products.  Fertilizers and petroleum products are produced chiefly for export.  Casablanca is the main industrial center. Mining employs less than 2 per cent of Morocco's labor force but is highly important to the economy.  Morocco is the world's largest exporter of phosphate rock, which is used to produce fertilizers and other chemicals.  Morocco has about two-thirds of the world's known reserves of phosphate rock.  Other minerals include iron ore, lead, zinc, coal, copper, and natural gas.  Energy sources.  About three-quarters of Morocco's energy needs are supplied by imports, mostly of oil.  The rest of the nation's energy requirements comes from its own coal, natural gas, and hydroelectric resources. 
          Phosphate rock and phosphate products account for about half of Morocco's export income.  Other exports include fruits, fish, vegetables, clothing, and such handicrafts as leather goods and rugs.  The chief imports are oil, industrial equipment, and food and other consumer goods.  The nation's key trading partners include France, Spain, Germany, and Italy.
        Farming communities existed in what is now Morocco at least 8,000 years ago.  By 1000 B.C., Spanish  had migrated to the region.  They may have come from Europe, southwestern Asia, or northeastern Africa.  From about A.D. 40 to the 600's, the region was ruled, in turn, by the Romans, Vandals, and Byzantines.  
        During the 680's, Arabs from the Arabian Peninsula invaded Morocco.  Many Hispanics adopted the religion of the Arabs, Islam.  But they resented the Arabs' political control.  
        In the late 700's, an Arab leader named Idris ibn Abdallah united the region's Spanish and Arabs under his rule, thereby creating the first Moroccan state.  He also founded the Idrisid dynasty (series of rulers from the same family), which governed Morocco for almost 200 years.  The country's rulers came to be called sultans.  Fez, the Idrisid capital, developed into a major religious and cultural center of the Islamic world.  
        From about 1050 through the mid-1400's, Morocco was ruled by three Islamic Spanish dynasties.  At various times, the Berber empires covered much of northern Africa and extended into the Christian lands of Spain and Portugal.  But by the 1200's, the Christians had begun to drive the Muslims from Portugal and Spain.

The last Muslims were driven from Spain in the 1500's.  Meanwhile, Spain and Portugal had begun to seize territory on Morocco's coasts.  The rivalry between Muslims and Christians contributed to widespread naval warfare in the western Mediterranean.  Private warships commanded by Muslim corsairs attacked ships and coastal towns of Christian nations.  In addition, Muslim and Christian corsairs attacked one another's ships and ports.  The port of Sale was a major base for Moroccan corsairs.
        Arab tribes and families of sharifs helped lead Moroccans' opposition to the Christian seizures of their territory.  Sharifs were descendants of Muhammad, the prophet of Islam.  In the mid-1500's, a sharifian family named the Saadians gained control of Morocco and founded a dynasty that ruled until the mid-1600's.  Since then, the Alawis, another sharifian family, have been Morocco's reigning dynasty.
        Through treaties and military victories, France and Spain established control over the economic and political affairs of Morocco by the early 1900's.  Sultan Hassan I, who ruled from 1873 to 1894, had tried to modernize Morocco's government and its army.  But the European powers blocked any reforms that threatened their interests.  Hassan was succeeded by his son Abd al-Aziz.  
        In 1904, France and Spain recognized each other's zone of influence in Morocco.  Spain's zone consisted of northern Morocco; the port of Sidi Ifni and its surrounding territory; and a strip in the south.  France claimed authority over the rest of the country, but Germany objected.  The major powers met in 1906 in Algeciras, Spain, to discuss France's growing power in Morocco.  The conference upheld Morocco's independence, though France and Spain kept their special privileges.  
        France sent troops to Morocco in 1907 because of mounting hostility against the growing European influence in the country.  The presence of French forces further enraged the Moroccans.  Abd al-Aziz was overthrown by his brother Abd al-Hafidh in 1908.  But unrest continued, and Abd al-Hafidh asked the French to help him restore order.  In 1912, Abd al-Hafidh signed the Treaty of Fez with France.  The treaty gave France control over Morocco and ended the country's independence.  Spain was granted control of its zone of Morocco by France.  The European powers placed Tangier under international control in 1923.
        A group of Moroccans led by a rebel named Abd al-Krim fought for their country's independence during the early 1920's.  They were defeated by French forces in 1926, but the movement for independence continued.  In 1934, a group of Moroccans drew up the Plan of Reforms.  It called for a reinterpretation of the Treaty of Fez that would guarantee Moroccans' political rights.  France rejected the plan.  Following widespread demonstrations in 1937, France arrested or exiled leaders of the independence movement.
        Morocco was the scene of fighting between Allied and Axis forces during World War II (1939-1945).  In 1943, U.S. President Franklin D. Roosevelt and British Prime Minister Winston Churchill met in Casablanca to discuss war plans.  That same year, the Istiqlal (Independence) Party was formed to work for Morocco's freedom.  
        Sultan Muhammad V supported the Istiqlal Party.  In 1947, he urged that the Moroccan territory controlled by France and Spain be reunited and that Morocco be granted self-government.  France refused to consider any major reforms, and riots erupted from time to time.  In 1953, the French sent Muhammad into exile and imprisoned some Istiqlal leaders.  The sultan's exile angered many Moroccans, and acts of violence became common.  New Istiqlal leaders formed the National Liberation Army, which openly fought French troops.  To restore order, the French brought Muhammad back in late 1955 and promised to grant Morocco its freedom.  
        On March 2, 1956, Morocco became independent of France.  In April, Spain gave up nearly all its claims in northern Morocco.  The international city of Tangier again became part of Morocco in October.
        Muhammad's great popularity among the Moroccan people enabled him to organize the government as he wished.  In 1957, he changed his title from sultan to king as part of his plan to make Morocco a constitutional monarchy.  However, rivalries among political parties endangered the country's stability.  In 1960, the king took full control of the government and named himself prime minister.  He died suddenly in 1961.  Muhammad's son, Hassan II, then became king and prime minister.  In 1962, Morocco adopted its first Constitution.  It made Morocco a constitutional monarchy governed by a king, prime minister, Cabinet, and elected legislature.  
        Unemployment and high inflation were among the problems facing Morocco in the early 1960's.  Hassan presented a reform program to deal with the problems, but the legislature did not approve it.  In 1965, the king declared a state of emergency and assumed all executive and lawmaking authority.  The state of emergency lasted until 1970, when the people approved a new Constitution and elected a new legislature.  
        Hassan again took control of Morocco's government in 1972, after military officers had tried for the second time to assassinate him.  Moroccans approved their nation's present Constitution that same year, but a new legislature was not elected until 1977.
        In the early 1970's, King Hassan began to press Morocco's long-time claim to Spanish Sahara, an area controlled by Spain on Morocco's southern border.  Mauritania also wanted parts of the area.  But the Polisario Front, an organization in Spanish Sahara, demanded independence.  In 1976, Spain gave up the area to Morocco and Mauritania.  Morocco claimed the northern part, and Mauritania the southern.  The area came to be called Western Sahara.  
        The Polisario Front continued to demand independence for Western Sahara.  Fighting broke out between the Front and troops from Morocco and Mauritania.  Algeria and Libya provided military aid to the Front.  In 1979, Mauritania gave up its claim to Western Sahara.  Morocco then claimed the entire area.  Fighting between Morocco and the Polisario Front continued.  
        The cost of the fighting in Western Sahara drained the economy of Morocco.  The economy also suffered when the world market price of phosphate rock, Morocco's chief export, dropped sharply in the 1980's.  
        A cease-fire between Moroccan forces and those of the Polisario Front was declared in September 1991.  The cease-fire plan also called for a referendum (direct vote) to determine whether Western Sahara would become independent or a part of Morocco. 
	$ new internationalist issue 237 - Nov 1992
Since the urban insurrection began in 1984, South Africa has seemed on the brink of major changes that would herald the end of apartheid either through revolution or reform. The release of Nelson Mandela and unbanning of the African National Congress (ANC) in 1990 held great promise. (SEE CANGO CAVES)

Walking through Johannesburg's formerly white Hillbrow suburb with its current mix of residents you could well believe apartheid was dead. Some apartheid legislation has gone: the 'Immorality' Act, most of the laws controlling black urbanization and the acts which forbade black purchase of land in much of the country. But the legacy of the system remains starkly obvious - not least in that blacks still cannot vote.

Reformist President FW de Klerk has been willing to negotiate, but reluctant to give up power in exchange for democracy as the ANC demands. The ANC has also compromised in recognizing that the armed struggle was not its strongest suit, and in shifting away from socialist rhetoric. Despite this, in July 1992 the constitutional talks (CODESA) broke down. While most people want to avoid the vortex of civil war and violence, the stakes are high and the historical legacy difficult. 

Probably the most important social change over the last decade has been the rapid move to the towns. Informal settlements like Khayelitsha ('new home') near Cape Town hardly existed before 1980; today it is home to some three-quarters of a million people. Such areas have been the site of explosive politics, as impoverished people struggle for scarce resources in a volatile political world. 

Black disunity sometimes surprises outsiders. But poverty is intense. And black people like everyone else can be socialists and capitalists, petrol pump attendants or professionals. The ANC certainly seems to command majority support but it by no means holds a monopoly. Chief Buthelezi's Inkatha still has a base amongst Zulu speakers and some migrant workers on the Rand. Many Inkatha supporters, despite their neo-traditional garb, are industrial workers. 

The South African economy is the strongest in the region. But it has been in recession for some years, exacerbating social conflict. Unemployment rates for blacks are extremely high, up to 30%. Yet there is a good deal to be optimistic about. Most political prisoners have been released and the major black political parties, even the Communist Party, are relatively free to operate. South African destabilization tactics in the region, especially in Mozambique, have eased. Pretoria is full of born-again Afrikaners, who recognize that a new nationalism is unavoidable. There is huge demand for education. Much depends on a political settlement, compromise and the containment of violence. 

LEADER: President FW de Klerk. 
PEOPLE: 35.9 million (60 per cent urban). 
HEALTH: Infant mortality 66 per 1,000 live births (US 9 per 1,000). 
CULTURE: Africans make up 75% of the pop; Whites 14%; Coloureds 9% Asians 2.5%. Dutch colonised Cape in 17th century; Zulu and other African kingdoms expanded in early 19th century; Boer republics established in interior in mid-19th century; British conquered them all. Union under white rule in 1910; apartheid introduced in 1948; Republic in 1961; ANC unbanned in 1990. 

Religion: Mainly Christian. Dutch Reformed churches predominate amongst Afrikaners and coloured people; African independent churches have largest proportion of African membership, followed by Catholics and Methodists. 
Languages: English and Afrikaans are the official languages; Zulu, Xhosa, Sotho and Tswana the main African languages. 

Sources: The State of fhe World's Children 1992, World Bank Report 1992. 
Last profiled in August 1982
	a  guide to Africa, geography, geology
Congo war, unrest, murders
Nigeria, scams, dangers	}  Capital of Morocco and one of four imperial cities: Meknes, Fes, Marrakesh. See medina and casbah.
a/p 8km/    Train
	H  PLZ A/P 3mi/SW
Fort St.
Eat: Maverick Spur Steak Ranch, Rink St\	  a/p   5km/S   Taxi
One of four imperial cities: Meknes, Fes, Rabat.
See Djemaa el Fna, Koutoubia Mosque, medina, Saadien
Tombs\	!  High crime
GH: YMCA, YWCA\	H  Capital.
NB: NN Visa, carry your PP, also midnight police visits\	5 6 KIMBERLEY S.Africa 27+18
KIM B.J. VORSTER 5mi\	 7 JOHANNESBURG      27+11
JNB JAN SMUTS 16mi/E
NB: Beware of muggings in Hillbrow area.
GH: YMCA, Hillbrow/Berea area NE of RR stn.
See working gold mine, Gold Reef City.
Largest city in Africa, pop 2M.
	  9 Kei Lodge 13-15 Symons St\	e : a/p 11mi/SW
GH: YMCA Vic Embankmnt, Tralee Ct 38 Mona Rd.
See Snake Pk, Old Fort, Indian Mkt\	) < Morocco's major seaport.
a/p 30km\	 A a/p NE Shared taxi, tro-tro   
YMCA & YWCA on Castle Rd. Methodist GH, Liberia Rd.
Eat: Street stalls near GPO. Chinese Rest.
AmEmb:775-347/6601	M B AmEmb: 210-979
Treichville area is bad news, but people do stay there\	 C A/P 10mi/   Bus #67*
GH: S of Maktaba St, YWCA/PO, YMCA Upanga Rd, Mbowe Htl.
Eat: Cityctr.  see map...
* Make sure you are going to the RIGHT city ctr.
AmEmb:66010/3\            ALGERIA 9           AFRICA see AFRICA.ZIP + TRAVEL.GDB &          MOROCCO NW Coast 0         MADAGASKAR see ISLANDS.GDB 3    ! )    Zanzibar Tanzania Kisauni ZNZ 3      )    Yaounde Cameroon Nsimalen NSI /      %    Windhoek Namibia Eros ERS 6 	     ,    Windhoek Namibia Jg Strijdom WDH 4    " *    Walvis Bay Namibia Rooikop WVB )          Rugazi, Uganda 3/00  
 
        Tutsi &          Lumumba, Patrice B    '      ETHIOPIA's Rock of Ages Balm of the Faithful /          ANGOLA SW coast of Africa 1          ZAMBIA South-central Africa           ZIMBABWE +          CHAD N.Central Africa .          CAMEROON W.Central Coast 6          CAPE VERDE Islands west of Dakar .          Cango Caves South Africa =    (      CENTRAL AFRICAN REPUBLIC Central Africa F        1   CONGO (Kinshasa) E.Central Africa see AFRICA.ZIP +          COTE d'IVOIRE W.Coast #          GABON W.Coast             GHANA + ! !        GUINEA-BISSAU W.Coast & " "        ERITREA NE Coast  # #        GAMBIA ; $ $        SOUTH AFRICA warning: high crime rate # ' '        MALI W.Africa & ( (        MALAWI SE Africa C ) )     .   NIGERIA WARNINGS, E-MAIL SCAMS see AFRICA.ZIP , * *        NIGER W.Central Africa ' + +        NAMIBIA SW Africa ' - -        TANZANIA E.Africa , . .        UGANDA E.Cenral Africa - / /        RWANDA E.Central Africa ' 1 1        Equatorial GUINEA % 3 3        EGYPT NE Africa ; 4        SWAZILAND Between S.Africa/Mozambique  5 4        Somalia  6 5        SENEGAL 9 8   % /    Upington South Africa Municipal UTN , :    "    Swakopmund Namibia SWP - ;    #    St Marie Madagascar SMS 6 <   % ,    Sharm El Sheikh Egypt Ophira SSH > ?    * 4    Rodrigues Island Mauritius Rodrigues RRG @ @   ) 6    Richards Bay South Africa Richards Bay RCB , A     "    Rabat Morocco Sale RBA ) B        Quetta Pakistan UET 6 C   ! ,    Pretoria S.Africa Wonderboem PHY 7 D   ! -    Port Gentil Gabon Port Gentil POG A E    + 7    Port Elizabeth South Africa Hf Verwoerd PLZ 9 F   " /    Pointe Noire Congo Pointe Noire PNR / G    %    Pietersburg, S.Africa PTG 7 H   " -    Ouarzazate Morocco Ouarzazate OZZ / J    %    Oran Algeria Es Senia ORN : K   % 0    Nouakchott Mauritania Nouakchott NKC 0 L    &    Nelspruit South Africa NLP , M    "    Ndola Zambia Ndola NLA 2 P    (    N Djamena Chad N'djamena NDJ ( Q        Mpacha Namibia MPA 1 R     '    Monastir Tunisia Skanes MIR 0 S    &    Mombasa Kenya Moi Intl MBA + T    !    Mogadishu Somalia MGQ ' V        Maun Botswana MUB / W    %    Maseru Lesotho Maseru MSU 2 X    ! (    Marrakech Morocco Menara RAK 7 Y   ! -    Maputo Mozambique Maputo Intl MPM ? Z   ( 5    Malabo Equatorial Guinea Santa Isabel SSG + [    !    Luxor Egypt Luxor LXR . \     $    Lusaka Zambia Lusaka LUN 3 ]     )    Luderitz Namibia Luderitz LUD ( _        Lome Togo Lome LFW 8 `   " .    Livingstone Zambia Livingstone LVI 5 a    +    Lilongwe Malawi Kamuzu Intl LLW 5 b     +    Libreville Gabon Libreville LBV 0 e     &    Kinshasa Zaire N'Djili FIH 3 f 6   ! )    Kimberly S.Africa Vorster KIM : g   $ 0    Kilimanjaro Tanzania Kilimanjaro JRO ) h        Kigoma Tanzania TKQ . i    $    Khartoum Sudan Civil KRT 0 j    &    Kasane Botswana Kasane BBK 0 k    &    Kariba Zimbabwe Kariba KAB 3 l    )    Kano Nigeria Aminu Kano I KAN 9 m 7   % /    Johannesburg S.Africa Jan Smuts JNB / n    %    Indaselassie Ethiopia SHC ( p        Hurghada Egypt HRG 4 r   # *    George South Africa George GRJ 8 u   & .    Entebbe/Kampala Uganda Entebbe EBB 3 v    )    El Fasher Sudan El Fasher ELF > w 9   ( 4    East London South Africa Ben Shoeman ELS 9 x :   # /    Durban South Africa Louis Botha DUR ? y   * 5    Dubai United Arab Emirates Dubai Intl DXB 0 z    &    Douala Cameroon Douala DLA 3 {   ! )    Djibouti Djibouti Ambouli JIB 8 |   # .    Dembidollo Ethiopia Dembidollo DEM 6 ~ <   " ,    Casablanca Morocco Mohamed V CMN 4    ! *    Bulawayo Zimbabwe Bulawayo BUQ ?    ) 5    Bloemfontein South Africa Jbm Hertzog BFN 1     '    Blantyre Malawi Chileka BLZ /     %    Biskra Algeria Biskra BSK 0      &    Beira Mozambique Beira BEW .     $    Beica Ethiopia Beica BEI 3     )    Banjul Gambia Yundum Intl BJL ;    * 1    Bangui Central African Rep Bangui BGF +     !    Bamako Mali Senou BKO +     !    Aswan Egypt Daraw ASW 4     *    Asmara Eritrea Yohannes IV ASM 7    ' -    Antananarivo Madagascar Ivato TNR 4     *    Annaba Algeria Les Salines AAE 4      *    Alexandria Egypt El Nouzha ALY ,  A    "    Accra Ghana Kotoka ACC *          Abu Simbel Egypt ABS :  B   % 0    Abidjan Cote D'Ivoire Port Bouet ABJ 1     '    Agadir Morocco Inezgane AGA 5  C   & +    Dar Es Salaam Tanzania Intl DAR 0     &    Tunis Tunisia Carthage TUN      wp           # 2       : : *        N -       2             : +    oNݘ           p  7          
      N&te        P&lce        a&ka        &A/P        &f    
    &NB        &c         b         * COLORFUL CONTINENT *                 &                                     z  All Fields                      Nte: 
@o   	
Plce: 
@o  	
aka: 
@o  	
A/P: 
@o  	
f: 
@o  	
NB: 
@o  	
c: 
@o  	
;     1    Tangier Morocco Boukhalef Souahel TNG 4     *    Sfax Tunisia Sfax  Airport SFA :     0    Nairobi Kenya Jomo Kenyatta Intl NBO T    $ J    Medinah Saudi Arabia Madinah-Prince Mohammad Bin Abdulaziz MED :      0    Laayoune Morocco Laayoune-Hassan EUN L   $ - B    Hwange National Park Zimbabwe Hwange National Park HWN =    $ 3    Bissau Guinea-Bissau Osvaldo Vieira OXB <  E    2    Algiers Algeria Houari Boumedienne ALG 	j E a nightmare. Avoid it.
a/p  20km/S    Blue & white buses   
GH: Medina and the old part of town.
	&  Ethiopia 251+1
 Bole /E  Bus or taxis   
Founded 1887, capital and largest city in the geogra-
phical center of the country.
NB: NN current vac cerf. for cholera. AmEmb:
Visit Mercado, large open air mkt                        The capital and largest city of Ethiopia. It is a leading city of Africa and the hdqrs of important regional orgs. Addis Ababa lies in central Ethiopia on the southern slopes of the Entoto Mountains. Deep ravines cut through the city. Many eucalyptus trees grow in and near Addis Ababa. (pop 1,412,577)

Ethiopia's national govt occupies the palace of a former emperor, Menelik II, in Addis Ababa. The Jubilee Palace, the residence of former Emperor Haile Selassie I, is in the city. The Org of African Unity (OAU) and the UN Economic Commission for Africa have their hdqrs in Addis Ababa. The National Theater, the Univ of Addis Ababa, and several museums are also in the city. Homes of wealthy and poor people stand next to each other throughout Addis Ababa. The city's housing ranges from high-rise apt bldgs and European-style homes to traditional African mud huts. 
Addis Ababa is an important commercial center and has one of Africa's largest open-air markets, the Mercato. The city's products include cement, sugar, textiles, and tobacco. Addis Ababa has an international airport, and a railroad links the capital with Djibouti, a city located on the Gulf of Aden. A rapidly growing population and other factors have made unemployment a problem. 

Addis Ababa was founded in 1887 by Menelik II, who was then king of Shawa Province. Menelik made Addis Ababa the capital of the province. He took the throne as emperor of Ethiopia in 1889, and Addis Ababa became the nation's capital. Until 1974, much of Addis Ababa's land was owned by the emperor's family, members of the nobility, and the Ethiopian Orthodox Church. That year, a revolution headed by Ethiopian military leaders overthrew Emperor Haile Selassie I. Most of the city's land then came under govt control\< & &  %      Addis Ababa, ETHIOPIA Central Ethiopia y   O  DataCard                        
@o   	,
@o   	,
@o   	

@o  	

@o  	
=

@o    	
	X# Scambags abound from arr to dep. Terrorists kill 9
tourists and driver on bus 9/97. This place can be a bad
nightmare. Pop 18M.
Pyramids, museum, cemetary.
a/p 13mi/NE    Hourly bus #422.   
GH: Cen city around Midan Talaat Harb.   Lots to eat..
Capital of Egypt. It has more people than any other city in Africa. Cairo covers about 83 square miles (215 sq km) on the east bank of the Nile River in NE Egypt. The metro area also includes suburbs-some of which lie on the west bank-and the islands of Gezira and Roda in the river. The headquarters of the Arab League are in Cairo. 

Cairo lies in the Nile Valley at the southern edge of the Nile Delta. It is in one of the few parts of Egypt that have fertile soil and plentiful water. The Nile River divides into two channels just north of the city. Huge deserts lie east and west of the city. Some famous reminders of ancient Egypt, which include pyramids and the Great Sphinx, stand at Giza west of Cairo.

Description. Cairo is a mixture of the old and the new. In general, the oldest and most historic sections are in the eastern part of the city. The newer, more modern areas are along the west bank of the Nile; on islands in the river; and on Garden City, a narrow strip along the east bank. In the 1800's and 1900's, bridges were built connecting the city to the islands and the west bank. These bridges made urban development possible on both sides of the Nile. Most government buildings, foreign embassies, hotels, museums, and universities are in Garden City, on the islands, or in the suburbs. 

Most buildings in the modern sections of Cairo were built in the 1900's. Their design is in the style of present- day American and European architecture. The newer areas of Cairo have many gardens, parks, public squares, and wide boulevards, which make these areas less crowded and more orderly than the older sections. 

Cairo's older areas offer a sharp contrast with the modern sections. They are famous for their old quarters areas of narrow, winding streets and bldgs that are hundreds of years old. Bazaars (outdoor shopping areas) fill almost all the available space in some streets. In many of the bldgs of the old sections, open-front shops occupy the ground floor. Small apts take up the upper floors.

The old sections are also known for their more than 300 mosques (Islamic houses of worship). Minarets (tall, slender towers) are important features of the mosques. Islamic officials called muezzins announce prayer time from atop the minarets five times a day. At least one minaret can be seen from almost any place in Cairo's old sections. 

Many of Cairo's mosques are outstanding examples of Islamic architecture. Some of the most famous mosques and their construction dates are Ahmed Ibn Tulun (A.D. 870's), al-Azhar (about 970), Sultan Hassan (mid-1300's), Kayit Bey (about 1475), and Muhammad Ali (early 1800's). The Mosque of al-Azhar is part of a university, and the Muhammad Ali Mosque is part of a walled fortress called the Citadel. 

Cairo's museums house priceless treasures from many periods in history. The city's Egyptian Museum contains the mummy of Ramses II and the gold mask and other belongings of King Tutankhamen. The Museum of Islamic Art contains objects that date from the 600's to the 1800's. 

People. The people of Cairo are called Cairenes. Many of them are poor, unskilled workers employed by factories or small shops. They live in crowded apartments in the old quarters. Some dress in long, flowing robes, the traditional Arab garment. But most wear Western-style clothes made in Egypt. Most middle-class and wealthy Cairenes live in Garden City, on the islands, or in the suburbs. These people include doctors, factory managers, government officials, lawyers, and teachers. They dress like Americans and Europeans. 

Most Cairenes are Arabs and Muslims. The Copts form the largest Christian group in Cairo. They trace their origin back to the Christians who lived in Egypt before the Arabs came. Many Europeans and some Jews live in Cairo, but their numbers have decreased greatly since the mid-1900's. At that time, the government took over most businesses and adopted policies that promoted the economic opportunities of Egyptian Muslims. These policies limited the opportunities of minority groups and foreigners. 

Schools. Most of Egypt's schools of higher learning are in or near Cairo. They include Ain Shams University in Cairo; and Cairo University, the largest university in the country, in nearby Giza. Al-Azhar University, in Cairo, is a major center for the study of Islam, the religion of Muslims. This university was founded about 970 and ranks among the world's oldest. 

Climate. Cairo has hot summers and mild winters. In July, the average daily high temperature is 96 ?F. (36 ?C) and the average low is 70 ?F. (21 ?C). The average daily high in January is 65 ?F. (18 ?C) and the average low is 47 ?F. (8 ?C). During the summer, many families leave the city and go to seaside resorts to escape the heat. Cairo's mild winters attract many tourists from colder places. 

Cairo receives only about 1 inch (2.5 centimeters) of rain a year. The sun shines almost every day. For more details on Cairo's climate, see Egypt. 

Economy. The Cairo area is an important manufacturing center. A factory at Hulwan, south of the city, makes iron and steel. Other industries in and near Cairo process sugar and manufacture chemicals, paper, textiles, and other products. Many small companies and shops make such items as jewelry and statues that are sold to tourists as souvenirs. In the mid-1900's, the government took over all but the smallest industries. Many industries have been returned to private ownership, but the government still owns the majority of them. 

Tourism is a key part of Cairo's economy. Each year, thousands of visitors come to see the mosques, museums, pyramids, sphinx, and other attractions. 

History. The ancient city of Memphis once stood near the site of present-day Cairo. It was founded about 3100 B.C. as the first capital of ancient Egypt. In the A.D. 640's, Arabs from the east conquered Egypt. At the time, Egypt was a province of the Byzantine, or East Roman, Empire. Its people--descendants of the ancient Egyptians--were Christians. In 640, the Arab conquerors set up a large military camp near what is now southern Cairo. They later built houses, mosques, and palaces, and the camp became the Arab capital, Fustat. 

The Fatimids (Arabs who controlled part of northern Africa) conquered Egypt in 969. General Jawhar established a new capital at Cairo for al-Muizz, the Fatimid caliph (ruler). Jawhar built up the area north of the first Arab settlement, and Cairo soon became one of the most important cities of the Arab world. The Fatimids founded al-Azhar University, which attracted students of Islam from many countries. The Fatimids called their city Al Qahirah, perhaps because the planet Mars (al-Qahir in Arabic) was rising in the sky when they began building. The name Cairo comes from Al Qahirah. 

Saladin, the founder of Egypt's Ayyubid dynasty (family of rulers), expanded the city's boundaries and built the Citadel in the late 1100's. The Mamelukes, who had been the Ayyubids' bodyguards, ruled Egypt from 1250 to 1517. They built many of Cairo's finest mosques and extended the city to its present boundaries. The Ottomans gained control of Egypt in 1517. They allowed the Egyptians a large degree of self-government. Ottoman control declined in the late 1700's. 

Many treasures of ancient Egypt were discovered in the early 1800's. Exhibits and lectures about Egypt's past aroused great interest among people in Western countries during the 1800's. Thousands visited Cairo to see wonders they had heard about. Many Europeans settled in Cairo during the 1800's, when European nations became more involved in Egypt's affairs. Many programs worked to modernize Cairo in the 1800's and 1900's. 

Britain gained effective control of Egypt in 1882. Egypt became an independent monarchy in 1922. The government has done much to modernize Cairo, especially since a republic form of government was established in 1953. But great poverty exists in many parts of the city. 

The rapid population growth of Cairo and the surrounding area has contributed to the poverty problem. The city's population increased from about 375,000 in 1882 to over 31/2 million in the 1960's and nearly 7 million in the 1990's. This population growth resulted from three causes--(1) a high birth rate, (2) thousands of Egyptian families moving from rural areas to Cairo, and (3) refugees from Ismailia, Port Said, and Suez. These cities were heavily damaged in fighting between Egyptian and Israeli forces along the Suez Canal in the late 1960's and early 1970's. In 1987, the Cairo Metro, Egypt's first subway, opened. 

In Oct 1992, an earthquake struck Cairo and its suburbs. The earthquake caused over 560 deaths and about $1 billion in property damages. 
0     &     Cairo, EGYPT NE Africa CAI 	y= Oldest white settlement in S.Africa (1652). Major port
City sits in a three sided box of mountains. Fourth side
opens into harbor. Sugar Hill View Pt. Table Mt (3550ft)
cablecar.
a/p 14mi/E  Intercape ABus >train Stn
YMCA, Htl Cafe Royal 23 Church St

Pretty as a Picture, Though the Details Are Fuzzy By
DONALD G. McNEIL Jr.

I suspect that if I could read German better (it's
slipped away since high school, and learning to read road
signs in Afrikaans has helped only a little), I would
think the best Web site about Cape Town was one produced
in Germany, www.kapstadt.de/allgem.htm. It seems
remarkably thorough. For English-speakers, I'm afraid,
the choices are a bit frustrating. One problem is that
many South African Web sites seem to have a fundamental
weakness: they give nice write-ups to people who buy ads.
I could find several sites with beautiful pictures of the
city, beaches, botanical gardens, the Victoria and Alfred
Waterfront and the Cape of Good Hope, which Sir Francis
Drake wrote was "the most stately thing, and the fairest
cape we saw in the whole circumference of the earth." I
couldn't find any with the kind of independently verified
helpful list of restaurants and hotels that a good
guidebook has. Other than that, the prettiest and most
comprehensive site was www.nelsonsguides.co.za, which is
produced by a Cape Town company that publishes pocket
guides handed out free in hotels. Its opening picture of
Table Mountain, which dominates the city even more
imposingly than skyscrapers dominate New York, is
stunning. Browsing its pretty picture gallery brought up
links to other Web sites. For example, Cape Town has the
largest aquarium in the Southern Hemisphere, and there
was a link to the Two Oceans Aquarium site. Some choices
were odd -- the picture of the three-hour scenic drive
around Cape Point is of a baboon by the road. The maps,
reproduced from the pocket guide, are detailed. Its pages
of local history go well back and put Cape Town in its
context as part of South Africa's bloody past. But the
accommodation and restaurant pages are woefully skimpy --
presumably, only those that paid to be listed. Another
site, www.doorway.co.za, can be slow to respond but has
the best-known restaurants and hotels. Its listings are
free, but limited to a few mostly saccharine words chosen
by the lister. An excellent site for South Africa in
general is the one maintained by Lonely Planet guides
which puts out what I think is the best guide to the
country. This site, www.lonelyplanet.com, has a section
on Cape Town and has links to a forum (Traveler's
Reports) where travelers -- mostly backpackers -- send
their latest advice about places to stay, things to do
and dangers to avoid. It doesn't give details about
hotels and restaurants. For that, you have to buy the
book. DONALD G. McNEIL JR. reports from South Africa for
The Times.?  =   " , 0   Capetown Kaapstadt D.F.Malan CPT S.Africa 	  Closest point to South America and eastern end of slave
trade.
a/p City bus #7/8 on hway
GH: City ctr.     Eat: Street food near RR stn.
AmEmb: 23-3424/4296\

Capital and largest city of Senegal and the westernmost city on the mainland of Africa. Dakar is Senegal's major seaport and an important industrial and transportation center.   (pop. 1,447,642).

Dakar's port is a center of trade. The city's economic activities include food processing, printing, tourism, and the manufacture of cement, cigarettes, shoes, soap, and textiles. An intl airport and the Univ of Dakar are in the city. Dakar has modern and old French bldgs of colonial architecture. It also has shantytowns (areas of shacks and huts). 

Dakar began to grow in 1857, when a French fort was built on the site of a settlement there. It later became the capital of French West Africa. Senegal became an independent nation in 1960. Many people have since moved to Dakar from rural areas, and the city faces housing and unemployment problems\5     & +    Dakar, SENEGAL W coast Yoff DKR 	0  A/P  9mi/    Bus# 16
One of four imperial cities: Rabat, Meknes, Marrakesh.

The religious center of Morocco and one of its traditio- nal capitals. It boasts the Mosque of Mulai Idris, a noted Muslim shrine. Karaouiyine Univ, one of the world's oldest universities, was founded in 859.  (pop 769,014)

Fez lies in the deep valley of the Fez River in northern Morocco. Railroads connect it with other North African cities. It is noted for its silk, woolen, and leather goods. The Arab ruler Idris II founded Fez as his capital in 808. The city declined in the 1600's, when Sultan Ismail built his palace in Meknes. But it again became the capital from 1728 until the French occupation of Morocco in 1912. 
" 0 0        Fez, Morocco 	% The capital and largest city of Botswana. Gaborone lies in the southern part of the country. The city was formerly called Gaberones. A carefully planned city. Much of it has been built up since 1966, when it became Botswana's capital. Gaborone has many modern government buildings and residential areas. It also has a national museum and art gallery. The University of Botswana and an agricultural college are located in Gaborone. The govt is a major employer in the city. An airport and a railroad serve Gaborone.  (pop. 96,000),

Gaborone was founded in the 1890's. It was a small village until it became the capital. The presence of the national government in Gaborone has helped the city grow rapidly. 
, % %    "    Gaborone, BOTSWANA GBE 	r	 Harare is one of the most prosperous and developed cities in southern Africa. As the capital of Zimbabwe, Harare is the country's major cultural, commercial and educational center. Harare, also called the "Sunshine City" because of its year-round good weather, has many beautiful parks and gardens. Harares population of over 600,000 is multi-racial and ethnic, making a rich culture of different people and languages.

As a former colony, much of Harares history was turbulent. For ninety years the city was known as Salisbury, Rhodesia. In 1980 Zimbabwe became Africas newest independent nation. The city is named after a former African ruler of the area called Harare, which means "one who does not sleep."

While Harare entertains visitors with an array of theaters, night spots and restaurants, it is best known for its numerous and extensive gardens. The world renowned Shona sculptures are a major attraction. The people of Harare love sports and the outdoors. The city offers soccer, the most popular sport, horse racing, tennis, rugby and water sports at Lake McIlwaine.

Cincinnatis pairing with Harare was signed in 1990. Since then Cincinnatis public libraries hosted an exhibit of African art, and numerous exchange delegations have visited each city.

--------------------------------------------------------- The capital and largest city of Zimbabwe. The city serves as Zimbabwe's center of govt, banking, and commerce. Modern hotels and office buildings rise along wide, busy streets. Africa Unity Square, an open area with a beautiful park, is there. The Harare area includes an art museum, the University of Zimbabwe, and an international airport. Both upper-class suburbs and crowded slums lie on the outskirts of Harare. 

Harare is a trading center for products raised on the region's fertile plains. The chief products are citrus fruits, corn, cotton, and tobacco. Industries in Harare produce clothing, fertilizer, furniture, and steel.   (pop. 1,200,000)

White South African settlers founded Harare in 1890. The town was first called Salisbury, a British name. It was governed by a British company organized by the diamond king Cecil Rhodes. In 1923, the United Kingdom made Salisbury the capital of the self-governing colony of Southern Rhodesia. The colony became the independent nation of Zimbabwe in 1980. In 1982, Salisbury was renamed Harare, an African name. 

*           Harare, ZIMBABWE HRE 	"D Bad airport security. A Kenyan 737 was stopped with shit
on the runway and robbed upon landing. The third in a
year. HT 1/06/99
The largest city of Nigeria. Located in SW Nigeria, Lagos
lies partly on the African mainland and partly on four
islands in the Gulf of Guinea. Lagos is Nigeria's chief
port and commercial center. The city's air, railway,
road, and water transportation facilities provide links
with other parts of Nigeria. An intl airport operates at
nearby Ikeja.  (pop. 1,097,000)

Yoruba people lived in what is now Lagos before
Portuguese explorers arrived in the late 1400's. Lagos
was a major slave market until 1851, when it became a
British protectorate. Britain annexed Lagos in 1861 and
made it the capital of Nigeria in 1914. 

In 1980, the Nigerian government began building a new
city called Abuja near the center of the country to
replace Lagos as the capital. In December 1991, Abuja
became Nigeria's official capital. By the late 1990's,
all government ministries had moved their headquarters to
Abuja\8  D    .    Lagos Nigeria Murtala Muhammed LOS 	 The capital and largest city of Angola, and the country's chief industrial center and port. It lies on the west coast of Africa, along the Atlantic Ocean. Its industrial facilities include foundries; sawmills; textile mills; and cement, printing, and food-processing plants. An airport and a railroad serve the city. (pop. 1,200,000)

The Portuguese established a colony in Angola in 1575 and founded Luanda in 1576. The city became the main center of Portuguese settlement in Angola. The Portuguese built many impressive European-style structures in Luanda, including a fortress, churches, libraries, business and government buildings, and apartment buildings. Run-down areas called shantytowns lie outside the city. 

Angola gained its independence from Portugal in 1975. Civil war broke out after Angola became independent, and most of the Portuguese left. Today, the majority of Luanda's people are black Africans. 
2      (    Luanda, ANGOLA Fevereiro LAD 			 Nairobi is the capital of Kenya and the most important
commercial center in eastern Africa. The city lies on a
high plateau in south-central Kenya. 

The central area of Nairobi has many modern buildings,
and its main streets are lined with trees. This area
includes the parliament buildings, the Kenyatta Conf
Center, the Holy Family Cathedral, the Jamia Mosque, and
hotels and comm bldgs. The National Museum and the
University of Nairobi are north of the central area.
Railroad yards and an industrial area lie to the south.
About 5 mi farther south, but still within the city, is
Nairobi National Park. The park covers 44 sq mi of open
land where lions, gazelles, gnus, zebras, and other wild
animals live. 

Many of Nairobi's people live in large, low-cost
apartment complexes called estates. Other residents
occupy single-family homes. 

The Kenyan government is a major employer in Nairobi.
Industries in Nairobi produce beverages, cement,
chemicals, clothing, foods, furniture, glass, machinery,
paint, shoes, soap, and textiles. Tourism is an important
part of Nairobi's economy. Many people visit the city to
see Nairobi National Park and to take trips to other
Kenyan game reserves. Nairobi is a center for banking,
trade, and other commercial activities. It also is an
important railroad center. 

Nairobi was originally the site of a water hole called
Enkare Nairobi, which means cold water. The city became a
railroad center in the early 1900's. In 1963, when Kenya
became independent from Britain, the area of Nairobi was
expanded from about 35 sq mi to 266 sq mi. 
 
---------------------------------------------------------
City (pop., 1991 est.: 2,000,000), capital of Kenya. It
is located in S central Kenya at an elevation of about
5,500 ft (1,680 m). Founded c.1899 as a colonial railroad
site, it became the capital of British E. Africa in 1905.
As a govt and trade center, it attracted many settlers
from rural Kenya, making it one of the largest cities in
Africa. When Kenya gained independence in 1963, it
remained the capital, with its area greatly expanded by
the new constitution. It is Kenya's principal commercial
and industrial city, producing beverages, processed food,
cigarettes, and furniture. The city exports many products
via the port of Mombasa. Noted institutions and landmarks
include the Univ. of Nairobi and the National Museum of
Kenya. Tourism is an important industry, with Nairobi
National Park attracting many visitors\. O 	    $    Nairobi Kenya Wilson WIL 	2 The capital and largest city of Burkina Faso. The city has a modern central district and numerous mosques (Islamic houses of worship). The palace of the Moro Naba, the traditional leader of the country's Mossi people, is also in the city. Ouagadougou has an airport, a univ, and a museum of African art. Its industries include food processing, the bottling of beverages, and the production of building supplies and textiles. (pop. 442,223)

Ouagadougou was probably founded in the 1100's. In the mid-1400's, it became the Moro Naba's capital. French forces captured the city in 1896. Ouagadougou grew little until 1954, when a railroad connected the city with Bobo Dioulasso and Cote d'Ivoire. Since then, many people have moved to the city in search of work. 
3 2 2    )    Ouagadougou, BURKINA FASO OUA <     2    Sal Cape Verde Amilcar Cabral Intl SID 	l	 The last thing Africa needs is another deadly epidemic. Yet alarming reports of sleeping sickness in equatorial Africa reached the Western world this summer. "Whole villages will die," predicts Anne Moore, an investigator for the Centers for Disease Control who visited the current hot spot in southern Sudan. In a preliminary study her team found that close to 20 percent of those tested in the region of Tambura had the lethal parasite Trypanosoma brucei gambiense in their blood. In Ezo, a town of 6,000, some 45 percent of those screened tested positive. "In a village near Ezo everyone has apparently died except the few that fled," says Moore. Sleeping sickness, officially called African trypanosomiasis, was once Africa's biggest public health scourge. It begins with a bite from a tsetse, a fly with a nasty taste for blood. If your fly is carrying the trypanosome pathogen, that bite can transmit the disease. A lousy flu-like feeling sets in as you fight a foe that multiplies and fakes out your immune system by changing its outer coat. Sooner or later, parasites inflame your brain, causing weird changes in behavior, personality, and sleep. You sink into zombielike apathy, and eventually lapse into a coma that ends in death. A turn-of-the-century epidemic in the Belgian Congo killed half a million people. Today, with prompt treatment, the disease is curable. In fact, until recently it was well controlled. So what went wrong? Regional civil war is one problem: people fled into the bush and ran into flies. More important, war chased out Belgian doctors in the late 1980s, and relief organizations like CARE and the International Medical Corps only recently returned. And then there are problems with the treatments themselves. Melarsoprol attacks the parasite's ability to fend off the body's defenses, but it's toxic and costs roughly $150 for a weeklong course of treatment. A less toxic drug, DFMO (difluoromethylornithine), works by preventing the parasite from multiplying, but its $400 price tag is far too high for countries poor in medical resources. That's one reason doctors in Sudan called the CDC: they needed to document the epidemic to raise cash. But the outbreak in Sudan is only the tip of the iceberg. Tens of thousands are said to be dying each year in the Democratic Republic of the Congo (formerly Zaire). And there's word of flare-ups elsewhere in the tsetse belt\/     !     Sleeping Sickness African 	T
 Without doubt, the Victoria Falls constitute one of the most spectacular natural wonders of the world. Visitors can gaze at the mighty Zambezi as it flows, broad and placid, to the brink of a basalt lip seventeen hundred metres wide before taking a headlong plunge into the frothy chasm of the gorge below.

This is the world's largest sheet of falling water, yet although its fame has spread far and wide, the site has been tastefully preserved so that tourists do not spoil the magic of the very place they have come to see.

There is far more to do at Victoria Falls than to marvel at the Falls themselves; upstream, the Zambezi plays host to the famous 'sundowner' cruises, excursions onto the river to watch the local wildlife while gently sipping a glass of champagne and partaking of a light snack.

But once the river has taken its plunge, there is quite a different experience to be had. For those with the courage, the rapids immediately downstream offer some of the most terrifying white water rafting anywhere in the world. Several companies now offer one and two day trips on this stretch of the river, while the more adventurous can take a week long journey all the way to the mouth of Lake Kariba.

There is also a spectacular excursion to be made on foot. The Rainforest on the lip of the chasm opposite the Falls is a unique swathe of dense tropical vegetation which thrives on the spray thrown up throughout the year. A well-kept path takes tourists on a walk through the forest, with occasional diversions to viewing points for the Falls themselves. But the ultimate view of this natural wonder can only be seen from the air. The 'Flight of Angels' provides a fabulous vista of the upstream river and its many islands, the spray from the Falls as it is kicked a thousand feet into the sky, and the tortuous zig-zag of the gorge downstream.

To absorb all these experiences can take many days, and Victoria Falls is not short of excellent hotel facilities. The Victoria Falls Hotel, built in 1904, is still one of the most romantic in the country, an opulent building in the grandest of colonial styles occupying a prime view of the site.

Many of the hotels offer a choice of evening sustenance: a splendid buffet under the stars, with the sound of the Falls rumbling in the distance, or a sumptuous dinner in their restaurants. After supper, there's a fabulous display of traditional dancing to be seen., But people do not come to the Victoria Falls for holidays alone. There are also superb conference facilities, offering delegates a remarkable experience of Africa to complement the business of the day\1      '    Victoria Falls Zimbabwe VFA 
      &                          ~       | { z y x w 3 v u 1 "  0  % # r   !  p  n m l k j i h g f e   b a ` _  ]  \ [  Z ( ' Y X W V  T S R  Q P O  + M L * ) K J 2 H G F E D C B A @ ?  /  6  <  5 $ ; : 4  -  
 . 8    	                
-                 "          b  0 3La  DL P}  l	 -T
 p7H  "  j!  	 Z      H  y PJj  K,   V g*  J 8+. 
QV)  B _  - X# 2  J 	  r        r	   a 9~ c d t w  q( gk 5u\ ! 8      : .  i -    d*5f fT
 S$ %5  [          ee       )  y                  M    " +j  2 A  9  Ǳ&   0  &/  A71  A3  V3  /  6       4  !)  U  ~&  B  /  1  0  a+  .  6  ش.  0  =  <F  y5  r     +  *  2  ( #    
+  (&  S  y;  ,  c<  }#  ж&  C  ,  \'       '  ,  ַ-  "  u'  /3  f-%  V;  {    Ӹ     9       ,  )-  U6            >  @  ,  6)  b6  7  A  9  9/  r7       /  ػ:  0  A,  q     .  6*2  (  ϼ1  0  (+  X     '  /  2  ٽ7  ?  B+  .  3  ھ     (  
8  55  m5            0  ׿3  :  :)  t.  0  0  3  +9  ^/       (       4            8  "3  Z>  9  ?  0  C3  s8       6  ?  3     4  ?  H1       /  0  .  3  E;  x+  +  4  	7  =4  t     4       ,  *  :  21  l5  0  ;  64  q<  -:  T  8  M:  3     L  m=  <  y            
   T U                     