\ Graphic library for HP100/200LX.
\ This is port to FortCMP of original LXGRAPH by Curtis Cameron.
\ Added some routines from J. A. Wrotniak's graphic library.
\ *
\ Pavel Zampach (zampach@volny.cz), 2002


10 HEX

?DEFINE SetLabel [IF]
CREATE xk 1D , 59 , 95 , 0D1 , 113 , 14F , 18B , 1C7 , 20A , 246 ,
1 1 IN/OUT
 \ [1..10]
: xk[n]
\ ( n -- val )
\ constructor for array xk
  1- 2* xk + @
;
[THEN]

2 0 IN/OUT
U: SetLabel
\ ( n adr -- )
\ par n number of label
\ par adr address of text string
\ draws a label for function keys
  G_FORCE SetReplacementRule
  BLACK Pen
  >R xk[n] DUP tk OVER wk + 0C7 1 DrawRectangle ( xk[n] -- )
  R@ C@ 0= IF
    R> 2DROP EXIT
  THEN
  WHITE Pen
  SmallFont
  R@ C@ 8 * wk SWAP - 2/ 1+ + tk 1+ AT-GRXY
  R> COUNT TYPE
;


1 0 IN/OUT
U: ClearLabel
\ ( n -- )
\ par n number of label
\ wipes a label for function keys
  G_FORCE SetReplacementRule
  WHITE Pen
  xk[n] tk OVER wk + 0C7 1 DrawRectangle
;


U: DrawTitleBox
\ ( x1 y1 x2 y2 adr cl -- )
\ par x1 x-coord of left upper corner
\ par y1 y-coord of left upper corner
\ par x2 x-coord of right bottom corner
\ par y2 y-coord of right bottom corner
\ par adr address of title text string
\ par cl says whether to clear first (boolean)
\ draws shadow box with title.
  SWAP >R >R y2a ! x2a ! y1a ! x1a !
  x1a @ y1a @ x2a @ y2a @      R> DrawShadowBox
  x1a @ y1a @ x2a @ y1a @ 0C + 1  DrawRectangle
  WHITE Pen
  MediumFont
  G_FORCE SetReplacementRule
  x1a @ x2a @ + R@ C@ 0A * - 2 /   y1a @ 2 + AT-GRXY
  R> COUNT TYPE
  BLACK Pen
  G_FORCETEXT SetReplacementRule
;

U: DrawShadowBox
\ ( x1 y1 x2 y2 cl -- )
\ par x1 x-coord of left upper corner
\ par y1 y-coord of left upper corner
\ par x2 x-coord of right bottom corner
\ par y2 y-coord of right bottom corner
\ par cl says whether to clear first (boolean)
\ draws shadow box.
  G_FORCETEXT SetReplacementRule
  >R y2 ! x2 ! y1 ! x1 !
  R> IF
    WHITE Pen
    x1 @ 1- y1 @ 1- x2 @ 1+ y2 @ 1+   1 DrawRectangle
  THEN
  BLACK Pen
  x1 @    y1 @    x2 @    y2 @        0 DrawRectangle
  x1 @ 1+ y1 @ 1+ x2 @ 1- y2 @ 1-     0 DrawRectangle
  shadow SetFillMask
  x1 @ 8 + y2 @ 1+  x2 @ 8 + y2 @ 4 + 2 DrawRectangle
  x2 @ 1+  y1 @ 4 + x2 @ 8 + y2 @     2 DrawRectangle
;

U: PAGE
\ ( -- )
\ clears screen and sets medium font.
  GraphicsOn
  MediumFont
  xtex OFF ytex OFF
;

U: LargeFont
\ ( -- )
\ sets large fonts for text output.
  0C fonty ! 10 fontx ! 100C (setfont)
;

U: MediumFont
\ ( -- )
\ sets medium fonts for text output.
  0B fonty ! 0A fontx ! 0A0B (setfont)
;

U: SmallFont
\ ( -- )
\ sets small fonts for text output.
  8 fonty ! 8 fontx ! 0808 (setfont)
;

U: CR
\ ( -- )
\ redefinition of standard Forth procedure.
  gron @ IF
    xtex OFF fonty @ ytex +!
  ELSE
    0D EMIT 0A EMIT
  THEN
;

U: HorizLine
\ ( x1 y1 x2 -- )
\ par x1 x-coord of origin
\ par y1 y-coord of origin
\ par x2 x-coord of end
\ draws horizontal line, using pen and line types previously set.
  OVER DrawLine
;

U: VertLine
\ ( x1 y1 y2 -- )
\ par x1 x-coord of origin
\ par y1 y-coord of origin
\ par y2 y-coord of end
\ draws verical line, using pen and line types previously set.
  >R OVER R> DrawLine
;

U: DrawLine
\ ( x1 y1 x2 y2 -- )
\ par x1 x-coord of origin
\ par y1 y-coord of origin
\ par x2 x-coord of end
\ par y2 y-coord of end
\ draws line, using pen and line types previously set.
  2SWAP Move Draw
;

2 0 IN/OUT
U: AT-XY
\ ( x y -- )
\ redefinition of standard Forth procedure.
  fonty @ * ytex !
  fontx @ * xtex !
;

2 0 IN/OUT
U: AT-GRXY
\ ( x y -- )
\ is similar to AT-XY, but coords are in pixels.
  ytex ! xtex !
;

?DEFINE GraphicsOn [IF]
0 0 IN/OUT
CODE GraphicsOn
\ ( -- )
\ turns on 640x200 graphics and clears screen.
\ Switch EMIT into graphic mode.
  0006 # AX MOV
  5F INT
  1 # AL MOV
  AL gron [] MOV
  RET
END-CODE
[THEN]

?DEFINE LoResGraphicsOn [IF]
0 0 IN/OUT
CODE LoResGraphicsOn
\ ( -- )
\ turns on HP95 compatible graphics and switch EMIT into graphic mode.
  0020 # AX MOV
  5F INT
  1 # AL MOV
  AL gron [] MOV
  RET
END-CODE
[THEN]

?DEFINE GraphicsOff [IF]
0 0 IN/OUT
CODE GraphicsOff
\ ( -- )
\ turns off graphics and switch EMIT to standard console output.
  0003 # AX MOV
  5F INT
  AL AL XOR
  AL gron [] MOV
  RET
END-CODE
[THEN]

?DEFINE Pen [IF]
1 0 IN/OUT
CODE Pen
\ ( n -- )
\ par n WHITE (0) or BLACK (1)
\ sets pen color.
  09 # AH MOV
  5F INT
  RET
END-CODE
[THEN]

?DEFINE Line [IF]
1 0 IN/OUT
CODE Line
\ ( n -- )
\ par n 16-bit pattern
\ lines and rectangles will be drawn with pattern.
  AX CX MOV
  0B # AH MOV
  5F INT
  RET
END-CODE
[THEN]

2 0 IN/OUT
CODE Move
\ ( x y -- )
\ moves pen without drawing anything.
  AX DX MOV
  BX CX MOV
  08 # AH MOV
  5F INT
  RET
END-CODE

?DEFINE DrawDot [IF]
2 0 IN/OUT
CODE DrawDot
\ ( x y -- )
\ draws one point.
  AX DX MOV
  BX CX MOV
  07 # AH MOV
  5F INT
  RET
END-CODE
[THEN]

?DEFINE Draw [IF]
2 0 IN/OUT
CODE Draw
\ ( x y -- )
\ draws from old pen position to (x, y), using pen and line types previously set.
  AX DX MOV
  BX CX MOV
  06 # AH MOV
  5F INT
  RET
END-CODE
[THEN]


?DEFINE DrawRectangle [IF]
CODE DrawRectangle
\ ( x1 y1 x2 y2 fill -- )
\ par x1 x-coord of left upper corner
\ par y1 y-coord of left upper corner
\ par x2 x-coord of right bottom corner
\ par y2 y-coord of right bottom corner
\ par fill 0=outline, 1=pen fill, 2=pattern fill
\ draws filled rectangle.
  ES POPSEG     \ return address
  DI POP        \ fill
  CX POP        \ y2
  DX POP        \ x2
  AX POP        \ y1
  BX POP        \ x1
  ES PUSHSEG    \ return address back first
  DX PUSH       \ x2 back
  CX PUSH       \ y2 back
  DI PUSH       \ fill back
  CALL' Move
  AX POP        \ fill
  DX POP        \ y2
  CX POP        \ x2
  05 # AH MOV
  5F INT
  RET
END-CODE
[THEN]


?DEFINE SetFillMask [IF]
1 0 IN/OUT
CODE SetFillMask
\ ( addr -- )
\ par addr is pointer to 8 byte pattern
\ sets fill type for rectangles.
  AX DI MOV
  DS PUSHSEG
  ES POPSEG
  01 # AH MOV
  5F INT
  RET
END-CODE
[THEN]

?DEFINE SetReplacementRule [IF]
1 0 IN/OUT
CODE SetReplacementRule
\ ( n -- )
\ par n G_FORCE, G_AND, G_NOT, G_OR, G_XOR, G_FORCETEXT
\ sets rule for next drawing.
  0A # AH MOV
  5F INT
  RET
END-CODE
[THEN]

?DEFINE StoreArea [IF]
CODE StoreArea
\ ( x1 y1 x2 y2 addr -- )
\ par x1 x-coord of left upper corner
\ par y1 y-coord of left upper corner
\ par x2 x-coord of right bottom corner
\ par y2 y-coord of right bottom corner
\ par addr have to be set to point to memory area large enough to hold the image
\ stores screen area into memory (in data segment).
  BX POP    \ return address
  DI POP    \ offset of buffer
  DS PUSHSEG
  ES POPSEG \ segment of buffer
  BP POP    \ y2
  SI POP    \ x2
  DX POP    \ y1
  CX POP    \ x1
  0D # AH MOV
  BX PUSH   \ return address back
  5F INT
  RET
END-CODE
[THEN]

?DEFINE PlaceArea [IF]
CODE PlaceArea
\ ( x y addr repl -- )
\ par x x-coord of left upper corner
\ par y y-coord of left upper corner
\ par addr point to memory
\ par repl G_FORCE, G_AND, G_NOT, G_OR, G_XOR, G_FORCETEXT
\ places area from memory to screen. This routine has one more
\  parameter then original Cameron's one (repl)!
  BX POP    \ return address
  AX POP    \ replacement rule
  DI POP    \ offset of buffer
  DS PUSHSEG
  ES POPSEG \ segment of buffer
  DX POP    \ y
  CX POP    \ x
  0E # AH MOV
  BX PUSH   \ return address back
  5F INT
  RET
END-CODE
[THEN]

?DEFINE Clip [IF]
CODE Clip
\ ( x1 y1 x2 y2 -- )
\ par x1 x-coord of left upper corner
\ par y1 y-coord of left upper corner
\ par x2 x-coord of right bottom corner
\ par y2 y-coord of right bottom corner
\ sets clip area.
  BX POP    \ return address
  DI POP    \ y2
  SI POP    \ x2
  DX POP    \ y1
  CX POP    \ x1
  4 # AH MOV
  BX PUSH   \ return address back
  5F INT
  RET
END-CODE
[THEN]

?DEFINE DotRead [IF]
2 1 IN/OUT
CODE DotRead
\ ( x y -- c )
\ par x x-coord
\ par y y-coord
\ par c color of pixel - WHITE (0) or BLACK (1)
\ reads the pixel color.
  AX DX MOV
  BX CX MOV
  0C # AH MOV
  5F INT
  AH AH XOR
  RET
END-CODE
[THEN]

?DEFINE LogOrig [IF]
2 0 IN/OUT
CODE LogOrig
\ ( x y -- )
\ par x x-coord
\ par y y-coord
\ sets logical origin of coords.
  AX DX MOV
  BX CX MOV
  3 # AH MOV
  5F INT
  RET
END-CODE
[THEN]

1 0 IN/OUT
CODE EMIT
\ ( char -- )
\ This basic text output rutine is redefineted and so it is
\ allowed to use all standard text output routines ( .
\ ." .R ) in graphics mode too. Output is switched by 
\ GraphicsOn or LoResGraphicsOn and back by GraphicsOff.
  AL DL MOV
  gron [] AL MOV
  1 # AL CMP =0 IF,
    DL AL MOV
    AL chre [] MOV    \ graphic text output
    0F00 # AX MOV
    xtex [] CX MOV
    ytex [] DX MOV
    chre # DI MOV
    DS PUSHSEG
    ES POPSEG
    5F INT
    fontx [] AX MOV    \ xtex:=xtex+fontx
    xtex [] BX MOV
    BX AX ADD
    AX xtex [] MOV
    RET
  THEN,                \ standard DOS output
    02 # AH MOV
    21 INT
    RET
END-CODE


?DEFINE (setfont) [IF]
1 0 IN/OUT
CODE (setfont)
\ ( n -- )
\ help procedure for setting font size.
  AX CX MOV
  10 # AH MOV
  5F INT
  DX ES >SEG
  AX DI MOV
  11 # AH MOV
  5F INT
  RET
END-CODE
[THEN]

0A = [IF] DECIMAL [THEN]