#		      Loki Resource Source File
#
# See the file resource.doc for information on the syntax of this file.
#
# Please be careful when making changes to the resource file.  This
# file, in effect, "opens up" the internals of the program and it _is_
# possible to create a file that will cause the program to crash.  If in
# doubt, fetch a clean copy of the distribution version and start over
# with your changes.
#
# In general, you can change the _values_ for any entry.  Changing an
# entry's _type_ or inserting or deleting entries (except for adding
# new entries to the end of a table) is what will cause big problems.
#
# This file can be compiled for one of four types of systems:
#
#	i	generic IBMPC and compatible
#	c	HP100LX "cougar:" system manager
#	d	HP100LX "DOS:" MS/DOS, but don't assume sys mgr loaded
#	j	HP95LX "jaguar:" MS/DOS under system manager
#	s	HP95LX "system manager:" system manager
#	u	applies to Unix systems
#
# Not all of these values apply to all systems.  Restrictions are
# marked.

# ------------------------------------------------------------
# Character Sets

include "rpagebeg.res"
include "rpage^$.res"

# ------------------------------------------------------------
# Units
# ------------------------------------------------------------
# This table holds the unit definitions.  Each entry has these entries:
#
#	string		the suffix that uniquely designates the unit; may
#			have two parts separated by single space
#			character; first part must be unique among all
#			units and WORD_CMDS (and not be "e")
#
#	string		a print format; first character is a designator
#			with these meanings:
#
#				space	send the rest to xprintf [*]
#				G	general purpose float
#				K	display ASCII/key name
#
#			[*] The string that is sent has any *
#			characters replaced with the computed field
#			width.
#
#	int		a unit category code:
#
#				0	untyped
#				1	binary
#				2	distance
#				3	area
#				4	volume
#				5	mass
#				6	angle
#				7	time
#				8	date
#				9	temperature
#
#	factors		a string containing up to 3 unit factors: see the
#			examples
#
#	int		display by default: 1:yes, 0:no


table	UNITS

UN_NONE		"none"
UN__FORMAT	"G"
UN__CAT		0
UN__FACTORS	0
UN__VIS		1

# binary units

UN_BIN		"b"
-		" %bb"
-		1
-		""
-		0

UN_OCT		"o"
-		" %oo"
-		1
-		""
-		_sj 0
		_* 1

UN_DEC		"d"
-		" %dd"	# format is ignored: see UFormat in lunits.c
-		1
-		""
-		1

UN_HEX		"h"
-		" %xh"
-		1
-		""
-		1

UN_ASCII	"k"
-		"K"
-		1
-		""
-		1

UN_BINZ		"zb"
-		" %0*bzb"
-		1
-		""
-		0

UN_OCTZ		"zo"
-		" %0*ozo"
-		1
-		""
-		0

UN_HEXZ		"zh"
-		" %0*xzh"
-		1
-		""
-		0

# distance units

UN_M		"m"
-		"G"
-		2
-		""
-		1

UN_IN		"in"
-		"G"
-		2
-		""
-		_sj 0
		_* 1

UN_FTIN		"' \""		# stored as number of inches
-		"G%d'%d\""
-		2
-		"\xc"
-		1

UN_FT		"ft"
-		"G"
-		2
-		""
-		_sj 0
		_* 1

UN_SMOOT	"Smoot"
-		"G"
-		2
-		""
-		0

UN_SQM		"sqm"
-		"G"
-		3
-		""
-		1

UN_SQFT		"sqft"
-		"G"
-		3
-		""
-		1

UN_SQIN		"sqin"
-		"G"
-		3
-		""
-		_sj 0
		_* 1

UN_L		"li"
-		"G"
-		4
-		""
-		1

UN_GAL		"gal"
-		"G"
-		4
-		""
-		1

UN_CUM		"cum"
-		"G"
-		4
-		""
-		_sj 0
		_* 1

UN_CUFT		"cuft"
-		"G"
-		4
-		""
-		1

UN_CUIN		"cuin"
-		"G"
-		4
-		""
-		_sj 0
		_* 1

# mass units

UN_KG		"kg"
-		"G"
-		5
-		""
-		1

UN_LB		"lb"
-		"G"
-		5
-		""
-		1

UN_OZ		"oz"
-		"G"
-		5
-		""
-		0

# angle units

UN_DEG		"g '"	# stored as number of seconds
-		"G%dg%02d'%02d\""
-		6
-		"<<"
-		1

UN_RAD		"rad"
-		"G"
-		6
-		""
-		1

UN_GRAD		"grad"
-		"G"
-		6
-		""
-		0

UN_RA		"ra '"	# stored as number of seconds
-		"G%dra%02d'%02d\""
-		6
-		"<<"
-		_sj 0
		_* 1

# time units

UN_TIME		": :"	# stored as number of seconds
-		"G%d:%02d:%02d"
-		7
-		"<<"
-		1

# date units

UN_DATE		"y"	# stored as YYYYMMDD
-		"G"
-		8
-		""
-		1

# temperature units

UN_DEGC		"oC"
-		"G"
-		9
-		""
-		1

UN_DEGF		"oF"
-		"G"
-		9
-		""
-		1

# ------------------------------------------------------------
# Messages and Menus

include "rlang^%.res"

# ------------------------------------------------------------
# Configuration Table
#
# This table holds all basic configuration information.

table	CONF

# ------------------------------------------------------------
# Command Line
# ------------------------------------------------------------
# These values can be overridden by command line options.  They
# let you change enough things to get up and running.

# Keyboard input: this value specifies where keyboard input is taken
# from.  The value in this file can be overridden on the command line
# with the -k option. Values:
#
#	"B"	MS/DOS ROM BIOS
#	"D"	MS/DOS BDOS (may intercept some control characters)
#	"E"	MS/DOS ROM BIOS extended input
#	"J"	MS/DOS: like "E", but do event-driven input
#	"P"	MS/DOS serial port; uses DOS calls to get the data so
#		the default is COM1; can be changed with MODE; does
#		not support IBM function keys; cannot tell whether a
#		character is available
#	"S"	standard input
#	"T"	termcap
#	"V"	UNIX: standard input, interpret VT100 function keys

KEYINP	_cdjs	"J"
	_u	"S"
	_*	"B"


# Screen type: This value specifies the type of screen output used by
# the editor.  The value in this file can be overridden on the command
# line with the -s option.  Values:
#
#	mode	display	status		size		default method
#
#	0	CGA	text		25 x 40		memory mapped
#	1	CGA	text		25 x 40		memory mapped
#	2	CGA	text		25 x 80		memory mapped
#	3	CGA	text		25 x 80		memory mapped
#	4	CGA	graphics	25 x 40		BIOS call
#	5	CGA	graphics,gray	25 x 40		BIOS call
#	6	CGA	graphics	25 x 80		BIOS call
#	7	MDA	text		25 x 80		memory mapped
#	8	PCJr	unsupported
#	9	PCJr	unsupported
#	10	PCJr,EGA unsupported
#	11	?	unsupported
#	12	?	unsupported
#	13	EGA	graphics	25 x 40		BIOS call
#	14	EGA	graphics	25 x 80		BIOS call
#	15	EGA	graphics	43 x 80		BIOS call
#	16	EGA	unsupported
#	24	95LX	text		16 x 40		memory mapped
#	25	95LX	graphics	21 x 60		custom 1
#	26	95LX	graphics	25 x 80		custom 2
#	27	100LX	text		25 x 80		extended BIOS call
#	28	VT100	text		24 x 80		standard output
#	29	termcap	text		LINES x COLS	API
#	80	100LX	text		64 x 18		extended BIOS call
#	81	100LX	text		64 x 18		extended BIOS call
#	82	100LX	text		40 x 25		extended BIOS call
#	83	100LX	text		40 x 25		extended BIOS call
#	84	100LX	text		40 x 16		extended BIOS call
#	85	100LX	text		40 x 16		extended BIOS call
#
# special values:
#
#	100	used to tell the program to auto-determine the mode
#		If one of the unsupported types is found, mode 2 is used.
#	101	used to mark the end of a list
#	102	used to indicate that no mode has been specified yet
#	103	return to normal font

SCRNTYPE	_u	28
		_js	24	# don't change this to 25/26: see in*95.doc
		_cd	80
		_*	100


# ------------------------------------------------------------
# User Configuration
# ------------------------------------------------------------
# Here is where most configuration will be made.

# SHOWSTARTUP: show the startup information.  Values are:
#	"Y"	yes, show it
#	"N"	do, don't

SHOWSTARTUP	"Y"


# DEFWSIZE: the default word size.  Values are 1-32.

DEFWSIZE	32


# DEFCOMPL: the default complement mode.  Affects the display of decimal
# binary values only.  Values:
#	0	unsigned
#	1	1's complement
#	2	2's complement

DEFCOMPL	2


# DEFFMODE: the default fraction mode.  Values:
#	0	not fraction
#	1	fixed denominator
#	2	factors of denominator
#	3	most precise

DEFFMODE	0


# DEFDENOM: the default fraction denominator.

DEFDENOM	64


# INITMACRO: this macro is executed after Loki starts up and just
# before the program starts reading commands.  Note that if you
# start Loki without specifying any files on the command line (or
# are using the system manager version), and do not have an inital
# file specified with INITFILE, you must press a key before this
# macro is run.

INITMACRO	key ""


# ESC swap: this value allows you to swap the ESC key with any one
# other key on the keyboard.  The other key must be a single key (i.e.,
# not a ^X prefix function.  The value to use to swap the ESC key with
# the ` key is 96.  On MS/DOS machines, you can specify swapping with
# "function" keys (or anything else that returns a key value in the form
# XX00) by using the value 256 + the scan code.

ESCSWAP		27


# CTX swap: this value allows you to swap the ^X key with any one
# other key on the keyboard.  The other key must be a single key (i.e.,
# not a Esc prefix function.  On MS/DOS machines, you can specify
# swapping with "function" keys (or anything else that returns a key
# value in the form XX00) by using the value 256 + the scan code.

CTXSWAP		24


# Meta handle: this value allows you to specify how "meta" keys are
# handled.  Meta keys send the codes 128 through 255.  Values:
#	"B"	They are bad commands.
#	"I"	They are self-insert (used for entering 8-bit characters)
#	"M"	They are mapped to the meta (Esc prefix) commands

METAKEY	_u	"M"
	_*	"I"


# Use caret notation: this value allows you to specify how control
# and meta characters (other than tab, soft NL, and hard NL) are
# displayed.  Values:
#	"Y"	Yes, display them with ^ notation.
#	"N	No, do not convert them before display (allows display
#		of 8-bit characters; not recommended on V and T
#		terminal types)

USECARAT _u	"Y"
	_*	"N"


# Radix: this value allows you to set the default radix to use in the
# calculator.  Values:
#	0	"."
#	1	","

RADIX		0


# Beg NumLock: this value allows you to control NumLock handling upon
# startup.  For system manager versions, this value only applies at
# initial startup and final exit: not when being task-switched.  Values:
#	0	Don't change it
#	1	Set it
#	2	Clear it

BEGNUMLOCK	0


# End NumLock: this value allows you to control NumLock handling upon
# exiting.  For system manager versions, this value only applies at
# initial startup and final exit: not when being task-switched.  Values:
#	0	Don't change it
#	1	Set it
#	2	Clear it
#	3	Restore it the way that it was on startup

ENDNUMLOCK	0


# Hexadecimal lowercase: this value allows you to control how the
# lower case letters a-f are interpreted during number entry.  (Upper
# case letters will always be interpreted as non-hex.)  Values:
#	'N'	Such letters may mean unit names or the exponent letter.
#	'H'	Such letters should be assumed to be part of hex
#		numbers.

HEXLOWER	'N'


# Tab spacing: this value specifies the tab spacing in columns.  The
# value can be changed with the ^X , command.

TABW		_sj 3
		_* 8


# ------------------------------------------------------------
# Starting here, you probably don't want to actually change anything...
# ------------------------------------------------------------

# This gives the name of the environment file to use FOR LOADING.
# The search path is followed.

ENVFILE		"loki.env"


# This gives the name of the environment file to use FOR SAVING.
# This value is only used if no file was found for loading.  (If
# a file was loaded at startup, it will be saved to the same place.)

ENVSAVEFILE	_iu "./loki.env"
		_* "C:\\_DAT\\LOKI.ENV"


# This gives the name of the file used for saving (writing) the status
# to.  If the file exists, the program appends to it.

SAVEFILE	"loki.out"


# This value tells what version the resource file was complied for.
# It simply provides a way to get this information into the resource
# file.

MADEFOR		"^&"


# Screen method: This value specifies the method used to handle screen
# output.  The value in this file can be overridden on the command
# line with the -m option.  Values:
#
#	"@"	use default as implied by font
#	"B"	force memory mapped -> BIOS calls (MSDOS only)

SCRNMETHOD	"@"


# Type list: this list allows you to specify the screen types that the
# ^X + command cycles among.  Values are as from the SCRTYPE list.

TYPELIST	list8
			?u  28
			?js 24 ?js 25 ?js 26
			?cd  2 ?cd 80 ?cd 84
			?i   2 ?i   0	# MDA displays don't cycle
					# EGA mode 15 must be explicitly
					#  requested
			101 .


# This list contains the attribute values to use for various displays.
# Don't change the order or add/delete any entries.  Each entry is
# four bytes and contains the attribute for:
#
#	normal character
#	reverse video character
#	underscored character
#	reverse video, underscored character

ATTRLIST list8
	15 112 4 112	# 0 CGA text, 1 bit/pixel
	15 112 4 112	# 1 CGA text, 4 bits/pixel
	?cd 7 !cd 15 112 ?cd 10 !cd 4 112	# 2 CGA text, 1 bit/pixel
	112 48 116 15	# 3 CGA text, 4 bits/pixel
	127 127 127 127	# 4 CGA graphics, 2 bits/pixel
	127 127 127 127	# 5 CGA graphics,gray, 2 bits/pixel
	127 127 127 127	# 6 CGA graphics, 1 bit/pixel
	7 112 1 9	# 7 MDA text
	0 0 0 0		# 8 PCJr unsupported, 4 bits/pixel
	0 0 0 0		# 9 PCJr unsupported, 4 bits/pixel
	0 0 0 0		# 10 PCJr,EGA unsupported, 2,6 bits/pixel
	0 0 0 0		# 11 ? unsupported, ?
	0 0 0 0		# 12 ? unsupported, ?
	127 127 127 127	# 13 EGA graphics, 4 bits/pixel
	127 127 127 127	# 14 EGA graphics, 4 bits/pixel
	127 127 127 127	# 15 EGA graphics, 2 bits/pixel
	0 0 0 0		# 16 EGA unsupported, ?
	7 112 1 9	# 24 95LX text
	0 1 2 3		# 25 95LX graphics (please don't change)
	0 1 2 3		# 26 95LX graphics (please don't change)
	15 112 4 112	# 27 100LX text, 1 bit/pixel
	0 1 2 3		# 28 VT100 (please don't change)
	0 1 0 1		# 29 termcap (please don't change)
	?cd 7 !cd 15 112 ?cd 10 !cd 4 112	# 80 100LX text, 1 bit/pixel
	15 112 4 112	# 81 100LX text, 2 bits/pixel
	15 112 4 112	# 82 100LX text, 1 bit/pixel
	15 112 4 112	# 83 100LX text, 2 bits/pixel
	?cd 7 !cd 15 112 ?cd 10 !cd 4 112	# 84 100LX text, 1 bit/pixel
	15 112 4 112	# 85 100LX text, 2 bits/pixel
	.


# Box drawing characters: this value holds the list of characters used
# to draw boxes.  The order is:
#
#	UL corner
#	top
#	UR corner
#	left
#	right
#	LL corner
#	bottom
#	LR corner

BOXCHARS	_u "+-+||+-+"
		_* "\xDA\xC4\xBF\xB3\xB3\xC0\xC4\xD9"


# Fraction type characters: this value holds the list of characters
# used to display fractions.  The convention is that the actual vale
# is in the direction of the arrow. The order is:
#
#	fraction is too low
#	fraction is exactly the actual value
#	fraction is too high

FRACMARKS	_u "^ v"
		_* "\x1e \x1f"


# Window split character: this value allows you to specify the
# character to use (in reverse video) as the window divider line.

WINDSPLITCHAR	_u "-" 
		_* "\xc4"


# Menu split character: this value allows you to specify the
# character to use (in reverse video) as the menu divider line.

MENU0SPLITCHAR	_u "="		# type 0 menus
		_* "\xCD"


# Other split character: this value allows you to specify the
# character to use (in reverse video) as the divider line for
# other purposes.

OTHERSPLITCHAR	"*"


# The identifier tag stored in the environment header.  Must be
# exactly 32 bytes long (not counting the NUL), and should end with
# CR, LF, ^Z.

IDENT		"Loki environment version 1   \r\n\x1a"


# The name of the program to use when writing the clipboard.  This value
# is used only by the system manager version.

CBPROG		_sc "Loki"
		_* ""


# The name of the clipboard tag type to use when reading and writing the
# clipboard.  This value is used only by the system manager version.

CBTAG		_sc "TEXT"
		_* ""


# The name of the "smart" clipboard tag type to use when reading and
# writing the clipboard.  This value is used only by the system manager
# version.

CBSMARTTAG	_sc "LOKI"
		_* ""


# ------------------------------------------------------------
# Tiny Font Table
#

table	TINYFONT
-	list8 ?js fontmap 0 .


# ------------------------------------------------------------
# Function ID Table: there must be an entry in here for every command
# function.  The order >>MUST<< exactly match that in ltable.c.

# The value of each item is a string.  The string is used to encode
# more information about the command.  The characters in the string
# have these meanings:
#
#	0: do Enter first
#		SP	no
#		'E'	yes
#
#	1: number of arguments dropped off the stack
#		'0' zero, '1', one, '2' two, '3' three, '4' four
#
#	2: number of results pushed to stack
#		'0' zero, '1', one, '2' two, '3' three, '4' four
#
#	3: last X usage
#		SP	not affected
#		'L'	last x register is updated
#
#	4: stack lift
#		SP	disabled
#		'E'	enabled

table	FUNCID

AADD		"E21LE"
AAND		"E21LE"
ACHS		" 11 D"
ACLEAR		"E11 E"
ACUBRT		"E11LE"
ACUBE		"E11LE"
ADIV		"E21LE"
AENTER		" 12 D"
AINV		"E11LE"
ALAST		"E01 E"
AMUL		"E21LE"
ANEG		"E11LE"
ANOT		"E11LE"
AOR		"E21LE"
APERCENT	"E22LE"
ARCL		"E01 E"
AROLL		"E00 E"
ASLEFT		"E21LE"
ASRIGHT		"E21LE"
ASTO		"E11 E"
ASQRT		"E11LE"
ASQUARE		"E11LE"
ASUB		"E21LE"
ASWAP		"E22 E"
AXOR		"E21LE"
CCHARBD		" 00  "
DDATE		"E01 E"
DNEWDISPLAY	" 00  "
DTIME		"E01 E"
FENVDEFAULT	" 00  "
FMODE		" 00  "
FSAVE		" 00  "
FSETDENOM	" 00  "
KBEGMAC		" 00  "
KCOLON		" 00  "
KENDMAC		" 00  "
KFROMMAC	" 00  "
KLOADMAC	" 00  "
MABORT		" 00  "
MABOUT		" 00  "
MALL		" 00  "
MCLEAR		" 00 E"
MCLEARSTK	" 00 D"
MCLEARX		" 00 D"
MCOMPL		" 00  "
MCONV		"E11LE"
MCOPY		" 00  "
MCTRLX		" 00  "
MCUT		" 00 D"
MDOKEY		" 00  "
MENTER		" 01 E"
MENTERASCII	"E01 E"
MEXIT		" 00  "
MFONT		" 00  "
MHEXLETTERS	" 00  "
MMACEVAL	" 00  "
MMENU		" 00  "
MMENUM		" 00  "
MMETA		" 00  "
MNUMBEG		" 00  "
MNUMEND		" 00  "
MPANE		" 00  "
MPANEKEY	" 00  "
MPASTE		" 00  "
MQUOTE		" 00  "
MRADIX		" 00  "
MREGISTERS	" 00  "
MSETTABS	" 00  "
MSHOW		" 00  "
MSPACE		" 01 E"
MSTATUS		" 00  "
MTYPE		" 00  "
MUARG		" 00  "
MWSIZE		" 10 E"
SI		" 00  "
UC		" 00  "

# ------------------------------------------------------------
# Base Dispatch Table
#
# This table is exactly 128 entries long.  It containst the dispatch
# table used for the base command table (no prefix keys).  Entries
# should use the symbols from the Help Strings Table in rlang*.res.

table		BASE
-		list8

# ^@^A^B^C^D^E^F^G
UC UC ACUBRT ACUBE UC UC UC MABORT

# ^H^I^J^K^L^M^N^O
CCHARBD SI UC UC DNEWDISPLAY MENTER UC UC

# ^P^Q^R^S^T^U^V^W
UC MQUOTE ASQRT ASQUARE AENTER MUARG MCONV MCUT

# ^X^Y^Z^[^\^]^^^_
MCTRLX MPASTE UC MMETA UC KFROMMAC MMENUM UC

#  !"#$%&'
MSPACE ANOT SI UC SI APERCENT AAND SI

# ()*+,-./
SI SI AMUL AADD SI ASUB SI ADIV

# 01234567
SI SI SI SI SI SI SI SI

# 89:;<=>?
SI SI SI SI ARCL SI ASTO SI

# @ABCDEFG
SI SI SI SI SI SI SI SI

# HIJKLMNO
SI SI SI SI SI SI SI SI

# PQRSTUVW
SI SI SI SI SI SI SI SI

# XYZ[\]^_
SI SI SI ASLEFT AINV ASRIGHT AXOR SI

# `abcdefg
ACHS SI SI SI SI SI SI SI

# hijklmno
SI SI SI SI SI SI SI SI

# pqrstuvw
SI SI SI SI SI SI SI SI

# xyz{|}~
SI SI SI SI AOR SI SI

# ^?
CCHARBD
.


# ------------------------------------------------------------
# Ctrl-X Dispatch Table
#
# This table is exactly 128 entries long.  It containst the dispatch
# table used for the Control-X command table.  Entries should use the
# symbols from the Help Strings Table in rlang*.res.

table		CTX
-		list8

# ^@^A^B^C^D^E^F^G
UC UC UC MEXIT UC UC UC MABORT

# ^H^I^J^K^L^M^N^O
UC UC UC MCLEARSTK UC UC UC UC

# ^P^Q^R^S^T^U^V^W
UC UC FENVDEFAULT FSAVE UC UC UC UC

# ^X^Y^Z^[^\^]^^^_
UC UC UC UC UC UC UC UC

#  !"#$%&'
UC UC UC MDOKEY UC FSETDENOM UC UC

# ()*+,-./
KBEGMAC KENDMAC UC MFONT MSETTABS UC FMODE UC

# 01234567
MPANEKEY MPANEKEY MPANEKEY MPANEKEY MPANEKEY MPANEKEY MPANEKEY
MPANEKEY

# 89:;<=>?
MPANEKEY MPANEKEY UC UC UC UC UC UC

# @ABCDEFG
ACLEAR MALL MNUMBEG MEXIT MNUMEND KFROMMAC UC UC

# HIJKLMNO
MHEXLETTERS MRADIX UC UC MCLEAR MCOMPL UC UC

# PQRSTUVW
MPANE MQUOTE MREGISTERS MSHOW MTYPE MSTATUS UC UC

# XYZ[\]^_
MCLEARX UC MWSIZE UC UC UC UC UC

# `abcdefg
ACLEAR MALL MNUMBEG MEXIT MNUMEND KFROMMAC UC UC

# hijklmno
MHEXLETTERS MRADIX UC UC MCLEAR MCOMPL UC UC

# pqrstuvw
MPANE MQUOTE MREGISTERS MSHOW MTYPE MSTATUS UC UC

# xyz{|}~^?
MCLEARX UC MWSIZE UC UC UC UC UC
.


# ------------------------------------------------------------
# Meta Dispatch Table
#
# This table is exactly 128 entries long.  It containst the dispatch
# table used for the Control-[ (Meta prefix) command table.  Entries
# should use the symbols from the Help Strings Table in rlang*.res.

table		ESC
-		list8

# ^@^A^B^C^D^E^F^G
UC UC UC UC UC UC UC MABORT

# ^H^I^J^K^L^M^N^O
UC UC UC UC DNEWDISPLAY UC UC UC

# ^P^Q^R^S^T^U^V^W
UC UC UC UC UC UC UC UC

# ^X^Y^Z^[^\^]^^^_
UC UC UC UC UC KLOADMAC UC UC

#  !"#$%&'
UC UC UC UC UC UC UC UC

# ()*+,-./
UC UC UC UC UC UC UC UC

# 01234567
MMACEVAL MMACEVAL MMACEVAL MMACEVAL MMACEVAL MMACEVAL MMACEVAL MMACEVAL 

# 89:;<=>?
MMACEVAL MMACEVAL UC UC UC UC UC UC

# @ABCDEFG
UC UC UC UC UC UC UC UC

# HIJKLMNO (keep ESC O open for VT100 function key support)
UC UC UC UC UC UC UC UC

# PQRSTUVW
UC UC UC UC UC UC UC MCOPY

# XYZ[\]^_
UC UC UC UC UC UC UC UC

# `abcdefg
UC UC UC UC UC UC UC UC

# hijklmno
UC UC UC UC UC UC UC UC

# pqrstuvw
UC UC UC UC UC UC UC MCOPY

# xyz{|}~^?
UC UC UC UC UC UC UC UC
.


# ------------------------------------------------------------
# Function Key Dispatch Table
#
# This table is a little over 128 entries long.  It containst the
# dispatch table used for function keys.  Entries should use the
# symbols from the Help Strings Table in rlang*.res.

table		FUNC
-		list8

# 0-9
MMENU KCOLON MENTERASCII UC UC UC UC UC MABOUT UC

# 10-19
UC UC UC UC UC UC UC MCOPY UC UC

# 20-29
UC UC UC UC UC UC UC UC UC UC

# 30-39
UC UC UC UC UC UC UC UC ACHS UC

# 40-49
UC UC UC UC ASQRT AINV ASWAP AROLL ALAST ASTO

# 50-59
ARCL UC UC UC UC UC UC UC UC MPANEKEY

# 60-69
MPANEKEY MPANEKEY MPANEKEY MPANEKEY MPANEKEY MPANEKEY MPANEKEY
MPANEKEY MPANEKEY UC

# 70-79
UC UC UC UC UC UC UC UC UC UC

# 80-89
UC UC UC UC UC UC UC UC UC UC

# 90-99
UC UC UC UC UC UC UC UC UC UC

# 100-109
UC UC UC UC UC UC UC UC UC UC

# 110-119
UC UC UC UC UC UC UC UC UC UC

# 120-129
MMACEVAL MMACEVAL MMACEVAL MMACEVAL MMACEVAL MMACEVAL MMACEVAL
MMACEVAL MMACEVAL MMACEVAL

# 130-139
UC UC UC UC UC UC UC UC UC UC

# 140-149
UC UC UC UC UC UC UC UC UC UC

# 150-159
UC UC UC UC UC UC UC UC UC UC

# 160-169
UC UC UC UC UC UC UC UC UC UC

# 170-179
UC UC UC UC UC UC UC UC UC UC

# 180-189
UC UC UC UC UC UC UC UC UC UC

# 190-199
UC UC UC UC UC UC UC UC UC UC

# 200-209
MMENUM UC UC UC UC UC UC UC MFONT DDATE

# 210-219
DTIME UC MCUT MCOPY MPASTE UC UC UC UC UC

# 220-229
UC UC UC UC UC UC UC UC UC UC

# 230-239
UC UC UC UC UC UC UC UC UC UC

# 240-249
UC UC UC UC UC UC UC UC UC UC

# 250-255
UC UC UC UC UC UC
.


# ------------------------------------------------------------
# Word commands
#
# This table holds all non-unit word commands.  Format is:
#
#	string	character squence
#	int	command to execute

table	WORD_CMDS

-	"l"
-	ALAST

-	"r"
-	AROLL

-	"s"
-	ASWAP

-	"t"
-	AENTER


# ------------------------------------------------------------
# Conversions Table
#
# This table holds the inter-unit conversions.  Format is:
#
#	int	from unit
#	int	to unit
#	string	how

table	CONVERT

# distance - 1

-	UN_M
-	UN_IN
-	"*39.37007874"

-	UN_M
-	UN_FTIN
-	"*39.37007874"

-	UN_M
-	UN_FT
-	"*3.280839895"

-	UN_M
-	UN_SMOOT
-	"*.5876131155"

-	UN_IN
-	UN_M
-	"*.0254"

-	UN_IN
-	UN_FTIN
-	"*1"

-	UN_IN
-	UN_FT
-	"*.08333333333"

-	UN_IN
-	UN_SMOOT
-	"*.01492537313"

-	UN_FTIN
-	UN_M
-	"*.0254"

-	UN_FTIN
-	UN_IN
-	"*1"

-	UN_FTIN
-	UN_FT
-	"*.08333333333"

-	UN_FTIN
-	UN_SMOOT
-	"*.01492537313"

-	UN_FT
-	UN_M
-	"*.3048"

-	UN_FT
-	UN_IN
-	"*12"

-	UN_FT
-	UN_FTIN
-	"*12"

-	UN_FT
-	UN_SMOOT
-	"*.1791044776"

-	UN_SMOOT
-	UN_M
-	"*1.7018"

-	UN_SMOOT
-	UN_IN
-	"*67"

-	UN_SMOOT
-	UN_FTIN
-	"*67"

-	UN_SMOOT
-	UN_FT
-	"*5.583333333"

# distance - 2

-	UN_SQM
-	UN_SQFT
-	"*10.76391042"

-	UN_SQM
-	UN_SQIN
-	"*1550.003100"

-	UN_SQFT
-	UN_SQM
-	"*.09290304"

-	UN_SQFT
-	UN_SQIN
-	"*144"

-	UN_SQIN
-	UN_SQM
-	"*.00064516"

-	UN_SQIN
-	UN_SQFT
-	"*.006944444444"

# distance - 3

-	UN_L
-	UN_CUM
-	"*.001"

-	UN_L
-	UN_GAL
-	"*.2641720524"

-	UN_L
-	UN_CUFT
-	"*.03531466672"

-	UN_L
-	UN_CUIN
-	"*61.02374409"

-	UN_GAL
-	UN_L
-	"*3.785411784"

-	UN_GAL
-	UN_CUM
-	"*.003785411784"

-	UN_GAL
-	UN_CUFT
-	"*.1336805556"

-	UN_GAL
-	UN_CUIN
-	"*231"

-	UN_CUM
-	UN_L
-	"*1000"

-	UN_CUM
-	UN_GAL
-	"*264.1720524"

-	UN_CUM
-	UN_CUFT
-	"*35.31466672"

-	UN_CUM
-	UN_CUIN
-	"*61023.74409"

-	UN_CUFT
-	UN_L
-	"*28.31684659"

-	UN_CUFT
-	UN_GAL
-	"*7.480519481"

-	UN_CUFT
-	UN_CUM
-	"*.02831684659"

-	UN_CUFT
-	UN_CUIN
-	"*1728"

-	UN_CUIN
-	UN_L
-	"*.016387064"

-	UN_CUIN
-	UN_GAL
-	"*.004329004329"

-	UN_CUIN
-	UN_CUM
-	"*.000016387064"

-	UN_CUIN
-	UN_CUFT
-	"*.0005787037037"

# mass units

-	UN_KG
-	UN_LB
-	"*2.204622622"

-	UN_KG
-	UN_OZ
-	"*35.27396195"

-	UN_LB
-	UN_KG
-	"*.45359237"

-	UN_LB
-	UN_OZ
-	"*16"

-	UN_OZ
-	UN_KG
-	"*.02834952313"

-	UN_OZ
-	UN_LB
-	"*.0625"

# angle units

-	UN_DEG
-	UN_RAD
-	"*.000004848136811"

-	UN_DEG
-	UN_GRAD
-	"*.0003086419753"

-	UN_DEG
-	UN_RA
-	"*.06666666667"

-	UN_RAD
-	UN_DEG
-	"*206264.8062"

-	UN_RAD
-	UN_GRAD
-	"*63.66197724"

-	UN_RAD
-	UN_RA
-	"*13750.98708"

-	UN_GRAD
-	UN_DEG
-	"*3240"

-	UN_GRAD
-	UN_RAD
-	"*.01570796337"

-	UN_GRAD
-	UN_RA
-	"*216"

-	UN_RA
-	UN_DEG
-	"*15"

-	UN_RA
-	UN_RAD
-	"*0.00007272205217"

-	UN_RA
-	UN_GRAD
-	"*.004629629630"

# temperature units

-	UN_DEGC
-	UN_DEGF
-	"C"

-	UN_DEGF
-	UN_DEGC
-	"F"


# ------------------------------------------------------------
# Promotions Table
#
# This table holds the intra-unit power promotions.  Format is:
#
#	int	unit for length
#	int	unit for area
#	int	unit for volume

table	PROMOTE

-	UN_M
-	UN_SQM
-	UN_CUM

-	UN_FT
-	UN_SQFT
-	UN_CUFT

-	UN_IN
-	UN_SQIN
-	UN_CUIN

-	UN_M
-	UN_SQM
-	UN_CUM


# ------------------------------------------------------------
# Alternates Table
#
# For those distance/area/volume units that don't have promotions, this
# table tells what units to convert to for promotion.   Format is:
#
#	int	unit without promotion
#	int	unit to convert to

table	ALTERNATES

-	UN_FTIN
-	UN_IN

-	UN_SMOOT
-	UN_M

-	UN_L
-	UN_CUM

-	UN_GAL
-	UN_CUFT


# ------------------------------------------------------------
# Keyboard Macros Table
#
# This table holds the pre-defined keyboard macros.  Note that the
# fifth entry (value 4) can _only_ be used by Esc 4 or Alt-4, it cannot
# be loaded with Esc ^]...
#
# When using these with Esc # (or Alt-#), you can _not_ include any
# menu sequences.  The code that executes these and the menu code
# share a buffer.  As all menu operations are available via regular
# key sequences, this should not be a problem.
#
# You can include menu sequences in macros loaded with Esc ^].

# These had all _better_ be key sequences.

table	KEYM

-	key	""	# 0
-	key	""	# 1
-	key	""	# 2
-	key	""	# 3
-	key	""	# 4 restricted use
-	key	""	# 5
-	key	""	# 6
-	key	""	# 7
-	key	""	# 8
-	key	""	# 9


# ------------------------------------------------------------
# This is where you put more menus.

# ------------------------------------------------------------
# Summary table.
# 

# This _must_ be the last table and is used to locate the main menu.

table		-
-	MAIN

