/* Datex data */

#define byte	unsigned char
#define word	unsigned short
#define dword	unsigned long


// Datex data types

struct   sr_desc_type
{
	word	offset;
	byte	sr_type;
};


struct datex_hdr_type
{
	word	r_len;
	byte	res1;
	byte	r_dri_level;
	byte	res2[2];
	dword	r_time;
	dword	res3;
	word	r_maintype;
	sr_desc_type sr_desc[8];
};

struct datex_record_type
{
	datex_hdr_type	hdr;
	byte	 data[1450];
};


union datex_record_union_type
	{
	datex_record_type record;
	byte b[1500];				// Union to simplify acces to individual bytes
									// Add 10 bytes for room
	};

struct phdb_req_type
{
	byte	phdb_rcrd_type;
	short	tx_interval;
	short	reserved[3]	;
};

struct group_hdr_type
{
	dword	status_bits;
	word	label_info;
};


struct ecg_group_type
{
	group_hdr_type	hdr;
	short				hr;
	short				st1;
	short				st2;
	short				st3;
	short				reserved;
};

struct p_group_type
{
	group_hdr_type	hdr;
	short				sys;
	short				dia;
	short				mean;
	short				hr;
};

struct nibp_group_type
{
	group_hdr_type	hdr;
	short				sys;
	short				dia;
	short				mean;
	short				hr;
};

struct t_group_type
{
	group_hdr_type	hdr;
	short				temp;	
};

struct SpO2_group_type
{
	group_hdr_type	hdr;
	short				SpO2;
	short				pr;
	short				ir_amp;
	short				reserved;
};

struct co2_group_type
{
	group_hdr_type	hdr;
	short				et;
	short				fi;
	short				rr;
	short				amb_press;
};

struct o2_group_type
{
	group_hdr_type	hdr;
	short				et;
	short				fi;
};

struct n2o_group_type
{
	group_hdr_type	hdr;
	short				et;
	short				fi;
};

struct aa_group_type
{
	group_hdr_type	hdr;
	short				et;
	short				fi;
	short				mac_sum;
};

struct flow_vol_group_type
{
	group_hdr_type	hdr;
	short				rr;
	short				ppeak;
	short				peep;
	short				reserved;
	short				tv_insp;
	short				tv_exp;
	short				compliance;
	short				reserved2;
};

struct	co_wedge_group_type
{
	group_hdr_type	hdr;
	short				co;
	short				blood_temp;
	short				reserved;
	short				pcwp;
};

struct phdb_type
{
	dword		time;
	ecg_group_type 	ecg;
	p_group_type 		p[4];
	nibp_group_type 	nibp;
	t_group_type 		t[4];
	SpO2_group_type 	SpO2;
	co2_group_type 	co2;
	o2_group_type 		o2;
	n2o_group_type 	n2o;
	aa_group_type 		aa;
	flow_vol_group_type 	flow_vol;
	co_wedge_group_type 	co_wedge;
	byte	reserved [60];
};

// these define the offsets from the start of the phdb structure

#define ecg_offset	0x04
#define p_offset		0x14
#define nibp_offset	0x4C
#define t_offset		0x5A
#define SpO2_offset	0x7A
#define co2_offset	0x88
#define o2_offset		0x96
#define n2o_offset	0xA0
#define aa_offset		0xAA
#define flow_offset 	0xB6
#define co_wedge_offset	0xCC

#define gphdr_offset	0x06

#define pgroupsize	14
#define tgroupsize  	8

#define phdh_size		278


struct aux_phdb_info
{
	dword	nibp_time;
	short	reserved;
	dword	co_time;
	dword	pcwp_time;
	short	pat_bsa;
	byte	reserved2[100];
};


//*********************************************************************



// Data validity macros

#define DATA_INVALID_LIMIT	(-32001)	/* limit for special invalid data values */
#define DATA_INVALID			(-32767)	/* there is no valid data */
#define DATA_NOT_UPDATED	(-32766)	/* data is not updated */
#define DATA_DISCONT			(-32765)	/* data discontinuity (calibration ...) */
#define DATA_UNDER_RANGE	(-32764)	/* data exceeds lower valid limit */
#define DATA_OVER_RANGE		(-32763)	/* data exceeds upper valid limit */

/* Macro to check if the data is valid */

#define DATA_OK(data)		((short)(data) >= DATA_INVALID_LIMIT)


/*---------- General definitions ---------*/

/*
**	Asynchronous interface specific constants
*/
#define		FRAMECHAR	0x7E
#define		CTRLCHAR	   0x7D
#define     BIT5        32
#define     BIT5COMPL   223


/*---------- Datex Record Interface data structure definitions ----------*/

#define		DRI_MAX_SUBRECS		8	/* # of subrecords in a packet */
#define		DRI_MAX_PHDBRECS		5	/* # of phys.db records in a packet */

/* data packet maintypes */

#define DRI_MT_PHDB			0

/* data packet subtypes  */

#define DRI_PH_60S_TREND	3
#define DRI_PH_DISPL			1

/*
**	These masks define the internal structure of the ECG label field
*/
#define LBL_ECG_CH3(val)		( val & 0x000F)
#define LBL_ECG_CH2(val)		((val & 0x00F0) >> 4)
#define LBL_ECG_CH1(val)		((val & 0x0F00) >> 8)
#define LBL_ECG_QRS_SRC(val)	((val & 0x3000) >> 12)
#define LBL_ECG_R_SRC(val)		((val & 0xC000) >> 14)

/*
**	Internal structure of NIBP label field
*/
#define	LBIT_AUTOMODE			3
#define	LBIT_STATMODE			4
#define	LBIT_MEAS_ON			5
#define	LBIT_STASIS_ON			6
#define	LBIT_CALIB_ON			7
#define LBIT_NIBP_OVER_60S_OLD	8

#define LBL_NIBP_CUFFID(val)			(val & 0x0007)	/* 3 LSBs */
#define LBL_NIBP_AUTOMODE(val)		(val & 0x0008)
#define LBL_NIBP_STATMODE(val)		(val & 0x0010)
#define LBL_NIBP_MEAS_ON(val)			(val & 0x0020)
#define LBL_NIBP_STASIS_ON(val)		(val & 0x0040)
#define LBL_NIBP_CALIB_ON(val)		(val & 0x0080)
#define LBL_NIBP_OVER_60S(val)		(val & 0x0100)


