/* "Basic"  v.1.0     Project Start: ??/??/??  
                      Project Ready: ??/??/?? */

/* ======================================
   Definitions
   ====================================== */
#include  "lxapi.h"
#include <string.h>


#define XY_CENTER(w,h) ((640-w)/2),((200-h)/2),(w),(h)


char far *msgnull       = "";
char far *msgAppName    = "Basic";
char far *msgTitle      = " Basic Start";
char far *msgHelpKey    = "Help";
char far *msgF10Key     = "Quit";
char far *msgFile       = "&File";
char far *msgExit       = "E&xit";
char far *msgQuit       = "&Quit";
char far *msgHelp       = "&Help";
char far *msgAbout      = "&About Basic Start";
char far *msgOK         = "OK";
char far *msgHelpHeader = "";
char far *msgHelpNote   = "";


/* FUNCTIONS In This Program
  =========================== */
void far DoQuit( void );             /* Quit the program. */
void far DoAbout(void);              /* Run the About screen. */
void far DoHelp1(void);              /* Run main help screen. */


int far MainHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...);
int far HelpHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...);
/* int far HelpHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...); */

char far **StringTable[]={
  &msgnull, &msgAppName, &msgTitle, &msgHelpKey, &msgF10Key, &msgFile,
  &msgExit, &msgQuit, &msgHelp, &msgAbout, &msgOK, &msgHelpHeader, 
  &msgHelpNote
};


EVENT_NORM  app_event;
LHAPIBLOCK  CapData;
BOOL  Done;
/* =========================================================================
   ======================================
   Define Main Title Bar
   ====================================== */
LHWINDOW TDateTime = {
    DateTime,0,0,0,0,
    0,0,0,STYLE_DATETIME|STYLE_NOFOCUS,
    NULL,NO_FKEYS,PARENT_MENU,NO_HELP
};

LHWINDOW MainTitle = {
    TitleBar,0,0,0,0,
    (PLHRES)&msgTitle,0,0,STYLE_NOFOCUS,
    NULL,NO_FKEYS,(PLHMENU)&TDateTime,NO_HELP
};
/* ======================================
   Define Main Window, Menu & F-Keys
   ====================================== */
LHFKEY MainFKeys[]= {
  {(PLHRES)&msgHelpKey  ,(PLHFUNC)DoHelp1,1,0},
  {(PLHRES)&msgF10Key   ,(PLHFUNC)DoQuit,10+FKEY_LAST,0}
};

LHMENU FileMenu[] = {
  { (PLHRES)&msgExit, (PLHFUNC)DoQuit, 0, 0 },
  { 0, 0, 0, 0}
};

LHMENU HelpMenu[] = {
  { (PLHRES)&msgHelp , (PLHFUNC)DoHelp1, 0, MENU_ELLIPSIS},
  { (PLHRES)&msgAbout, (PLHFUNC)DoAbout, 0, MENU_BARBEFORE|MENU_ELLIPSIS},
  { 0, 0, 0, 0}
};

LHMENU TopMenu[] = {
  { (PLHRES)&msgFile      , (PLHFUNC)FileMenu   , 0, MENU_PULLDOWN },
  { (PLHRES)&msgQuit      , (PLHFUNC)DoQuit     , 0, 0 },
  { (PLHRES)&msgHelp      , (PLHFUNC)HelpMenu   , 0, MENU_PULLDOWN },
  { 0, 0, 0, 0}
};

LHWINDOW MainView={
              (PLHCLASS)MainHandler,0,0,640,190,
              (PLHRES)&msgnull,NULL,0, 0,
              NULL,MainFKeys,TopMenu,NO_HELP
};

int far MainHandler(PLHWINDOW Wnd, WORD Message, WORD Data, WORD Extra,...) {
        switch (Message) {
               case KEYSTROKE:
                    break;
               case DRAW:
                    if (Data&DRAW_FRAME)
                        ClearRect(Wnd->x,Wnd->y,Wnd->w,Wnd->h);
                    break;
        }
        return SubclassMsg(Object, Wnd, Message, Data, Extra);
}

/* ======================================
   Define Help Window, Menu & F-Keys
   ====================================== */
  char far **HelpMsgArray[] = {
  &msgHelpNote
};

LHWINDOW HelpArray[] = {
  { MessageBox, 10, 17, 580, 145,
    NULL, (PLHDATA)&HelpMsgArray, countof(HelpMsgArray),
    STYLE_NOBORDER|STYLE_NOFOCUS|STYLE_XYRELATIVE,
    NULL, PARENT_FKEYS, NO_MENU, NO_HELP }
};  

LHFKEY OKFKeys[]= {
 {(PLHRES)&msgOK,(PLHFUNC)CMD_DONE,10+FKEY_LAST,FKEY_SENDMSG}
};

LHWINDOW HelpDialog = {
  (PLHCLASS)HelpHandler, XY_CENTER(600,170), 
  (PLHRES)&msgHelpHeader, (PLHDATA)&HelpArray, countof(HelpArray),
   0, NULL, OKFKeys, NO_MENU, NO_HELP
};

int far HelpHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...)
{
if(Msg == COMMAND && ( Data == CMD_DONE || Data == CMD_ESC )) {
   Msg=COMMAND;
   Data=CMD_ESC;
   }
  return SubclassMsg(DialogBox, Wnd, Msg, Data, Extra);
}


/* ======================================
   Standard Stuff...
   ====================================== */

#define GetDataSeg()  _DS

void FixupFarPtrs(void)
{
int i,dataseg;
  dataseg=GetDataSeg();
  for(i=0; i<countof(StringTable); i++)
    *(((int *)(StringTable[i]))+1) = dataseg;
}


/* ======================================
   Quit the program
   ====================================== */
void far DoQuit(void)
{
  Done = TRUE;
}

/* ======================================
   Run the About screen.
   ====================================== */
void far DoAbout(void)
{
msgHelpHeader = "About Basic Start";

/*
|-----------------------------------------------------------|
Text can be from position 1 to 61 and a total of 13 rows. */

msgHelpNote = 
"Basic Start is a program from THE PALMTOP NETWORK-\n"
"http://www.palmtop.net\n"
"\n"
"Basic Start has been written and compiled on the HP 200LX\n"
"Palmtop PC, using Borland Turbo C 2.0 and NKIT EXM devel-\n"
"opment kit.\n"
"\n"
"This is a small freeware program with source code for you\n"
"that want to start EXM programming. Use the source code  \n"
"as a start and from there you can create your own\n"
"Programs.\n"
"\n"
"THE PALMTOP NETWORK, March 1999.";


  ClearRect(0, 10, 640, 180);
  SendMsg( &HelpDialog, CREATE, CREATE_FOCUS, 0 );
}

/* ======================================
   Run the Main Help screen.
   ====================================== */
void far DoHelp1(void)
{
/* Check if the Menu is active, if so close it. */
if(CapData.TopMenuWnd.Status&STATUS_VISIBLE)
   SendMsg(&CapData.TopMenuWnd, DESTROY, 0, 0);

msgHelpHeader = "Basic Start Overview";

msgHelpNote = 
"F1 - This help dialog.\n"
"F10- Exit the program.\n"
"\n";


  ClearRect(0, 10, 640, 180);
  SendMsg( &HelpDialog, CREATE, CREATE_FOCUS, 0 );
}


/* ======================================
   MAIN
   ====================================== */
void main(void)
{
    m_init_app(SYSTEM_MANAGER_VERSION);
    m_reg_app_name(msgAppName);
    InitializeLHAPI(&CapData);
    SetMenuFont(FONT_NORMAL);
    SetDefaultFont(FONT_NORMAL);
    FixupFarPtrs();


    SendMsg( &MainView, CREATE, CREATE_FOCUS, 0 );
    SendMsg( &MainTitle, CREATE, CREATE_NORMAL, 0 ); /* Show Main Title */

    Done = FALSE;

    while( !Done ) {
         app_event.do_event = DO_EVENT;
         m_action( &app_event );
         switch( app_event.kind ) {
             case E_ACTIV:
                  FixupFarPtrs();
                  ReactivateLHAPI(&CapData);
                  break;
             case E_REFRESH:
                  FixupFarPtrs();
                  ReactivateLHAPI(&CapData);
                  break;
             case E_DEACT:
                  DeactivateLHAPI();
                  break;
             case E_TERM:
                  FixupFarPtrs();
                  Done = TRUE;
                  break;
             case E_KEY:
                  SendFocusMsg( KEYSTROKE, app_event.data, app_event.scan);
  /*                SendMsg(GetFocus(), KEYSTROKE,app_event.data,app_event.scan); */
                  break;
             case E_NONE:
                  SendMsg(&TDateTime,DRAW,DRAW_ALL,0);
                  break;
             }


        }

    app_event.do_event = DO_FINI;
    m_action(&app_event);
}

