;==============================================================
;To create BACKLITE.COM you may either use A86, TASM or MASM:
;
;Using A86
;---------------------
; A86 BACKLITE.ASM
;
;Using turbo assembler
;---------------------
; TASM BACKLITE.ASM
; TLINK /T BACKLITE.OBJ
;
;Using MASM
;----------
; MASM BACKLITE.ASM;
; LINK BACKLITE.OBJ;
; EXE2BIN BACKLITE.EXE BACKLITE.COM
;==============================================================

.186
cseg  segment 'code'
      assume cs:cseg,ds:cseg
org   100h

HOT   equ 30FEh         ;Hotkey scancode (Fn-B)
IR_N1 equ 09h           ;interrupt number 1 to chain in
IR_N2 equ 1Ch           ;interrupt number 2 to chain in
                
;-----begin resident part--------------------------------------

  start:
jmp   install

;-----begin resident data--------------------------------------

tsr   db 'backlit'      ;string to identify TSR (7 chars)
hotk  dw HOT            ;hotkey scancode always at offset 10dec
activ dw 0              ;0=not active, 1=active
inver dw 0              ;0=normal,     1=invert
mute  dw 1              ;0=sound,      1=no sound
onseq dw 0              ;0=no ON key   1=ON key sequence
shade db 0              ;last shadereg

;-----end resident data----------------------------------------
;-----begin resident code--------------------------------------
;-----INT 09H--------------------------------------------------

  int_09_new:
pushf                   ;because iret pops flags as well
db    09ah              ;opcode: jmp far
  int_09_old:
dw    0,0               ;jump to old int
sti
push  ax
mov   ah,11h            ;key pressed?
call  int16
je    int_09_end        ;no
cmp   ax,cs:hotk        ;hotkey?
jne   int_09_end        ;no
xor   cs:activ,1        ;toggle activ flag

in    al,22h
mov   ah,al             ;remember old port setting in ah

mov   al,58h            ;GPIO[26] operational reg
out   22h,al            ;select
in    al,23h            ;get operational reg
xor   al,4              ;toggle backlite
out   23h,al            ;write operational reg

mov   al,ah             ;restore old port setting
out   22h,al

cmp   cs:mute,1         ;without sound?
je    int_09_key        ;yes
xor   ax,ax
mov   ax,cs:activ
call  sound             ;play appropriate activation sound

  int_09_key:
mov   ah,10h            ;read out key
call  int16

  int_09_end:
pop   ax
iret                    ;return from int

;-----INT 1CH--------------------------------------------------

  int_1c_new:
pushf                   ;because iret pops flags as well
db    09ah              ;opcode: jmp far
  int_1c_old:
dw    0,0               ;jump to old int

push  ax
push  es
mov   ax,40h
mov   es,ax                ;ES points to bios data area
test  byte ptr es:[0fah],1 ;ongoing ON sequence?
je    int_1c_non           ;no
mov   cs:onseq,1           ;yes, remember
jmp   short int_1c_end     ;and exit

  int_1c_non:           ;no ongoing ON sequence
in    al,22h
mov   ah,al             ;remember old port setting in ah

mov   al,2ch            ;display controller shade reg
out   22h,al
in    al,23h

cmp   cs:onseq,0        ;ON sequence in the past?
je    int_1c_inv        ;no
mov   cs:onseq,0        ;yes, reset flag
push  ax
mov   ah,al
and   ah,1              ;isolate invert bit
cmp   ah,cs:shade       ;did invert bit change? 
pop   ax
je    int_1c_inv        ;no, hence it was not ON /
xor   cs:inver,1        ;otherwise it must have been ON /

  int_1c_inv:
or    al,1              ;invert screen
cmp   cs:activ,1        ;is backlite on?
je    int_1c_chk        ;yes, check local inversion
and   al,0feh           ;no, reset to normal

  int_1c_chk:
cmp   cs:inver,0        ;local inversion?
je    int_1c_wri        ;no
xor   al,1              ;yes, just toggle actual setting

  int_1c_wri:
out   23h,al            ;write shade reg
and   al,1              ;isolate invert bit
mov   cs:shade,al       ;and remember

mov   al,ah             ;restore old port setting
out   22h,al

  int_1c_end:
pop   es
pop   ax
iret                    ;return from int

;-----resident subroutine SOUND--------------------------------

DURA  equ 40            ;sound duration
STEP  equ 30            ;sound interval
BASIS equ 200           ;sound basis
FREQ  equ DURA*STEP+BASIS

  sound: 
pusha
mov   bx,-STEP
mov   cx,FREQ
mov   dx,DURA
or    ax,ax
jne   sound_1
mov   bx,STEP
mov   cx,BASIS
  sound_1:
in    al,61h
and   al,0FEh
  cycle:
or    al,2
out   61h,al
push  cx
  first:
loop  first
pop   cx
and   al,0FDh
out   61h,al
push  cx
  second:
loop  second
pop   cx
add   cx,bx
dec   dx
jne   cycle
popa
ret
;-----resident subroutine INT16--------------------------------

;simulates the keyboard interrupt to prevent light sleep

  int16:
;fkt 10h: read keyboard
;fkt 11h: check keyboard
;         zf=0 key ax available
;         zf=1 no key available
push  bx
push  cx
push  es
mov   bx,40h
mov   es,bx
  int16_1:
mov   bx,es:[1ah]
cmp   bx,es:[1ch]
jne   int16_2
cmp   ah,11h
jne   int16_1
jmp   short int16_e
  int16_2:
mov   cx,es:[bx]
cmp   ah,10h
mov   ax,cx
jne   int16_e
add   bx,2
cmp   bx,es:[82h]
jb    int16_3
mov   bx,es:[80h]
  int16_3:
mov   es:[1ah],bx
  int16_e:
pop   es
pop   cx
pop   bx
ret

RPARA equ ($-offset start+100h)/16+1 ;resident lenght mod 16

;-----end resident part----------------------------------------
;-----begin nonresident code-----------------------------------

  install:
xor   cx,cx             ;cx=0
mov   bx,80h
mov   cl,[bx]           ;command tail begin
or    cx,cx             ;tail available?
jne   inst_t            ;yes
call  resident          ;no, already resident?
jc    inst_0            ;yes
jmp   inst_new          ;no, install new
  inst_0:
lea   dx,tex2           ;...is resident
jmp   short inst_e

;tail is available

  inst_t:
call  resident          ;already resident?
jc    inst_tr           ;yes

;tail if not loaded resident

  inst_tl:
inc   bx
mov   al,[bx]
or    al,20h            ;make lower case
cmp   al,'s'
je    inst_ts
loop  inst_tl
lea   dx,help
jmp   short inst_e
  inst_ts:
xor   mute,1
jmp   short inst_new

;tail if loaded resident

  inst_tr:
inc   bx
mov   al,[bx]
or    al,20h            ;make lower case
cmp   al,'s'
je    inst_trs
cmp   al,'r'
je    inst_r
loop  inst_tr
lea   dx,help
jmp   short inst_e
  inst_trs:
xor   es:mute,1
jmp   short inst_ee
 
  inst_e:
mov   ah,9
int   21h
  inst_ee:
mov   ah,4ch            ;end non TSR
int   21h

  inst_R:
lea   dx,tex5
push  es                ;resident codesegment
mov   ah,35h
mov   al,IR_N1
int   21h
mov   bx,es             ;codesegment installed int
pop   es
mov   ax,es
cmp   bx,ax             ;if not equal
jne   inst_e            ;error
push  ds
push  dx

lds   dx,es:dword ptr int_09_old
mov   ah,25h
mov   al,IR_N1
int   21h

lds   dx,es:dword ptr int_1c_old
mov   ah,25h
mov   al,IR_N2
int   21h

pop   dx
pop   ds
not   word ptr es:start
mov   ah,49h
int   21h
jc    inst_e
lea   dx,tex4
jmp   inst_e

;-----install new----------------------------------------------

  inst_new:

mov   al,4fh            ;GPIO[26] configuration reg
out   22h,al            ;select
in    al,23h            ;get configuration reg
or    al,1              ;set: general output
out   23h,al            ;write configuration reg

mov   al,58h            ;GPIO[26] operational reg
out   22h,al            ;select
in    al,23h            ;get operational reg
and   al,0FBh           ;backlite off
out   23h,al            ;write operational reg

push  es

mov   ah,35h
mov   al,IR_N1          ;get old int
int   21h
mov   word ptr int_09_old,bx
mov   word ptr int_09_old+2,es

mov   ah,35h
mov   al,IR_N2          ;get old int
int   21h
mov   word ptr int_1c_old,bx
mov   word ptr int_1c_old+2,es

pop   es

mov   dx,offset int_09_new
mov   ah,25h
mov   al,IR_N1          ;set int
int   21h

mov   dx,offset int_1c_new
mov   ah,25h
mov   al,IR_N2          ;set int
int   21h

lea   dx,logo
mov   ah,9
int   21h
mov   ax,ds:[002ch]     ;environement block
mov   es,ax
mov   ah,49h            ;release
int   21h
not   word ptr start
mov   dx,RPARA
mov   ax,3100h          ;stay resident
int   21h

;-----nonresident subroutines----------------------------------

;cf=1:program is already loaded resident at codesegment es
;cf=0:program is not loaded resident, es=cs=ds

  resident:
pusha
cld
not    word ptr start   ;was changed at upload
xor    bx,bx
mov    ax,cs            ;search up to cs
  resident_loop:        ;do for every paragraph
inc    bx               ;next paragraph
mov    es,bx            ;in es
cmp    ax,bx            ;done?
clc
je     resident_e       ;end, hence not found
mov    si,offset start  ;offset in our code to compare
mov    di,si            ;offset in resident code
mov    cx,10            ;bytes to compare
rep    cmpsb            ;compare ds:si with es:di
jne    resident_loop    ;not found in this paragraph, loop
stc
  resident_e:
not    word ptr start   ;reset to origin 
popa
ret

;-----begin nonresident data-----------------------------------
                                                           
logo: db 13,10
      db 'Ŀ',13,10
      db 'BackLite V1.3 (c) 99 Stefan Peichl',13,10
      db 'Fn B  Toggles The Backlight On/Off',13,10
      db '',13,10,'$'
help: db 'Usage: BACKLITE [/S][/R]',13,10
      db '/S   = Sound toggle',13,10
      db '/R   = Remove',13,10
      db 'Fn B = Hotkey$',13,10
tex2: db '...is resident$'
tex4: db '...removed$'
tex5: db '...cannot remove$'

;-----end nonresident data-------------------------------------

cseg  ends
end   start
