#!/bin/sh

## leave this script in same folder with DOSBoxWPMac source
## requires build environment created in $HOME/Development/i386

## error handling!!! I have no idea how it works. I copied it from the net :) --Dominus
DIE=0
function error_quit
{
echo -e "\033[1;31m **Error** line #${1:-"Unknown Error"}\033[0m" 1>&2
exit 1
}

$DOSBOXFOLDER="."

chmod +x *.sh

# function definition
mfile="Makefile"
function distclean () {
	if [ -f "$mfile" ]
	then
		make distclean >/dev/null
	fi
}

OPT=' -arch i386 -m32 -O2 -msse -msse2 -force_cpusubtype_ALL ' # -w
SDK=' -mmacosx-version-min=10.7 '                                   
export MACOSX_DEPLOYMENT_TARGET=10.7
export PATH=$HOME/Development/i386/bin/:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin
export CC="/Applications/Xcode.app/Contents/Developer/usr/bin/gcc -arch i386"
export CXX="/Applications/Xcode.app/Contents/Developer/usr/bin/g++ -arch i386"
export CPPFLAGS='-I'$HOME'/Development/i386/include'$SDK
export CFLAGS='-I'$HOME'/Development/i386/include '$SDK' '$OPT
export CXXFLAGS='-I'$HOME'/Development/i386/include '$SDK' '$OPT
export LDFLAGS='-L'$HOME'/Development/i386/lib '$SDK' '$OPT
export LIBTOOLFLAGS=--silent

###----------------------------------------------------------------------

#echo
#read -p "Build static-linked DOSBoxWP (25- and 43-line)? (y/N) " -n 1 -r
#echo    # (optional) move to a new line
#if [[ $REPLY =~ ^[Yy]$ ]]
#then	# start build-static-linked block

if [ -f "./src/dosbox.cpp" ]	# checking for at least one source file
	then
		echo Source folder seems to be correct.
	else
		echo
		echo Could not find source files. Aborting.
		exit
fi

distclean
## make distclean >/dev/null

### build 43-line version

# cd $DOSBOXFOLDER
./autogen.sh
chmod +x ./configure
./configure -q --prefix=$HOME/Development/i386 --disable-sdltest --disable-alsatest --enable-forty3 --enable-wpdos  || {    
DIE=1
error_quit "$(( $LINENO -2 )) : configure failed."
}

make clean >/dev/null

rm temporary.patch
echo '--- ./Makefile' >temporary.patch
echo '+++ ./Makefile' >>temporary.patch
echo '@@ -238,7 +238,7 @@' >>temporary.patch
echo  ' INSTALL_STRIP_PROGRAM = $(install_sh) -c -s' >>temporary.patch
echo ' LDFLAGS = -L'$HOME'/Development/i386/lib  -mmacosx-version-min=10.7   -arch i386 -m32 -O2 -msse -msse2 -force_cpusubtype_ALL ' >>temporary.patch
echo ' LIBOBJS = ' >>temporary.patch
echo '-LIBS = -lSDL_sound  -L'$HOME'/Development/i386/lib -lSDLmain -lSDL -Wl,-framework,Cocoa -lpng -lz -lSDL_net -framework OpenGL -framework CoreMIDI -framework AudioUnit -framework AudioToolbox' >>temporary.patch
echo '+LIBS = -L'$HOME'/Development/i386/lib '$HOME'/Development/i386/lib/libSDLmain.a '$HOME'/Development/i386/lib/libSDL.a -Wl,-framework,OpenGL -Wl,-framework,Cocoa -Wl,-framework,ApplicationServices -Wl,-framework,Carbon -Wl,-framework,AudioToolbox -Wl,-framework,AudioUnit -Wl,-framework,IOKit -framework CoreMIDI '$HOME'/Development/i386/lib/libpng.a '$HOME'/Development/i386/lib/libz.a '$HOME'/Development/i386/lib/libSDL_net.a '$HOME'/Development/i386/lib/libSDL_sound.a '$HOME'/Development/i386/lib/libogg.a '$HOME'/Development/i386/lib/libvorbis.a '$HOME'/Development/i386/lib/libvorbisfile.a '$HOME'/Development/i386/lib/libvorbisenc.a' >>temporary.patch
echo ' LTLIBOBJS = ' >>temporary.patch
echo ' MAKEINFO = ${SHELL} '$HOME'/Development/dosbox-svn-3982/missing makeinfo' >>temporary.patch
echo ' MKDIR_P = ./install-sh -c -d' >>temporary.patch
echo '@@ -254,7 +254,7 @@' >>temporary.patch
echo ' RANLIB = ranlib' >>temporary.patch
echo ' SDL_CFLAGS = -I'$HOME'/Development/i386/include/SDL -D_GNU_SOURCE=1 -D_THREAD_SAFE' >>temporary.patch
echo ' SDL_CONFIG = '$HOME'/Development/i386/bin//sdl-config' >>temporary.patch
echo '-SDL_LIBS = -L'$HOME'/Development/i386/lib -lSDLmain -lSDL -Wl,-framework,Cocoa' >>temporary.patch
echo '+SDL_LIBS = -L'$HOME'/Development/i386/lib '$HOME'/Development/i386/lib/libSDLmain.a '$HOME'/Development/i386/lib/libSDL.a -Wl,-framework,OpenGL -Wl,-framework,Cocoa -Wl,-framework,ApplicationServices -Wl,-framework,Carbon -Wl,-framework,AudioToolbox -Wl,-framework,AudioUnit -Wl,-framework,IOKit' >>temporary.patch
echo ' SET_MAKE = ' >>temporary.patch
echo ' SHELL = /bin/sh' >>temporary.patch
echo ' STRIP = ' >>temporary.patch
echo '' >>temporary.patch
echo '--- ./src/Makefile' >>temporary.patch
echo '+++ ./src/Makefile' >>temporary.patch
echo '@@ -242,7 +242,7 @@' >>temporary.patch
echo ' INSTALL_STRIP_PROGRAM = $(install_sh) -c -s' >>temporary.patch
echo ' LDFLAGS = -L'$HOME'/Development/i386/lib  -mmacosx-version-min=10.7   -arch i386 -m32 -O2 -msse -msse2 -force_cpusubtype_ALL ' >>temporary.patch
echo ' LIBOBJS = ' >>temporary.patch
echo '-LIBS = -lSDL_sound  -L'$HOME'/Development/i386/lib -lSDLmain -lSDL -Wl,-framework,Cocoa -lpng -lz -lSDL_net -framework OpenGL -framework CoreMIDI -framework AudioUnit -framework AudioToolbox' >>temporary.patch
echo '+LIBS = -L'$HOME'/Development/i386/lib '$HOME'/Development/i386/lib/libSDLmain.a '$HOME'/Development/i386/lib/libSDL.a -Wl,-framework,OpenGL -Wl,-framework,Cocoa -Wl,-framework,ApplicationServices -Wl,-framework,Carbon -Wl,-framework,AudioToolbox -Wl,-framework,AudioUnit -Wl,-framework,IOKit -framework CoreMIDI '$HOME'/Development/i386/lib/libpng.a '$HOME'/Development/i386/lib/libz.a '$HOME'/Development/i386/lib/libSDL_net.a '$HOME'/Development/i386/lib/libSDL_sound.a '$HOME'/Development/i386/lib/libogg.a '$HOME'/Development/i386/lib/libvorbis.a '$HOME'/Development/i386/lib/libvorbisfile.a '$HOME'/Development/i386/lib/libvorbisenc.a' >>temporary.patch
echo ' LTLIBOBJS = ' >>temporary.patch
echo ' MAKEINFO = ${SHELL} '$HOME'/Development/dosbox-svn-3982/missing makeinfo' >>temporary.patch
echo ' MKDIR_P = .././install-sh -c -d' >>temporary.patch
echo '@@ -258,7 +258,7 @@' >>temporary.patch
echo ' RANLIB = ranlib' >>temporary.patch
echo ' SDL_CFLAGS = -I'$HOME'/Development/i386/include/SDL -D_GNU_SOURCE=1 -D_THREAD_SAFE' >>temporary.patch
echo ' SDL_CONFIG = '$HOME'/Development/i386/bin//sdl-config' >>temporary.patch
echo '-SDL_LIBS = -L'$HOME'/Development/i386/lib -lSDLmain -lSDL -Wl,-framework,Cocoa'>>temporary.patch
echo '+SDL_LIBS = -L'$HOME'/Development/i386/lib '$HOME'/Development/i386/lib/libSDLmain.a '$HOME'/Development/i386/lib/libSDL.a -Wl,-framework,OpenGL -Wl,-framework,Cocoa -Wl,-framework,ApplicationServices -Wl,-framework,Carbon -Wl,-framework,AudioToolbox -Wl,-framework,AudioUnit -Wl,-framework,IOKit' >>temporary.patch
echo ' SET_MAKE = ' >>temporary.patch
echo ' SHELL = /bin/sh' >>temporary.patch
echo ' STRIP = ' >>temporary.patch

echo && echo
patch -p1 -i temporary.patch ||  error dosbox patch

echo
# read -p "Press Enter to continue if patch above succeeded; ctrl-C to quit."

make clean && make -j9 -s || {
DIE=1
error_quit "$(( $LINENO -2 )) : make failed."
}

mv ./src/dosbox ./src/DOSBoxWP-43line

echo && echo  43-line DOSBoxWP built in ./src
echo

#read -p "Run 43-line DOSBoxWP in ./src (y/N)? " -n 1 -r
#echo    # (optional) move to a new line
#if [[ $REPLY =~ ^[Yy]$ ]]
#then
	cd src
    echo '[cpu]'>dosbox.conf
    echo 'core=dynamic'>>dosbox.conf
    echo '[autoexec]'>>dosbox.conf
    echo 'config -get cpu'>>dosbox.conf
	./DOSBoxWP-43line -conf=./dosbox.conf
    cd ..
#fi

####  exit    #######################

make clean >/dev/null

### Build 25-line DOSBoxWP

# cd $DOSBOXFOLDER
./autogen.sh
./configure -q --prefix=$HOME/Development/i386 --disable-sdltest --disable-alsatest --enable-wpdos || {    
DIE=1
error_quit "$(( $LINENO -2 )) : configure failed."
}

make clean >/dev/null

rm temporary.patch
echo '--- ./Makefile' >temporary.patch
echo '+++ ./Makefile' >>temporary.patch
echo '@@ -238,7 +238,7 @@' >>temporary.patch
echo  ' INSTALL_STRIP_PROGRAM = $(install_sh) -c -s' >>temporary.patch
echo ' LDFLAGS = -L'$HOME'/Development/i386/lib  -mmacosx-version-min=10.7   -arch i386 -m32 -O2 -msse -msse2 -force_cpusubtype_ALL ' >>temporary.patch
echo ' LIBOBJS = ' >>temporary.patch
echo '-LIBS = -lSDL_sound  -L'$HOME'/Development/i386/lib -lSDLmain -lSDL -Wl,-framework,Cocoa -lpng -lz -lSDL_net -framework OpenGL -framework CoreMIDI -framework AudioUnit -framework AudioToolbox' >>temporary.patch
echo '+LIBS = -L'$HOME'/Development/i386/lib '$HOME'/Development/i386/lib/libSDLmain.a '$HOME'/Development/i386/lib/libSDL.a -Wl,-framework,OpenGL -Wl,-framework,Cocoa -Wl,-framework,ApplicationServices -Wl,-framework,Carbon -Wl,-framework,AudioToolbox -Wl,-framework,AudioUnit -Wl,-framework,IOKit -framework CoreMIDI '$HOME'/Development/i386/lib/libpng.a '$HOME'/Development/i386/lib/libz.a '$HOME'/Development/i386/lib/libSDL_net.a '$HOME'/Development/i386/lib/libSDL_sound.a '$HOME'/Development/i386/lib/libogg.a '$HOME'/Development/i386/lib/libvorbis.a '$HOME'/Development/i386/lib/libvorbisfile.a '$HOME'/Development/i386/lib/libvorbisenc.a' >>temporary.patch
echo ' LTLIBOBJS = ' >>temporary.patch
echo ' MAKEINFO = ${SHELL} '$HOME'/Development/dosbox-svn-3982/missing makeinfo' >>temporary.patch
echo ' MKDIR_P = ./install-sh -c -d' >>temporary.patch
echo '@@ -254,7 +254,7 @@' >>temporary.patch
echo ' RANLIB = ranlib' >>temporary.patch
echo ' SDL_CFLAGS = -I'$HOME'/Development/i386/include/SDL -D_GNU_SOURCE=1 -D_THREAD_SAFE' >>temporary.patch
echo ' SDL_CONFIG = '$HOME'/Development/i386/bin//sdl-config' >>temporary.patch
echo '-SDL_LIBS = -L'$HOME'/Development/i386/lib -lSDLmain -lSDL -Wl,-framework,Cocoa' >>temporary.patch
echo '+SDL_LIBS = -L'$HOME'/Development/i386/lib '$HOME'/Development/i386/lib/libSDLmain.a '$HOME'/Development/i386/lib/libSDL.a -Wl,-framework,OpenGL -Wl,-framework,Cocoa -Wl,-framework,ApplicationServices -Wl,-framework,Carbon -Wl,-framework,AudioToolbox -Wl,-framework,AudioUnit -Wl,-framework,IOKit' >>temporary.patch
echo ' SET_MAKE = ' >>temporary.patch
echo ' SHELL = /bin/sh' >>temporary.patch
echo ' STRIP = ' >>temporary.patch
echo '' >>temporary.patch
echo '--- ./src/Makefile' >>temporary.patch
echo '+++ ./src/Makefile' >>temporary.patch
echo '@@ -242,7 +242,7 @@' >>temporary.patch
echo ' INSTALL_STRIP_PROGRAM = $(install_sh) -c -s' >>temporary.patch
echo ' LDFLAGS = -L'$HOME'/Development/i386/lib  -mmacosx-version-min=10.7   -arch i386 -m32 -O2 -msse -msse2 -force_cpusubtype_ALL ' >>temporary.patch
echo ' LIBOBJS = ' >>temporary.patch
echo '-LIBS = -lSDL_sound  -L'$HOME'/Development/i386/lib -lSDLmain -lSDL -Wl,-framework,Cocoa -lpng -lz -lSDL_net -framework OpenGL -framework CoreMIDI -framework AudioUnit -framework AudioToolbox' >>temporary.patch
echo '+LIBS = -L'$HOME'/Development/i386/lib '$HOME'/Development/i386/lib/libSDLmain.a '$HOME'/Development/i386/lib/libSDL.a -Wl,-framework,OpenGL -Wl,-framework,Cocoa -Wl,-framework,ApplicationServices -Wl,-framework,Carbon -Wl,-framework,AudioToolbox -Wl,-framework,AudioUnit -Wl,-framework,IOKit -framework CoreMIDI '$HOME'/Development/i386/lib/libpng.a '$HOME'/Development/i386/lib/libz.a '$HOME'/Development/i386/lib/libSDL_net.a '$HOME'/Development/i386/lib/libSDL_sound.a '$HOME'/Development/i386/lib/libogg.a '$HOME'/Development/i386/lib/libvorbis.a '$HOME'/Development/i386/lib/libvorbisfile.a '$HOME'/Development/i386/lib/libvorbisenc.a' >>temporary.patch
echo ' LTLIBOBJS = ' >>temporary.patch
echo ' MAKEINFO = ${SHELL} '$HOME'/Development/dosbox-svn-3982/missing makeinfo' >>temporary.patch
echo ' MKDIR_P = .././install-sh -c -d' >>temporary.patch
echo '@@ -258,7 +258,7 @@' >>temporary.patch
echo ' RANLIB = ranlib' >>temporary.patch
echo ' SDL_CFLAGS = -I'$HOME'/Development/i386/include/SDL -D_GNU_SOURCE=1 -D_THREAD_SAFE' >>temporary.patch
echo ' SDL_CONFIG = '$HOME'/Development/i386/bin//sdl-config' >>temporary.patch
echo '-SDL_LIBS = -L'$HOME'/Development/i386/lib -lSDLmain -lSDL -Wl,-framework,Cocoa'>>temporary.patch
echo '+SDL_LIBS = -L'$HOME'/Development/i386/lib '$HOME'/Development/i386/lib/libSDLmain.a '$HOME'/Development/i386/lib/libSDL.a -Wl,-framework,OpenGL -Wl,-framework,Cocoa -Wl,-framework,ApplicationServices -Wl,-framework,Carbon -Wl,-framework,AudioToolbox -Wl,-framework,AudioUnit -Wl,-framework,IOKit' >>temporary.patch
echo ' SET_MAKE = ' >>temporary.patch
echo ' SHELL = /bin/sh' >>temporary.patch
echo ' STRIP = ' >>temporary.patch

echo && echo
patch -p1 -i temporary.patch ||  error dosbox patch

echo
## read -p "Press Enter to continue if patch above succeeded; ctrl-C to quit."

make clean && make -j9 -s || {
DIE=1
error_quit "$(( $LINENO -2 )) : make failed."
}
mv ./src/dosbox ./src/DOSBoxWP-25line

echo && echo  25-line DOSBoxWP built in ./src
echo

read -p "Run 25-line DOSBoxWP in ./src (y/N)? " -n 1 -r
echo    # (optional) move to a new line
if [[ $REPLY =~ ^[Yy]$ ]]
then
    cd src
    echo '[cpu]'>dosbox.conf
    echo 'core=dynamic'>>dosbox.conf
    echo '[autoexec]'>>dosbox.conf
    echo 'config -get cpu'>>dosbox.conf
	./DOSBoxWP-25line -conf=./dosbox.conf
    cd ..
fi

make clean >/dev/null

read -p "Open src folder (y/N)? " -n 1 -r
echo    # (optional) move to a new line
if [[ $REPLY =~ ^[Yy]$ ]]
then
	open ./src
fi

## fi		# end build-static-linked block

echo 

### -------------------------------------

if [ ] ; then           ## remove this to include block

echo
read -p "Create OS X MyDOSBox.app in $DOSBOXFOLDER/src? (y/N) " -n 1 -r
echo    # (optional) move to a new line
if [[ $REPLY =~ ^[Yy]$ ]]
then	# start build-static-linked block

if [ -f "$DOSBOXFOLDER/src/dosbox" ]
	then
		echo
	else
		echo Cannot build app in $DOSBOXFOLDER/src. Dosbox executable not found.
		exit
fi

cd $DOSBOXFOLDER/src

if [ -f "$DOSBOXFOLDER/src/MyDOSBox.app/Contents/PkgInfo" ]
	then
	read -p "Delete existing MyDOSBox.app in $DOSBOXFOLDER/src? (y/N) " -n 1 -r
		echo    # (optional) move to a new line
		if [[ $REPLY =~ ^[Yy]$ ]]
		then	
			rm -rf $DOSBOXFOLDER/src/MyDOSBox.app/*
			rmdir $DOSBOXFOLDER/src/MyDOSBox.app
		else
			echo Existing MyDOSBox.app not deleted. Aborting.
			exit
		fi
fi

#mkdir -p DOSBoxWP.app/Contents/MacOS
cp DOSBoxWP-43line DOSBoxWP.app/Contents/MacOS/DOSBox
cp DOSBoxWP-43line DOSBoxWP.app/Contents/MacOS/DOSBox-text
cp DOSBoxWP-25line DOSBoxWP.app/Contents/MacOS/DOSBox-text-25line

#echo 'APPL????' >DOSBoxWP.app/Contents/PkgInfo
#mkdir -p DOSBoxWP.app/Contents/Resources
# cp dosbox.icns DOSBoxWP.app/Contents/Resources/dosbox.icns		# uncomment if you have an icns file!

# cd DOSBoxWP.app/Contents
# 
# echo '<?xml version="1.0" encoding="UTF-8"?>' >> Info.plist
# echo '<!DOCTYPE plist PUBLIC "-//Apple//DTD PLIST 1.0//EN" "http://www.apple.com/DTDs/PropertyList-1.0.dtd">' >> Info.plist
# echo '<plist version="1.0">' >> Info.plist
# echo '<dict>' >> Info.plist
# echo '	<key>CFBundleDevelopmentRegion</key>' >> Info.plist
# echo '	<string>English</string>' >> Info.plist
# echo '	<key>CFBundleDisplayName</key>' >> Info.plist
# echo '	<string>DOSBox</string>' >> Info.plist
# echo '	<key>CFBundleExecutable</key>' >> Info.plist
# echo '	<string>DOSBoxWP</string>' >> Info.plist
# echo '	<key>CFBundleGetInfoString</key>' >> Info.plist
# echo '	<string>SVN, Copyright 2002-2016 The DOSBox Team and wpdos.org</string>' >> Info.plist
# echo '	<key>CFBundleIconFile</key>' >> Info.plist
# echo '	<string>dosbox.icns</string>' >> Info.plist
# echo '	<key>CFBundleInfoDictionaryVersion</key>' >> Info.plist
# echo '	<string>6.0</string>' >> Info.plist
# echo '	<key>CFBundleName</key>' >> Info.plist
# echo '	<string>DOSBox</string>' >> Info.plist
# echo '	<key>CFBundlePackageType</key>' >> Info.plist
# echo '	<string>APPL</string>' >> Info.plist
# echo '	<key>CFBundleShortVersionString</key>' >> Info.plist
# echo '	<string>SVN</string>' >> Info.plist
# echo '	<key>CFBundleVersion</key>' >> Info.plist
# echo '	<string>SVN</string>' >> Info.plist
# echo '	<key>NSHumanReadableCopyright</key>' >> Info.plist
# echo '	<string>Copyright 2002-2016 The DOSBox Team and wpdos.org</string>' >> Info.plist
# echo '	<key>NSPrincipalClass</key>' >> Info.plist
# echo '	<string>NSApplication</string>' >> Info.plist
# echo '	<key>CGDisableCoalescedUpdates</key>' >> Info.plist
# echo '	<true/>' >> Info.plist
# echo '</dict>' >> Info.plist
# echo '</plist>' >> Info.plist

cd ../..

echo && echo
read -p "Run MyDOSBox.app in $DOSBOXFOLDER/src (y/N)? " -n 1 -r
echo    # (optional) move to a new line
if [[ $REPLY =~ ^[Yy]$ ]]
then
	open ./MyDOSBox.app
fi

fi

echo

fi ## remove to include

exit
