/* --------------------------------------------------------------------
   Project: PAL General Database routines
   Module:  SHOWDBT.C
   Author:  Jean-Jacques Moreau
   Started: 11. Aug. 99
   Subject: Show database title
   -------------------------------------------------------------------- */

/* --------------------------------------------------------------------
                          standard includes
   -------------------------------------------------------------------- */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>

/* --------------------------------------------------------------------
                            local includes
   -------------------------------------------------------------------- */

#include "pal.h"


/* -------------------------------------------------------------------------
                           Show database title
   ------------------------------------------------------------------------- */

void ShowDBTitle(DBDESC *pDD, char *pPrefix)
{
   char Title[128];
   char *pDBName;
   char *p;

   pDBName = Filename(pDD->FileName);
   for(p = pDBName; p < pDBName + strlen(pDBName); p++)
      *p = toupper(*p);
   sprintf(Title, "%s:%s", pPrefix, pDBName);

   ShowTopTime(Title, FALSE);

   free(pDBName);
}

