'/* LSORT.BAS  Sort/retrieve/index data; ascending/descending; mixed types */
'/*            By: Dale Thorn                                              */
'/*            Rev. 04.02.1998                                             */

dim insbeg(10), inslen(10), insseq(10), lnsptr(700, 1)
dim nc as ncnf                                     'sort-options pass structure


function psort(nc as ncnf, cnc.data, cnc.indx, cnc.lng, _ 'sort & retrieve data
cnc.nbuf, cnc.sdat, insbeg(), inslen(), insseq(), lnsptr())
   if nc.oper = 0 then                       'insert a record <add to the sort>
      if nc.init = 0 then                     'first-sort-record initialization
         nc.init = -1                               'adjust initialization flag
         nc.sseq = insseq(0)                           'primary output sequence
         i = ifn.kill(nc.sdno, "sortdata.sdx")    'kill work data file (if any)
         i = ifn.kill(nc.ndno, "sortdata.ndx")   'kill work index file (if any)
         open "sortdata.sdx" for binary as nc.sdno         'open work data file
         open "sortdata.ndx" for binary as nc.ndno        'open work index file
         cnc.lng = string$(4, 0)           'buffer stores a long-integer string
         lfree = lps.free(4096, clng(195840))              'reserve 4 kb memory
         nc.rmax = lfree \ (nc.slen + 6)      'maximum records per memory group
         if nc.rmax > 32640 \ nc.slen then   'records available > string-length
            nc.rmax = 32640 \ nc.slen          'reset maximum records per group
         end if
         cnc.data = space$(nc.rmax * nc.slen)            'main sort data buffer
         cnc.indx = space$(nc.rmax * 3 + 3) 'reorderable/shiftable index buffer
         nc.rptr = 1                               'used to count total records
         nc.rcnt = 1                 'used to count records within a sort group
         nc.gptr = 1                                       'sort buffer pointer
      end if
      if nc.rcnt > nc.rmax then              'too many records to fit in memory
         if nc.ntot = 0 then     'first group; initialize index group variables
            nc.gtot = nc.rcnt - 1                  'number of records per group
            nc.nlen = nc.gtot * 3                    'size of index file buffer
         end if                             'put group data to the sort [below]
         i = ips.ssav(nc, cnc.data, cnc.indx, insbeg(), inslen(), insseq())
         nc.offs = nc.rptr - 1                  'group-to-record offset counter
         nc.rcnt = 1                                'reset group record counter
         nc.gptr = 1                                       'sort buffer pointer
      end if
      i = ips.fill(nc, cnc.data, cnc.indx, cnc.lng, _   'add record to the sort
      cnc.sdat, insbeg(), inslen(), insseq())
      nc.rptr = nc.rptr + 1                    'increment total records counter
      nc.rcnt = nc.rcnt + 1                     'increment group record counter
      nc.gptr = nc.rcnt                                    'sort buffer pointer
   else                                    'retrieve a record or build an index
      nc.offs = 0                               'group-to-record offset counter
      if nc.init = -1 then               'first retrieval record initialization
         nc.init = -2                               'adjust initialization flag
         nc.rtot = nc.rptr - 1                'total records from original sort
         nc.stot = nc.rcnt - 1       'partial-group subtotal from original sort
         nc.dptr = 1                         'beginning pointer for data output
         if nc.ntot then       'sorting was done in groups; put to sort [below]
            i = ips.ssav(nc, cnc.data, cnc.indx, insbeg(), inslen(), insseq())
            igrplen = nc.nlen                                   'group size * 3
            cnc.data = ""                       'erase buffer to reclaim memory
            cnc.indx = ""                       'erase buffer to reclaim memory
            cnc.data = space$(nc.ntot * nc.slen)   'buffer holds 1 record/group
            cnc.indx = space$(nc.ntot * 3 + 3)     'buffer holds 1 record/group
         else                                   'all sorting was done in memory
            nc.dtot = nc.rtot                          'total records to output
            nc.rmax = nc.rtot             'reset maximum records for file write
            nc.nlen = nc.rmax * 3                'length of index data to write
            i = ips.ssav(nc, cnc.data, cnc.indx, insbeg(), inslen(), insseq())
            cnc.data = ""                       'erase buffer to reclaim memory
            cnc.indx = ""                       'erase buffer to reclaim memory
            nc.ntot = 0                   'reset to zero after call to ips.ssav
         end if
         lfree = lps.free(4096, clng(32640))               'reserve normal 4 kb
         lsize = nc.rtot * 3                                 'total records * 3
         nc.mndx = (lsize <= 32640 and lsize <= lfree)    'index-in-memory flag
         if nc.mndx then               'retrieval index fits entirely in memory
            nc.nlen = lsize                 'buffer length is index file length
            cnc.nbuf = space$(nc.nlen)              'allocate index file buffer
            i = ips.rget(nc.ndno, nc.nlen, clng(1), cnc.nbuf)   'load the index
         else                           'retrieval index does not fit in memory
            nc.nlen = 3                 'buffer length is 24-bit integer length
            cnc.nbuf = space$(nc.nlen)              'allocate index file buffer
         end if
         if nc.ntot then                             'merge-sort initialization
            ixx1 = (nc.sseq > 0)                  'used locally to shorten line
            ixx2 = (nc.sseq < 0)                  'used locally to shorten line
            ixx3 = (nc.mndx * 2 and ixx1)         'used locally to shorten line
            ixx4 = (nc.mndx * 2 and ixx2)         'used locally to shorten line
            iyy1 = 1 - nc.mndx * 2                'used locally to shorten line
            iyy2 = igrplen \ (1 - (not nc.mndx) * 2) 'used here to shorten line
            for ircdcnt = 1 to nc.ntot              'loop thru each index group
               nc.rcnt = ircdcnt                 'set sort group record pointer
               nc.gptr = ircdcnt                 'set sort group record pointer
               iyy3 = (nc.gtot - nc.stot) * (ixx2 and (nc.rcnt = nc.ntot))
               iyy4 = (nc.gtot - nc.stot) * (ixx1 and (nc.rcnt = nc.ntot))
               lrcd = clng(nc.rcnt + ixx1) * iyy2 + iyy3 * iyy1 + ixx4 - ixx1
               lrcx = clng(nc.rcnt + ixx2) * iyy2 + iyy4 * iyy1 + ixx3 - ixx2
               if nc.mndx then            'get index pointer from memory buffer
                  mid$(cnc.lng, 1) = mid$(cnc.nbuf, cint(lrcd), 3)'get f/memory
               else                                'get index pointer from file
                  i = ips.rget(nc.ndno, nc.nlen, lrcd, cnc.nbuf) 'get from file
                  mid$(cnc.lng, 1) = cnc.nbuf   'put file value to long-integer
               end if              'add one record from each sort group [below]
               i = ips.rget(nc.sdno, nc.slen, cvl(cnc.lng), cnc.sdat) 'get data
               i = ips.fill(nc, cnc.data, cnc.indx, cnc.lng, _ 'add to the sort
               cnc.sdat, insbeg(), inslen(), insseq())
               lnsptr(nc.rcnt - 1, 0) = lrcd  'begin ptr.for group index record
               lnsptr(nc.rcnt - 1, 1) = lrcx    'end ptr.for group index record
            next
            if nc.sseq < 0 then                        'primary output sequence
               nc.dptr = nc.rcnt                 'begin output in reverse order
            end if
         else                                'non-merge; all output from memory
            if nc.sseq < 0 then                        'primary output sequence
               nc.dptr = nc.dtot                 'begin output in reverse order
            end if
         end if
      end if
      if nc.ntot then                         'merge-retrieval from sort groups
         if nc.rcnt then                      'sort records are still available
            mid$(cnc.lng, 1) = mid$(cnc.indx, nc.dptr * 3 - 2, 3) 'ptr-to-index
            nc.gptr = cvl(cnc.lng)                 'set the group-pointer value
            iptr = nc.gptr - 1                    'temp value used for lnsptr()
            if nc.mndx then            'retrieval index fits entirely in memory
               mid$(cnc.lng, 1) = mid$(cnc.nbuf, cint(lnsptr(iptr, 0)), 3)
            else                 'get pointer-to-data from memory-index [above]
               i = ips.rget(nc.ndno, nc.nlen, lnsptr(iptr, 0), cnc.nbuf)
               mid$(cnc.lng, 1) = cnc.nbuf 'put index buffer to long-int buffer
            end if               'get pointer-to-data from index buffer [above]
            nc.rptr = cvl(cnc.lng)                     'convert pointer-to-data
            if nc.sseq > 0 then                           'sort-output sequence
               mid$(cnc.indx, 1) = mid$(cnc.indx, 4)      'shift the work-index
            end if
            if lnsptr(iptr, 0) = lnsptr(iptr, 1) then   'end of this sort group
               nc.rcnt = nc.rcnt - 1             'decrement group stack pointer
               if nc.sseq < 0 then                        'sort-output sequence
                  nc.dptr = nc.rcnt                    'set output data pointer
               end if
            else     'end of group not yet reached; increment the group pointer
               lnsptr(iptr, 0) = lnsptr(iptr, 0) + (1 - nc.mndx * 2) * nc.sseq
               if nc.mndx then         'retrieval index fits entirely in memory
                  mid$(cnc.lng, 1) = mid$(cnc.nbuf, cint(lnsptr(iptr, 0)), 3)
               else              'get pointer-to-data from memory-index [above]
                  i = ips.rget(nc.ndno, nc.nlen, lnsptr(iptr, 0), cnc.nbuf)
                  mid$(cnc.lng, 1) = cnc.nbuf 'put index buffer to long-integer
               end if            'get pointer-to-data from index buffer [above]
               i = ips.rget(nc.sdno, nc.slen, cvl(cnc.lng), cnc.sdat) 'get data
               i = ips.fill(nc, cnc.data, cnc.indx, cnc.lng, _     '...to merge
               cnc.sdat, insbeg(), inslen(), insseq())       '...into the stack
            end if       'retrieve the data to send back to the calling program
            i = ips.rget(nc.sdno, nc.slen, nc.rptr, cnc.sdat)    'retrieve data
            icmp = 0                              'retrieval process incomplete
         else                             'sort records are no longer available
            icmp = not 0                     'retrieval process is now complete
         end if
      else                     'non-merge sort retrieval; all data is in memory
         if nc.dtot then                      'sort records are still available
            mid$(cnc.lng, 1) = mid$(cnc.nbuf, nc.dptr * 3 - 2, 3)'long-int.buff
            i = ips.rget(nc.sdno, nc.slen, cvl(cnc.lng), cnc.sdat)'data&pointer
            nc.dptr = nc.dptr + nc.sseq   'increment or decrement stack pointer
            nc.dtot = nc.dtot - 1                  'decrement remaining records
            icmp = 0                              'retrieval process incomplete
         else                                   'no more sort records available
            icmp = not 0                     'retrieval process is now complete
         end if
      end if
      if icmp then                                           'sort is completed
         i = ifn.kill(nc.sdno, "sortdata.sdx")             'kill sort data file
         i = ifn.kill(nc.ndno, "sortdata.ndx")        'kill sort index workfile
         cnc.data = ""                             'kill main sort group buffer
         cnc.indx = ""                                  'kill sort index buffer
         cnc.nbuf = ""                                  'kill index file buffer
         cnc.sdat = ""                                   'kill sort data buffer
      end if
   end if
end function


function ips.fill(nc as ncnf, cnc.data, cnc.indx, _      'add data to the stack
cnc.lng, cnc.sdat, insbeg(), inslen(), insseq())
   itop = nc.rcnt                                 'set top end of binary search
   ilow = 0                                       'set low end of binary search
   do while itop - ilow > 1    'search work data buffer using work index buffer
      imid = ilow + (itop - ilow) \ 2                'set mid point for compare
      mid$(cnc.lng, 1) = mid$(cnc.indx, imid * 3 - 2, 3)  'set long-int f/index
      iptr = (cvl(cnc.lng) - nc.offs - 1) * nc.slen + 1'pointer to index buffer
      if cnc.sdat <= mid$(cnc.data, iptr, nc.slen) then  'new data is <= buffer
         itop = imid                                         'move search lower
      else             'sort record value > compare value in sort memory buffer
         ilow = imid                                        'move search higher
      end if
   loop
   iptr = itop * 3 - 2                   'current index-"stack" insert position
   mid$(cnc.data, (nc.gptr - 1) * nc.slen + 1) = cnc.sdat      'write sort data
   mid$(cnc.indx, iptr + 3) = mid$(cnc.indx, iptr, (nc.rcnt - itop) * 3) 'shift
   mid$(cnc.indx, iptr) = left$(mkl$(nc.offs + nc.gptr), 3)
end function                            'write current pointer to index [above]


function ips.rget(ifno, ilen, lrcd, cbuf)           'get a record from the file
   get ifno, (lrcd - 1) * ilen + 1, cbuf                        'get the record
end function


function ips.rput(ifno, ilen, ircd, cbuf)             'put a record to the file
   put ifno, clng(ircd - 1) * ilen + 1, cbuf                    'put the record
end function


function ips.ssav(nc as ncnf, cnc.data, cnc.indx, insbeg(), inslen(), insseq())
   nc.ntot = nc.ntot + 1                      'increment the index group number
   i = ips.rput(nc.ndno, nc.nlen, nc.ntot, left$(cnc.indx, nc.nlen))
   ilen = nc.rmax * nc.slen                        'size of group memory buffer
   irec = lof(nc.sdno) \ ilen + 1                        'current data "record"
   i = ips.rput(nc.sdno, ilen, irec, cnc.data)          'put data group to file
end function


function lps.free(iexc, lmax)           'get maximum free memory less exclusion
   if fre("") - iexc > lmax then                  'available memory > requested
      lps.free = lmax                                 'return requested maximum
   else                                         'requested memory NOT available
      lps.free = fre("") - iexc              'return free memory less exclusion
   end if
end function
