/********************************************************/
/*							*/
/* EVA4to5 : EVA5 f[^쐬vO			*/
/*							*/
/*    eva4to5  file1  file2  file3			*/
/*	input						*/
/*		file1 : EVA4 data			*/
/*		file2 : PCM data (4bit PCM, 15KHz)	*/
/*	output						*/
/*		file3 : EVA5 data			*/
/*							*/
/********************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define	BYTE	unsigned char
#define	WORD	unsigned short

/* constants */
#define	XSIZE	24
#define	YSIZE	92
#define	FSIZE	XSIZE * YSIZE
#define	PSIZE	15600
#define	XDOT	96
#define	YDOT	92
#define	WFREQ	15600

/* public declaration */

static char filename[3][256];

/* sub functions */

void	err_exit(char *msg)
{
	fprintf(stderr, "%s\n", msg);
	exit(1);
}


void	usage()
{
	err_exit("EVA4to5 -- EVA4 to EVA5 Converter   "
		 " by T.Yamamoto\n\n"
		 " Usage: EVACV <EVA4 file> <PCM file> <output file>\n"
		 "\n");
}


void	fnmake(char *fn)
{
	char	*p, *p0;
	
	p = fn;
	while(*p++ != '\0')
		;
	p0 = --p;

	while(*p != '.' && *p != '\\' && *p != '/' && *p != ':'
	      && p >= fn)
		--p;
	
	if(*p != '.') strcpy(p0, ".EVA");
}


void	getcomlin(int argc, char *argv[])	/* analyze command line */
{
	int	i;
	int	fc = 0;

	if(argc < 2) usage();

	for(i = 1; i < argc; i++)
	{	char	*p;
		p = argv[i];
		if(*p == '-' || *p == '/')
		{
			usage();
		} else
		{
			if(fc > 2) usage();
			strcpy(filename[fc], p);
			if(fc == 2) fnmake(filename[fc]);
			fc++;
		}
	}
	if(fc != 3) usage();
}


/* main function */

void	main(int argc, char *argv[])
{
	static char header[256];
	static BYTE fbuf[FSIZE * 2];
	static BYTE pbuf[PSIZE];
	FILE	*fp1, *fp2, *fp3;
	unsigned int	t, tmax;
	double	pw;

	getcomlin(argc, argv);

	fp1=fopen(filename[0], "rb");
	if(fp1 == NULL)
		err_exit("Input file not found.");

	fp2=fopen(filename[1], "rb");
	if(fp2 == NULL)
		err_exit("PCM file not found.");

	fp3 = fopen(filename[2], "wb");
	if(fp3 == NULL)
		err_exit("Output file open error.");

	fread(header, 1, 4, fp1);
	if(strncmp(header, "EVA4", 4) != 0)
		err_exit("̃t@C EVA4 `ł͂܂B");
	while(fgetc(fp1)!= '\x1A' && feof(fp1) == 0)
		;
	tmax = fgetc(fp1);
	tmax = tmax + (fgetc(fp1) << 8);
	printf("frames = %d\n", tmax);

	pw = fgetc(fp1);
	fgetc(fp1);

	fwrite("EVA5\x1A", 1, 5, fp3);		/* ^Cg@@Rg */
	fputc(tmax & 255, fp3);			/* t[           */
	fputc(tmax >> 8, fp3);
	fputc(XDOT & 255, fp3);			/* hbg         */
	fputc(XDOT >> 8, fp3);
	fputc(YDOT & 255, fp3);			/* chbg         */
	fputc(YDOT >> 8, fp3);
	fputc(2, fp3);				/* Frbg             */
	fputc(0x18, fp3);			/* cic~0x10j */
	fputc(1,fp3);				/* PCM Format		  */
	fputc(WFREQ & 255, fp3);		/* PCM g             */
	fputc(WFREQ >> 8, fp3);
	pw = WFREQ / pw / 2;
	fputc((int)pw & 255, fp3);		/* R}PCMf[^  */
	fputc((int)pw >> 8, fp3);
	fputc(0, fp3);				/* \                   */
	
	
	for(t = 0; t < tmax; t++)
	{
		int	fl1, fl2, fl;
		
		printf("%d\r", t);
		
		memset(pbuf, '\0', sizeof(pbuf));
		fread(pbuf, 1, pw, fp2);
		fwrite(pbuf, 1, pw, fp3);
		
		fl1 = fgetc(fp1);
		fl2 = fgetc(fp1);
		fl = fl1+ (fl2 << 8);
		if(fread(fbuf, 1, fl, fp1) != fl)
			err_exit("t@CĂ܂B");
		
		fputc(fl1, fp3);
		fputc(fl2, fp3);
		if(fwrite(fbuf, 1, fl, fp3) != fl)
			err_exit("ݏo܂B");
	}
	fcloseall();
	printf("\n");
}
