#include "syncdir.h"
#include <time.h>
#include <string.h>
#include <stdlib.h>

static char *logBuf = 0;

void logExecuteComplete(void)
{
  if (logFile)
  {
    time_t now = time(0);
    struct tm *tm = localtime(&now);
    fprintf(logFile, "\nSyncdir finished: %s", asctime(tm));
  }
  if (!optionTest(OPT_QUIET))
    showExecuteComplete();
}

static void logList(const char *lst)
{
  const char *ptr = lst;
  BOOL isFirst = TRUE;
  while (*ptr)
  {
    if (isFirst)
      isFirst = FALSE;
    else
      fputs("; ", logFile);
    fputs(ptr, logFile);
    ptr += strlen(ptr) + 1;
  }
}

void logBegin(void)
{
  logBuf = malloc(2048);
  if (logFile)
  {
    time_t now = time(0);
    struct tm *tm = localtime(&now);
    fprintf(logFile, "Syncdir begin: %s", asctime(tm));
    fprintf(logFile, "source: %s\n"
                     "dest:   %s\n",
                     source->name,
                     dest->name);
    fputs("Include: ", logFile);
    logList(includeList);
    fputc('\n', logFile);

    if (excludeList[0])
    {
      fputs("Exclude: ", logFile);
      logList(excludeList);
      fputc('\n', logFile);
    }
  }
  if (!optionTest(OPT_QUIET))
    showBegin();
}

void logComplete(void)
{
  free(logBuf);
  if (logFile)
  {
    time_t now = time(0);
    struct tm *tm = localtime(&now);
    fprintf(logFile, "Syncdir complete: %s", asctime(tm));
  }
  if (!optionTest(OPT_QUIET))
    showComplete();
}

void logExecuteBegin(void)
{
  if (logFile)
  {
    fprintf(logFile, "\nAdd/Copy: %ld (%ld bytes)\n",
      source->stAdd.tCt + source->stCopy.tCt,
      source->stAdd.tSz + source->stCopy.tSz);
    fprintf(logFile, "Delete:   %ld (%ld bytes)\n",
      source->stDelete.tCt + dest->stDelete.tCt,
      source->stDelete.tSz + dest->stDelete.tSz);
    fputc('\n', logFile);
  }
  if (!optionTest(OPT_QUIET))
    showExecuteBegin();
}

void logExecuteError(const char *file, const char *fn, const char *msg)
{
  if (file)
    sprintf(logBuf, "!%s\n!...%s::%s\n", file, fn, msg);
  else
    sprintf(logBuf, "!%s::%s\n", fn, msg);

  if (logFile)
  {
    fputs(logBuf, logFile);
    fflush(logFile);
  } 
  if (!optionTest(OPT_QUIET))
    showExecuteError(file, fn, msg, logBuf);
}

void logExecuteAction(const char *src, const char *dst, ACTION act, BOOL exec)
{
  if (act == ACTION_DELETE)
    sprintf(logBuf, "%-6.6s %s\n", actionString(act), src);
  else
    sprintf(logBuf, "%-6.6s %s\n      -->%s\n", actionString(act), src, dst);

  if (logFile && !optionTest(OPT_LOG_ERRORS) && exec)
  {
    fputs(logBuf, logFile);
    fflush(logFile);
  }
  if (!optionTest(OPT_QUIET))
    showExecuteAction(src, dst, act, exec, logBuf);
}
