#include "syncdir.h"
#include <assert.h>

void fileInfoUpdateStats(FILEINFO *inf)
{
  FILETABLE   *tbl = inf->owner;
  ACTIONSTATS *sts;
  switch (inf->action)
  {
    case ACTION_ADD:     sts = &tbl->stAdd;    break;
    case ACTION_COPY:    sts = &tbl->stCopy;   break;
    case ACTION_DELETE:  sts = &tbl->stDelete; break;
    default:
      sts = 0;
  }
  if (sts)
  {
    sts->tCt++;
    sts->tSz += inf->size;
  }
}
