#include "ntui.h"
#include <process.h>
#include <assert.h>
#include <time.h>

static HWND scanDlgWnd   = 0;
static HWND pathWnd      = 0;
static HWND filesWnd     = 0;
static HWND acceptedWnd  = 0;

static BOOL cancel       = FALSE;
static HANDLE fnComplete = 0;

#define WM_USER_CLOSE WM_USER + 100

static BOOL CALLBACK scanDlgProc(HWND hWnd, UINT uMsg, WPARAM wp, LPARAM lp)
{
  BOOL ret = FALSE;
  switch (uMsg)
  {
    case WM_COMMAND:
      if ((HIWORD(wp) == BN_CLICKED) && (LOWORD(wp) == IDCANCEL))
      {
        cancel = TRUE;
        EnableWindow(GetDlgItem(hWnd, IDCANCEL), FALSE);
        ret = TRUE;
      }
      break;
    case WM_INITDIALOG:
      statDlgPlaceSubDlg(hWnd);
      pathWnd     = GetDlgItem(hWnd, IDC_PATH);
      filesWnd    = GetDlgItem(hWnd, IDC_FILES);
      acceptedWnd = GetDlgItem(hWnd, IDC_ACCEPTED);
      SetWindowText(pathWnd, (const char *) lp);
      {
        BOOL OK = SetEvent(fnComplete);
        assert(OK);
      }
      break;
    case WM_USER_CLOSE:
      DestroyWindow(hWnd);
      ret = TRUE;
      break;
    case WM_DESTROY:
      PostQuitMessage(0);
      ret = TRUE;
      break;
  }
  return ret;
}

static time_t lastUpdate;
BOOL scanDlgUpdate(UINT32 files, UINT32 accepted)
{
  time_t now = time(0);
  if (difftime(now, lastUpdate))
  {
    char buf[32];
    lastUpdate = now;
    ultoa(files, buf, 10);
    SetWindowText(filesWnd, buf);
    ultoa(accepted, buf, 10);
    SetWindowText(acceptedWnd, buf);
  }
  if (cancel && (MessageBox(scanDlgWnd, "Cancel?", "Cancel?", MB_YESNO | MB_ICONSTOP | MB_APPLMODAL) == IDNO))
  {
    EnableWindow(GetDlgItem(scanDlgWnd, IDCANCEL), TRUE);
    cancel = FALSE;
  }
  return (cancel == FALSE);
}

static UINT scanDlgThread(void *p)
{
  MSG msg;
  scanDlgWnd  = CreateDialogParam(0, MAKEINTRESOURCE(IDD_SCAN), 0, scanDlgProc, (LPARAM) p);
  while (GetMessage(&msg, 0, 0, 0))
  {
    TranslateMessage(&msg);
    DispatchMessage(&msg);
  }
  SetEvent(fnComplete);
  return 0;
}

void scanDlgCreate(const char *path)
{
  SECURITY_ATTRIBUTES sa;
  sa.nLength = sizeof(sa);
  sa.lpSecurityDescriptor = 0;
  sa.bInheritHandle = TRUE;

  assert(!fnComplete);
  scanDlgWnd = 0;
  lastUpdate = 0;
  fnComplete = CreateEvent(&sa, FALSE, FALSE, 0);
  assert(fnComplete != 0);
  _beginthread(scanDlgThread, 0, (void *) path);
  WaitForMultipleObjects(1, &fnComplete, FALSE, INFINITE);
}

void scanDlgDestroy()
{
  while (!scanDlgWnd)
    Sleep(0);
  PostMessage(scanDlgWnd, WM_USER_CLOSE, 0, 0);
  WaitForMultipleObjects(1, &fnComplete, FALSE, INFINITE);
  CloseHandle(fnComplete);
  fnComplete = 0;
}
