/* CHESS PROGRAM: DEMO.CHS
/*          DATE: 9/25/94
/*        AUTHOR: C. Schanck
/*
/*       DESCRIPTION: This program file will run a new Bingo user
/* through a small demo of Bingo's capabilities.  It is structured
/* like this:
/* 
/*    intro page                     
/*    demo of syntax highlighting   
/*    demo of Bingo's virtual memory
/*    demo of editing/undo                  
/*    few words about Bingo         
/*                         
/* In the future, I would like to add some examples of searching,
/* definable menus, and more.
{     
   int l;
                                        
   /* intro, with syntax highlighting turned off
   Conf_syntax("n");
   Edit_file("demo.c\\r");
   bring_up(1);
   if(leave_key())
      return(0);
   
   /* demo of syntax highlighting
   bring_up(26);
   Conf_syntax("y");
   update_display();
   if(leave_key())
      return(0);
   Conf_syntax("n");
   update_display();

   /* demo of Bingo's virtual memory
   if(get_yesno("Demonstrate Bingo's Virtual memory?",1)==1)
   {  
      Window_split();
      bring_up(50);
      Window_previous();
      Edit_file(".\docs\bingo.doc\\r");
      Bot_of_file();
      l=ask("file_line");
      Window_next();
      if(leave_key())
         return(0);
      Window_previous();
      File_info();
              
      /* make the file bigger */
      Top_of_file();
      Line_mark();
      Jump("2000\\r");
      msg("Copying 2000 lines...");
      Copy();                  
      while(l<20000)
      {                  
         l=l+2000;
         msg("Increasing to %d lines...",l);
         Paste();
      }
      
      Window_next();
      bring_up(78);
      if(leave_key())
         return(0);

      Window_previous();
      File_info();

      bring_up(1);
      while(Down_page());
      
      Window_next();
      bring_up(93);
      if(leave_key())
         return(0);

      Window_previous();
      Window_one();
      msg("Please wait while I delete this file...");
      Copy();
      Abort();
   }           
   
   /* demo of undo
   bring_up(105);
   Conf_syntax("y");
   update_display();
   if(leave_key())
      return(0);
      
   l=1;
   msg("Press a key to do modification %d...",l);
   getkey();

   Jump("117,13\\r");
   str("  ");
   clr_cmd();
   Jump("+1\\r");
   Line_mark();
   l=l+1;
   update_display();
   msg("Press a key to do modification %d...",l);
   getkey();

   Cut();
   l=l+1;
   update_display();
   msg("Press a key to do modification %d...",l);
   getkey();

   Cut();
   Jump("119,45\\r");
   l=l+1;
   update_display();
   msg("Press a key to do modification %d...",l);
   getkey();

   Del_eol();
   update_display();
   if(leave_key())
      return(0);

   set_msg_wait(0);
   do
   {   
      msg("Press a key to undo modification %d...",l);
      l=l-1;
      getkey();
   }
   while(Undo()); 
   set_msg_wait(1);
   if(leave_key())
      return(0);
   
   Conf_syntax("n");
   update_display();
   bring_up(133);
   msg("Press any key to end this demo...");
   getkey();
   Abort_all();
}                                    
bring_up
int i
{  
   char buf[10];    
   set_display(0);
   i=i+ask("file_w_height")/2;
   Top_of_file();
   sformat(buf,"%d\\r",i);
   Jump(buf);
   Top_of_screen();
   Begin_line();
   set_display(1);
   update_display();
}
leave_key
{
   msg("Press any key to continue...");
   if((getkey()%256)==27)
   {
      Abort();
      return(1);
   }
   return(0);
}
      
