/* TIMESTMP
 *
 * (c) 2001 by Daniel Hertrich. http://www.daniel-hertrich.de
 *
 * TIMESTMP creates a PIM/PE compatible time stamp using the current date
 * and time with two line feeds before and behind the stamp.
 *
 * Call with parameter /t to add the time, without parameter, only date
 * is used.
 * 
 *
 */
 
#define VERSION "1.0"

#include <stdlib.h>
#include <time.h>

void usage (void);
void make_line (void);


char line[35];
time_t jetzt;
struct tm *ptr;
char datzeit[12]; datzeit1[12];
char addtime = 0;

int main(int argc, char *argv[])
{
  if (argc > 2) usage(); 
  if ((strstr(argv[1],"/t")) || (strstr(argv[1],"/T")) || (strstr(argv[1],"-t")) || (strstr(argv[1],"-T")))
    addtime = 1;
  make_line();
  return(0);
}



void usage (void)
{
  printf("\a\n\nCall SHOWDATE this way:\n\n\
SHOWDATE     for a time stamp with current date only\n\
SHOWDATE /t  for a time stamp with current date and time\n\n");
  exit(1);
}


void make_line(void) 
{
  time(&jetzt);
  ptr = localtime(&jetzt);
  printf("\n\n+. ");

  strftime(datzeit, 80, "%d-%m-20%y",ptr);  /* date string */
  strftime(datzeit1, 80, "%H:%M",ptr);      /* time string */

  printf("%s",datzeit);
  if (addtime)
    printf(" %s",datzeit1);
  printf("\n\n");
}

