/* Copyright (c) 2016-2017, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/types.h>
#include "msm_sdw.h"

const u8 msm_sdw_page_map[MSM_SDW_MAX_REGISTER] = {
	[MSM_SDW_TX9_SPKR_PROT_PATH_CTL] = 0xa,
	[MSM_SDW_TX9_SPKR_PROT_PATH_CFG0] = 0xa,
	[MSM_SDW_TX10_SPKR_PROT_PATH_CTL] = 0xa,
	[MSM_SDW_TX10_SPKR_PROT_PATH_CFG0] = 0xa,
	[MSM_SDW_TX11_SPKR_PROT_PATH_CTL] = 0xa,
	[MSM_SDW_TX11_SPKR_PROT_PATH_CFG0] = 0xa,
	[MSM_SDW_TX12_SPKR_PROT_PATH_CTL] = 0xa,
	[MSM_SDW_TX12_SPKR_PROT_PATH_CFG0] = 0xa,
	[MSM_SDW_COMPANDER7_CTL0] = 0xb,
	[MSM_SDW_COMPANDER7_CTL1] = 0xb,
	[MSM_SDW_COMPANDER7_CTL2] = 0xb,
	[MSM_SDW_COMPANDER7_CTL3] = 0xb,
	[MSM_SDW_COMPANDER7_CTL4] = 0xb,
	[MSM_SDW_COMPANDER7_CTL5] = 0xb,
	[MSM_SDW_COMPANDER7_CTL6] = 0xb,
	[MSM_SDW_COMPANDER7_CTL7] = 0xb,
	[MSM_SDW_COMPANDER8_CTL0] = 0xb,
	[MSM_SDW_COMPANDER8_CTL1] = 0xb,
	[MSM_SDW_COMPANDER8_CTL2] = 0xb,
	[MSM_SDW_COMPANDER8_CTL3] = 0xb,
	[MSM_SDW_COMPANDER8_CTL4] = 0xb,
	[MSM_SDW_COMPANDER8_CTL5] = 0xb,
	[MSM_SDW_COMPANDER8_CTL6] = 0xb,
	[MSM_SDW_COMPANDER8_CTL7] = 0xb,
	[MSM_SDW_RX7_RX_PATH_CTL] = 0xb,
	[MSM_SDW_RX7_RX_PATH_CFG0] = 0xb,
	[MSM_SDW_RX7_RX_PATH_CFG1] = 0xb,
	[MSM_SDW_RX7_RX_PATH_CFG2] = 0xb,
	[MSM_SDW_RX7_RX_VOL_CTL] = 0xb,
	[MSM_SDW_RX7_RX_PATH_MIX_CTL] = 0xb,
	[MSM_SDW_RX7_RX_PATH_MIX_CFG] = 0xb,
	[MSM_SDW_RX7_RX_VOL_MIX_CTL] = 0xb,
	[MSM_SDW_RX7_RX_PATH_SEC0] = 0xb,
	[MSM_SDW_RX7_RX_PATH_SEC1] = 0xb,
	[MSM_SDW_RX7_RX_PATH_SEC2] = 0xb,
	[MSM_SDW_RX7_RX_PATH_SEC3] = 0xb,
	[MSM_SDW_RX7_RX_PATH_SEC5] = 0xb,
	[MSM_SDW_RX7_RX_PATH_SEC6] = 0xb,
	[MSM_SDW_RX7_RX_PATH_SEC7] = 0xb,
	[MSM_SDW_RX7_RX_PATH_MIX_SEC0] = 0xb,
	[MSM_SDW_RX7_RX_PATH_MIX_SEC1] = 0xb,
	[MSM_SDW_RX8_RX_PATH_CTL] = 0xb,
	[MSM_SDW_RX8_RX_PATH_CFG0] = 0xb,
	[MSM_SDW_RX8_RX_PATH_CFG1] = 0xb,
	[MSM_SDW_RX8_RX_PATH_CFG2] = 0xb,
	[MSM_SDW_RX8_RX_VOL_CTL] = 0xb,
	[MSM_SDW_RX8_RX_PATH_MIX_CTL] = 0xb,
	[MSM_SDW_RX8_RX_PATH_MIX_CFG] = 0xb,
	[MSM_SDW_RX8_RX_VOL_MIX_CTL] = 0xb,
	[MSM_SDW_RX8_RX_PATH_SEC0] = 0xb,
	[MSM_SDW_RX8_RX_PATH_SEC1] = 0xb,
	[MSM_SDW_RX8_RX_PATH_SEC2] = 0xb,
	[MSM_SDW_RX8_RX_PATH_SEC3] = 0xb,
	[MSM_SDW_RX8_RX_PATH_SEC5] = 0xb,
	[MSM_SDW_RX8_RX_PATH_SEC6] = 0xb,
	[MSM_SDW_RX8_RX_PATH_SEC7] = 0xb,
	[MSM_SDW_RX8_RX_PATH_MIX_SEC0] = 0xb,
	[MSM_SDW_RX8_RX_PATH_MIX_SEC1] = 0xb,
	[MSM_SDW_BOOST0_BOOST_PATH_CTL] = 0xc,
	[MSM_SDW_BOOST0_BOOST_CTL] = 0xc,
	[MSM_SDW_BOOST0_BOOST_CFG1] = 0xc,
	[MSM_SDW_BOOST0_BOOST_CFG2] = 0xc,
	[MSM_SDW_BOOST1_BOOST_PATH_CTL] = 0xc,
	[MSM_SDW_BOOST1_BOOST_CTL] = 0xc,
	[MSM_SDW_BOOST1_BOOST_CFG1] = 0xc,
	[MSM_SDW_BOOST1_BOOST_CFG2] = 0xc,
	[MSM_SDW_AHB_BRIDGE_WR_DATA_0] = 0xc,
	[MSM_SDW_AHB_BRIDGE_WR_DATA_1] = 0xc,
	[MSM_SDW_AHB_BRIDGE_WR_DATA_2] = 0xc,
	[MSM_SDW_AHB_BRIDGE_WR_DATA_3] = 0xc,
	[MSM_SDW_AHB_BRIDGE_WR_ADDR_0] = 0xc,
	[MSM_SDW_AHB_BRIDGE_WR_ADDR_1] = 0xc,
	[MSM_SDW_AHB_BRIDGE_WR_ADDR_2] = 0xc,
	[MSM_SDW_AHB_BRIDGE_WR_ADDR_3] = 0xc,
	[MSM_SDW_AHB_BRIDGE_RD_ADDR_0] = 0xc,
	[MSM_SDW_AHB_BRIDGE_RD_ADDR_1] = 0xc,
	[MSM_SDW_AHB_BRIDGE_RD_ADDR_2] = 0xc,
	[MSM_SDW_AHB_BRIDGE_RD_ADDR_3] = 0xc,
	[MSM_SDW_AHB_BRIDGE_RD_DATA_0] = 0xc,
	[MSM_SDW_AHB_BRIDGE_RD_DATA_1] = 0xc,
	[MSM_SDW_AHB_BRIDGE_RD_DATA_2] = 0xc,
	[MSM_SDW_AHB_BRIDGE_RD_DATA_3] = 0xc,
	[MSM_SDW_AHB_BRIDGE_ACCESS_CFG] = 0xc,
	[MSM_SDW_AHB_BRIDGE_ACCESS_STATUS] = 0xc,
	[MSM_SDW_CLK_RST_CTRL_MCLK_CONTROL] = 0xd,
	[MSM_SDW_CLK_RST_CTRL_FS_CNT_CONTROL] = 0xd,
	[MSM_SDW_CLK_RST_CTRL_SWR_CONTROL] = 0xd,
	[MSM_SDW_TOP_TOP_CFG0] = 0xd,
	[MSM_SDW_TOP_TOP_CFG1] = 0xd,
	[MSM_SDW_TOP_RX_I2S_CTL] = 0xd,
	[MSM_SDW_TOP_TX_I2S_CTL] = 0xd,
	[MSM_SDW_TOP_I2S_CLK] = 0xd,
	[MSM_SDW_TOP_RX7_PATH_INPUT0_MUX] = 0xd,
	[MSM_SDW_TOP_RX7_PATH_INPUT1_MUX] = 0xd,
	[MSM_SDW_TOP_RX8_PATH_INPUT0_MUX] = 0xd,
	[MSM_SDW_TOP_RX8_PATH_INPUT1_MUX] = 0xd,
	[MSM_SDW_TOP_FREQ_MCLK] = 0xd,
	[MSM_SDW_TOP_DEBUG_BUS_SEL] = 0xd,
	[MSM_SDW_TOP_DEBUG_EN] = 0xd,
	[MSM_SDW_TOP_I2S_RESET] = 0xd,
	[MSM_SDW_TOP_BLOCKS_RESET] = 0xd,
};

const u8 msm_sdw_reg_readable[MSM_SDW_MAX_REGISTER] = {
	[MSM_SDW_PAGE_REGISTER] = 1,
	[MSM_SDW_TX9_SPKR_PROT_PATH_CTL] = 1,
	[MSM_SDW_TX9_SPKR_PROT_PATH_CFG0] = 1,
	[MSM_SDW_TX10_SPKR_PROT_PATH_CTL] = 1,
	[MSM_SDW_TX10_SPKR_PROT_PATH_CFG0] = 1,
	[MSM_SDW_TX11_SPKR_PROT_PATH_CTL] = 1,
	[MSM_SDW_TX11_SPKR_PROT_PATH_CFG0] = 1,
	[MSM_SDW_TX12_SPKR_PROT_PATH_CTL] = 1,
	[MSM_SDW_TX12_SPKR_PROT_PATH_CFG0] = 1,
	[MSM_SDW_COMPANDER7_CTL0] = 1,
	[MSM_SDW_COMPANDER7_CTL1] = 1,
	[MSM_SDW_COMPANDER7_CTL2] = 1,
	[MSM_SDW_COMPANDER7_CTL3] = 1,
	[MSM_SDW_COMPANDER7_CTL4] = 1,
	[MSM_SDW_COMPANDER7_CTL5] = 1,
	[MSM_SDW_COMPANDER7_CTL6] = 1,
	[MSM_SDW_COMPANDER7_CTL7] = 1,
	[MSM_SDW_COMPANDER8_CTL0] = 1,
	[MSM_SDW_COMPANDER8_CTL1] = 1,
	[MSM_SDW_COMPANDER8_CTL2] = 1,
	[MSM_SDW_COMPANDER8_CTL3] = 1,
	[MSM_SDW_COMPANDER8_CTL4] = 1,
	[MSM_SDW_COMPANDER8_CTL5] = 1,
	[MSM_SDW_COMPANDER8_CTL6] = 1,
	[MSM_SDW_COMPANDER8_CTL7] = 1,
	[MSM_SDW_RX7_RX_PATH_CTL] = 1,
	[MSM_SDW_RX7_RX_PATH_CFG0] = 1,
	[MSM_SDW_RX7_RX_PATH_CFG1] = 1,
	[MSM_SDW_RX7_RX_PATH_CFG2] = 1,
	[MSM_SDW_RX7_RX_VOL_CTL] = 1,
	[MSM_SDW_RX7_RX_PATH_MIX_CTL] = 1,
	[MSM_SDW_RX7_RX_PATH_MIX_CFG] = 1,
	[MSM_SDW_RX7_RX_VOL_MIX_CTL] = 1,
	[MSM_SDW_RX7_RX_PATH_SEC0] = 1,
	[MSM_SDW_RX7_RX_PATH_SEC1] = 1,
	[MSM_SDW_RX7_RX_PATH_SEC2] = 1,
	[MSM_SDW_RX7_RX_PATH_SEC3] = 1,
	[MSM_SDW_RX7_RX_PATH_SEC5] = 1,
	[MSM_SDW_RX7_RX_PATH_SEC6] = 1,
	[MSM_SDW_RX7_RX_PATH_SEC7] = 1,
	[MSM_SDW_RX7_RX_PATH_MIX_SEC0] = 1,
	[MSM_SDW_RX7_RX_PATH_MIX_SEC1] = 1,
	[MSM_SDW_RX8_RX_PATH_CTL] = 1,
	[MSM_SDW_RX8_RX_PATH_CFG0] = 1,
	[MSM_SDW_RX8_RX_PATH_CFG1] = 1,
	[MSM_SDW_RX8_RX_PATH_CFG2] = 1,
	[MSM_SDW_RX8_RX_VOL_CTL] = 1,
	[MSM_SDW_RX8_RX_PATH_MIX_CTL] = 1,
	[MSM_SDW_RX8_RX_PATH_MIX_CFG] = 1,
	[MSM_SDW_RX8_RX_VOL_MIX_CTL] = 1,
	[MSM_SDW_RX8_RX_PATH_SEC0] = 1,
	[MSM_SDW_RX8_RX_PATH_SEC1] = 1,
	[MSM_SDW_RX8_RX_PATH_SEC2] = 1,
	[MSM_SDW_RX8_RX_PATH_SEC3] = 1,
	[MSM_SDW_RX8_RX_PATH_SEC5] = 1,
	[MSM_SDW_RX8_RX_PATH_SEC6] = 1,
	[MSM_SDW_RX8_RX_PATH_SEC7] = 1,
	[MSM_SDW_RX8_RX_PATH_MIX_SEC0] = 1,
	[MSM_SDW_RX8_RX_PATH_MIX_SEC1] = 1,
	[MSM_SDW_BOOST0_BOOST_PATH_CTL] = 1,
	[MSM_SDW_BOOST0_BOOST_CTL] = 1,
	[MSM_SDW_BOOST0_BOOST_CFG1] = 1,
	[MSM_SDW_BOOST0_BOOST_CFG2] = 1,
	[MSM_SDW_BOOST1_BOOST_PATH_CTL] = 1,
	[MSM_SDW_BOOST1_BOOST_CTL] = 1,
	[MSM_SDW_BOOST1_BOOST_CFG1] = 1,
	[MSM_SDW_BOOST1_BOOST_CFG2] = 1,
	[MSM_SDW_AHB_BRIDGE_WR_DATA_0] = 1,
	[MSM_SDW_AHB_BRIDGE_WR_DATA_1] = 1,
	[MSM_SDW_AHB_BRIDGE_WR_DATA_2] = 1,
	[MSM_SDW_AHB_BRIDGE_WR_DATA_3] = 1,
	[MSM_SDW_AHB_BRIDGE_WR_ADDR_0] = 1,
	[MSM_SDW_AHB_BRIDGE_WR_ADDR_1] = 1,
	[MSM_SDW_AHB_BRIDGE_WR_ADDR_2] = 1,
	[MSM_SDW_AHB_BRIDGE_WR_ADDR_3] = 1,
	[MSM_SDW_AHB_BRIDGE_RD_ADDR_0] = 1,
	[MSM_SDW_AHB_BRIDGE_RD_ADDR_1] = 1,
	[MSM_SDW_AHB_BRIDGE_RD_ADDR_2] = 1,
	[MSM_SDW_AHB_BRIDGE_RD_ADDR_3] = 1,
	[MSM_SDW_AHB_BRIDGE_RD_DATA_0] = 1,
	[MSM_SDW_AHB_BRIDGE_RD_DATA_1] = 1,
	[MSM_SDW_AHB_BRIDGE_RD_DATA_2] = 1,
	[MSM_SDW_AHB_BRIDGE_RD_DATA_3] = 1,
	[MSM_SDW_AHB_BRIDGE_ACCESS_CFG] = 1,
	[MSM_SDW_AHB_BRIDGE_ACCESS_STATUS] = 1,
	[MSM_SDW_CLK_RST_CTRL_MCLK_CONTROL] = 1,
	[MSM_SDW_CLK_RST_CTRL_FS_CNT_CONTROL] = 1,
	[MSM_SDW_CLK_RST_CTRL_SWR_CONTROL] = 1,
	[MSM_SDW_TOP_TOP_CFG0] = 1,
	[MSM_SDW_TOP_TOP_CFG1] = 1,
	[MSM_SDW_TOP_RX_I2S_CTL] = 1,
	[MSM_SDW_TOP_TX_I2S_CTL] = 1,
	[MSM_SDW_TOP_RX7_PATH_INPUT0_MUX] = 1,
	[MSM_SDW_TOP_RX7_PATH_INPUT1_MUX] = 1,
	[MSM_SDW_TOP_RX8_PATH_INPUT0_MUX] = 1,
	[MSM_SDW_TOP_RX8_PATH_INPUT1_MUX] = 1,
	[MSM_SDW_TOP_FREQ_MCLK] = 1,
	[MSM_SDW_TOP_DEBUG_BUS_SEL] = 1,
	[MSM_SDW_TOP_DEBUG_EN] = 1,
	[MSM_SDW_TOP_I2S_RESET] = 1,
	[MSM_SDW_TOP_BLOCKS_RESET] = 1,
};

const u8 msm_sdw_reg_writeable[MSM_SDW_MAX_REGISTER] = {
	[MSM_SDW_PAGE_REGISTER] = 1,
	[MSM_SDW_TX9_SPKR_PROT_PATH_CTL] = 1,
	[MSM_SDW_TX9_SPKR_PROT_PATH_CFG0] = 1,
	[MSM_SDW_TX10_SPKR_PROT_PATH_CTL] = 1,
	[MSM_SDW_TX10_SPKR_PROT_PATH_CFG0] = 1,
	[MSM_SDW_TX11_SPKR_PROT_PATH_CTL] = 1,
	[MSM_SDW_TX11_SPKR_PROT_PATH_CFG0] = 1,
	[MSM_SDW_TX12_SPKR_PROT_PATH_CTL] = 1,
	[MSM_SDW_TX12_SPKR_PROT_PATH_CFG0] = 1,
	[MSM_SDW_COMPANDER7_CTL0] = 1,
	[MSM_SDW_COMPANDER7_CTL1] = 1,
	[MSM_SDW_COMPANDER7_CTL2] = 1,
	[MSM_SDW_COMPANDER7_CTL3] = 1,
	[MSM_SDW_COMPANDER7_CTL4] = 1,
	[MSM_SDW_COMPANDER7_CTL5] = 1,
	[MSM_SDW_COMPANDER7_CTL7] = 1,
	[MSM_SDW_COMPANDER8_CTL0] = 1,
	[MSM_SDW_COMPANDER8_CTL1] = 1,
	[MSM_SDW_COMPANDER8_CTL2] = 1,
	[MSM_SDW_COMPANDER8_CTL3] = 1,
	[MSM_SDW_COMPANDER8_CTL4] = 1,
	[MSM_SDW_COMPANDER8_CTL5] = 1,
	[MSM_SDW_COMPANDER8_CTL7] = 1,
	[MSM_SDW_RX7_RX_PATH_CTL] = 1,
	[MSM_SDW_RX7_RX_PATH_CFG0] = 1,
	[MSM_SDW_RX7_RX_PATH_CFG1] = 1,
	[MSM_SDW_RX7_RX_PATH_CFG2] = 1,
	[MSM_SDW_RX7_RX_VOL_CTL] = 1,
	[MSM_SDW_RX7_RX_PATH_MIX_CTL] = 1,
	[MSM_SDW_RX7_RX_PATH_MIX_CFG] = 1,
	[MSM_SDW_RX7_RX_VOL_MIX_CTL] = 1,
	[MSM_SDW_RX7_RX_PATH_SEC0] = 1,
	[MSM_SDW_RX7_RX_PATH_SEC1] = 1,
	[MSM_SDW_RX7_RX_PATH_SEC2] = 1,
	[MSM_SDW_RX7_RX_PATH_SEC3] = 1,
	[MSM_SDW_RX7_RX_PATH_SEC5] = 1,
	[MSM_SDW_RX7_RX_PATH_SEC6] = 1,
	[MSM_SDW_RX7_RX_PATH_SEC7] = 1,
	[MSM_SDW_RX7_RX_PATH_MIX_SEC0] = 1,
	[MSM_SDW_RX7_RX_PATH_MIX_SEC1] = 1,
	[MSM_SDW_RX8_RX_PATH_CTL] = 1,
	[MSM_SDW_RX8_RX_PATH_CFG0] = 1,
	[MSM_SDW_RX8_RX_PATH_CFG1] = 1,
	[MSM_SDW_RX8_RX_PATH_CFG2] = 1,
	[MSM_SDW_RX8_RX_VOL_CTL] = 1,
	[MSM_SDW_RX8_RX_PATH_MIX_CTL] = 1,
	[MSM_SDW_RX8_RX_PATH_MIX_CFG] = 1,
	[MSM_SDW_RX8_RX_VOL_MIX_CTL] = 1,
	[MSM_SDW_RX8_RX_PATH_SEC0] = 1,
	[MSM_SDW_RX8_RX_PATH_SEC1] = 1,
	[MSM_SDW_RX8_RX_PATH_SEC2] = 1,
	[MSM_SDW_RX8_RX_PATH_SEC3] = 1,
	[MSM_SDW_RX8_RX_PATH_SEC5] = 1,
	[MSM_SDW_RX8_RX_PATH_SEC6] = 1,
	[MSM_SDW_RX8_RX_PATH_SEC7] = 1,
	[MSM_SDW_RX8_RX_PATH_MIX_SEC0] = 1,
	[MSM_SDW_RX8_RX_PATH_MIX_SEC1] = 1,
	[MSM_SDW_BOOST0_BOOST_PATH_CTL] = 1,
	[MSM_SDW_BOOST0_BOOST_CTL] = 1,
	[MSM_SDW_BOOST0_BOOST_CFG1] = 1,
	[MSM_SDW_BOOST0_BOOST_CFG2] = 1,
	[MSM_SDW_BOOST1_BOOST_PATH_CTL] = 1,
	[MSM_SDW_BOOST1_BOOST_CTL] = 1,
	[MSM_SDW_BOOST1_BOOST_CFG1] = 1,
	[MSM_SDW_BOOST1_BOOST_CFG2] = 1,
	[MSM_SDW_AHB_BRIDGE_WR_DATA_0] = 1,
	[MSM_SDW_AHB_BRIDGE_WR_DATA_1] = 1,
	[MSM_SDW_AHB_BRIDGE_WR_DATA_2] = 1,
	[MSM_SDW_AHB_BRIDGE_WR_DATA_3] = 1,
	[MSM_SDW_AHB_BRIDGE_WR_ADDR_0] = 1,
	[MSM_SDW_AHB_BRIDGE_WR_ADDR_1] = 1,
	[MSM_SDW_AHB_BRIDGE_WR_ADDR_2] = 1,
	[MSM_SDW_AHB_BRIDGE_WR_ADDR_3] = 1,
	[MSM_SDW_AHB_BRIDGE_RD_ADDR_0] = 1,
	[MSM_SDW_AHB_BRIDGE_RD_ADDR_1] = 1,
	[MSM_SDW_AHB_BRIDGE_RD_ADDR_2] = 1,
	[MSM_SDW_AHB_BRIDGE_RD_ADDR_3] = 1,
	[MSM_SDW_AHB_BRIDGE_ACCESS_CFG] = 1,
	[MSM_SDW_CLK_RST_CTRL_MCLK_CONTROL] = 1,
	[MSM_SDW_CLK_RST_CTRL_FS_CNT_CONTROL] = 1,
	[MSM_SDW_CLK_RST_CTRL_SWR_CONTROL] = 1,
	[MSM_SDW_TOP_TOP_CFG0] = 1,
	[MSM_SDW_TOP_TOP_CFG1] = 1,
	[MSM_SDW_TOP_RX_I2S_CTL] = 1,
	[MSM_SDW_TOP_TX_I2S_CTL] = 1,
	[MSM_SDW_TOP_RX7_PATH_INPUT0_MUX] = 1,
	[MSM_SDW_TOP_RX7_PATH_INPUT1_MUX] = 1,
	[MSM_SDW_TOP_RX8_PATH_INPUT0_MUX] = 1,
	[MSM_SDW_TOP_RX8_PATH_INPUT1_MUX] = 1,
	[MSM_SDW_TOP_FREQ_MCLK] = 1,
	[MSM_SDW_TOP_DEBUG_BUS_SEL] = 1,
	[MSM_SDW_TOP_DEBUG_EN] = 1,
	[MSM_SDW_TOP_I2S_RESET] = 1,
	[MSM_SDW_TOP_BLOCKS_RESET] = 1,
};
