/*
 * Decompiled with CFR 0.152.
 */
package netP5;

import java.net.DatagramPacket;
import java.net.InetAddress;
import netP5.TcpClient;
import netP5.TcpPacket;

public class NetMessage {
    private InetAddress _myInetAddress;
    private int _myPort;
    private String _myString = "";
    private byte[] _myData = new byte[0];
    private TcpClient _myTcpClient;
    private boolean isDatagramPacket = false;

    protected NetMessage(DatagramPacket datagramPacket) {
        this._myInetAddress = datagramPacket.getAddress();
        this._myPort = datagramPacket.getPort();
        this._myData = datagramPacket.getData();
        this.isDatagramPacket = true;
    }

    protected NetMessage(TcpPacket tcpPacket) {
        this._myInetAddress = tcpPacket.getTcpConnection().socket().getInetAddress();
        this._myPort = tcpPacket.getTcpConnection().socket().getPort();
        this._myString = tcpPacket.getTcpConnection().getString();
        this._myData = tcpPacket.getData();
        this._myTcpClient = tcpPacket.getTcpConnection();
    }

    public byte[] getData() {
        return this._myData;
    }

    public String getString() {
        if (this.isDatagramPacket) {
            return new String(this._myData);
        }
        return this._myString;
    }

    public int port() {
        return this._myPort;
    }

    public TcpClient tcpConnection() {
        return this._myTcpClient;
    }

    public String address() {
        return this._myInetAddress.getHostAddress();
    }

    public InetAddress inetAddress() {
        return this._myInetAddress;
    }
}

