/*
 * Decompiled with CFR 0.152.
 */
package netP5;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.MulticastSocket;
import java.net.SocketException;
import netP5.Logger;
import netP5.NetAddress;
import netP5.UdpPacketListener;

public abstract class AbstractMulticast
implements Runnable {
    protected NetAddress _myNetAddress;
    protected boolean isRunning;
    protected boolean isSocket;
    protected MulticastSocket _myMulticastSocket;
    protected UdpPacketListener _myListener;
    protected int _myDatagramSize = 1536;
    private Thread _myThread;

    public AbstractMulticast(UdpPacketListener udpPacketListener, String string, int n, int n2) {
        this._myDatagramSize = n2;
        this._myListener = udpPacketListener;
        if (this._myListener != null) {
            this.init(string, n);
        }
    }

    public AbstractMulticast(UdpPacketListener udpPacketListener, String string, int n) {
        this._myListener = udpPacketListener;
        if (this._myListener != null) {
            this.init(string, n);
        }
    }

    protected void init(String string, int n) {
        this._myNetAddress = new NetAddress(string, n);
        if (!this._myNetAddress.isvalid()) {
            Logger.printError("UdpClient", "unknown host " + string);
        }
        this.isRunning = this.openSocket();
        this.start();
    }

    public MulticastSocket socket() {
        return this._myMulticastSocket;
    }

    public void setDatagramSize(int n) {
        this._myDatagramSize = n;
    }

    public void start() {
        this._myThread = null;
        this._myMulticastSocket = null;
        this._myThread = new Thread(this);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            Logger.printError("Multicast.start()", "Multicast sleep interuption " + interruptedException);
        }
        try {
            this._myMulticastSocket = new MulticastSocket(this._myNetAddress.port());
            this._myMulticastSocket.joinGroup(this._myNetAddress.inetaddress());
            Logger.printProcess("Multicast.start()", "new Multicast DatagramSocket created @ port " + this._myNetAddress.port());
        }
        catch (IOException iOException) {
            Logger.printError("Multicast.start()", " IOException, couldnt create new DatagramSocket @ port " + this._myNetAddress.port() + " " + iOException);
        }
        if (this._myMulticastSocket != null) {
            this._myThread.start();
            this.isRunning = this._myThread.isAlive();
            this.isSocket = true;
        } else {
            this.isRunning = false;
        }
    }

    public void run() {
        if (this._myMulticastSocket != null) {
            if (this.isRunning) {
                Logger.printProcess("Multicast.run()", "Multicast is running @ " + this._myNetAddress.inetaddress().getHostAddress() + ":" + this._myNetAddress.port());
            }
        } else {
            Logger.printError("UdpServer.run()", "Socket is null. closing UdpServer.");
            return;
        }
        while (this.isRunning) {
            try {
                byte[] byArray = new byte[this._myDatagramSize];
                DatagramPacket datagramPacket = new DatagramPacket(byArray, this._myDatagramSize);
                this._myMulticastSocket.receive(datagramPacket);
                System.out.println("got it.");
                this._myListener.process(datagramPacket, this._myNetAddress.port());
            }
            catch (IOException iOException) {
                Logger.printError("UdpServer.run()", "IOException:  " + iOException);
                break;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                Logger.printError("UdpServer.run()", "ArrayIndexOutOfBoundsException:  " + arrayIndexOutOfBoundsException);
            }
        }
        this.dispose();
    }

    public void dispose() {
        this.close();
    }

    public void close() {
        this.isRunning = false;
        if (this._myMulticastSocket != null) {
            try {
                this._myMulticastSocket.leaveGroup(this._myNetAddress.inetaddress());
                this._myMulticastSocket.disconnect();
                this._myMulticastSocket.close();
                this._myMulticastSocket = null;
                Logger.printProcess("Multicast.close", "Closing multicast datagram socket.");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean openSocket() {
        try {
            this._myMulticastSocket = new MulticastSocket();
        }
        catch (SocketException socketException) {
            Logger.printError("Multicast.openSocket", "cant create socket " + socketException.getMessage());
            return false;
        }
        catch (IOException iOException) {
            Logger.printError("Multicast.openSocket", "cant create multicastSocket " + iOException.getMessage());
            return false;
        }
        Logger.printProcess("Multicast.openSocket", "multicast socket initialized.");
        return true;
    }

    public boolean setTimeToLive(int n) {
        try {
            this._myMulticastSocket.setTimeToLive(n);
            return true;
        }
        catch (IOException iOException) {
            Logger.printError("UdpServer.setTimeToLive()", "" + iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logger.printError("UdpServer.setTimeToLive()", "" + illegalArgumentException);
        }
        return false;
    }

    public int timeToLive() {
        try {
            return this._myMulticastSocket.getTimeToLive();
        }
        catch (IOException iOException) {
            Logger.printError("Multicast.getTimeToLive()", "" + iOException);
            return -1;
        }
    }

    public void setLoopback(boolean bl) {
        try {
            this._myMulticastSocket.setLoopbackMode(bl);
        }
        catch (SocketException socketException) {
            Logger.printError("Multicast.setLoopback()", "" + socketException);
        }
    }

    public boolean loopback() {
        try {
            return this._myMulticastSocket.getLoopbackMode();
        }
        catch (SocketException socketException) {
            Logger.printError("Multicast.loopback()", "" + socketException);
            return false;
        }
    }

    protected void send(DatagramPacket datagramPacket) {
        if (this.isRunning) {
            try {
                this._myMulticastSocket.send(datagramPacket);
            }
            catch (IOException iOException) {
                Logger.printError("Multicast.send", "ioexception while sending packet.");
            }
        }
    }

    public void send(String string) {
        this.send(string.getBytes());
    }

    public void send(byte[] byArray) {
        if (this.isRunning) {
            try {
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, this._myNetAddress.inetaddress(), this._myNetAddress.port());
                this.send(datagramPacket);
            }
            catch (NullPointerException nullPointerException) {
                Logger.printError("Multicast.send", "a nullpointer exception occured." + nullPointerException);
            }
        } else {
            Logger.printWarning("Multicast.send", "DatagramSocket is not running. Packet has not been sent.");
        }
    }
}

