/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.CVector3f;
import controlP5.ControlP5;
import controlP5.ControlP5XMLElement;
import controlP5.Controller;
import controlP5.ControllerGroup;
import controlP5.Label;
import java.util.Hashtable;
import java.util.Vector;
import processing.core.PApplet;

public class Radio
extends Controller {
    Vector _myRadioButtons;
    private int myLineSpacing = 14;
    int labelOffsetX = 14;
    int labelOffsetY = 2;
    CVector3f _myMousePosition = new CVector3f();
    RadioButton _myCurrentRadioButton;
    int _myRadioButtonWidth = 10;
    int _myRadioButtonHeight = 10;
    boolean isSetupLocked = false;
    int _myHeight;
    int _myWidth;

    public Radio(ControlP5 controlP5, ControllerGroup controllerGroup, String string, float f, float f2) {
        super(controlP5, controllerGroup, string, f, f2, 30, 30);
        this._myRadioButtons = new Vector();
    }

    public Radio(ControlP5 controlP5, ControllerGroup controllerGroup, String string, float f, float f2, int n, int n2, int n3) {
        super(controlP5, controllerGroup, string, f, f2, 30, 30);
        this._myRadioButtons = new Vector();
        this.myLineSpacing = n3;
        this._myRadioButtonWidth = n;
        this._myRadioButtonHeight = n2;
        this.labelOffsetX = this._myRadioButtonWidth + 4;
    }

    public RadioButton add(String string, int n) {
        return this.addItem(string, n);
    }

    public RadioButton addItem(String string, int n) {
        RadioButton radioButton = new RadioButton(0, this._myRadioButtons.size() * this.myLineSpacing, string, n);
        this._myRadioButtons.add(radioButton);
        this.getDimensions();
        if (this._myRadioButtons.size() == 1) {
            this.activate(radioButton.name());
        }
        return radioButton;
    }

    public void removeItem(String string) {
        for (int i = this._myRadioButtons.size() - 1; i >= 0; --i) {
            if (!((RadioButton)this._myRadioButtons.get(i)).name().equals(string)) continue;
            this._myRadioButtons.remove(i);
            for (int j = i; j < this._myRadioButtons.size(); ++j) {
                ((RadioButton)this._myRadioButtons.get((int)j))._myY -= this.myLineSpacing;
            }
            return;
        }
    }

    private void getDimensions() {
        int n = 0;
        for (int i = 0; i < this._myRadioButtons.size(); ++i) {
            int n2 = ((RadioButton)this._myRadioButtons.get((int)i)).label.width() + this.labelOffsetX;
            n = n2 > n ? n2 : n;
        }
        this.width = n;
        this.height = this._myRadioButtons.size() * this.myLineSpacing;
    }

    public void draw(PApplet pApplet) {
        pApplet.pushMatrix();
        pApplet.translate(this.position.x(), this.position.y());
        for (int i = 0; i < this._myRadioButtons.size(); ++i) {
            ((RadioButton)this._myRadioButtons.get(i)).updateInternalEvents(pApplet);
            ((RadioButton)this._myRadioButtons.get(i)).draw(pApplet);
        }
        pApplet.popMatrix();
    }

    public void setValue(float f) {
        for (int i = 0; i < this._myRadioButtons.size(); ++i) {
            RadioButton radioButton = (RadioButton)this._myRadioButtons.get(i);
            if ((float)radioButton.value == f) {
                radioButton.activate();
                this.current(radioButton);
                continue;
            }
            radioButton.deactivate();
        }
        this._myValue = f;
        this.broadcast(1);
    }

    public void update() {
        this.setValue(this._myValue);
    }

    public void current(RadioButton radioButton) {
        this._myCurrentRadioButton = radioButton;
    }

    public RadioButton current() {
        return this._myCurrentRadioButton;
    }

    public void activate(String string) {
        for (int i = 0; i < this._myRadioButtons.size(); ++i) {
            RadioButton radioButton = (RadioButton)this._myRadioButtons.get(i);
            if (!string.equals(radioButton.name())) continue;
            this.setValue(radioButton.value);
            return;
        }
    }

    public void addToXMLElement(ControlP5XMLElement controlP5XMLElement) {
        controlP5XMLElement.setAttribute("type", "radio");
        for (int i = 0; i < this._myRadioButtons.size(); ++i) {
            controlP5XMLElement.addChild(((RadioButton)this._myRadioButtons.get(i)).getAsXML());
        }
    }

    class RadioButton {
        int _myX;
        int _myY;
        Label label;
        int value;
        int _myId = -1;
        boolean isActive;

        RadioButton(int n, int n2, String string, int n3) {
            this._myX = n;
            this._myY = n2;
            this.label = new Label(string);
            this.value = n3;
        }

        public String name() {
            return this.label.toString();
        }

        public int id() {
            return this._myId;
        }

        public void setId(int n) {
            this._myId = n;
        }

        protected void deactivate() {
            this.isActive = false;
        }

        protected void activate() {
            this.isActive = true;
        }

        public void updateInternalEvents(PApplet pApplet) {
            if (Radio.this.isInside && this.insideRadioButton() && Radio.this.isMousePressed && Radio.this.current() != this) {
                Radio.this.setValue(this.value);
            }
        }

        public void draw(PApplet pApplet) {
            pApplet.noStroke();
            if (this.isActive) {
                pApplet.fill(Radio.this.color.colorActive);
            } else {
                pApplet.fill(Radio.this.color.colorForeground);
            }
            if (Radio.this.isInside && this.insideRadioButton()) {
                pApplet.fill(Radio.this.color.colorActive);
            }
            pApplet.pushMatrix();
            pApplet.translate((float)this._myX, (float)this._myY);
            pApplet.rect(0.0f, 0.0f, (float)Radio.this._myRadioButtonWidth, (float)Radio.this._myRadioButtonHeight);
            this.label.draw(pApplet, Radio.this.labelOffsetX, Radio.this.labelOffsetY);
            pApplet.popMatrix();
        }

        private boolean insideRadioButton() {
            return (float)Radio.this._myControlWindow.mouseX > Radio.this.position.x() + Radio.this._myParent.absolutePosition().x() + (float)this._myX && (float)Radio.this._myControlWindow.mouseX < Radio.this.position.x() + Radio.this._myParent.absolutePosition().x() + (float)this._myX + (float)Radio.this._myRadioButtonWidth && (float)Radio.this._myControlWindow.mouseY > Radio.this.position.y() + Radio.this._myParent.absolutePosition().y() + (float)this._myY && (float)Radio.this._myControlWindow.mouseY < Radio.this.position.y() + Radio.this._myParent.absolutePosition().y() + (float)this._myY + (float)Radio.this._myRadioButtonHeight;
        }

        protected ControlP5XMLElement getAsXML() {
            ControlP5XMLElement controlP5XMLElement = new ControlP5XMLElement(new Hashtable(), true, false);
            controlP5XMLElement.setName("radiobutton");
            controlP5XMLElement.setAttribute("type", "radiobutton");
            controlP5XMLElement.setAttribute("name", this.label.toString());
            controlP5XMLElement.setAttribute("label", this.label.toString());
            controlP5XMLElement.setAttribute("id", new Integer(this.id()));
            controlP5XMLElement.setAttribute("value", new Float(this.value));
            controlP5XMLElement.setAttribute("state", new Integer(this.isActive ? 1 : 0));
            return controlP5XMLElement;
        }
    }
}

