/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.ControlWindow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import processing.core.PApplet;

public class PAppletWindow
extends PApplet
implements WindowListener,
ComponentListener {
    int width = 600;
    int height = 200;
    int x = 100;
    int y = 100;
    private String _myName;
    protected boolean isLoop = true;
    protected ControlWindow controlWindow;
    protected ControlP5 controlP5;
    public static final int NORMAL = 0;
    public static final int ECONOMIC = 1;
    protected int _myMode = 1;
    protected String _myRenderer = "";
    protected int _myFrameRate = 15;

    public PAppletWindow() {
    }

    public PAppletWindow(String string, int n, int n2) {
        this(string, n, n2, "", 15);
    }

    public PAppletWindow(String string, int n, int n2, String string2, int n3) {
        this._myName = string;
        this.width = n;
        this.height = n2;
        this._myFrameRate = n3;
        this._myRenderer = string2;
        this.launch();
    }

    public PAppletWindow(String string, int n, int n2, int n3, int n4) {
        this(string, n, n2, n3, n4, "", 15);
    }

    public PAppletWindow(String string, int n, int n2, int n3, int n4, String string2, int n5) {
        this._myName = string;
        this.width = n3;
        this.height = n4;
        this.x = n;
        this.y = n2;
        this._myFrameRate = n5;
        this._myRenderer = string2;
        this.launch();
    }

    public void pause() {
        this.controlWindow.isPostDraw = false;
    }

    public void play() {
        this.controlWindow.isPostDraw = true;
    }

    public String name() {
        return this._myName;
    }

    protected void visible(boolean bl) {
        if (bl) {
            this.frame.show();
        } else {
            this.frame.hide();
        }
    }

    protected void resizeable(boolean bl) {
        this.frame.setResizable(bl);
    }

    public void setup() {
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this._myRenderer.length() == 0) {
            this.size(this.width, this.height);
        } else {
            this.size(this.width, this.height, this._myRenderer);
        }
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string = "frameRate";
        Method[] methodArray = this.getClass().getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().toLowerCase().equals("framerate")) continue;
            string = methodArray[i].getName();
            break;
        }
        try {
            Method method = this.getClass().getMethod(string, Float.TYPE);
            method.invoke((Object)this, new Float(this._myFrameRate));
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    protected void setControlWindow(ControlWindow controlWindow) {
        this.controlWindow = controlWindow;
    }

    public void draw() {
    }

    public void windowActivated(WindowEvent windowEvent) {
        this.isLoop = true;
        this.loop();
    }

    public void keyPressed(KeyEvent keyEvent) {
        ControlP5.papplet.keyPressed(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        ControlP5.papplet.keyReleased(keyEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
        ControlP5.papplet.keyTyped(keyEvent);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.controlWindow.remove();
        this.controlWindow._myApplet.stop();
        this.dispose();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
        if (this._myMode == 1) {
            this.isLoop = false;
            this.noLoop();
        }
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
        Component component = componentEvent.getComponent();
        this.x = component.getLocation().x;
        this.y = component.getLocation().y;
        this.frame.setTitle(this._myName + " x:" + this.x + " y:" + this.y + "   " + this.width + "x" + this.height);
    }

    public void componentResized(ComponentEvent componentEvent) {
        Component component = componentEvent.getComponent();
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void setMode(int n) {
        if (n == 1) {
            this._myMode = 1;
            return;
        }
        this._myMode = 0;
    }

    protected void dispose() {
        this.controlWindow._myApplet.stop();
        this.stop();
        this.removeAll();
        this.frame.removeAll();
        this.frame.dispose();
    }

    private void launch() {
        Object object;
        GraphicsDevice graphicsDevice = null;
        if (graphicsDevice == null) {
            object = GraphicsEnvironment.getLocalGraphicsEnvironment();
            graphicsDevice = ((GraphicsEnvironment)object).getDefaultScreenDevice();
        }
        this.frame = new Frame(graphicsDevice.getDefaultConfiguration());
        this.frame.setResizable(false);
        this.init();
        this.frame.pack();
        object = this.frame.getInsets();
        int n = Math.max(this.width, 128) + ((Insets)object).left + ((Insets)object).right;
        int n2 = Math.max(this.height, 128) + ((Insets)object).top + ((Insets)object).bottom;
        this.frame.setSize(n, n2);
        this.frame.setLayout(null);
        this.frame.add((Component)((Object)this));
        this.frame.setBackground(Color.black);
        int n3 = n2 - ((Insets)object).top - ((Insets)object).bottom;
        this.setBounds((n - this.width) / 2, ((Insets)object).top + (n3 - this.height) / 2, this.width, this.height);
        this.frame.addWindowListener(this);
        this.frame.addComponentListener(this);
        this.frame.setName(this._myName);
        this.frame.setTitle(this._myName + " x:" + this.x + " y:" + this.y + "   w:" + this.width + " h:" + this.height);
        this.frame.setVisible(true);
        this.requestFocus();
    }
}

