/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.ControlP5XMLElement;
import controlP5.Controller;
import controlP5.ControllerGroup;
import processing.core.PApplet;

public class Knob
extends Controller {
    int cnt;
    float _myDiameter;
    float _myRadius;
    float _myAngle = (float)Math.PI;

    public Knob(ControlP5 controlP5, ControllerGroup controllerGroup, String string, float f, float f2, float f3, int n, int n2, int n3) {
        super(controlP5, controllerGroup, string, n, n2, n3, n3);
        this._myValue = f3;
        this.setMin(f);
        this.setMax(f2);
        this._myDiameter = n3;
        this._myRadius = this._myDiameter / 2.0f;
        this._myUnit = (this._myMax - this._myMin) / ((float)Math.PI * 2);
    }

    public void updateInternalEvents(PApplet pApplet) {
        if (this.isMousePressed) {
            if (!ControlP5.keyHandler.isAltDown) {
                this._myAngle = (float)Math.atan2((float)this._myControlWindow.mouseY - this._myRadius - this._myParent.absolutePosition().y() - this.position.y(), (float)this._myControlWindow.mouseX - this._myRadius - this._myParent.absolutePosition().x() - this.position.x());
                this.setValue((this._myAngle + (float)Math.PI) * this._myUnit);
            }
        }
    }

    public void draw(PApplet pApplet) {
        pApplet.pushMatrix();
        pApplet.translate(this.position().x() + this._myRadius, this.position().y() + this._myRadius);
        pApplet.fill(this.color.colorBackground);
        pApplet.ellipse(-this._myRadius, -this._myRadius, (float)this.width, (float)this.height);
        float f = pApplet.g.strokeWeight;
        pApplet.strokeWeight(1.0f);
        pApplet.pushMatrix();
        pApplet.stroke(this.color.colorForeground);
        pApplet.line(-this._myRadius / 2.0f, 0.0f, -this._myRadius, 0.0f);
        pApplet.rotate(this._myAngle);
        pApplet.stroke(this.color.colorActive);
        pApplet.line(0.0f, 0.0f, this._myRadius, 0.0f);
        pApplet.popMatrix();
        pApplet.noStroke();
        pApplet.pushMatrix();
        pApplet.translate(-this._myRadius, -this._myRadius);
        this._myLabel.draw(pApplet, 4, this.height + 4);
        pApplet.popMatrix();
        pApplet.popMatrix();
        pApplet.strokeWeight(f);
    }

    protected void onEnter() {
        this.isActive = true;
    }

    protected void onLeave() {
        this.isActive = false;
    }

    public void mousePressed() {
    }

    public void mouseReleased() {
        this.isActive = true;
        this.broadcast(1);
    }

    public void setMin(float f) {
        this._myMin = f;
    }

    public void setMax(float f) {
        this._myMax = f;
    }

    public void setValue(float f) {
        this._myAngle = f / this._myUnit - (float)Math.PI;
        this._myValue = f;
        this.broadcast(1);
    }

    public void update() {
        this.setValue(this._myValue);
    }

    public void addToXMLElement(ControlP5XMLElement controlP5XMLElement) {
        controlP5XMLElement.setAttribute("type", "knob");
        controlP5XMLElement.setAttribute("min", new Float(this.min()));
        controlP5XMLElement.setAttribute("max", new Float(this.max()));
    }
}

