--[[
Gameboy note visualizer for VBA-rr. This script draws a piano showing the currently played notes.
Only works for GB/GBC ROMs, not GBA. Provided "as is". Made by nitro2k01.
--]]

-- ch = 1,2,3
function getChannelFreq(ch, p_1, p_2, p_3)
  channelfreqregs = {0xFF13, 0xFF18, 0xFF1D}
  local temp,tempint;

  temp = memory.readbyte(channelfreqregs[ch])     +
  bit.lshift(AND(memory.readbyte(channelfreqregs[ch]+1), 0x7), 8);
  
  -- Calculate frequency in Hz
  temp = 131072/(2048-temp)

  -- Calculate note number  
  temp = math.log(temp*4/261.626)/math.log(1.059463);

  -- Round to nearest semitone
  tempint = math.floor(temp+0.5)

  return tempint, temp-tempint, tempint%12, math.floor(tempint/12), p_1, p_2, p_3;
end


-- draw a piano at some position
function drawPiano(note, noteerr, noteinoctave, octave, intop)
  local left, top, objheight, objwidth, idx, objpos;

  left = 32;
  top = intop;
  objheight = 20;
  objwidth = 8;

  -- Table of white and black keys
  blackwhite = {1,nil,1,nil,1,1,nil,1,nil,1,nil,1}

  -- Format: RRGGBBAA. I'm using the string format instead of the int format to prevent a bug in Lua where the highest bit of an int32 is ignored.

  ---             Off fill     Off border   On fill      Off fill
  whitecolors = {"#ffffffff", "#0000c0ff", "#cc77aa40", "#ffffff70"}
  blackcolors = {"#000000ee", "#000000ee", "#00000070", "#00000040"}

  gui.text(left-8, top, octave, "#ff0000A0", "#ddccbbA0");

  -- Draw white keys
  idx = 1;
  objpos = 0;
  repeat
    if blackwhite[idx] then
      if idx == noteinoctave+1 then
        gui.rect(left+objwidth*objpos, top, left+objwidth*(objpos+1), top+objheight, whitecolors[1], whitecolors[2])
      else
        gui.rect(left+objwidth*objpos, top, left+objwidth*(objpos+1), top+objheight, whitecolors[3], whitecolors[4])
      end
        
      objpos = objpos + 1;
    end
    
    idx = idx + 1;
  until idx > 12

  -- Draw black keys. This is done in a separate loop so that black keys are drawn on top of the white keys. (Looks better.)
  idx = 1;
  objpos = 1;

  repeat
    if not blackwhite[idx] then
      if idx == noteinoctave+1 then
        gui.rect(left+objwidth*(objpos-0.25), top, left+objwidth*(objpos+0.25), top+objheight/2, blackcolors[1], blackcolors[2])
      else
        gui.rect(left+objwidth*(objpos-0.25), top, left+objwidth*(objpos+0.25), top+objheight/2, blackcolors[3], blackcolors[4])
      end
        
      objpos = objpos + 1;
      if objpos == 3 then objpos = objpos + 1; end;
    end
    
    idx = idx + 1;
  until idx > 12

end

hextable={"0","1","2","3","4","5","6","7","8","9","A","B","C","D","E","F"}

-- VBlank catch function
function tehline()

  local rectsize = 2;
  local xoffset = 24;
  local idx = 0
  local tempbyte=0;
  local tempnibble=0;
  local cc_hexstring="";

  
  repeat
    
    tempbyte = memory.readbyte(0xFF30+idx);
  
    tempnibble = bit.rshift(bit.band(tempbyte, 0xF0),4);
    cc_hexstring = cc_hexstring .. hextable[tempnibble+1];
    tempidx=idx*2
    gui.rect(xoffset+rectsize*tempidx, 15*rectsize-rectsize*tempnibble, xoffset+rectsize*tempidx+rectsize, 15*rectsize-rectsize*tempnibble+rectsize, "#E3204080")

    tempnibble = bit.band(tempbyte, 0xF);
    cc_hexstring = cc_hexstring .. hextable[tempnibble+1];
    tempidx=idx*2+1
    gui.rect(xoffset+rectsize*tempidx, 15*rectsize-rectsize*tempnibble, xoffset+rectsize*tempidx+rectsize, 15*rectsize-rectsize*tempnibble+rectsize, "#E3204080")

  
    idx = idx + 1;
  until idx>15

  drawPiano(getChannelFreq(1, 72));
  drawPiano(getChannelFreq(2, 96));
  drawPiano(getChannelFreq(3, 120));

end

vba.registerafter(tehline)
