/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.AssignPrivateIpAddressesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssignPrivateIpAddressesRequestMarshaller
implements Marshaller<Request<AssignPrivateIpAddressesRequest>, AssignPrivateIpAddressesRequest> {
    @Override
    public Request<AssignPrivateIpAddressesRequest> marshall(AssignPrivateIpAddressesRequest assignPrivateIpAddressesRequest) {
        if (assignPrivateIpAddressesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AssignPrivateIpAddressesRequest> request = new DefaultRequest<AssignPrivateIpAddressesRequest>(assignPrivateIpAddressesRequest, "AmazonEC2");
        request.addParameter("Action", "AssignPrivateIpAddresses");
        request.addParameter("Version", "2014-02-01");
        if (assignPrivateIpAddressesRequest.getNetworkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId", StringUtils.fromString(assignPrivateIpAddressesRequest.getNetworkInterfaceId()));
        }
        List<String> privateIpAddressesList = assignPrivateIpAddressesRequest.getPrivateIpAddresses();
        int privateIpAddressesListIndex = 1;
        for (String privateIpAddressesListValue : privateIpAddressesList) {
            if (privateIpAddressesListValue != null) {
                request.addParameter("PrivateIpAddress." + privateIpAddressesListIndex, StringUtils.fromString(privateIpAddressesListValue));
            }
            ++privateIpAddressesListIndex;
        }
        if (assignPrivateIpAddressesRequest.getSecondaryPrivateIpAddressCount() != null) {
            request.addParameter("SecondaryPrivateIpAddressCount", StringUtils.fromInteger(assignPrivateIpAddressesRequest.getSecondaryPrivateIpAddressCount()));
        }
        if (assignPrivateIpAddressesRequest.isAllowReassignment() != null) {
            request.addParameter("AllowReassignment", StringUtils.fromBoolean(assignPrivateIpAddressesRequest.isAllowReassignment()));
        }
        return request;
    }
}

