/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.cloudsearchv2.model.DescribeExpressionsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeExpressionsRequestMarshaller
implements Marshaller<Request<DescribeExpressionsRequest>, DescribeExpressionsRequest> {
    @Override
    public Request<DescribeExpressionsRequest> marshall(DescribeExpressionsRequest describeExpressionsRequest) {
        if (describeExpressionsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeExpressionsRequest> request = new DefaultRequest<DescribeExpressionsRequest>(describeExpressionsRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "DescribeExpressions");
        request.addParameter("Version", "2013-01-01");
        if (describeExpressionsRequest.getDomainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString(describeExpressionsRequest.getDomainName()));
        }
        List<String> expressionNamesList = describeExpressionsRequest.getExpressionNames();
        int expressionNamesListIndex = 1;
        for (String expressionNamesListValue : expressionNamesList) {
            if (expressionNamesListValue != null) {
                request.addParameter("ExpressionNames.member." + expressionNamesListIndex, StringUtils.fromString(expressionNamesListValue));
            }
            ++expressionNamesListIndex;
        }
        if (describeExpressionsRequest.isDeployed() != null) {
            request.addParameter("Deployed", StringUtils.fromBoolean(describeExpressionsRequest.isDeployed()));
        }
        return request;
    }
}

