<<
  " << PICT LCD-> {#0 #0}"      % enter the first part of the menu
				% program onto the stack as a string
  GROB 21 7 FFFFF1FFFFF1FFFFF1FFFFF1FFFFF1FFFFF1FFFFF1
  -> block                      % store a 27 by 7 black block
    <<
      ERASE                     % clear screen
      0 32 FOR J                % vertical loop (step 8)
	0 110 FOR I             % horizontal loop (step 22)
	  PICT
	  I R->B J R->B 2 ->LIST        % turn I, J into co-ordinates
	  block
	  REPL                  % draw block at I, J
	  PICT                  % put PICT on stack for latter use
	  J 8 / 1 + ->STR       % turn J (position in pixels) into a 
				% keyboard position
	  "," +
	  I 22 / 1 + ->STR +    % same for I
	  " Label?" +           % construct prompt string
	  { \alpha }
	  INPUT                 % input label
	  1 ->GROB              % turn label into small lettering GROB
	  DUP SIZE              % extract the size of the label
	  #2 /                  % divide height by 2
	  J 4 + R->B            % find the middle of the box vertically
	  SWAP -                % take difference to center string in box
	  SWAP                  % swap to get the horizontal size
	  #2 /                  % divide width by 2
	  I
	  IF 'I!=0 OR J!=32' ->NUM      % special case: enter key
	  THEN
	    11                  % normal key is 21 pixels wide, half
				% this is 11.
	  ELSE
	    22 'I' STO+         % enter key. Increment I.
	    PICT
	    I R->B J R_B 2 ->LIST
	    block               % draw next box over
	    REPL
	    {#21 #32} {#21 #38} LINE    % fill in the pixels between
				% the boxes to make one big box.
	    22                  % half of the big box is size 22
	  END
	  SWAP -                % take the difference to center horizontally
	  SWAP                  % swap to get the order of co-ords right
	  2 ->LIST              % turn them into a coordinate list.
				% Now we have the coords to draw the
				% label centered in the box.
	  SWAP                  % swap co-ords with the label GROB
	  GXOR                  % draw the label (using PICT from
				% the stack at level 3.)
	22 STEP                 % step in the horizontal direction
      8 STEP                    % step in the vertical direction
    >>
  PICT                          % extract the menu display from the
  {#0 #0} {#130 #39}            % graphics screen
  SUB                           
  ->STR +                       % turn it into a string and concatenate
				% to the program segment above.
  " REPL {#0 #0} SWAP REPL	% the next program segment
    {#0 #0} PVIEW 0 WAIT
    IF DUP 60 > THEN DROP ELSE "
  +                             % concatenate with the rest of the program
  { }                           % Start the outer-most (menu) level of
				% the commands list
  1 5 FOR row
    { }                         % start a row-level commands list
    1 6 FOR col
      IF 'row==5 AND col==2' ->NUM
      THEN                      % special case for "enter" again
	3 'col' STO
      END
      "(C) M Woodhams.		% a random item to be put on the stack
       May be copied            % and dropped immediately inside the 
       May not be sold."	% loop.
      DO
	DROP                    % drop top of stack (junk or previous
				% incorrect keystroke)
	"UNIT (Y/N)?" 3 DISP    
	0 WAIT                  % get keystroke
      UNTIL
	DUP DUP 32.1 ==
	SWAP 52.1 == OR         % keep looping until "Y" or "N"
      END                       % leave loop with either 32.1 ("N")
				% or 52.1 ("Y") on stack.
      row ->STR                 % start building prompt string
      "," +
      col ->STR +
      SWAP                      % swap Y or N to top of stack
      IF
	32.1 ==                 % if "N" then constant
      THEN
	" Const" +              % finish prompt string
	{ V } INPUT
	->OBJ 1 ->LIST          % turn the result into a one item list
      ELSE                      % a unit has been requested
	" Unit" +               % finish prompt string
	{ \alpha } INPUT
	-> unit                 % store in unit temporarily.
	  <<                    % build a list of three programs to
				% perform the unshifted and shifted
				% functions of a unit menu key.
	    " << 1_" unit + " * >>" +
	    OBJ->               % make unit multiply program
	    " << 1_" unit + " CONVERT >>" +
	    OBJ->               % make unit convert program
	    " << 1_" unit + " / >>" +
	    OBJ->               % make unit divide program
	    3 ->LIST            % turn them into a list.
	  >>
      END
      1 ->LIST +                % add the newly formed list (which
				% contains the commands for one key)
				% to the list of commands for keys
				% for the whole row. (This is a list
				% of lists.)
    NEXT                        % next row
    1 ->LIST +                  % add the newly formed row list
				% (with the commands for all the keys
				% in one row) to the master list. (This
				% is a list of lists of lists.)
  NEXT  
  -> STR +                      % turn into a string, and concatenate
				% with the program so far.
  " OVER 10 / IP GET		% the final menu program segment.
    OVER 10 / FP 10 * IP GET
    SWAP FP 10 * GET
    EVAL END
    >> "
  +                             % concatenate with program so far
  ->OBJ                         % convert from a string to a program
>>                              % exit with the menu program on the stack.
 
 
Sample menu program:
 
<<
  PICT                          % PICT on stack for latter use
  LCD->                         % make copy of stack display
  {#0 #0}
				% this is the display made by the
				% compile program. I have not typed it
				% out in full.
  GROB 131 40 FFFFFDFFFF7FFFFFDFFFF7FFFFFDFFFF70
	      FF3FFDFF8F7FF5FFDA3737FF1FFDF7BF70
	      FFDFFDF7FF7FF5FFDABAA6FFDFFDF7DF70
	      FFDFFDF79F7FF1FFD83327FF1FFDF7EF70
	      etc.
  REPL                          % put menu display over stack display
  {#0 #0}
  SWAP
  REPL                          % put stack + menu in PICT
  {#0 #0} PVIEW                 % display PICT
  0 WAIT                        % wait for keystroke
  IF                            % if in row 6 or greater, quit
    DUP 60 >
  THEN
    DROP
  ELSE                          % otherwise, put hierarchical list
				% onto the stack.
    {                           % start of main list
      {                         % start of first row sub-list
	{'299792458_m/s'}       % first row, first key command sub-sub-list
	{'6.672E-11_N*m^2/kg^2'}% etc. First row is all constants.
	{'6.62618E-34_J*s'}
	{'1.054589E-34_J*s'}
	{'1.602189E-19_C'}
	{'1.38066E-23_J/K'}
      }                         % end of first row sub-list
      {                         % start of second row sub-list
	{'.000000056703_W/(m^2*K^4)'}
	{'1.672649E-27_kg'}     % all constants again
	{'9.010953E-31_kg'}
	{'1.989E30_kg'}
	{'695990000_m'}
	{'3.826E26_W'}
      }                         % end of second row sub-list
      {                         % start of third row sub-list
	{ << '1_s' * >> << '1_s' CONVERT >> << '1_s' / >> }
				% a sub-sub-list of three programs for
				% the first key of the third row. These
				% execute the normal unit commands.
	{ << '1_m' * >> << '1_m' CONVERT >> << '1_m' / >> }
				% all the third and remaining rows are
				% unit keys.
	{ << '1_kg' * >> << '1_kg' CONVERT >> << '1_kg' / >> }
	{ << '1_m/s' * >> << '1_m/s' CONVERT >> << '1_m/s' / >> }
	{ << '1_J' * >> << '1_J' CONVERT >> << '1_J' / >> }
	{ << '1_K' * >> << '1_K' CONVERT >> << '1_K' / >> }
      }                         % end of third row sub-list
      {                         % start of fourth row sub-list
	{ << '1_yr' * >> << '1_yr' CONVERT >> << '1_yr' / >> }
	{ << '1_cm' * >> << '1_cm' CONVERT >> << '1_cm' / >> }
	{ << '1_g' * >> << '1_g' CONVERT >> << '1_g' / >> }
	{ << '1_cm/s' * >> << '1_cm/s' CONVERT >> << '1_cm/s' / >> }
	{ << '1_erg' * >> << '1_erg' CONVERT >> << '1_erg' / >> }
	{ << '1_W' * >> << '1_W' CONVERT >> << '1_W' / >> }
      }                         % end of fourth row sub-list
      {                         % start of fifth row sub-list
				% contains only 5 items, as fifth row
				% has only 5 keys.
	{ << '1_pc' * >> << '1_pc' CONVERT >> << '1_pc' / >> }
	{ << '1_\angstm' * >> << '1_\angstm' CONVERT >> << '1_\angstm' / >> }
	{ << '1_c' * >> << '1_c' CONVERT >> << '1_c' / >> }
	{ << '1_eV' * >> << '1_eV' CONVERT >> << '1_eV' / >> }
	{ << '1_b' * >> << '1_b' CONVERT >> << '1_b' / >> }
      }                         % end of fifth row sub-list
    }                           % end of main list
    OVER 10 / IP GET            % get key co-ords, extract tens digit,
				% and use this to get the correct row
				% sub-list
    OVER 10 / FP 10 * IP GET    % get the key co-ord, extract ones digit,
				% and use this to get the correct key
				% sub-sub-list form the row sub-list.
    SWAP FP 10 * GET            % get the tenths digit, and use it
				% to extract the correct item from the
				% key sub-sub-list
    EVAL                        % execute/evaluate this item.
  END
>>
 
 
