/* This program converts HP48 GROBs (ported to a PC) to a series of PIXON */
/* statements that can be read into the DRAW48 program from Preston Brown */
/* You will need a copy of DRAW48 to see how the GROB2DRW program works.  */
/* DRAW48 is available in DL13 of the HP-Forum on CIS                     */

#include <stdio.h>
#include <string.h>
#include <dos.h>
FILE *gr_fl, *drw_fl;

main(int argc, char **argv)
{
     char table[17]="0123456789ABCDEF";
     char *pos, *strchr();
     int table_offs;
     int count=0;
     int white=1;
     int ch,w,h,i,mask;
     
     if(argc != 3)
     {
          printf("Usage: GR2DRAW GROBfilename DRAWfilename"); exit(1);
     }
     
     if((gr_fl=fopen(argv[1],"r"))==NULL)
     {
          printf("Can't open GROB file %s ", argv[1]); exit(1);
     }
     
     if((drw_fl=fopen(argv[2],"w"))==NULL)
     {
          printf("Trouble opening DRAW file %s", argv[2]);exit(1);
     }
     else                     /* put the first line in the Draw file. */
     {
          fputs("%%HP:T(3)A(D)F(.);\\<< ERASE { #0 #0 } PVIEW 7 FREEZE RAD ",
                drw_fl);
          fputs("\n",drw_fl);
     }     

     clrscr();      printf("Now processing: one moment...");
     
     w=0;           h=0;
     
     while ((ch=getc(gr_fl)) != EOF)    /* read in the GROB FILE one */
                                        /* character at a time       */
     {
          switch(ch)                    /* count the white spaces    */
                                        /* until you reach more than */ 
          {                             /* 5. This starts the GROB string.*/
               case ' ': case '\t': case '\n' : white++; break;
               default: if (white){ white=0; count++;}
          }

          if (count > 5)
          {
               pos=strchr(table,ch);    /* get pointer to position in*/
                                        /* the lookup table          */
               table_offs=pos-table;    /* calculate the offset into */
                                        /* the table. This converts  */
               mask=1;                  /* the ASCII char to a hex   */
               for(i=0;i<4;i++)         /* value.                    */
               {
                    if((mask & table_offs)!=0)/* if the pixel is on then */
                         fprintf(drw_fl,"{ #%d #%d } PIXON\n",w,h);
                                        /* put this in the DRAW file */
                    mask<<=1;           /* shift the mask left by 1  */
                    if(w++ > 134) {h++;w=0;} 
                                        /* incr w, check if > width  */
                                        /* if yes, incr h:reset w    */
               }                        /* Do this 4 times. Then get */
          }                             /* the next character from   */
     }                                  /* the GROB string.          */
     fputs("\\>>",drw_fl);
     fputs("\n",drw_fl);
     fclose(drw_fl);
     fclose(gr_fl);
     printf("\n\n Finished processing: start Draw48 and Get %s",argv[2]);    
}
 
