{$I COMPDIR.PAS}

USES UYmodem , UEZComm , Dos , UJump , Crt ;

PROCEDURE Usage ;
BEGIN
     WriteLn ( '------------  YMODEM (C)1995 Laurent Bernard ------------' );
     WriteLn ( '   Transferring files using Batch YMODEM protocol...' );
     WriteLn ( '   Refer to the file XYMODEM.ZIP by Chuck Forsberg for the protocol description.' );
     WriteLn ( 'Usage: Y action [ioparams]  [filespec]' );
     WriteLn ( '  where action is: ''h'' this help ,''r'' receive files and ''s'' send files' );
     WriteLn ( ' [ioparams] are optional and can be: ');
     WriteLn ( '  -snumber  speed(110,150,300,600,1200,2400,4800,9600 ;default 9600)');
     WriteLn ( '  -dnumber  data bits(7,8 ;default 8)');
     WriteLn ( '  -tnumber  stop bits(1,2 ;default 1)');
     WriteLn ( '  -pnumber  parity( 0:None,1:Odd,2:Even ;default None)');
     WriteLn ( '  -#number  port(0: COM Port 1 , 1: COM Port 2)');
     WriteLn ( '  -r        enable file overwriting when receiving');
     WriteLn ( '            (note: by default, Y will rename the file)');
     WriteLn ( '[filespec] are used when action is s : sending.' );
     WriteLn ( '  You can use normal msdos file specifications with ?,*.' );
     WriteLn ( 'Examples:' );
     WriteLn ( ' Receiving file with the default parameters: Y r' );
     WriteLn ( ' Receiving file at 1200 bauds              : Y r -s1200' );
     WriteLn ( ' Sending files using even parity: Y s -p2 f1.fil wildc*. \upload\*.* ' );
     WriteLn ( 'IMPORTANT NOTE: Press ESC to abort transfers !!' );
     WriteLn ( '       This program is placed in the public domain.' );
     WriteLn ( '       You can use it, modify it, but  DON''T SELL IT !!' );

     Halt(1);
END;


PROCEDURE Error ( s : STRING );
BEGIN WriteLn ;
      WriteLn(s);
      Halt(1);
END;

PROCEDURE ReadInt( s : STRING ; start : BYTE ; VAR Integ : LONGINT );
VAR TmpRes : LONGINT ;
    Index : BYTE ;
BEGIN TmpRes := 0 ;
      FOR Index := start TO Length(s) DO
       BEGIN TmpRes := TmpRes * 10 ;
             IF s[Index] IN ['0'..'9'] THEN
                Inc(TmpRes , Ord(s[Index]) - Ord('0') )
             ELSE BEGIN WriteLn ( 'Invalid parameter...'); Exit;
                  END;
       END;
      Integ := TmpRes ;
END;


CONST Buffer_Size = 32768 ;

CONST ComSpeed    : WORD = 9600 ;
      ComDataBits : BYTE = 8 ;
      ComStopBits : BYTE = 1 ;
      ComParity   : BYTE = No_Parity ;
      ComPortNb   : BYTE = 1 ;
      ComReplace  : BOOLEAN = FALSE ;


VAR   IndexParams : WORD ;

PROCEDURE ReadSettings;
VAR EndSettings : BOOLEAN ;
    TmpInt : LONGINT ;
    Tmp : STRING;

BEGIN
        EndSettings := FALSE ;
        IndexParams := 2 ;
        WHILE NOT(EndSettings) AND ( IndexParams<= ParamCount )
        DO BEGIN
             Tmp := ParamStr(IndexParams);
             IF Tmp[1] = '-' THEN
              BEGIN
                 IF Length(Tmp) < 2 THEN EndSettings  := TRUE
                 ELSE
                 CASE UpCase(Tmp[2]) OF
                   'S' : BEGIN
                           TmpInt := ComSpeed ;
                           ReadInt(tmp,3,TmpInt) ;
                           Inc(IndexParams);
                           CASE TmpInt OF
                            9600: ;
                            4800: ;
                            2400: ;
                            1200: ;
                             600: ;
                             300: ;
                             150: ;
                             110: ;
                             ELSE TmpInt := ComSpeed ;
                           END;
                           ComSpeed := TmpInt ;
                         END;
                   'D' : BEGIN
                           TmpInt := ComDataBits ;
                           ReadInt(tmp,3,TmpInt) ;
                           Inc(IndexParams);
                           CASE TmpInt OF
                             8: ;
                             7: ;
                             ELSE TmpInt := ComDataBits ;
                           END;
                           ComDataBits := TmpInt ;
                         END;
                   'T' : BEGIN
                           TmpInt := ComStopBits ;
                           ReadInt(tmp,3,TmpInt) ;
                           Inc(IndexParams);
                           CASE TmpInt OF
                             2: ;
                             1: ;
                             ELSE TmpInt := ComStopBits ;
                           END;
                           ComStopBits := TmpInt ;
                         END;
                   'P' : BEGIN
                           TmpInt := ComParity ;
                           ReadInt(tmp,3,TmpInt) ;
                           Inc(IndexParams);
                           CASE TmpInt OF
                             2: ;
                             1: ;
                             0: ;
                             ELSE TmpInt := ComParity ;
                           END;
                           ComParity := TmpInt ;
                         END;
                   '#' : BEGIN
                           TmpInt := ComPortNb ;
                           ReadInt(tmp,3,TmpInt) ;
                           Inc(IndexParams);
                           CASE TmpInt OF
                             2: ;
                             1: ;
                             ELSE TmpInt := ComPortNb ;
                           END;
                           ComPortNb := TmpInt ;
                         END;
                   'R' : BEGIN
                              ComReplace := TRUE ;
                              Inc(IndexParams);
                         END;
                   ELSE EndSettings := TRUE ;
                 END; { Case }
             END
            ELSE
             EndSettings := TRUE ;

           END; { while }
END;


PROCEDURE SendJoker ( s : STRING );
VAR PathStr : STRING ;

  PROCEDURE ExtractPath ;
  VAR Index : BYTE ;
  BEGIN Index := Length(s);
        WHILE ( s[Index] <> '\' ) AND ( Index > 0 ) DO Dec(Index);
        PathStr := Copy( s , 1 , Index );
  END;
VAR DirInfo: SearchRec;

BEGIN ExtractPath ;
      FindFirst( s, Archive, DirInfo);
      WHILE DosError = 0 DO
       BEGIN
         YM_SendFile ( ComPortNb , PathStr + DirInfo.Name , DirInfo.Name );
         FindNext(DirInfo);
       END;
END;


CONST StrParity : ARRAY[0..2] OF STRING = ( 'None' , 'Odd' , 'Even' ) ;

VAR DoReceive : BOOLEAN ;
    StartSend : BOOLEAN ;

    Tmp : STRING ;

    UserAbort : BOOLEAN ;

BEGIN
     DirectVideo := FALSE ;

     IF ParamCount = 0 THEN Usage ;

     Tmp := ParamStr(1);
     IF Length(Tmp) <> 1 THEN Usage;

     CASE UpCase(Tmp[1]) OF
       'S' : DoReceive := FALSE ;
       'R' : DoReceive := TRUE ;
       ELSE Usage;
     END;

     WriteLn ;
     WriteLn ('------------ YMODEM ------------------');
     WriteLn (' (C)1995 Laurent Bernard' );
     WriteLn ;
     WriteLn ;

     ReadSettings;

     WriteLn ('------------ Settings ----------------' );
     WriteLn('Speed:    ' , ComSpeed   :4 );
     WriteLn('Data bits:' , ComDataBits:4 );
     WriteLn('Stop bits:' , ComStopBits:4 );
     WriteLn('Parity:   ' , StrParity[ComParity] );
     WriteLn('Port:     ' , ComPortNb  :4 );
     WriteLn('Replace:  ' , ComReplace );

     WriteLn ('------------ Opening connection ------' );
     PortOpen( ComPortNb,
               Buffer_Size,
        Get_Comm_Params_Value(ComSpeed,ComDataBits,ComStopBits,ComParity));


     WriteLn ('-------- Initiating batch session ----' );

     UserAbort := FALSE ;
     SetJump( UserBreak );
     IF UserAbort THEN
      BEGIN PortClose ( ComPortNb );
            WriteLn ;
            WriteLn (' -------- User aborted transfer ...' );
            Halt(1);
      END;
     UserAbort := TRUE ;

     IF DoReceive THEN
      BEGIN
        WriteLn ('-------------- Receiving -------------');
        WHILE YM_ReceiveFile ( ComPortNb , ComReplace ) DO
          WriteLn ('-------------- Receiving -------------');
      END
     ELSE
      BEGIN
        WHILE IndexParams <= ParamCount DO
         BEGIN WriteLn ('-------------- Sending ---------------');
               SendJoker ( ParamStr(IndexParams) );
               Inc(IndexParams);
         END;
        YM_CloseBatchSession ( ComPortNb );
      END;

     WriteLn ('------------ Closing connection ------' );
     PortClose ( ComPortNb );
     WriteLn ('Good Bye !!' );
END.