{$I COMPDIR.PAS}

UNIT UEZComm ;
INTERFACE
USES Crt , UJump ;

CONST No_Parity   = 0 ;
      Odd_Parity  = 1 ;
      Even_Parity = 2 ;

VAR UserBreak : JumpRecord ;

FUNCTION  Get_Comm_Params_Value ( Speed:WORD; Data_Bits:BYTE;
                                  Stop_Bits :BYTE; Parity:BYTE ) : BYTE ;


PROCEDURE PortOpen ( NbPort : BYTE ; Buf_Size : WORD ; Params_Value : BYTE );
PROCEDURE PortClose ( NbPort : BYTE );
FUNCTION  PortTest ( NbPort : BYTE ): BOOLEAN ;
FUNCTION  PortRead ( NbPort : BYTE ) : BYTE ;
PROCEDURE PortWrite ( NbPort : BYTE ; Cha : BYTE );
FUNCTION  PortReadTicks ( NbPort:BYTE; NbTics:INTEGER; VAR c:BYTE ):BOOLEAN;

PROCEDURE PortClearLineTicks( NbPort:BYTE; NbTics:INTEGER);

IMPLEMENTATION
USES RS232 ;

FUNCTION Get_Comm_Params_Value ( Speed:WORD; Data_Bits:BYTE;
                                 Stop_Bits :BYTE; Parity:BYTE ) : BYTE ;
VAR R : BYTE ;
BEGIN
     R := 0 ;
     CASE Speed OF
      110  : R := R OR $00 ;
      150  : R := R OR $20 ;
      300  : R := R OR $40 ;
      600  : R := R OR $60 ;
      1200 : R := R OR $80 ;
      2400 : R := R OR $A0 ;
      4800 : R := R OR $C0 ;
      9600 : R := R OR $E0 ;
     END;
     CASE Data_Bits OF
      7 : R := R OR $02 ;
      8 : R := R OR $03 ;
     END;
     CASE Stop_Bits OF
      1 : R := R OR $00 ;
      2 : R := R OR $04 ;
     END;
     CASE Parity OF
      0 : R := R OR $00 ;
      1 : R := R OR $08 ;
      2 : R := R OR $18 ;
     END;
    Get_Comm_Params_Value := R ;
END;

PROCEDURE PortOpen ( NbPort : BYTE ; Buf_Size : WORD ; Params_Value : BYTE );
BEGIN CASE NbPort OF
        1: RS232.Open_1 ( Buf_Size , Params_Value );
        2: RS232.Open_2 ( Buf_Size , Params_Value );
      END;
END;

PROCEDURE PortClose ( NbPort : BYTE );
BEGIN CASE NbPort OF
        1: RS232.Close_1 ;
        2: RS232.Close_2 ;
      END;
END;

FUNCTION PortTest ( NbPort : BYTE ): BOOLEAN ;
BEGIN IF KeyPressed AND ( ReadKey = #27 ) THEN LongJump ( UserBreak , 0 ) ;
      CASE NbPort OF
        1: PortTest := RS232.Test_Port_1 ;
        2: PortTest := RS232.Test_Port_2 ;
      END;
END;

FUNCTION PortRead ( NbPort : BYTE ) : BYTE ;
BEGIN IF KeyPressed AND ( ReadKey = #27 ) THEN LongJump ( UserBreak , 0 ) ;
      CASE NbPort OF
        1: PortRead := Read_Port_1 ;
        2: PortRead := Read_Port_2 ;
      END;
END;

PROCEDURE PortWrite ( NbPort : BYTE ; Cha : BYTE );
BEGIN IF KeyPressed AND ( ReadKey = #27 ) THEN LongJump ( UserBreak , 0 ) ;
      CASE NbPort OF
        1: Write_Port_1 ( Cha );
        2: Write_Port_2 ( Cha );
      END;
END;

FUNCTION PortReadTicks ( NbPort:BYTE; NbTics:INTEGER; VAR c:BYTE ):BOOLEAN;
VAR BiosTime  : LONGINT ABSOLUTE $40:$6C ;
    BeginTime : LONGINT ;
BEGIN
     BeginTime := BiosTime ;
     WHILE ( ( BiosTime - BeginTime ) < nbTics ) DO
      BEGIN
       IF PortTest ( NbPort ) THEN
          BEGIN
             c := PortRead ( NbPort ) ;
             PortReadTicks := TRUE ;
             Exit ;
          END;
      END;
     PortReadTicks := FALSE ;
END;

PROCEDURE PortClearLineTicks( NbPort:BYTE; NbTics:INTEGER);
VAR c : BYTE ;
BEGIN WHILE PortReadTicks(NbPort,NbTics,c) DO ;
END;

END.