{$I COMPDIR.PAS}

UNIT RS232 ;
{                RS232.PAS
                                        (C) Laurent Bernard 09/11/93

     This unit in Turbo Pascal implements valuable routines for
   accessing the RS232-C microchip.
     A program should call Open_1 or Open_2 at the beginning.
     Once finished, a call to Close_1 or Close_2 is required to free
   the memory allocated for the buffer.

     The main IO routines are in RS232.ASM.
}

INTERFACE

PROCEDURE Open_1 ( Buf_Size : WORD ; Params_Value : BYTE ) ;
PROCEDURE Open_2 ( Buf_Size : WORD ; Params_Value : BYTE ) ;

PROCEDURE Close_1 ;
PROCEDURE Close_2 ;

FUNCTION  Test_Port_1 : BOOLEAN ;
FUNCTION  Test_Port_2 : BOOLEAN ;

FUNCTION  Read_Port_1 : BYTE ;
FUNCTION  Read_Port_2 : BYTE ;

PROCEDURE Write_Port_1 ( Cha : BYTE ) ;
PROCEDURE Write_Port_2 ( Cha : BYTE ) ;

{ The following routines should not be used in general }
PROCEDURE Init_Port_1 ( Buf:POINTER ; BSize:WORD; Params_Value:BYTE ) ;
PROCEDURE Init_Port_2 ( Buf:POINTER ; BSize:WORD; Params_Value:BYTE ) ;
FUNCTION Close_Port_1 : WORD ; { Returns the size of the Buffer }
FUNCTION Close_Port_2 : WORD ; { Returns the size of the Buffer }

IMPLEMENTATION

VAR Buf1 , Buf2 : POINTER ;

PROCEDURE Open_1 ( Buf_Size : WORD ; Params_Value : BYTE ) ;
BEGIN
     GetMem ( Buf1 , Buf_Size ) ;
     Init_Port_1 ( Buf1 , Buf_Size , Params_Value ) ;
END;

PROCEDURE Open_2 ( Buf_Size : WORD ; Params_Value : BYTE ) ;
BEGIN
     GetMem ( Buf2 , Buf_Size ) ;
     Init_Port_2 ( Buf2 , Buf_Size , Params_Value ) ;
END;

PROCEDURE Close_1 ;
BEGIN   FreeMem ( Buf1 , Close_Port_1 ) ;
END;

PROCEDURE Close_2 ;
BEGIN   FreeMem ( Buf2 , Close_Port_2 ) ;
END;


PROCEDURE Init_Port_1( Buf:POINTER; BSize:WORD; Params_Value:BYTE); EXTERNAL;
PROCEDURE Init_Port_2( Buf:POINTER; BSize:WORD; Params_Value:BYTE); EXTERNAL;

FUNCTION Test_Port_1 : BOOLEAN ; EXTERNAL ;
FUNCTION Test_Port_2 : BOOLEAN ; EXTERNAL ;

FUNCTION Read_Port_1 : BYTE ; EXTERNAL ;
FUNCTION Read_Port_2 : BYTE ; EXTERNAL ;

PROCEDURE Write_Port_1 ( Cha : BYTE ) ; EXTERNAL ;
PROCEDURE Write_Port_2 ( Cha : BYTE ) ; EXTERNAL ;

FUNCTION Close_Port_1 : WORD ; EXTERNAL ;
FUNCTION Close_Port_2 : WORD ; EXTERNAL ;
{$L RS232.OBJ}

END.