   ;        ******* RS232.ASM *******
   ; Source Implementing Low Level IO Routines on RS-232C
   ;  Interface for Turbo Pascal ( RS232.PAS )
   ;                                  (C) Laurent Bernard 09/11/93

   .MODEL TPASCAL
   .CODE

   PUBLIC Test_Port_1
   PUBLIC Test_Port_2
   PUBLIC Read_Port_1
   PUBLIC Read_Port_2
   PUBLIC Write_Port_1
   PUBLIC Write_Port_2
   PUBLIC Close_Port_1
   PUBLIC Close_Port_2
   PUBLIC Init_Port_1
   PUBLIC Init_Port_2

   Write_1  DW ?
   Read_1 DW ?

   Write_2  DW ?
   Read_2 DW ?

   Old_Int_1 DD ?
   Old_Int_2 DD ?

   Buffer_1 DD ?
   Size_Buffer_1 DW ?

   Buffer_2 DD ?
   Size_Buffer_2 DW ?


   ADR_8259_IMR = 21h
   ADR_8259_EOI = 20h

   ADR_DATA_1 = 3F8h
   ADR_DATA_2 = 2F8h

   ADR_IER_1  = 3F9h
   ADR_IER_2  = 2F9h

   ADR_MCR_1  = 3FCh
   ADR_MCR_2  = 2FCh

   ADR_STAT_1 = 3FDh
   ADR_STAT_2 = 2FDh

   MASQ_INT_1 = 10h
   MASQ_INT_2 = 08h

   ADR_INT_1  = 0Ch
   ADR_INT_2  = 0Bh


Treat_Int_1:
   PUSH DS
   PUSH DX
   PUSH AX
   PUSH DI

   LDS DI , CS:[Buffer_1]

   MOV DX , ADR_DATA_1
   IN  AL , DX

   MOV DX , CS:[Write_1]
   ADD DI , DX
   MOV DS:[DI] , AL
   INC DX
   CMP DX , CS:[Size_Buffer_1]
   JNE @1
   XOR DX , DX
@1:MOV CS:[Write_1] , DX

   MOV DX , ADR_8259_EOI
   MOV AL , 020h
   OUT DX , AL

   POP  DI
   POP  AX
   POP  DX
   POP  DS
   IRET

Treat_Int_2:
   PUSH DS
   PUSH DX
   PUSH AX
   PUSH DI

   LDS DI , CS:[Buffer_2]

   MOV DX , ADR_DATA_2
   IN  AL , DX

   MOV DX , CS:[Write_2]
   ADD DI , DX
   MOV DS:[DI] , AL
   INC DX
   CMP DX , CS:[Size_Buffer_2]
   JNE @2
   XOR DX , DX
@2:MOV CS:[Write_2] , DX

   MOV DX , ADR_8259_EOI
   MOV AL , 020h
   OUT DX , AL

   POP  DI
   POP  AX
   POP  DX
   POP  DS
   IRET


Test_Port_1 PROC FAR
   MOV DX , ADR_8259_IMR
   IN  AL , DX
   OR  AL , MASQ_INT_1
   OUT DX , AL

   MOV BX , CS:[Write_1]
   SUB BX , CS:[Read_1]

   AND AL , NOT MASQ_INT_1
   OUT DX , AL

   XOR AL , AL
   OR  BX , BX
   JZ  @ExitTP1
   INC AL
@ExitTP1:
   RET
Test_Port_1 ENDP


Test_Port_2 PROC FAR
   MOV DX , ADR_8259_IMR
   IN  AL , DX
   OR  AL , MASQ_INT_2
   OUT DX , AL

   MOV BX , CS:[Write_2]
   SUB BX , CS:[Read_2]

   AND AL , NOT MASQ_INT_2
   OUT DX , AL

   XOR AL , AL
   OR  BX , BX
   JZ  @ExitTP2
   INC AL
@ExitTP2:
   RET
Test_Port_2 ENDP


Read_Port_1 PROC FAR
   MOV DX , ADR_8259_IMR
   IN  AL , DX
   OR  AL , MASQ_INT_1
   OUT DX , AL
   XOR CL , CL ; { MOV CL , Car_Nul }
   MOV BX , CS:[Read_1]
   CMP BX , CS:[Write_1]
   JE  @ExitRP1
   LES DI , CS:[Buffer_1]
   ADD DI , BX
   MOV CL , ES:[DI]
   INC BX
   CMP BX , CS:[Size_Buffer_1]
   JNE @NoModRP1
   XOR BX , BX
@NoModRP1:
   MOV CS:[Read_1] , BX
@ExitRP1:
   AND AL , NOT MASQ_INT_1
   OUT DX , AL
   MOV AL , CL
   RET
Read_Port_1 ENDP

Read_Port_2 PROC FAR
   MOV DX , ADR_8259_IMR
   IN  AL , DX
   OR  AL , MASQ_INT_2
   OUT DX , AL
   XOR CL , CL ; { MOV CL , Car_Nul }
   MOV BX , CS:[Read_2]
   CMP BX , CS:[Write_2]
   JE  @ExitRP2
   LES DI , CS:[Buffer_2]
   ADD DI , BX
   MOV CL , ES:[DI]
   INC BX
   CMP BX , CS:[Size_Buffer_2]
   JNE @NoModRP2
   XOR BX , BX
@NoModRP2:
   MOV CS:[Read_2] , BX
@ExitRP2:
   AND AL , NOT MASQ_INT_2
   OUT DX , AL
   MOV AL , CL
   RET
Read_Port_2 ENDP


Write_Port_1 PROC FAR Dat : BYTE
   MOV DX , ADR_STAT_1
@Wait_WP1:
   IN AL , DX
   TEST AL , 020h
   JZ   @Wait_WP1
   MOV DX , ADR_DATA_1
   MOV AL , Dat
   OUT DX , AL
   RET
Write_Port_1 ENDP


Write_Port_2 PROC FAR Dat : BYTE
   MOV DX , ADR_STAT_2
@Wait_WP2:
   IN AL , DX
   TEST AL , 020h
   JZ   @Wait_WP2
   MOV DX , ADR_DATA_2
   MOV AL , Dat
   OUT DX , AL
   RET
Write_Port_2 ENDP


Close_Port_1 PROC FAR
   ; { Disable Comm1 Interrupts }
   MOV DX , ADR_8259_IMR
   IN  AL , DX
   OR  AL , MASQ_INT_1
   OUT DX , AL
   ; { Restore Old Interrupt Vector }
   MOV AH , 25h
   MOV AL , ADR_INT_1
   MOV DX , WORD PTR CS:[Old_Int_1]
   PUSH DS
   MOV DS , WORD PTR CS:[Old_Int_1 + 2]
   INT 21h
   POP DS
   MOV AX , CS:[Size_Buffer_1]
   RET
Close_Port_1 ENDP

Close_Port_2 PROC FAR
   ; { Disable Comm2 Interrupts }
   MOV DX , ADR_8259_IMR
   IN  AL , DX
   OR  AL , MASQ_INT_2
   OUT DX , AL
   ; { Restore Old Interrupt Vector }
   MOV AH , 25h
   MOV AL , ADR_INT_2
   MOV DX , WORD PTR CS:[Old_Int_2]
   PUSH DS
   MOV DS , WORD PTR CS:[Old_Int_2 + 2]
   INT 21h
   POP DS
   MOV AX , CS:[Size_Buffer_2]
   RET
Close_Port_2 ENDP


Init_Port_1 PROC FAR Buf : DWORD , BSize : WORD , Params_Value : BYTE
   ; { Clear Buffer }
   CLD
   MOV CX , BSize
   MOV CS:[Size_Buffer_1] , CX
   LES DI , Buf
   MOV WORD PTR CS:[Buffer_1] , DI
   MOV AX , ES
   MOV WORD PTR CS:[Buffer_1 + 2] , AX
   MOV AL , ' '
   REP STOSB
   ; { Init R/W Vars }
   MOV WORD PTR CS:[Write_1] , 0
   MOV WORD PTR CS:[Read_1] , 0
   ; { Set UART Params }
   XOR AH , AH
   MOV AL , Params_Value
   XOR DX , DX ; { Port 1 }
   INT 14h
   ; { Save Old Interrupt Vector }
   MOV AH , 35h
   MOV AL , ADR_INT_1
   INT 21h
   MOV WORD PTR CS:[Old_Int_1]     , BX
   MOV WORD PTR CS:[Old_Int_1 + 2] , ES
   ; { Set New Interrupt Vector }
   MOV AH , 25h
   MOV AL , ADR_INT_1
   MOV DX , OFFSET Treat_Int_1
   PUSH DS
   MOV BX , CS ; { = SEG Treat_Int_1 }
   MOV DS , BX
   INT 21h
   POP DS
   ; { Port[ ADR_MCR_1 ] := B }
   MOV DX , ADR_MCR_1
   MOV AL , 0Bh
   OUT DX , AL
   ; { Port[ ADR_IER_1 ] := 1 }
   MOV DX , ADR_IER_1
   MOV AL , 01h
   OUT DX , AL
   ; { Port[ ADR_8259_IMR ] &= NOT MASQ_INT_1 }
   MOV DX , ADR_8259_IMR
   IN  AL , DX
   AND AL , NOT MASQ_INT_1
   OUT DX , AL
   RET
Init_Port_1 ENDP

Init_Port_2 PROC FAR Buf : DWORD , BSize : WORD , Params_Value : BYTE
   ; { Clear Buffer }
   CLD
   MOV CX , BSize
   MOV CS:[Size_Buffer_2] , CX
   LES DI , Buf
   MOV WORD PTR CS:[Buffer_2] , DI
   MOV AX , ES
   MOV WORD PTR CS:[Buffer_2 + 2] , AX
   MOV AL , ' '
   REP STOSB
   ; { Init R/W Vars }
   MOV WORD PTR CS:[Write_2] , 0
   MOV WORD PTR CS:[Read_2] , 0
   ; { Set UART Params }
   XOR AH , AH
   MOV AL , Params_Value
   MOV DX , 1 ; { Port 2 }
   INT 14h
   ; { Save Old Interrupt Vector }
   MOV AH , 35h
   MOV AL , ADR_INT_2
   INT 21h
   MOV WORD PTR CS:[Old_Int_2]     , BX
   MOV WORD PTR CS:[Old_Int_2 + 2] , ES
   ; { Set New Interrupt Vector }
   MOV AH , 25h
   MOV AL , ADR_INT_2
   MOV DX , OFFSET Treat_Int_2
   PUSH DS
   MOV BX , CS ; { = SEG Treat_Int_2 }
   MOV DS , BX
   INT 21h
   POP DS
   ; { Port[ ADR_MCR_2 ] := B }
   MOV DX , ADR_MCR_2
   MOV AL , 0Bh
   OUT DX , AL
   ; { Port[ ADR_IER_2 ] := 1 }
   MOV DX , ADR_IER_2
   MOV AL , 01h
   OUT DX , AL
   ; { Port[ ADR_8259_IMR ] &= NOT MASQ_INT_2 }
   MOV DX , ADR_8259_IMR
   IN  AL , DX
   AND AL , NOT MASQ_INT_2
   OUT DX , AL
   RET
Init_Port_2 ENDP

   END