'+--------------------------[ PCB-ATCH Ver 1.50 ]----------------------------+
'|  Written By Gary Meeker 07/11/94                        Updated 12/22/95  |
'|  SYSOP: SHARP Technical Support Line BBS               Lawrenceville, GA  |
'|         (770) 962-1788                          300-28800 Baud. 24 Hours  |
'+---------------------------------------------------------------------------+
'V1.00  07/11/94 - Initial Release
'V1.10  07/11/94 - 2nd Release
'                  Added support for Cam-Mail .QWK packets with file attachments
'V1.20  07/15/94 - 3rd Release
'                  Added file cleanup after copying attached files.
'                  Added support for Clearing Network Tags to replace the
'                  separate program CLEARTAG
'                  Added support for Setting Net Status in NETFLAGS.DAT to
'                  replace the separate program MAKE-NET
'                  Added support for exporting attached files
'V1.30  07/16/94 - 4th Release
'                  Added support for change in PCBoard which uses original
'                  filename if possible rather than renaming to .000-.999
'V1.40  07/22/94 - 5th Release
'                  Added support a CLEARTAG configuration file to control
'                  which conferences are to be cleared
'V1.50  12/22/95 - 6th Release
'                  I seem to have had the filename order in ATTACHED.LST
'                  backwards, fixed that.

DEFINT A-Z

'   PDQ Declarations
DECLARE FUNCTION PDQExist% (FileSpec$)
DECLARE FUNCTION PDQParse$ (Work$)
DECLARE FUNCTION PDQValI% (Number$)
DECLARE FUNCTION PDQValL& (Number$)
DECLARE SUB CritErrOff ()
DECLARE SUB CritErrOn ()
DECLARE SUB PDQRestore ()
DECLARE SUB SetDelimitChar (Char)

'   QuickPack Declarations
DECLARE FUNCTION GetBit% (Array$, Element%)
DECLARE FUNCTION QPStrI$ (IntValue%)
DECLARE FUNCTION QPStrL$ (LongValue&)
DECLARE SUB FCopy (Source$, Dest$, Buffer$, ErrCode%)
DECLARE SUB KillFile (FileName$)
DECLARE SUB SetBit (Array$, Element%, Bit%)

' PROBAS Declarations

' Myown Declarations
DECLARE FUNCTION EndString(Temp$, EndCh$)
DECLARE FUNCTION FindLastCh(St$, BYVAL Ch)
DECLARE FUNCTION Signed2& (X%)
DECLARE SUB DelChar (Target$, Position, Char$)
DECLARE SUB INC ALIAS "_inc" (IntVar%)
DECLARE SUB INC2 ALIAS "_incL" (LongVar&)
DECLARE SUB IncStepL(LongVar&, StepVar%)

' Local Declarations
DECLARE FUNCTION EndChar$(St$, EndCh$)
DECLARE FUNCTION MakeExt$(St$, Ext$)
DECLARE SUB GetParameter(Parameter$, Flag)
DECLARE SUB ProcessFile(Flag)
DECLARE SUB ModifyName()
DECLARE SUB SetNet()

TYPE QWKMsgRecord
   Status AS STRING * 1          'Status Flag (*+-`~ or blank)                   1
   Number AS STRING * 7          'Message Number                                 2
   MDate AS STRING * 8           'Date of Message (in mm-dd-yy format)           9
   MTime AS STRING * 5           'Time of Message (in hh:mm format)             17
   ToWho AS STRING * 25          'Who the Message is For                        22
   From AS STRING * 25           'Who the Message is From                       47
   Subject AS STRING * 25        'Subject of the Message                        72
   Password AS STRING * 12       'Message Password (if any or ^^)               97
   Reference AS STRING * 8       'Reference Message Number                     109
   Blocks AS STRING * 6          'Number of 128 byte blocks in Message         117
   Deleted AS STRING * 1         'Flag for Message Status (#225 or #226)       123
   ConfNum AS INTEGER            'Conference number (unsigned word)            124
   MsgNum AS INTEGER             'Logical message number in the current packet 126
   NetTag AS STRING * 1          '                                             128
END TYPE                                                                      '129

PRINT "PCB-Attach Ver 1.50 - Copyright 1994,1995 Gary Meeker"

DIM SHARED QwkMsg AS QWKMsgRecord, B AS STRING * 72, A AS STRING * 1
DIM SHARED WorkDir$, AttachDir$, Source$, Target$, FileName$, NewName$
DIM SHARED Expanded$, Attach$, ConfNum, MsgNum&, Export, ExpCount, NetCount

Expanded$ = CHR$(255) + "@"
Attach$ = Expanded$ + "ATTACH :"

'   Get the Command Line
C$ = UCASE$(COMMAND$)

SetDelimitChar 32             ' Command line arguments separated by spaces

CritErrOff                    ' Stop nasty DOS/SHARE Errors

GetParameter "/A", Attach     ' Do we process Attached files?

GetParameter "/X", Export     ' Are we Exporting instead of Importing?

GetParameter "/M", MakeNet    ' Do we set network flags in NETFLAGS.DAT?

GetParameter "/C", ClearTag   ' Do we Clear Network Tagline flags?

MsgFile$   = PDQParse$(C$)                   ' Get the Message Filename
AttachDir$ = EndChar$(PDQParse$(C$), "\")    ' Get the Attached file directory

IF Export OR ClearTag THEN
   EndPath = FindLastCh(MsgFile$, 92)        ' Find the end of the path portion
   WorkDir$ = LEFT$(MsgFile$, EndPath)       ' Get just the path portion
   TagFile$ = MakeExt(MID$(MsgFile$, EndPath + 1), "TAG")  ' Get the filename
ELSE
   WorkDir$ = EndChar$(MsgFile$, "\")        ' Make sure it ends with '\'
   MsgFile$ = WorkDir$ + "MESSAGES.DAT"      ' Set the message filename
END IF

AttachFile$ = WorkDir$ + "ATTACHED.LST"      ' Set the Attach File filename
NetFile$    = WorkDir$ + "NETFLAGS.DAT"      ' Set the Network Tag filename

Conf$ = STRING$(2048, 0)                   ' Assume no conferences to be cleared
IF ClearTag THEN
   IF PDQExist(TagFile$) THEN              ' Read the list file if there
      OPEN TagFile$ FOR INPUT ACCESS READ AS #1
         LINE INPUT #1, ConfList$          ' Clear just these.
      CLOSE #1
   ELSE
      LSET Conf$ = STRING$(2048, 255)      ' Clear any conference!
   END IF
   ClearOnly = NOT Export                  ' That's all we are doing!
END IF

IF LEN(ConfList$) > 0 THEN
   SetDelimitChar 44                       ' Parameters separated by commas now
   PDQRestore                              ' Start with 1st parameter
   DO
      Test$ = PDQParse$(ConfList$)         ' Get a parameter
      IF LEN(Test$) = 0 THEN EXIT DO
      X = INSTR(Test$, "-")                ' Is it a Range?
      IF X > 0 THEN                        '   Yes
         FOR N = PDQValI(LEFT$(Test$, X-1)) TO PDQValI(MID$(Test$, X+1))
            SetBit Conf$, N, -1            '      Set each Conference
         NEXT N
      ELSE                                 '   No
         SetBit Conf$, PDQValI(Test$), -1  '      Set this Conference
      END IF
   LOOP
   PRINT
END IF

IF NOT Export AND NOT ClearTags AND NOT PDQExist(NetFile$) THEN
   OPEN NetFile$ FOR OUTPUT ACCESS WRITE SHARED AS #1
      PRINT #1, STRING$(8192, 1);          ' Create a file since there was none
   CLOSE #1
END IF

IF NOT PDQExist(MsgFile$) THEN
   PRINT "Missing "; MsgFile$; "!"         ' We got to have a file to read
   GOTO ErrExit
END IF
OPEN MsgFile$ FOR BINARY ACCESS READ WRITE SHARED AS #1
   PRINT "Reading "; MsgFile$
   IF PDQExist(AttachFile$) AND NOT (ClearTag OR Export OR MakeNet) THEN
      PRINT "Reading "; AttachFile$
      OPEN AttachFile$ FOR INPUT ACCESS READ SHARED AS #2
      OPEN NetFile$ FOR BINARY ACCESS READ WRITE SHARED AS #3
         WHILE NOT EOF(2)
'           INPUT #2, ConfNum, MsgNum&, OrgName$, FileName$   'Old line
            INPUT #2, ConfNum, MsgNum&, FileName$, OrgName$   'Changed 12/22/95
            Source$ = WorkDir$ + FileName$
            IF PDQExist(Source$) THEN ProcessFile -1
         WEND
         PRINT "Checking NETFLAGS.";
         MsgNum& = -1 : ModifyName         ' Make sure all NETFLAGs are set.
         PRINT
      CLOSE #3
      CLOSE #2
      KillFile AttachFile$
   ELSE
      IF Export THEN
         IF Attach THEN OPEN AttachFile$ FOR APPEND ACCESS READ WRITE SHARED AS #2
         OPEN "PCB-Atch.LST" FOR OUTPUT ACCESS WRITE SHARED AS #3
            PRINT #3, MsgFile$
      ELSEIF NOT ClearTag THEN             ' Must be Import!
         OPEN NetFile$ FOR BINARY ACCESS READ WRITE SHARED AS #3
      END IF
      Recs& = LOF(1) \ 128
      Rec& = 2
      WHILE Rec& < Recs&
         Offset& = (Rec& - 1&) * 128 + 1&
         GET #1, Offset&, QwkMsg
         Blocks = PDQValI(QwkMsg.Blocks$)
         IF Blocks = 0 THEN
            Blocks = 1
         ELSE
            IF NOT (Export OR Cleartag) THEN
               SetNet                 ' If Importing make sure NETFLAG is set.
            ELSEIF GetBit(Conf$, QwkMsg.ConfNum) AND QwkMsg.NetTag$ <> " " THEN
               QwkMsg.NetTag$ = " "   ' If Exporting clear Network Tag character
               PUT #1, Offset&, QwkMsg
               INC TagCount
            END IF
            Offset& = Rec& * 128 + 1&
            DO WHILE NOT (ClearOnly OR MakeNet)   '
               GET #1, Offset&, B$                ' Read a special PCBoard line
               IF LEFT$(B$, 10) = Attach$ THEN    ' Is it '<255>@ATTACH :' ?
                  X = INSTR(B$, ")")+2            '    yes, find the filename
                  FileName$ = MID$(B$, X, INSTR(X, B$, " ") - X)
                  IF Export THEN
                     Source$ = AttachDir$ + FileName$
                     FileName$ = MID$(B$, 11, INSTR(11, B$, " ") - 11)
                  ELSE
                     Source$ = WorkDir$ + FileName$
                  END IF
                  IF PDQExist(Source$) THEN
                     ProcessFile 0                ' Sets NewName$
                     MID$(B$, X) = NewName$       ' Update the attached name
                     PUT #1, Offset&, B$          ' Update the message file
                     IF Export AND Attach THEN
                        PRINT #2, QPStrL$(Signed2&(QwkMsg.ConfNum)); " ,"; _
                         RTRIM$(QwkMsg.Number$); " ,"; NewName$; ","; FileName$ 'changed 12/22/95
'                        RTRIM$(QwkMsg.Number$); " ,"; FileName$; ","; NewName$ 'old line
                     END IF
                  ELSE
                     PRINT "Attached file "; FileName$; " not present."
                  END IF
                  EXIT DO
               ELSEIF LEFT$(B$, 2) <> Expanded$ THEN  ' No, was it a special line
                  EXIT DO                             '    No, so quit looking
               END IF
               IncStepL Offset&, 72                   '    Yes, so read another
            LOOP
         END IF
         IncStepL Rec&, Blocks                        ' Next message please
      WEND
      IF Export THEN
         IF Attach AND (ExpCount > 0) THEN PRINT #3, AttachFile$
         IF NOT MakeNet THEN
            PRINT "Attached"; ExpCount; "file"; LEFT$("s", -(ExpCount <> 1)); "."
         END IF
         IF Attach THEN CLOSE #2
      ELSEIF NOT ClearTag THEN
         PRINT "Updated"; NetCount; "network status flag"; LEFT$("s", -(NetCount <> 1)); "."
      END IF
      CLOSE #3
   END IF
CLOSE #1

IF ClearTag THEN
   PRINT "Cleared"; TagCount; "network tag"; LEFT$("s", -(TagCount <> 1)); "."
ELSE
   PRINT "Done."
END IF

ErrExit:

PRINT
CritErron                       ' Restore nasty error handler
END

FUNCTION EndChar$(St$, EndCh$) STATIC
   Temp$ = RTRIM$(ST$)
   IF (LEN(Temp$) = 0) OR EndString(Temp$, EndCh$) THEN
      EndChar$ = Temp$
   ELSE
      EndChar$ = Temp$ + EndCh$
   END IF
END FUNCTION

FUNCTION MakeExt$(St$, Ext$) STATIC
   ExtPos = FindLastCh(St$, 46)
   IF ExtPos THEN
      MakeExt$ = LEFT$(St$, ExtPos) + Ext$
   ELSE
      MakeExt$ = RTRIM$(St$) + "." + Ext$
   END IF
END FUNCTION

SUB GetParameter(Parameter$, Par)
   SHARED C$                                ' We need to access COMMAND line
   StrLen = LEN(Parameter$)
   Flag = INSTR(C$, Parameter$)
   IF Flag THEN                                   ' Was Parameter present?
      Par = -1                                    ' Yes,
      DelChar C$, Flag, SPACE$(StrLen)            ' delete it all
   END IF
END SUB

SUB ProcessFile(Flag)         ' Find a unique attachment filename
   NewName$ = FileName$             ' Try the orgional name first
   T = 0                            ' Start with .000 if needed
   DO WHILE T <= 1000               ' 000-999 Only
      IF Export THEN
         Target$ = WorkDir$ + NewName$
      ELSE
         Target$ = AttachDir$ + NewName$
      END IF
      IF NOT PDQExist(Target$) THEN       ' See if already in directory
         PRINT "Copying "; Source$; " to "; Target$     ' No...
         FCopy Source$, Target$, SPACE$(4096), ErCd
         IF Export THEN
            PRINT #3, Target$       ' Add it to the List of files for PKZIP
            INC ExpCount
         ELSE
            KillFile Source$        ' Remove origional when importing
         END IF
         IF Flag THEN ModifyName
         EXIT SUB
      END IF
      NewName$ = MakeExt$(FileName$, RIGHT$("000" + QPStrI$(T), 3))
      INC T                         ' Prepare for next file name
   LOOP
END SUB

'Modify the name of the file in MESSAGES.DAT if importing QMAIL files.

SUB ModifyName                ' Update the MESSAGES.DAT file
   Recs& = LOF(1) \ 128
   Rec& = 2
   WHILE Rec& < Recs&
      Offset& = (Rec& - 1&) * 128 + 1&
      GET #1, Offset&, QwkMsg
      Blocks = PDQValI(QwkMsg.Blocks$)
      IF Blocks = 0 THEN
         Blocks = 1
      ELSEIF QwkMsg.ConfNum = ConfNum AND PDQValL&(QwkMsg.Number$) = MsgNum& THEN
         Offset& = Rec& * 128 + 1&
         DO
            GET #1, Offset&, B$     ' Get a 72 character line
            IF LEFT$(B$, 10) = Attach$ THEN  ' Is this our '<255>$ATTACH :' line
               MID$(B$, INSTR(B$, ")")+2) = NewName$    ' Yes...
               PUT #1, Offset&, B$                      ' Update it then
               EXIT DO
            ELSEIF LEFT$(B$, 2) <> Expanded$ THEN       ' No, and not special
               PRINT "Unable to locate @ATTACH statement!"
               EXIT DO
            END IF
            IncStepL Offset&, 72                        ' Read another line
         LOOP
         EXIT SUB
      ELSEIF MsgNum& = -1 THEN
         SetNet         ' Make sure NETFLAG is set.
      END IF
      IncStepL Rec&, Blocks                             ' Next message please.
   WEND
END SUB

SUB SetNet
   GET #3, QwkMsg.ConfNum + 1, A$                       ' Get the NetFlag byte
   IF ASC(A$) < 2 THEN                                  ' If not Net status
      A$ = CHR$(6)                                      '   then set it
      PUT #3, QwkMsg.ConfNum + 1, A$                    '   and update file
      INC NetCount                                      ' count it for report
   END IF
END SUB

'This file was last compiled with:
'BC PCB-ATCH.BAS  /o /s;
'LINK PCB-ATCH+
'     C:\QB\LIB\_NOERROR C:\QB\LIB\_NOFIELD C:\QB\LIB\_NOREAD C:\QB\LIB\_NOVAL+
'     /ex /nod /noe /packcode /far
'
'     nul
'     C:\QB\LIB\SCREEN C:\QB\LIB\MYOWN C:\QB\LIB\QPPRO C:\QB\LIB\PDQFP
'
