//
// fileview.hpp - J.E.C. File Viewer
// Version - 1.15
// 1/17/95 - 12:48:35am
// Michael Taylor
//
// zpb_begin Revisions 
// zpb_end 

#ifndef _FILEVIEW_HPP
#define _FILEVIEW_HPP

#include <zapph/mdi.hpp>
#include <intpack/zip.hpp>				// Interface Pack
#include "fileview.h"			// Resource Constants

// zpb_begin AppIncludes 
#ifdef WINDOWS
extern "C" {
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <shellapi.h>   // Contains Drag/Drop APIs
}
#endif

#include "file.hpp"
#include "view.hpp"
// zpb_end 

#include "dialogs.hpp"			// Module Class Definitions

typedef int (zEvH::*NotifyEvtProc)(zNotifyEvt *);
typedef int (zEvH::*NotifyFocusProc)(zFocusEvt *);
void centerWindow(zWindow *w, BOOL fOnParent = TRUE);

class zfBitmapPane : public zPane {
	zBitmap theBitmap;
public:
	zfBitmapPane(zWindow* w, const zResId& id, zSizer* sz);
	virtual int draw(zDrawEvt *e);
};

class tbFileViewToolBar : public zToolbar {
	zBitmap *theBmp;
public:
	tbFileViewToolBar(zMDIMarginFrame *w, zSizer *sz, zBitmap *bmp=0);
	~tbFileViewToolBar();

	// zpb_begin ptbFileViewToolBarClass 
	// zpb_end 
};

class WFileView : public zMDIAppFrame {
public:
	zToolbar *pTB;

	WFileView(const char* title);
	~WFileView();
	int cmdFileOpen(zCommandEvt*);
	int cmdFileClose(zCommandEvt*);
	int cmdFileEditFile(zCommandEvt*);
	int cmdFilePrint(zCommandEvt*);
	int cmdFilePageSetup(zCommandEvt*);
	int cmdFileExit(zCommandEvt*);
	int cmdEditCopy(zCommandEvt*);
	int cmdEditGotoLine(zCommandEvt*);
	int cmdViewWordWrap(zCommandEvt*);
	int cmdViewHexMode(zCommandEvt*);
	int cmdSearchFind(zCommandEvt*);
	int cmdSearchFindNext(zCommandEvt*);
	int cmdSearchFindPrev(zCommandEvt*);
	int cmdOptionsConfiguration(zCommandEvt*);
	int cmdOptionsFont(zCommandEvt*);
	int cmdHelpAbout(zCommandEvt*);
	int cmdHelpHelp(zCommandEvt*);
	int cmdMDIWindow(zCommandEvt*);

	// zpb_begin WFileViewClass 
	int cmdNextWin(zCommandEvt*);
	zStatusLineEZ* sbar;
	zFontSpec*	Wfont;
	int 	resetMenu ();
	int 	close (FileView *);
	int 	startmaximised;		// should app open maximised
	int 	openmaximised;		// open child windows maximised
	int	restore;		// restore on drop file
	int	addvscroll;		// add vertical scroll bar
	int	addhscroll;		// add horizontal scroll bar
	int 	findoffset;		// offset to show line with found data
	int     regexp;			// use regular expressions
	int     matchcase;		// match case in find/findnext
	int     direction;		// direction of the find/findnext
	int	wordwrap;		// word wrap mode
	int	hexmode;		// hex display mode
	int	rightMargin;		// page setup
	int	leftMargin;		// page setup
	int	topMargin;		// page setup
	int	bottomMargin;		// page setup
	char    *editor () { return editorname;}
	char    *findstring () { return szFindWhat;}
	LOGFONT	lf;
private:
	int     DragDrop (zEvent *);	// MS-win specific DROPFILES support
	int     size (zSizeEvt *ev);
	int     move (zMoveEvt *ev);
	void    updateIni ();
	int     topleftx, toplefty, width, height, tempx, tempy;
	int     minimised;
	int     maximised;
	char    *inifilename;
	char    *editorname;
	zMenu   *FileMenu;
	zMenu   *EditMenu;
	zMenu   *SearchMenu;
	int     nFiles;
	int     findflags;		// flags for find/findnext modes
        char    *szFindWhat;		// string to find
#define MAXSLEN	256        
	// zpb_end 
};
#endif
