//
// dialogs.cpp - J.E.C. File Viewer
// Version - 1.15
// 1/17/95 - 12:48:34am
// Michael Taylor
//
// zpb_begin ModuleRevisions 
// zpb_end 

#include "zapp.hpp"
#include "fileview.hpp"				// Main App Class Definitions & Includes

ZAPP_IMPL_ASSERTS;

// zpb_begin ModuleVars 
// zpb_end 

//
// Dialog Member Functions - SetOptions 
//
DSetOptions::DSetOptions(zWindow *w,const zResId& rid) : zFormDialog(w,rid) {
	// zpb_begin DSetOptionsConstructor2 
	WFileView *FV = (WFileView *)w;
	// zpb_end 
	backgroundColor(LTGRAY);
	_Findoffset = 0;
	pFindoffset = ZNEW zIntEdit(this, ID_FINDOFFSET, &_Findoffset, "##", FLD_NOTREQUIRED);
	pEditorname = ZNEW zEditLine(this, ID_EDITORNAME, &_Editorname, 0);
	pOpenmax = ZNEW zCheckBox3d(this, ID_OPENMAX, &_Openmax);
	pRestore = ZNEW zCheckBox3d(this, ID_RESTORE, &_Restore);
	pAddvscrollbar = ZNEW zCheckBox3d(this, ID_ADDVSCROLLBAR, &_Addvscrollbar);
	pAddhscrollbar = ZNEW zCheckBox3d(this, ID_ADDHSCROLLBAR, &_Addhscrollbar);
	pOk = ZNEW zBitmapButton(this, IDOK, ZNEW zBitmap(zResId(IDB_SetOptionsOk)));
	pCancel = ZNEW zBitmapButton(this, IDCANCEL, ZNEW zBitmap(zResId(IDB_SetOptionsCancel)));
 	sizer()->update();
	// zpb_begin DSetOptionsConstructor 
	pOpenmax->check (FV->openmaximised);
	pRestore->check (FV->restore);
	pAddvscrollbar->check (FV->addvscroll);
	pAddhscrollbar->check (FV->addhscroll);
	_Findoffset = FV->findoffset;
	pFindoffset->setToDefault ();
        strcpy (_Editorname, FV->editor());
	pEditorname->setToDefault ();
	// zpb_end 
	show();
}

// zpb_begin DSetOptionsMemberFunctions 
// zpb_end 


//
// Dialog Member Functions - FindDialog 
//
DFindDialog::DFindDialog(zWindow *w,const zResId& rid) : zFormDialog(w,rid) {
	// zpb_begin DFindDialogConstructor2 
	WFileView *FV = (WFileView *)w;
	// zpb_end 
	backgroundColor(LTGRAY);
	pFindstring = ZNEW zEditLine(this, ID_FINDSTRING, &_Findstring, 0);
	pMatchcase = ZNEW zCheckBox3d(this, ID_MATCHCASE, &_Matchcase);
	pRegexp = ZNEW zCheckBox3d(this, ID_REGEXP, &_Regexp);
	pOk = ZNEW zBitmapButton(this, IDOK, ZNEW zBitmap(zResId(IDB_FindDialogOk)));
	pCancel = ZNEW zBitmapButton(this, IDCANCEL, ZNEW zBitmap(zResId(IDB_FindDialogCancel)));
	_UpGroup = ID_UP;	// Set initial check
	ZNEW zRadioGroup3d(this, ID_UP, ID_DOWN, &_UpGroup);  
 	sizer()->update();
	// zpb_begin DFindDialogConstructor 
	strcpy (_Findstring, FV->findstring ());
	pFindstring->setToDefault ();
	_Matchcase = FV->matchcase;
	pMatchcase->setToDefault ();
	_Regexp = FV->regexp;
	pRegexp->setToDefault ();
	zRadioGroup3d* pUpgroup = ZNEW zRadioGroup3d(this, ID_UP, ID_DOWN, &_UpGroup);  
	_UpGroup = (FV->direction == PREV) ? ID_UP : ID_DOWN;
	pUpgroup->setToDefault ();
	// zpb_end 
	show();
}


// zpb_begin DFindDialogMemberFunctions 
// zpb_end 


//
// Dialog Member Functions - GotoDialog 
//
DGotoDialog::DGotoDialog(zWindow *w,const zResId& rid) : zFormDialog(w,rid) {
	// zpb_begin DGotoDialogConstructor2 
	WFileView *FV = (WFileView *)w;
	// zpb_end 
	backgroundColor(LTGRAY);
	_Lineno = 0;
	pLineno = ZNEW zIntEdit(this, ID_LINENO, &_Lineno, "######", 0);
	pOk = ZNEW zBitmapButton(this, IDOK, ZNEW zBitmap(zResId(IDB_GotoDialogOk)));
	pCancel = ZNEW zBitmapButton(this, IDCANCEL, ZNEW zBitmap(zResId(IDB_GotoDialogCancel)));
 	sizer()->update();
	// zpb_begin DGotoDialogConstructor 
//	_Lineno = FV->lineno;
//	pLineno->setToDefault ();
	// zpb_end 
	show();
}

// zpb_begin DGotoDialogMemberFunctions 
// zpb_end 


//
// Dialog Member Functions - AboutBox 
//
DAboutBox::DAboutBox(zWindow *w,const zResId& rid) : zFormDialog(w,rid) {
	// zpb_begin DAboutBoxConstructor2 
	// zpb_end 
	backgroundColor(LTGRAY);
	pOk = ZNEW zBitmapButton(this, IDOK, ZNEW zBitmap(zResId(IDB_AboutBoxOk)));
 	sizer()->update();
	// zpb_begin DAboutBoxConstructor 
	// zpb_end 
	show();
}

// zpb_begin DAboutBoxMemberFunctions 
// zpb_end 


//
// Dialog Member Functions - PageSetup 
//
DPageSetup::DPageSetup(zWindow *w,const zResId& rid) : zFormDialog(w,rid) {
	// zpb_begin DPageSetupConstructor2 
	WFileView *FV = (WFileView *)w;
	// zpb_end 
	backgroundColor(LTGRAY);
	_LeftMargin = 0;
	_RightMargin = 0;
	_TopMargin = 0;
	_BottomMargin = 0;
	pLeftMargin = ZNEW zUnsignedIntEdit(this, ID_LEFTMARGIN, &_LeftMargin, "#####", 0);
	pRightMargin = ZNEW zUnsignedIntEdit(this, ID_RIGHTMARGIN, &_RightMargin, "#####", 0);
	pTopMargin = ZNEW zUnsignedIntEdit(this, ID_TOPMARGIN, &_TopMargin, "#####", 0);
	pBottomMargin = ZNEW zUnsignedIntEdit(this, ID_BOTTOMMARGIN, &_BottomMargin, "#####", 0);
	pOK = ZNEW zBitmapButton(this, IDOK, ZNEW zBitmap(zResId(IDB_PageSetupOK)));
	pCANCEL = ZNEW zBitmapButton(this, IDCANCEL, ZNEW zBitmap(zResId(IDB_PageSetupCANCEL)));
 	sizer()->update();
	// zpb_begin DPageSetupConstructor 
	_LeftMargin = FV->leftMargin;
	pLeftMargin->setToDefault ();
	_RightMargin = FV->rightMargin;
	pRightMargin->setToDefault ();
	_TopMargin = FV->topMargin;
	pTopMargin->setToDefault ();
	_BottomMargin = FV->bottomMargin;
	pBottomMargin->setToDefault ();
	// zpb_end 
	show();
}

// zpb_begin DPageSetupMemberFunctions 
// zpb_end 


// zpb_begin dialogsUserCode 
// zpb_end 
