package vrml;

import vrml.*;
import vrml.exceptions.*;

public class Browser {

  public static native String getName();
  public static native String getVersion();

  public static native String getNavigationType();
  public static native void setNavigationType(String type)
    throws InvalidNavigationTypeException;

  public static native float getNavigationSpeed();
  public static native void setNavigationSpeed(float speed);

  public static native float getCurrentSpeed();

  public static native float getNavigationScale();
  public static native void setNavigationScale(float scale);

  public static native boolean getHeadlight();
  public static native void setHeadlight(boolean onOff);

  public static native String getWorldURL();
  public static native void loadWorld(String [] url);

  public static native float getCurrentFrameRate();

  public static native Node createVrmlFromURL(String[] url)
    throws InvalidVRMLException;
  public static native Node createVrmlFromString(String vrmlSyntax)
    throws InvalidVRMLException;

  public native void addRoute(Node fromNode, String fromEventOut,
    Node toNode, String toEventIn)
    throws InvalidRouteException;
  public native void deleteRoute(Node fromNode, String fromEventOut,
    Node toNode, String toEventIn)
    throws InvalidRouteException;

  public native void bindBackground(Node background);
  public native void unbindBackground();
  public native boolean isBackgroundBound(Node background);

  public native void bindNavigationInfo(Node navigationInfo);
  public native void unbindNavigationInfo();
  public native boolean isNavigationInfoBound(Node navigationInfo);

  public native void bindViewpoint(Node viewpoint);
  public native void unbindViewpoint();
  public native boolean isViewpointBound(Node viewpoint);
}
