


NcFTP(1)                 USER COMMANDS                   NcFTP(1)



NAME
     NcFTP - Internet file transfer program

SYNOPSIS
     ncftp [program options] [[open options] hostname[:pathname]]

OPTIONS
     Program options:
       -D   : Turn debug mode and trace mode on.
       -L   : Don't use visual mode (use line mode).
       -V   : Use visual mode.
       -H   : Dump the version information.

     Command-line open options:
       -a   : Open anonymously.
       -u   : Open with username and password prompt.
       -p X : Use port number X when opening.
       -r   : Redial until connected.
       -d X : Redial, delaying X seconds between tries.
       -g X : Give up after X redials without connection.

     Command-line retrieve options:
       -C   : Force continuation (reget).
       -f   : Force overwrite.
       -G   : Don't use wildcard matching.
       -R   : Recursive.  Useful for fetching whole directories.
       -n X : Get selected files only if X days old or newer.

DESCRIPTION
     NcFTP is a user interface  to  the  Internet  standard  File
     Transfer  Protocol.   This program allows a user to transfer
     files to and from a remote network site,  and  offers  addi-
     tional  features  that  are not found in the standard inter-
     face, ftp.

     The program runs in one of three modes:  visual  mode,  line
     mode, and colon mode.

     If your system is somewhat modern, the default  mode  should
     be  visual  mode.  This is a full-screen interface that uses
     the  curses  library.   With  visual  mode,  you  edit   the
     program's  settings  with a nice screen interface instead of
     typing arcane commands.

     If you are not in visual mode, you will be using  line  mode
     for  the  interactive  shell.   This  mode  is  a  no-frills
     command-line interface that will look like the  default  ftp
     program's command shell.

     The third mode, colon mode, refers to the program's  ability
     to  do  a  quick retrieve of a file directly from your shell
     command line, without going into the  program's  own  shell.



NCEMRSoft              Last change: 2.1.0                       1






NcFTP(1)                 USER COMMANDS                   NcFTP(1)



     This mode is useful for shell scripts.

INTRODUCTION TO VISUAL MODE
     When entering visual mode, the screen clears and is  rewrit-
     ten with the splash screen.  You should see the black status
     bar occupying the second to last row on the screen.  Beneath
     the status bar is the input line, where you type commands to
     the program's shell.

     The program then waits for you  to  do  something.   Usually
     this  means you want to open a remote filesystem to transfer
     files to and from your local machine's  filesystem.   To  do
     that,  you need to know the symbolic name of the remote sys-
     tem, or its Internet Protocol (IP) address.  For example,  a
     symbolic  name  might  be  ``typhoon.unl.edu,''  and  its IP
     address could be ``129.93.33.24.'' To open a  connection  to
     that system, you use the program's open command:

          open typhoon.unl.edu
          open 129.93.33.24

     Both of these try to open the machine called typhoon at  the
     University of Nebraska.  Using the symbolic name is the pre-
     ferred way, because IP addresses may change without  notice,
     while the symbolic names usually stay the same.

     When you open a remote filesystem, you need to have  permis-
     sion.   The  FTP  Protocol's  authentication  system is very
     similar to that of logging in to your account.  You have  to
     give  an  account  name, and its password for access to that
     account's files.  However, most  remote  systems  that  have
     anything you might be interested in don't require an account
     name for use.  You can  often  get  anonymous  access  to  a
     remote  filesystem  and  exchange  files that have been made
     publicly accessible.  The program attempts to get  anonymous
     permission  to  a  remote  system by default.  What actually
     happens is that the program tries to  use  ``anonymous''  as
     the  account  name,  and  when prompted for a password, uses
     your E-mail address as a courtesy  to  the  remote  system's
     maintainer.   You can have the program try to use a specific
     account also.  That will be explained later.

     If the connection succeeded, you should see the  status  bar
     change to hold the remote system's name on one side, and the
     current remote directory on the other side.  To  see  what's
     in  the  current remote directory, you can use the program's
     ls and dir commands.  The former is terse,  preferring  more
     remote  files  in  less screen space, and the latter is more
     verbose, giving detailed information about each item in  the
     directory.





NCEMRSoft              Last change: 2.1.0                       2






NcFTP(1)                 USER COMMANDS                   NcFTP(1)



     You can use the program's cd command to move to other direc-
     tories  on  the  remote system.  The cd command behaves very
     much like the command of the same name  in  the  Bourne  and
     Korn shell.

     The purpose of the program is to exchange  data  with  other
     systems.   You  can  use the program's get command to copy a
     file from the remote system to your local system:

          get README.txt

     The program will display the progress of the transfer on the
     screen, so you can tell how much needs to be done before the
     transfer finishes.  When the transfer does finish, then  you
     can enter more commands to the program's command shell.

     You can use the program's put command to copy  a  file  from
     your system to the remote system:

          put something.tar

     When you are finished using the remote system, you can  open
     another  one  or  use the quit command to terminate the pro-
     gram.

THE HOSTS FILE
     One of the program's goals is to minimize typing and  maxim-
     ize  convenience.   The program automatically saves informa-
     tion about the sites you call on in a  special  file  called
     the  hosts  file, which is stored in the .ncftp subdirectory
     of your home directory.  Each  host  entry  saves  its  name
     along  with  other  settings, including the remote directory
     you were in, the account information, and more.  This  makes
     it  easy  to  call  back a site later and have everything be
     like it was when you left the last time.

     A big advantage of saving this information is that  you  can
     refer  to a site by a shorter, more meaningful name, instead
     of using the full symbolic name for a site.  For example, if
     you  called a site named ``typhoon.unl.edu'' frequently, its
     nickname might be just ``typhoon.''  Then, instead of:

          open typhoon.unl.edu

     you could use:

          open typhoon

     You could also abbreviate the nickname further, as  long  as
     the  program  will know which site you are referring to.  If
     no other site in your hosts file  had  a  nickname  starting
     with the letters ``ty,'' you could do just:



NCEMRSoft              Last change: 2.1.0                       3






NcFTP(1)                 USER COMMANDS                   NcFTP(1)



          open ty

     Use the nicknaming feature to assign mnemonic names to hosts
     whose real names don't give much hint to what you call there
     for.   A  popular  game  called  Nethack  is   archived   at
     linc.cis.upenn.edu,  in the /pub/NH3.1 directory.  You could
     assign ``nethack'' as the nickname for this site.  Then  you
     could try:

          open nethack

     instead of:

          open linc.cis.upenn.edu

USING THE HOST EDITOR
     To manipulate the hosts stored in your hosts file,  you  use
     the  program's  host  editor.  Run the host editor by typing
     the hosts command from within the program.  This brings up a
     new screen of information.

     On the right side is the list of remote systems the  program
     has  saved for you already.  Each time you open a connection
     to a remote system, the program saves an entry in your  host
     file  for  you  automatically.   If  you have not opened any
     sites successfully yet, this list would be empty.

     On the left side is some instructions saying what you can do
     with  the  list.   The  host editor is waiting for you to do
     something, like select a site whose  settings  you  want  to
     edit.

     Some host editor ``hot key'' commands are one key only.  You
     do  not  need  to  hit enter after the hot key commands.  To
     exit the host editor for example, you would  just  type  the
     ``x''  key  only.   The  multi-key  commands require a slash
     first and do require the enter key.  To delete the  selected
     site,  for  example,  you  would  type  the  ``/'' key, then
     ``del,'' and then the enter key.

     You can use the ``d'' key to move down one line in the  host
     list,  and  the  ``u'' key to move up one line.  If you have
     many entries in the host list, you won't be able to see them
     all  at once.  The host list scrolls as appropriate to bring
     the other sites into view.  Use the ``p'' and ``n'' keys  to
     move pages at a time.

     Another way to select a site in the host list is to use  the
     capital letters.  If I had many entries in my host list, but
     wanted to select a site whose nickname  was  ``nethack,''  I
     could  type  ``N'' and the host list would zoom to the first
     site with nickname starting with the letter ``n.''



NCEMRSoft              Last change: 2.1.0                       4






NcFTP(1)                 USER COMMANDS                   NcFTP(1)



     After you have hilited a host you want to edit, use the  /ed
     command.   Doing that brings up another screen with the set-
     tings for that host.

     In the Site Options screen, you use hot  keys  to  select  a
     setting  to  edit.   To  edit the nickname, for example, you
     would type ``a.'' When you are finished editing  this  host,
     hit the ``x'' key to return to the host editor's screen.

SITE OPTIONS
     Edit the Nickname field to change the name you use  to  open
     this site with.  Remember, when you change the nickname, you
     must use this nickname to  refer  to  this  particular  host
     entry,  so  if  you change it to ``foobar,'' you need to use
     ``open foobar.'' This is required because you can have  mul-
     tiple  entries  for  a  remote host.  For example, you could
     have  two   entries   for   wuarchive.wustl.edu,   nicknamed
     ``wumac''  and  ``wuwindows.''  If  you  were  to say ``open
     wuarchive.wustl.edu,'' it's not clear to the  program  which
     host entry to use.

     Change the login information for the  site  by  editing  the
     User, Password, and Account fields.  Normally you would want
     to leave these as is for  anonymous  logins.   Depending  on
     your  situation, you might want to use a specific account on
     the remote system.  This is one way to get  the  program  to
     use a non-anonymous login.

     The Directory field specifies the directory to move to  upon
     successful connection to the site.  When you close the site,
     this field is updated for you automatically to be the direc-
     tory you were in when you closed the site.

     The Transfer Type field can be changed to  use  a  different
     translation  mode  when transferring files.  This program is
     usually running on a UNIX system, and  most  remote  systems
     are  also  UNIX  variants,  so  the default transfer type is
     binary, which does no translation at all.

     However, when you need to work with  plain  text  files  and
     transfer  them between non-UNIX systems, you can change this
     to ASCII.  That will guarantee that the text-only files will
     translate  correctly.   Most often, you will need to use the
     binary transfer type.

     The Port field can be changed so that the program  tries  to
     use  a  non-standard port number.  I have yet to ever need a
     different port number, but this capability is here  in  case
     it's needed.

     The Has SIZE Command field will  probably  not  need  to  be
     edited.   This  field  is  mostly for your information only.



NCEMRSoft              Last change: 2.1.0                       5






NcFTP(1)                 USER COMMANDS                   NcFTP(1)



     The SIZE command is an FTP Protocol command that the program
     would  like  the  remote  server  to support.  If it is sup-
     ported, the program can get an  exact  number  of  bytes  of
     remote  files  before transferring.  That is nice to know so
     the progress reports work better.

     The Has MDTM Command field will  probably  not  need  to  be
     edited  either.   If the remote server supports it, the pro-
     gram can get the exact modification date of the remote file,
     and set the local file to the same date.

     The Can Use Passive FTP field specifies whether  the  remote
     server allows use of the FTP Protocol's PASV command.  There
     are two ways to set up FTP connections.  The default way  is
     what  I  call  Port  FTP.  Unfortunately, Port FTP cannot be
     used when your local host is hiding behind a Firewall.  Pas-
     sive FTP can be used with a firewall, and that's why I would
     like to use that method if possible.  You probably will  not
     need to edit this field, since this can be detected automat-
     ically most of the time.

     The Operating System field is used by the program to tell if
     it  can  rely  on certain dependencies to specific operating
     systems.  If the OS is a UNIX variant, the program can  make
     some  assumptions  about the remote server's responses.  For
     example, if the OS is UNIX, the ls command tries to use  the
     -CF  flags, like you could with ``/bin/ls -CF'' on UNIX.  If
     the OS wasn't UNIX, the ``-CF'' might not make sense to  the
     remote  server and it might complain.  You probably will not
     need to edit this field, since this can be detected automat-
     ically most of the time.

     The comment field can be used to store a  brief  description
     about  the  site.   For example, for my ``nethack'' entry, I
     could use this field to hold ``Archive site for latest  ver-
     sion of Nethack.'' When you are in the host editor's window,
     if you hilite a site that has a comment, it  is  printed  at
     the bottom of the screen so you do not have to edit the site
     to look at it.

PREFERENCES
     In addition to remote-host specific options, the program has
     global  options  that  are user-configurable.  To change the
     program's preferences, run the prefs command from within the
     program.

     The Default open mode field specifies how the program should
     try  to  open  connections.   If  you  do a lot of anonymous
     FTPing, you should leave this set to anonymous.   You  might
     want  to  set this field to user & password if the hosts you
     FTP to most often don't allow anonymous logins.   For  exam-
     ple, if you are using the program on your company network to



NCEMRSoft              Last change: 2.1.0                       6






NcFTP(1)                 USER COMMANDS                   NcFTP(1)



     copy things from different company machines, you  would  not
     want to use anonymous FTP mode.

     The Anonymous password field lets you change the value given
     to  the  remote host when you use an anonymous login.  It is
     customary  (and  sometimes  required)  to  use  your  e-mail
     address  as  the  password  for anonymous FTP, so the remote
     host's administrator knows who is using the service.  If the
     program didn't get your e-mail address right, or you want to
     use something different, you can change it here.

     The program now uses more whitespace than before  to  reduce
     eyestrain.   If you prefer, you can turn off that feature by
     changing the Blank lines between cmds field.

     The program can log the transfers you do to a  file  so  you
     can  refer  to  the  log if you can't remember where you got
     something.   To  turn  on  the  log,  which  is   saved   as
     ~/.ncftp/log,  you  can  set  the  User  log size field to a
     number greater than zero.  You probably do not want  to  let
     this  file  grow forever, so you set the maximum size of the
     log by setting that field.

     Although the program is perfectly happy  saving  every  site
     you  ever  open  in  the  hosts file, you may want to put an
     upper bound on the number of sites saved.   If  you  have  a
     slow  machine,  which might cause the program to take awhile
     to load and save the hosts, or if disk space is at  a  prem-
     ium,  you  can  set the Max hosts to save field to limit the
     number of hosts saved.  Once that limit is reached, the pro-
     gram will discard sites whose time since the last connection
     is the longest.  In other words, a site you only called once
     a long time ago and forgot about will be the first to go.

     A few program functions need to use a pager program to  view
     large  amounts  of  text.   For  example,  the  page command
     retrieves a remote file and uses the pager to view it.   You
     can  specify the program to use (and its command line flags,
     if any) by setting the pager field.

     When you transfer files between the  remote  host  and  your
     local  host,  the  program uses a progress meter to show you
     the status of the transfer.  The program has a few different
     progress  meters  to  choose  from,  and you can try out the
     other ones by changing the Progress meter field.

     You can control how much of the remote server's  chatter  is
     printed  by changing the Remote messages field.  The program
     always prints error messages,  but  most  of  the  time  the
     remote  server  doesn't  have anything useful to say.  There
     are a couple of messages that may be  worth  printing.   The
     first  is  the startup message.  Typically, when you connect



NCEMRSoft              Last change: 2.1.0                       7






NcFTP(1)                 USER COMMANDS                   NcFTP(1)



     to a server it has  some  important  information  about  the
     server.   Some  servers  have chdir messages, which are sent
     when you enter a special directory.  You specify whether  to
     print these messages by toggling the Remote messages field.

     By default, the program stays in the same directory you were
     in  when  you  ran the program, so that downloads will go in
     that directory.  I like to use a ``download  directory''  so
     that  all  of my downloads go to a specific directory.  This
     prevents me from exceeding  my  quota,  and  overwriting  my
     other  files.  You can set the Startup in Local Dir field to
     have the program change the local directory each  time  when
     the  program  starts up.  Then you know where to expect your
     downloads to end up.

     The program itself has some messages which you may get tired
     of  and  want  to turn off.  You can change the Startup mes-
     sages field  to  specify  whether  the  program  prints  its
     ``splash screen'' and whether it prints a tip on how to max-
     imize use of the program.

     When you retrieve a remote  file,  by  default  the  program
     tries  to  also set the exact modification time of the local
     file as the remote file.  You can turn that off by  changing
     the File timestamps field.

     If you don't like the full-screen graphics, you can use  the
     line-oriented  mode  by  changing the Screen graphics field.
     Once you turn visual mode off from the  Preferences  screen,
     you  won't  be  able  to  get back to the preferences screen
     again when using line mode.  To get back into  visual  mode,
     you can run the program with the ``-V'' flag, like:

          ncftp -V

COMMAND REFERENCE
     I will now describe the commands that the program's  command
     shell  supports.  The first command to know is help.  If you
     just type

          help

     from the command shell, the program prints the names of  all
     of the supported commands.  From there, you can get specific
     help for a command by typing the command after, for example:

          help open

     prints information about the open command.

     The shell escape command is simply the exclamation point,  !
     To spawn a shell, just do:



NCEMRSoft              Last change: 2.1.0                       8






NcFTP(1)                 USER COMMANDS                   NcFTP(1)



          !

     You can also use this to do one command only, like:

          !date +%H:%M:%S

     The cd command changes the working directory on  the  remote
     host.   Use  this  command to move to different areas on the
     remote server.  If you just opened a new site, you might  be
     in the root directory.  Perhaps there was a directory called
     ``/pub/news/comp.sources.d'' that someone  told  you  about.
     From the root directory, you could:

          cd pub
          cd news
          cd comp.sources.d

     or, more concisely,

          cd /pub/news/comp.sources.d

     Then, commands such as get, put, and ls  could  be  used  to
     refer to items in that directory.

     Some shells in the UNIX environment have a feature  I  like,
     which  is  switching  to the previous directory.  Like those
     shells, you can do:

          cd -

     to change to the last directory you were in.

     The close command disconnects you from  the  remote  server.
     The  program does this for you automatically when needed, so
     you can simply open other sites or quit the program  without
     worrying about closing the connection by hand.

     Sometimes it may be necessary to  use  the  create  command.
     This  makes  an  empty file on the remote host.  This can be
     useful when you are unable to contact  the  remote  server's
     administrator,  but  hope someone in the know will spot your
     file.  For example,

          create readline2.0.tar_is_corrupt

     might persuade someone to repost that file.

     The debug command is mostly for use by me and  the  testers.
     You could type

          debug 1




NCEMRSoft              Last change: 2.1.0                       9






NcFTP(1)                 USER COMMANDS                   NcFTP(1)



     to turn debugging mode on.  Then you could see all  messages
     between  the  program  and  the  remote server, and things I
     print only in debugging mode.  If you report a bug, I  might
     ask  you to send me a trace file.  To do that, you would run
     the program, and then type

          debug trace 1

     And so I could see how the program was compiled,  you  would
     type

          version

     After you quit the program, you could then send me an  email
     with  the  contents  of the ~/.ncftp/trace file, which would
     also have the version information in it.

     The dir command prints a  detailed  directory  listing.   It
     tries  to behave like UNIX's ``/bin/ls -l'' command.  If the
     remote server seems to be a UNIX host, you can also use  the
     same flags you would with ls, for instance

          dir -rt

     would try to act like

          /bin/ls -lrt

     would on UNIX.

     The echo command wouldn't seem very useful, but  it  can  be
     nice for use with the program's macros.  It behaves like the
     equivalent command does under a UNIX shell, but accepts some
     extra   flags.    All  ``percent''  flags  are  fed  through
     strftime(4).  So you could type

          echo It is now %H:%M on %B %d.

     and you should get  something  like  this  printed  on  your
     screen:

          It is now 19:00 on January 22.

     There are also ``at'' flags, which the program expands:

          @H : Name of connected host
          @D : Full pathname of remote current working directory
          @J : Short name of remote current working directory
          @N : Newline.
          @n : Nickname of connected host





NCEMRSoft              Last change: 2.1.0                      10






NcFTP(1)                 USER COMMANDS                   NcFTP(1)



     Example:

          echo "Connected to @H at %H:%M." >> junk

     If you later looked at the contents of  ``junk,''  it  might
     say:

          Connected to sphygmomanometer.unl.edu at 20:37.

     The get command copies files from the current working direc-
     tory  on  the  remote host to your machine's current working
     directory.  To place a copy  of  ``README''  in  your  local
     directory, you could try:

          get README

     The  get  command  has  some  powerful  features  which  are
     described below, in ``SPECIAL DOWNLOADING FEATURES.''

     The hosts command runs the Host Editor.   You  already  know
     how  what that does, since you read the section above on it,
     right?

     The lcd command is the first of a few  ``l''  commands  that
     work  with the local host.  This changes the current working
     directory on the local host.  If you want to download  files
     into  a  different  local  directory,  you  could use lcd to
     change to that directory and then do your downloads.

     Another local command that comes in handy is  the  lls  com-
     mand,  which runs ``/bin/ls'' on the local host and displays
     the results in the program's window.  You can use  the  same
     flags  with  lls  as you would in your command shell, so you
     can do things like:

          lcd ~/doc
          lls -lrt p*.txt

     The program also has a built-in interface to the  name  ser-
     vice  via  the  lookup  command.   This means you can lookup
     entries for hosts, like:

          lookup cse.unl.edu ftp.cs.unl.edu sphygmomanometer.unl.edu

     prints:

          cse.unl.edu  129.93.33.1
          typhoon.unl.edu  129.93.33.24
          sphygmomanometer.unl.edu  129.93.33.126

     There is also a more detailed option, enabled  with  ``-v,''
     i.e.:



NCEMRSoft              Last change: 2.1.0                      11






NcFTP(1)                 USER COMMANDS                   NcFTP(1)



          lookup -v cse.unl.edu ftp.cs.unl.edu

     prints:

          cse.unl.edu:
              Name:     cse.unl.edu
              Address:  129.93.33.1

          ftp.cs.unl.edu:
              Name:     typhoon.unl.edu
              Alias:    ftp.cs.unl.edu
              Address:  129.93.33.24

     You can also give IP addresses, so this would work too:

          lookup 129.93.33.24

     prints:

          typhoon.unl.edu  129.93.33.24

     The lpage command views a local file one page at a time.  By
     default,  the  program  uses  your pager program to view the
     files.  You can choose to use the built-in  pager  by  using
     the ``-b'' flag.  Example:

          lpage -b ~/.ncftp/hosts

     The lpwd command is prints the current local directory.  Use
     this  command  when  you  forget where you are on your local
     machine.

     The ls command prints a brief directory listing.   It  tries
     to  behave  like  UNIX's  ``/bin/ls  -CF''  command.  If the
     remote server seems to be a UNIX host, you can also use  the
     same flags you would with ls, for instance

          ls -rt

     would try to act like

          /bin/ls -CFrt

     would on UNIX.

     The mkdir command tries to create a  new  directory  on  the
     remote  host.   For many public archives, you won't have the
     proper access permissions to do that.

     The open command connects you to a remote host.  Many times,
     you  will  simply  open  a host without using any flags, but
     nonetheless the  open  command  has  some  flags  to  enable



NCEMRSoft              Last change: 2.1.0                      12






NcFTP(1)                 USER COMMANDS                   NcFTP(1)



     certain features.

     To force an anonymous open, use the  ``-a''  flag.   On  the
     ftp.cs.unl.edu  machine,  which is the official archive site
     for NcFTP, I have a need to use both  anonymous  logins  and
     user logins.  The Host Editor remembers type of login I used
     last, so if the last time was a user login, I could use  the
     ``-a''  flag  to  switch  back  to  the anonymous login type
     without having to use the Host Editor to change that.

     Likewise, I could use the ``-u'' flag to force a user  open.
     Then  I  could  give  my account name and password to access
     that account.

     Many of the big archive sites like  wuarchive.wustl.edu  are
     busy,  so  you  aren't guaranteed a connection to them.  The
     program lets you ``redial'' sites periodically, until a con-
     nection  succeeds.   Use the ``-r' flag to turn on automatic
     redial.

     Redial itself has a few parameters.  You can set the  delay,
     in  seconds, of the time spent waiting between redials.  You
     can also have the program give up after a maximum number  of
     redials  is  reached.  Here's an example that fully utilizes
     redial mode:

     open -r -d 75 -g 10 bowser.nintendo.co.jp

     The ``-r'' turns on redialing, the ``-d''  sets  the  redial
     delay to 75 seconds, and the ``-g'' flag limits redialing to
     10 tries.  If you like,  you  can  just  trust  the  default
     redial settings and only use ``-r.''

     The open command will run the Host Editor if you don't  sup-
     ply  a  hostname  to  open.   You can use the Host Editor to
     select a host and open it by hitting the return key.

     The page command lets you browse a remote file one page at a
     time.   This  is  useful  for reading README's on the remote
     host without downloading  them  first.   This  command  uses
     whatever program you have set the pager field in the Prefer-
     ences screen to view the file.

     The pdir and pls commands  are  equivalent  to  dir  and  ls
     respectively,  only  they  feed  their output to your pager.
     These commands are primarily for line mode because directory
     listings  can scroll offscreen.  If you do a normal ls while
     in visual mode, if it would go offscreen, the built-in pager
     kicks  in  automatically.  Therefore I don't recommend using
     pdir and pls while in visual mode.





NCEMRSoft              Last change: 2.1.0                      13






NcFTP(1)                 USER COMMANDS                   NcFTP(1)



     The redir and predir commands give you a way  to  re-display
     the  last  directory  listing.  The program saves the output
     from the last dir or ls command you did, so if you  want  to
     see  it  again  you  can  do  this  without  wasting network
     bandwidth.  The predir command is the same as redir,  except
     that the output is fed to your pager.

     I have found that I mostly download, and  have  next  to  no
     need at all to upload.  But the put command is there in case
     you need to upload files to remote hosts.  For example, if I
     wanted to send some files to a remote host, I could do:

          lcd ~/docs/files
          put 02.txt 03.txt 05.txt 07.txt 11.txt

     The put command won't work if  you  don't  have  the  proper
     access  permissions  on the remote host.  Also, this command
     doesn't have any of the special features that the  get  com-
     mand has, except for the ``-z'' option.

     The pwd command prints the current remote working directory.
     In visual mode, this is in the status bar.

     If you need to change the name of a remote file, you can use
     the rename command, like:

          rename SPHYGMTR.TAR sphygmomanometer-2.3.1.tar

     Of course, when you finish using the program, type  quit  to
     end the program (You could also use bye, exit, or ^D).

     The quote command can be used to send a direct FTP  Protocol
     command to the remote server.  Generally this isn't too use-
     ful to the average user (or me either).

     The rhelp command sends a help request to the remote server.
     The  list  of  FTP  Protocol  commands is often printed, and
     sometimes some other information that  is  actually  useful,
     like how to reach the site administrator.

     Depending on the remote server, you may be able  to  give  a
     parameter to the server also, like:

          rhelp NLST

     One server responded:

          Syntax: NLST [ <sp> path-name ]

     If you need to delete a remote file you can try the rm  com-
     mand.   Much  of  the time this won't work because you won't
     have the proper access permissions.   This  command  doesn't



NCEMRSoft              Last change: 2.1.0                      14






NcFTP(1)                 USER COMMANDS                   NcFTP(1)



     accept  any  flags,  so you can't nuke a whole tree by using
     ``-rf'' flags like you can on UNIX.

     Similarly, the rmdir command removes a directory.  Depending
     on  the remote server, you may be able to remove a non-empty
     directory, so be careful.

     The set command is provided for backward compatibility  with
     older  versions  of  the  program,  and is superseded by the
     prefs command.  The basic syntax is:

          set option value

     Where the option is the  short  name  of  the  corresponding
     field  in  the  Preferences  screen.  The short names of the
     preferences  fields  can   be   found   by   browsing   your
     ~/.ncftp/prefs  file.   This  command is mainly for use with
     line mode, but since that mode is no longer officially  sup-
     ported by me, I want to discourage the use of this command.

     One obscure command you may have to  use  someday  is  site.
     The  FTP  Protocol  allows  for  ``site specific'' commands.
     These ``site'' commands vary of course, but one common  sub-
     command  that  is  useful  that some sites support is chmod,
     i.e.:

          site chmod 644 README

     Try doing one of these to see what the  remote  server  sup-
     ports, if any:

          rhelp SITE
          site help

     You may need to change transfer types during the course of a
     session  with  a server.  You can use the type command to do
     this.  Try one of these:

          type ascii
          type binary
          type image

     If you ever need to contact me  about  the  program,  please
     familiarize yourself with the version command.  This command
     dumps a lot of information that tells me  which  edition  of
     the  program you are using, and how it was installed on your
     system.  Here's a way to save the output of this command  to
     a file, so you can send it to me:

          version > version.txt





NCEMRSoft              Last change: 2.1.0                      15






NcFTP(1)                 USER COMMANDS                   NcFTP(1)



SPECIAL DOWNLOADING FEATURES
     You probably already know that you use the  get  command  to
     copy  files  on  the remote host to the local host.  But the
     get command has a few other tricks that you might find  use-
     ful.   First of all, ncftp skips files you already have.  If
     you try to

          get file24

     and there is a file named ``file24'' in  the  current  local
     directory  already, the program uses some additional heuris-
     tics to  determine  if  it  should  actually  waste  network
     bandwidth to download it again.

     The program tries to get the date and  size  of  the  remote
     file  ``file24.''  If  that file has the exact same date and
     size as the local file ``file24,''  the  program  will  skip
     over  that  file.   If the program could not get the date or
     size of the remote file, or the size  differs,  the  program
     will go ahead and fetch the file.

     In addition, if the local file's  date  is  newer  than  the
     remote  file's  date, the program skips the download because
     it concludes you already have a more recent version.

     What all this means for you is that you can use the  program
     to  mirror  another  archive.  For example, you might have a
     task that requires you keep a mirror of all the files  of  a
     remote  directory called ``files.'' In that directory, there
     might be dozens of files, some of which  are  updated  occa-
     sionally.   You  could  use ncftp to help you out by setting
     the appropriate local and remote  directories,  then  simply
     doing:

          get *

     The program will skip over the old files, and only  download
     the files that you don't have or have been updated since the
     last time.

     Nonetheless, you may want to ignore the program's advice and
     download  a file anyway, despite the program's thinking that
     you don't need to.  You can use the ``-f'' flag with get  to
     force a download:

          get -f README

     You may also need to use the ``-C'' flag to force  the  pro-
     gram to continue downloading where it left off.  I sometimes
     call that feature ``forced reget'' for historical reasons.





NCEMRSoft              Last change: 2.1.0                      16






NcFTP(1)                 USER COMMANDS                   NcFTP(1)



     You can also turn off wildcard matching with  get  by  using
     the ``-G'' flag.  Other FTP programs used the syntax

          get remote-file [local-file]

     which allowed you to specify a local pathname for  the  file
     you were trying to download.  NcFTP differs in that respect,
     and if you used the older programs, you would find that  the
     program's  get  behaves more like those other program's mget
     command.  This means that in NcFTP,that

          get file01 file02

     tries  to  download  remote  files  named   ``file01''   and
     ``file02.''  If you like, you can get that older behavior by
     using the ``-z'' flag, so:

          get -z file01 ../junk/files/01.txt

     would   get   ``file01''   and   use    the    local    name
     ``../junk/files/01.txt.''

     Another thing that get does is that you can use  the  ``-n''
     flag to fetch files that are a certain number of days old or
     newer.  If you just want to  get  the  newest  files  at  an
     archive,  you don't have to use a full mirror.  You can just
     say ``download all files that are 3 days old or newer.''  Do
     that by going to a directory, and trying:

          get -n 3 *

     The program also has ``reget'' mode built into the get  com-
     mand.   Other  FTP  programs provided a reget command, which
     was useful when you lost a  connection  during  a  download.
     Instead  of  the  remote host resending the entire file, you
     could use the reget command to continue the  transfer  where
     it was cut off.

     NcFTP has this capability built-in, and it examines the date
     and  size  of the remote file and local file to determine if
     the program should continue where it left off last time.  If
     the  dates  are the same, but the local file is smaller, the
     program attempts to ``reget.''

     The last, and most wasteful  feature  of  get  is  recursive
     mode, which is turned on with the ``-R'' flag.  This feature
     lets you download an entire directory's contents, i.e.:

          get -R /pub/info/help

     That creates a directory called ``./help''  in  the  current
     local  directory,  and  copies  all files and subdirectories



NCEMRSoft              Last change: 2.1.0                      17






NcFTP(1)                 USER COMMANDS                   NcFTP(1)



     into it.

     Please use some discretion with this feature.  If you get  a
     large  directory, you could really bog down the remote host.
     Archive administrators are providing a  public  service,  so
     don't  abuse the archive so much that they have to shut down
     public access because the real users of that  archive  can't
     get their work done.

MACROS
     The program has a simple macro/alias facility.  You can  use
     macros  to roll your own commands, or do things when certain
     events happen.

     To use macros, you will need to create and edit  the  macros
     file  in  your  .ncftp  subdirectory of your home directory.
     Your ~/.ncftp directory is created for you automatically the
     first  time  you  run  the program, but you have to make the
     macros file yourself since most users won't have a need  for
     them.

     You can have any number of macros.  The syntax is:

          macro macro-name
              macro-body...
          end

     Here's a simple macro that users  of  the  old  ftp  program
     might appreciate:

          macro binary
              type i
          end

     You could run that macro simply by running the  program  and
     typing the macro name as if it were a regular ncftp command.

     Macros can also have parameters, much like the Korn  Shell's
     shell functions and the C-Shell's aliases.  These parameters
     are sent to your macro, and if your macro uses the appropri-
     ate ``dollar'' variables, they are expanded.  To illustrate,
     try this macro:

          macro cdls
              cd $1
              ls
          end

     To run that macro, open a connection and try:

          cdls /pub




NCEMRSoft              Last change: 2.1.0                      18






NcFTP(1)                 USER COMMANDS                   NcFTP(1)



     That would try to cd to /pub, and then try to list its  con-
     tents with ls.

     Dollar variables are somewhat like those in the  Bourne  and
     Korn shells.  Example syntax:

          $4     :  Argument 4
          $*     :  All arguments.
          $@     :  All arguments, each of them surrounded by double quotes.
          $(2-5) :  Arguments 2, 3, 4, and 5.
          $(2,5) :  Arguments 2 and 5.
          $(3+)  :  Arguments 3, 4, 5, ..., N.

     A better way to code the ``cdls'' macro might be:

          macro cdls
              cd $1
              ls $(2+)
          end

     There are some special macros, which I  call  event  macros.
     The  program  looks for macros by special names, and if they
     exist, runs the macro when that event happens.

     One event macro is the .start.ncftp macro.  If  you  have  a
     macro  by that name defined in your macros file, the program
     will run that macro each time you run the program.

     Similarly, there is also a .quit.ncftp  macro  that  is  run
     each time you quit the program.

     Another set of event macros are site-specific.  For example,
     if  I  have a site nicknamed ``typhoon'' I could then define
     macros named .open.typhoon and  .close.typhoon  which  would
     run each time I opened and closed ``typhoon.''

     Another, more generic set of event macros are the  .open.any
     and  .close.any  macros  which  run when I open or close any
     site.  One possible use for these macros is to run  separate
     shell scripts to do some processing after you finish using a
     site.  I could have a macro like this:

          macro .quit.ncftp
              echo "Started post-processing downloads at %H:%M:%S"
              !sh ~/scripts/download-decoder
              echo "Finished post-processing downloads at %H:%M:%S"
          end

     Another use is to duplicate the old macdef  init  hack  that
     the  traditional  ftp  program used in its .netrc file.  For
     example:




NCEMRSoft              Last change: 2.1.0                      19






NcFTP(1)                 USER COMMANDS                   NcFTP(1)



          macro .open.infomac
              echo "Getting recent files list"
              get -z /pub/info-mac/help/recent-files ~/docs/recent
              ls -lrt
          end

USING COLON MODE
     The colon-mode feature is used  from  your  shell's  command
     line.

     In ancient times, way back during the Disco Era,  you  could
     use a program called tftp to fetch a file using the Internet
     standard Trivial File Transfer Protocol. You could use  that
     program to do something like this from within its shell:

          get wuarchive.wustl.edu:/graphics/gif/README

     and that would call wuarchive and fetch the README file.

     You can use this program to do  the  same  thing  from  your
     shell's command line:

          csh> ncftp wuarchive.wustl.edu:/graphics/gif/README
          csh> head README

     This tells your shell, in  this  case  the  C-shell  to  run
     NcFTP,     which     would     open     wuarchive,     fetch
     /graphics/gif/README and  write  the  file  /README  in  the
     current working directory, and then exits.

     The colon-mode feature is nice if you don't want  to  browse
     around  the remote site, and you know exactly want you want.
     It also comes in handy in shell  scripts,  where  you  don't
     want to enter the command shell, and might not want the pro-
     gram to spew output.

     You can use the Uniform Resource Locator standard also.  For
     example, this would work:

          csh> ncftp ftp://wuarchive.wustl.edu/graphics/gif/README

     There are times where you might  not  want  the  program  to
     write a colon-mode file in the current working directory, or
     perhaps you want to pipe the output of a  remote  file  into
     something  else.  Colon-mode has options to do this.  It was
     inspired by the guy who wrote the ftpcat perl  script.   The
     ``-c''  option  tells  the  program to write on the standard
     output stream.  The ``-m'' option pipes the file  into  your
     pager (like more) Of course this won't work if the thing you
     give colon-mode is a directory!  This example just  dumps  a
     remote file to stdout:




NCEMRSoft              Last change: 2.1.0                      20






NcFTP(1)                 USER COMMANDS                   NcFTP(1)



          csh> ncftp -c wuarc:/graphics/gif/README

     This example redirects a remote file into a different  loca-
     tion:

          csh> ncftp -c wu:/README > ~pdietz/thesis.tex

     This one shows how to use a pipeline:

          csh> ncftp -c wuarc:/README | tail | wc -l
          10
          csh>

     This shows how to page a remote file:

          csh> ncftp -m wuarc:/graphics/gif/README

USING LINE MODE
     The only reason I provide line mode is so that the primitive
     operating  systems  whose  curses library is missing or dys-
     functional won't render the program completely useless.

     exceptions of the functions that require visual  mode,  such
     as  the  Preferences  screen  and the Host Editor.  You will
     have to edit  the  ~/.ncftp/prefs  and  ~/.ncftp/hosts  file
     manually, with a text editor.

     As a small consolation, you  get  to  use  the  full-powered
     line-editing  libraries, like GNU Readline if they were com-
     piled with the program.

SUMMARY OF COMMAND LINE OPTIONS
     When you invoke the  program  from  your  shell,  there  are
     ``dash flags'' you can use like you can with most other UNIX
     programs.

     Here's a list of options you can use from the command line:

          -D : Turns on debugging mode and tracing.
          -V : Uses ``visual'' mode for this session.
          -L : Uses ``line mode'' for this session.
          -H : Prints the information from the ``version'' command and exits.

     When you turn on tracing, the  program  writes  a  log  with
     debugging  information to a file called trace in your .ncftp
     subdirectory of your home directory.  If you need to  report
     a  bug,  it  would be helpful to mail me the trace file so I
     can track it down better.

     In addition to the program flags, you  can  also  use  flags
     from  the  open  and  get  commands  with a colon mode path.
     Here's a really complex example:



NCEMRSoft              Last change: 2.1.0                      21






NcFTP(1)                 USER COMMANDS                   NcFTP(1)



          csh> ncftp -r -d 120 -n 3 sphygmomanometer.unl.edu:/pub/stuff/*

     This tries redialing that host every two minutes, and fetch-
     ing  all  files from the ``/pub/stuff'' directory that are 3
     days old or newer.

AUTHOR
     NcFTP   was   written    by    Mike    Gleason,    NCEMRSoft
     (mgleason@cse.unl.edu).    NcFTP   is  copyrighted  1995  by
     NCEMRSoft.  All rights reserved.

     As of this writing, the most recent version is  archived  in
     /pub/ncftp, on ftp.cs.unl.edu.

THANKS
     Ideas and some code contributed by my partner,  Phil  Dietz,
     NCEMRSoft (dietz@gateway.wtc.com).

     Thanks to everyone who has helped test the program, and sent
     in  feedback over the years.  Your support is what drives me
     to improve the program!

     I'd like to thank my  system  administrators,  most  notably
     Charles Daniel, for making testing on a variety of platforms
     possible, letting me have some extra  disk  space,  and  for
     maintaining the new FTP site.

     For testing above and beyond the call of duty,  I  am  espe-
     cially    grateful    to:    Phil   Dietz,   Kok   Hon   Yin
     (hkok@cse.unl.edu), Andrey A. Chernov (ache@astral.msk.su).

     Thanks to DaviD W. Sanderson (dws@ssec.wisc.edu), for  help-
     ing me out with the man page.

BUGS
     Due to a limitation in the curses library, scrolling may  be
     slow in visual mode.

     Shell escapes, suspending (^Z) and resuming, and interruping
     (^C) still have quirks with visual mode.

     There are  no  such  sites  named  bowser.nintendo.co.jp  or
     sphygmomanometer.unl.edu.

SEE ALSO
     ftp(1), ftpd(8), nslookup(1), compress(1), gzip(1), zcat(1),
     strftime(4), fsp(1), archie(1), rcp(1), tftp(1).








NCEMRSoft              Last change: 2.1.0                      22



